/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.element;

import java.util.ArrayList;
import java.util.EnumSet;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.element.GuiHelper;
import mrjake.aunis.gui.element.Tab;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.util.ItemMetaPair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.items.SlotItemHandler;

public class TabBiomeOverlay
extends Tab {
    private EnumSet<BiomeOverlayEnum> supportedOverlays;
    private Tab.SlotTab slot;
    private int slotTexX;
    private int slotTexY;

    protected TabBiomeOverlay(TabBiomeOverlayBuilder builder) {
        super(builder);
        this.supportedOverlays = builder.supportedOverlays;
        this.slotTexX = builder.slotTexX;
        this.slotTexY = builder.slotTexY;
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.render(fontRenderer, mouseX, mouseY);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bgTexLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 5), (int)(this.guiTop + this.defaultY + 24), (float)this.slotTexX, (float)this.slotTexY, (int)18, (int)18, (float)this.textureSize, (float)this.textureSize);
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && GuiHelper.isPointInRegion(this.guiLeft + this.currentOffsetX + 6, this.guiTop + this.defaultY + 25, 16, 16, mouseX, mouseY) && !this.slot.func_75216_d()) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(I18n.func_135052_a((String)"gui.stargate.biome_overlay.help", (Object[])new Object[0]));
            for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
                if (!this.supportedOverlays.contains((Object)biomeOverlay)) continue;
                String line = biomeOverlay.getLocalizedColorizedName() + ": ";
                for (ItemMetaPair itemMeta : AunisConfig.stargateConfig.getBiomeOverrideBlocks().get((Object)biomeOverlay)) {
                    line = line + itemMeta.getDisplayName() + ", ";
                }
                text.add(line);
            }
            screen.func_146283_a(text, mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public Tab.SlotTab createAndSaveSlot(SlotItemHandler slot) {
        this.slot = new Tab.SlotTab(slot, slotTab -> {
            slotTab.field_75223_e = this.currentOffsetX + 6;
            slotTab.field_75221_f = this.defaultY + 25;
        });
        return this.slot;
    }

    public static TabBiomeOverlayBuilder builder() {
        return new TabBiomeOverlayBuilder();
    }

    public static class TabBiomeOverlayBuilder
    extends Tab.TabBuilder {
        private EnumSet<BiomeOverlayEnum> supportedOverlays;
        private int slotTexX;
        private int slotTexY;

        public TabBiomeOverlayBuilder setSupportedOverlays(EnumSet<BiomeOverlayEnum> supportedOverlays) {
            this.supportedOverlays = supportedOverlays;
            return this;
        }

        public TabBiomeOverlayBuilder setSlotTexture(int x, int y) {
            this.slotTexX = x;
            this.slotTexY = y;
            return this;
        }

        @Override
        public TabBiomeOverlay build() {
            return new TabBiomeOverlay(this);
        }
    }
}

