/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.element;

import mrjake.aunis.gui.element.GuiHelper;
import mrjake.aunis.gui.element.Tab;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.items.SlotItemHandler;

public class TabAddress
extends Tab {
    private StargateClassicBaseTile gateTile;
    private SymbolTypeEnum symbolType;
    private int maxSymbols;

    protected TabAddress(TabAddressBuilder builder) {
        super(builder);
        this.gateTile = builder.gateTile;
        this.symbolType = builder.symbolType;
        this.maxSymbols = 6;
    }

    public void setMaxSymbols(int maxSymbols) {
        this.maxSymbols = maxSymbols;
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.render(fontRenderer, mouseX, mouseY);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bgTexLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 105), (int)(this.guiTop + this.defaultY + 86), (float)6.0f, (float)174.0f, (int)18, (int)18, (float)this.textureSize, (float)this.textureSize);
        int shadow = 2;
        float color = 1.0f;
        switch (this.symbolType) {
            case UNIVERSE: {
                color = 0.0f;
                break;
            }
        }
        if (this.isVisible() && this.gateTile.getStargateAddress(this.symbolType) != null) {
            for (int i = 0; i < this.maxSymbols; ++i) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gateTile.getStargateAddress(this.symbolType).get(i).getIconResource());
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                GuiHelper.drawTexturedRectWithShadow(symbolCoords.x, symbolCoords.y, shadow, shadow, this.symbolType.iconWidht, this.symbolType.iconHeight, color);
            }
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bgTexLocation);
            short progress = this.gateTile.getPageProgress();
            Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 97), (int)(this.guiTop + this.defaultY + 86 + (18 - progress)), (float)0.0f, (float)(174 + (18 - progress)), (int)6, (int)progress, (float)this.textureSize, (float)this.textureSize);
            GlStateManager.func_179084_k();
        }
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && this.gateTile.getStargateAddress(this.symbolType) != null) {
            for (int i = 0; i < this.maxSymbols; ++i) {
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                if (!GuiHelper.isPointInRegion(symbolCoords.x, symbolCoords.y, this.symbolType.iconWidht, this.symbolType.iconHeight, mouseX, mouseY)) continue;
                screen.func_146279_a(this.gateTile.getStargateAddress(this.symbolType).get(i).localize(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
    }

    public Tab.SlotTab createSlot(SlotItemHandler slot) {
        return new Tab.SlotTab(slot, slotTab -> {
            slotTab.field_75223_e = this.currentOffsetX + 106;
            slotTab.field_75221_f = this.defaultY + 87;
        });
    }

    public SymbolCoords getSymbolCoords(int symbol) {
        switch (this.symbolType) {
            case UNIVERSE: {
                return new SymbolCoords(this.guiLeft + this.currentOffsetX + 24 + 16 * (symbol % 6), this.guiTop + this.defaultY + 20 + 45 * (symbol / 6));
            }
            case PEGASUS: {
                return new SymbolCoords(this.guiLeft + this.currentOffsetX + 29 + 34 * (symbol % 3), this.guiTop + this.defaultY + 20 + 28 * (symbol / 3));
            }
        }
        return new SymbolCoords(this.guiLeft + this.currentOffsetX + 29 + 31 * (symbol % 3), this.guiTop + this.defaultY + 20 + 28 * (symbol / 3));
    }

    public static TabAddressBuilder builder() {
        return new TabAddressBuilder();
    }

    public static class TabAddressBuilder
    extends Tab.TabBuilder {
        private StargateClassicBaseTile gateTile;
        private SymbolTypeEnum symbolType;

        public TabAddressBuilder setGateTile(StargateClassicBaseTile gateTile) {
            this.gateTile = gateTile;
            return this;
        }

        public TabAddressBuilder setSymbolType(SymbolTypeEnum symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        @Override
        public TabAddress build() {
            return new TabAddress(this);
        }
    }

    public static class SymbolCoords {
        public final int x;
        public final int y;

        public SymbolCoords(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

