/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.element;

import java.awt.Rectangle;
import java.util.List;
import mrjake.aunis.gui.element.GuiHelper;
import mrjake.aunis.gui.element.TabSideEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.SlotItemHandler;

public abstract class Tab {
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected int defaultX;
    protected int defaultY;
    protected int openX;
    private int hiddenX;
    protected int width;
    protected int height;
    protected String tabTitle;
    protected TabSideEnum side;
    protected ResourceLocation bgTexLocation;
    protected int textureSize;
    private int bgTexX;
    private int bgTexY;
    private int iconX;
    private int iconY;
    private int iconWidth;
    private int iconHeight;
    private int iconTexX;
    private int iconTexY;
    private boolean isVisible = true;
    private boolean animate = false;
    private int startingOffsetX = 0;
    private boolean isTabOpen = false;
    private boolean isTabHidden = false;
    private float offsetPerTick;
    private long animationStart;
    private int animationTime;
    protected int currentOffsetX = 0;

    protected Tab(TabBuilder builder) {
        this.guiLeft = builder.guiLeft;
        this.guiTop = builder.guiTop;
        this.xSize = builder.xSize;
        this.ySize = builder.ySize;
        this.defaultX = builder.defaultX;
        this.defaultY = builder.defaultY;
        this.openX = builder.openX;
        this.hiddenX = builder.hiddenX;
        this.width = builder.width;
        this.height = builder.height;
        this.tabTitle = builder.tabTitle;
        this.side = builder.side;
        this.bgTexLocation = builder.bgTexLocation;
        this.textureSize = builder.textureSize;
        this.bgTexX = builder.bgTexX;
        this.bgTexY = builder.bgTexY;
        this.iconX = builder.iconX;
        this.iconY = builder.iconY;
        this.iconWidth = builder.iconWidth;
        this.iconHeight = builder.iconHeight;
        this.iconTexX = builder.iconTexX;
        this.iconTexY = builder.iconTexY;
        this.startingOffsetX = this.defaultX;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isOpen() {
        return this.isTabOpen;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHidden() {
        return this.isTabHidden;
    }

    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        if (!this.isVisible) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        this.updateAnimation(mc);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(this.bgTexLocation);
        Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX), (int)(this.guiTop + this.defaultY), (float)this.bgTexX, (float)this.bgTexY, (int)this.width, (int)this.height, (float)this.textureSize, (float)this.textureSize);
        Gui.func_146110_a((int)(this.guiLeft + this.iconX + this.currentOffsetX), (int)(this.guiTop + this.defaultY + this.iconY), (float)this.iconTexX, (float)this.iconTexY, (int)this.iconWidth, (int)this.iconHeight, (float)this.textureSize, (float)this.textureSize);
        fontRenderer.func_78276_b(this.tabTitle, this.guiLeft + this.currentOffsetX + (this.side.left() ? 24 : 0) + 4, this.guiTop + this.defaultY + 10, 0x404040);
        GlStateManager.func_179084_k();
    }

    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        if (!this.isVisible) {
            return;
        }
        if (!this.isTabOpen && this.isCursorOnTab(mouseX, mouseY)) {
            screen.func_146279_a(this.tabTitle, mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public boolean isCursorOnTab(int mouseX, int mouseY) {
        int xOffset = 0;
        if (this.isTabHidden && this.hiddenX < this.defaultX) {
            xOffset = 15;
        }
        return this.isVisible && GuiHelper.isPointInRegion(this.guiLeft + this.iconX + this.currentOffsetX + xOffset, this.guiTop + this.defaultY + this.iconY, this.iconWidth - (this.isTabHidden ? 15 : 0), this.iconHeight, mouseX, mouseY);
    }

    public void openTab() {
        this.animateTo(this.openX, 10);
        this.isTabHidden = false;
        this.isTabOpen = true;
    }

    public void closeTab() {
        this.animateTo(this.defaultX, this.isTabOpen ? 10 : 5);
        this.isTabHidden = false;
        this.isTabOpen = false;
    }

    public void hideTab() {
        this.animateTo(this.hiddenX, this.isTabOpen ? 10 : 5);
        this.isTabHidden = true;
        this.isTabOpen = false;
    }

    public void animateTo(int targetOffsetX, int animationTime) {
        this.animationTime = animationTime;
        this.startingOffsetX = this.currentOffsetX;
        this.offsetPerTick = (float)(targetOffsetX - this.startingOffsetX) / (float)animationTime;
        this.animationStart = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        this.animate = true;
    }

    public void updateAnimation(Minecraft mc) {
        this.currentOffsetX = this.startingOffsetX;
        if (this.animate) {
            float effTick = (float)(mc.field_71441_e.func_82737_E() - this.animationStart) + mc.func_184121_ak();
            if (effTick < (float)this.animationTime) {
                this.currentOffsetX += Math.round(this.offsetPerTick * effTick);
            } else {
                this.animate = false;
                this.currentOffsetX += (int)(this.offsetPerTick * (float)this.animationTime);
                this.startingOffsetX = this.currentOffsetX;
            }
        }
    }

    public Rectangle getArea() {
        int tabHeight;
        int n = tabHeight = this.isTabOpen | this.animate ? this.height : 34;
        if (this.side.left()) {
            return new Rectangle(this.guiLeft + this.currentOffsetX, this.guiTop + this.defaultY, Math.abs(this.currentOffsetX), tabHeight);
        }
        return new Rectangle(this.guiLeft + this.xSize, this.guiTop + this.defaultY, this.width + this.currentOffsetX - this.xSize, tabHeight);
    }

    public static boolean tabsInteract(List<Tab> tabs, int tabIndex) {
        Tab tab = tabs.get(tabIndex);
        for (Tab tab2 : tabs.subList(0, tabIndex)) {
            if (tab.side != tab2.side) continue;
            tab2.closeTab();
        }
        for (Tab tab2 : tabs.subList(tabIndex + 1, tabs.size())) {
            if (tab.side != tab2.side) continue;
            if (tab.isOpen()) {
                tab2.closeTab();
                continue;
            }
            tab2.hideTab();
        }
        if (tab.isOpen()) {
            tab.closeTab();
            return false;
        }
        tab.openTab();
        return true;
    }

    public static void updatePositions(List<Tab> tabs) {
        int yPosLeft = 2;
        int yPosRight = 2;
        for (Tab tab : tabs) {
            if (!tab.isVisible()) continue;
            if (tab.side.left()) {
                tab.defaultY = yPosLeft;
                yPosLeft += 22;
                continue;
            }
            tab.defaultY = yPosRight;
            yPosRight += 22;
        }
    }

    public static interface UpdateSlotPositionInterface {
        public void updatePos(SlotTab var1);
    }

    public class SlotTab
    extends SlotItemHandler {
        private UpdateSlotPositionInterface updateSlotPosition;

        public SlotTab(SlotItemHandler slot, UpdateSlotPositionInterface updateSlotPosition) {
            super(slot.getItemHandler(), slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
            this.field_75222_d = slot.field_75222_d;
            this.updateSlotPosition = updateSlotPosition;
        }

        public boolean func_111238_b() {
            return Tab.this.isTabOpen && !Tab.this.animate;
        }

        public void updatePos() {
            this.updateSlotPosition.updatePos(this);
        }
    }

    public static abstract class TabBuilder {
        private int guiLeft;
        private int guiTop;
        private int xSize;
        private int ySize;
        private int defaultX;
        private int defaultY;
        private int openX;
        private int hiddenX;
        private int width;
        private int height;
        private String tabTitle;
        private TabSideEnum side;
        private ResourceLocation bgTexLocation;
        private int textureSize;
        private int bgTexX;
        private int bgTexY;
        private int iconX;
        private int iconY;
        private int iconWidth;
        private int iconHeight;
        private int iconTexX;
        private int iconTexY;

        public TabBuilder setGuiSize(int xSize, int ySize) {
            this.xSize = xSize;
            this.ySize = ySize;
            return this;
        }

        public TabBuilder setGuiPosition(int guiLeft, int guiTop) {
            this.guiLeft = guiLeft;
            this.guiTop = guiTop;
            return this;
        }

        public TabBuilder setTabPosition(int defaultX, int defaultY) {
            this.defaultX = defaultX;
            this.defaultY = defaultY;
            return this;
        }

        public TabBuilder setOpenX(int openX) {
            this.openX = openX;
            return this;
        }

        public TabBuilder setHiddenX(int hiddenX) {
            this.hiddenX = hiddenX;
            return this;
        }

        public TabBuilder setTabSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public TabBuilder setTabTitle(String tabTitle) {
            this.tabTitle = tabTitle;
            return this;
        }

        public TabBuilder setTabSide(TabSideEnum side) {
            this.side = side;
            return this;
        }

        public TabBuilder setTexture(ResourceLocation bgTexLocation, int texureSize) {
            this.bgTexLocation = bgTexLocation;
            this.textureSize = texureSize;
            return this;
        }

        public TabBuilder setBackgroundTextureLocation(int bgTexX, int bgTexY) {
            this.bgTexX = bgTexX;
            this.bgTexY = bgTexY;
            return this;
        }

        public TabBuilder setIconRenderPos(int iconX, int iconY) {
            this.iconX = iconX;
            this.iconY = iconY;
            return this;
        }

        public TabBuilder setIconSize(int iconWidth, int iconHeight) {
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
            return this;
        }

        public TabBuilder setIconTextureLocation(int iconTexX, int iconTexY) {
            this.iconTexX = iconTexX;
            this.iconTexY = iconTexY;
            return this;
        }

        public abstract Tab build();
    }
}

