/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.element;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mrjake.aunis.gui.element.GuiHelper;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class Diode {
    public static final ResourceLocation DIODE_TEXTURE = new ResourceLocation("aunis", "textures/gui/diodes.png");
    private GuiScreen screen;
    private int x;
    private int y;
    private String description;
    private Map<DiodeStatus, String> statusStringMap;
    private DiodeStatus status;
    private StatusMapperInterface statusMapper;
    private StatusStringMapperInterface statusStringMapper;

    public Diode(GuiScreen screen, int x, int y, String description) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.description = description;
        this.statusStringMap = new HashMap<DiodeStatus, String>(3);
    }

    public Diode putStatus(DiodeStatus status, String statusString) {
        this.statusStringMap.put(status, statusString);
        return this;
    }

    public Diode setStatusMapper(StatusMapperInterface statusMapper) {
        this.statusMapper = statusMapper;
        return this;
    }

    public Diode setStatusStringMapper(StatusStringMapperInterface statusStringMapper) {
        this.statusStringMapper = statusStringMapper;
        return this;
    }

    public Diode setDiodeStatus(DiodeStatus status) {
        this.status = status;
        return this;
    }

    public boolean render(int mouseX, int mouseY) {
        this.status = this.statusMapper.get();
        GlStateManager.func_179147_l();
        this.screen.field_146297_k.func_110434_K().func_110577_a(DIODE_TEXTURE);
        Gui.func_146110_a((int)this.x, (int)this.y, (float)this.status.xTex, (float)this.status.yTex, (int)8, (int)7, (float)16.0f, (float)16.0f);
        GlStateManager.func_179084_k();
        return GuiHelper.isPointInRegion(this.x, this.y, 8, 8, mouseX, mouseY);
    }

    public void renderTooltip(int mouseX, int mouseY) {
        String statusString = null;
        if (this.statusStringMapper != null) {
            statusString = this.statusStringMapper.get();
        }
        if (statusString == null) {
            statusString = this.statusStringMap.get((Object)this.status);
        }
        TextComponentString textComponent = new TextComponentString(statusString);
        textComponent.func_150256_b().func_150217_b(Boolean.valueOf(true));
        textComponent.func_150256_b().func_150238_a(this.status.color);
        this.screen.func_146283_a(Arrays.asList(this.description, textComponent.func_150254_d()), mouseX, mouseY);
    }

    public static interface StatusStringMapperInterface {
        @Nullable
        public String get();
    }

    public static interface StatusMapperInterface {
        public DiodeStatus get();
    }

    public static enum DiodeStatus {
        OFF(0, 0, TextFormatting.DARK_RED),
        WARN(8, 0, TextFormatting.YELLOW),
        ON(0, 7, TextFormatting.GREEN);

        public int xTex;
        public int yTex;
        public TextFormatting color;

        private DiodeStatus(int xTex, int yTex, TextFormatting color) {
            this.xTex = xTex;
            this.yTex = yTex;
            this.color = color;
        }
    }
}

