/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.container;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.container.StargateContainer;
import mrjake.aunis.gui.element.Tab;
import mrjake.aunis.gui.element.TabAddress;
import mrjake.aunis.gui.element.TabBiomeOverlay;
import mrjake.aunis.gui.element.TabIris;
import mrjake.aunis.gui.element.TabSideEnum;
import mrjake.aunis.gui.element.TabbedContainerInterface;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.SetOpenTabToServer;
import mrjake.aunis.packet.stargate.SaveIrisCodeToServer;
import mrjake.aunis.stargate.network.SymbolMilkyWayEnum;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.stargate.network.SymbolUniverseEnum;
import mrjake.aunis.stargate.power.StargateClassicEnergyStorage;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.SlotItemHandler;

public class StargateContainerGui
extends GuiContainer
implements TabbedContainerInterface {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("aunis", "textures/gui/container_stargate.png");
    private StargateContainer container;
    private List<Tab> tabs;
    private TabAddress milkyWayAddressTab;
    private TabAddress pegasusAddressTab;
    private TabAddress universeAddressTab;
    private TabBiomeOverlay overlayTab;
    private TabIris irisTab;
    private int energyStored;
    private int maxEnergyStored;
    private BlockPos pos;

    public StargateContainerGui(BlockPos pos, StargateContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 168;
        this.pos = pos;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs = new ArrayList<Tab>();
        this.milkyWayAddressTab = (TabAddress)TabAddress.builder().setGateTile(this.container.gateTile).setSymbolType(SymbolTypeEnum.MILKYWAY).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 2).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.stargate.milky_way_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(1, 7).setIconSize(20, 18).setIconTextureLocation(304, 0).build();
        this.pegasusAddressTab = (TabAddress)TabAddress.builder().setGateTile(this.container.gateTile).setSymbolType(SymbolTypeEnum.PEGASUS).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 24).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.stargate.pegasus_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(1, 7).setIconSize(20, 18).setIconTextureLocation(304, 18).build();
        this.universeAddressTab = (TabAddress)TabAddress.builder().setGateTile(this.container.gateTile).setSymbolType(SymbolTypeEnum.UNIVERSE).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 46).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.stargate.universe_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(1, 7).setIconSize(20, 18).setIconTextureLocation(304, 36).build();
        this.overlayTab = (TabBiomeOverlay)TabBiomeOverlay.builder().setSupportedOverlays(this.container.gateTile.getSupportedOverlays()).setSlotTexture(6, 174).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(69, 2).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.func_135052_a((String)"gui.stargate.biome_overlay", (Object[])new Object[0])).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 113).setIconRenderPos(107, 7).setIconSize(20, 18).setIconTextureLocation(304, 54).build();
        this.irisTab = (TabIris)TabIris.builder().setCode(this.container.gateTile.getIrisCode()).setIrisMode(this.container.gateTile.getIrisMode()).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(69, 24).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.func_135052_a((String)"gui.stargate.iris_code", (Object[])new Object[0])).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 113).setIconRenderPos(107, 7).setIconSize(20, 18).setIconTextureLocation(304, 72).build();
        this.irisTab.setOnTabClose(this::saveIrisCode);
        this.tabs.add(this.milkyWayAddressTab);
        this.tabs.add(this.pegasusAddressTab);
        this.tabs.add(this.universeAddressTab);
        this.tabs.add(this.overlayTab);
        this.tabs.add(this.irisTab);
        this.container.field_75151_b.set(7, this.milkyWayAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(7)));
        this.container.field_75151_b.set(8, this.pegasusAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(8)));
        this.container.field_75151_b.set(9, this.universeAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(9)));
        this.container.field_75151_b.set(10, this.overlayTab.createAndSaveSlot((SlotItemHandler)this.container.func_75139_a(10)));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.func_146276_q_();
        boolean hasAddressUpgrade = false;
        boolean hasMilkyWayUpgrade = false;
        boolean hasAtlantisUpgrade = false;
        boolean hasUniverseUpgrade = false;
        boolean hasIrisUpgrade = !this.container.func_75139_a(11).func_75211_c().func_190926_b();
        block6: for (int i2 = 0; i2 < 4; ++i2) {
            StargateClassicBaseTile.StargateUpgradeEnum upgrade;
            ItemStack itemStack = this.container.func_75139_a(i2).func_75211_c();
            if (itemStack.func_190926_b() || (upgrade = StargateClassicBaseTile.StargateUpgradeEnum.valueOf(itemStack.func_77973_b())) == null) continue;
            switch (upgrade) {
                case CHEVRON_UPGRADE: {
                    hasAddressUpgrade = true;
                    continue block6;
                }
                case MILKYWAY_GLYPHS: {
                    hasMilkyWayUpgrade = true;
                    continue block6;
                }
                case PEGASUS_GLYPHS: {
                    hasAtlantisUpgrade = true;
                    continue block6;
                }
                case UNIVERSE_GLYPHS: {
                    hasUniverseUpgrade = true;
                }
            }
        }
        this.milkyWayAddressTab.setMaxSymbols(SymbolMilkyWayEnum.getMaxSymbolsDisplay(hasAddressUpgrade));
        this.pegasusAddressTab.setMaxSymbols(SymbolPegasusEnum.getMaxSymbolsDisplay(hasAddressUpgrade));
        this.universeAddressTab.setMaxSymbols(SymbolUniverseEnum.getMaxSymbolsDisplay(hasAddressUpgrade));
        this.milkyWayAddressTab.setVisible(hasMilkyWayUpgrade);
        this.pegasusAddressTab.setVisible(hasAtlantisUpgrade);
        this.universeAddressTab.setVisible(hasUniverseUpgrade);
        this.irisTab.setVisible(hasIrisUpgrade);
        Tab.updatePositions(this.tabs);
        StargateClassicEnergyStorage energyStorageInternal = (StargateClassicEnergyStorage)((Object)this.container.gateTile.getCapability(CapabilityEnergy.ENERGY, null));
        this.energyStored = energyStorageInternal.getEnergyStoredInternally();
        this.maxEnergyStored = energyStorageInternal.getMaxEnergyStoredInternally();
        for (i = 4; i < 7; ++i) {
            IEnergyStorage energyStorage = (IEnergyStorage)this.container.func_75139_a(i).func_75211_c().getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage == null) continue;
            this.energyStored += energyStorage.getEnergyStored();
            this.maxEnergyStored += energyStorage.getMaxEnergyStored();
        }
        for (i = 7; i < 11; ++i) {
            ((Tab.SlotTab)this.container.func_75139_a(i)).updatePos();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        if (this.irisTab.isVisible() && !this.irisTab.isOpen()) {
            if (this.irisTab.getIrisMode() != this.container.gateTile.getIrisMode()) {
                this.irisTab.updateValue(this.container.gateTile.getIrisMode());
            }
            if (this.irisTab.getCode() != this.container.gateTile.getIrisCode()) {
                this.irisTab.updateValue(this.container.gateTile.getIrisCode());
            }
        }
        for (Tab tab : this.tabs) {
            tab.render(this.field_146289_q, mouseX, mouseY);
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StargateContainerGui.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)512.0f, (float)512.0f);
        for (i = 0; i < 3 - this.container.gateTile.getSupportedCapacitors(); ++i) {
            StargateContainerGui.func_146110_a((int)(this.field_147003_i + 151 - 18 * i), (int)(this.field_147009_r + 40), (float)24.0f, (float)175.0f, (int)16, (int)16, (float)512.0f, (float)512.0f);
        }
        for (i = this.container.gateTile.getPowerTier(); i < 4; ++i) {
            StargateContainerGui.func_146110_a((int)(this.field_147003_i + 10 + 39 * i), (int)(this.field_147009_r + 61), (float)0.0f, (float)168.0f, (int)39, (int)6, (float)512.0f, (float)512.0f);
        }
        int width = Math.round((float)this.energyStored / (float)AunisConfig.powerConfig.stargateEnergyStorage * 156.0f);
        this.func_73733_a(this.field_147003_i + 10, this.field_147009_r + 61, this.field_147003_i + 10 + width, this.field_147009_r + 61 + 6, -3397592, -9234922);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.stargate.capacitors", (Object[])new Object[0]), 112, 29, 0x404040);
        String energyPercent = String.format("%.2f", Float.valueOf((float)this.energyStored / (float)this.maxEnergyStored * 100.0f)) + " %";
        this.field_146289_q.func_78276_b(energyPercent, 168 - this.field_146289_q.func_78256_a(energyPercent) + 2, 71, 0x404040);
        float openedSeconds = this.container.gateTile.getOpenedSecondsToDisplay();
        if (openedSeconds > 0.0f) {
            int minutes = (int)Math.floor(openedSeconds / 60.0f);
            int seconds = (int)(openedSeconds - (float)(60 * minutes));
            String secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
            String openedTime = "Opened: " + minutes + ":" + secondsString + "min";
            this.field_146289_q.func_78276_b(openedTime, 46, 16, 0x404040);
        } else {
            this.field_146289_q.func_78276_b("Gate closed", 46, 16, 0x404040);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.upgrades", (Object[])new Object[0]), 7, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        for (Tab tab : this.tabs) {
            tab.renderFg((GuiScreen)this, this.field_146289_q, mouseX, mouseY);
        }
        int transferred = this.container.gateTile.getEnergyTransferedLastTick();
        TextFormatting transferredFormatting = TextFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = TextFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = TextFormatting.RED;
        }
        float toClose = this.container.gateTile.getEnergySecondsToClose();
        TextFormatting toCloseFormatting = TextFormatting.GRAY;
        if (toClose > 0.0f) {
            toCloseFormatting = toClose < (float)AunisConfig.powerConfig.instabilitySeconds ? TextFormatting.DARK_RED : TextFormatting.GREEN;
        }
        if (this.func_146978_c(10, 61, 156, 6, mouseX, mouseY)) {
            List<String> power = Arrays.asList(I18n.func_135052_a((String)"gui.stargate.energyBuffer", (Object[])new Object[0]), TextFormatting.GRAY + String.format("%,d / %,d RF", this.energyStored, this.maxEnergyStored), transferredFormatting + transferredSign + String.format("%,d RF/t", transferred), toCloseFormatting + String.format("%.2f s", Float.valueOf(toClose)));
            this.func_146283_a(power, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab(mouseX, mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                this.container.setOpenTabId(i);
            } else {
                this.container.setOpenTabId(-1);
            }
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new SetOpenTabToServer(this.container.getOpenTabId()));
            break;
        }
        if (this.irisTab.isOpen()) {
            this.irisTab.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.tabs.stream().map(tab -> tab.getArea()).collect(Collectors.toList());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.irisTab.isOpen()) {
            this.irisTab.keyTyped(typedChar, keyCode);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146281_b() {
        this.saveIrisCode();
    }

    private void saveIrisCode() {
        AunisPacketHandler.INSTANCE.sendToServer((IMessage)new SaveIrisCodeToServer(this.pos, this.irisTab.getCode(), this.irisTab.getIrisMode()));
        this.container.gateTile.setIrisCode(this.irisTab.getCode());
        this.container.gateTile.setIrisMode(this.irisTab.getIrisMode());
    }
}

