/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.container;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mrjake.aunis.fluid.AunisFluids;
import mrjake.aunis.gui.container.DHDContainer;
import mrjake.aunis.gui.element.Diode;
import mrjake.aunis.gui.element.FluidTankElement;
import mrjake.aunis.gui.element.GuiHelper;
import mrjake.aunis.gui.element.Tab;
import mrjake.aunis.gui.element.TabBiomeOverlay;
import mrjake.aunis.gui.element.TabSideEnum;
import mrjake.aunis.gui.element.TabbedContainerInterface;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.SetOpenTabToServer;
import mrjake.aunis.tileentity.util.ReactorStateEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.SlotItemHandler;

public class DHDContainerGui
extends GuiContainer
implements TabbedContainerInterface {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("aunis", "textures/gui/container_dhd.png");
    private DHDContainer container;
    private FluidTankElement tank;
    private List<Diode> diodes = new ArrayList<Diode>(3);
    private List<Tab> tabs = new ArrayList<Tab>();
    private TabBiomeOverlay overlayTab;

    public DHDContainerGui(DHDContainer container) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 168;
        this.container = container;
        container.tankNaquadah.setFluid(new FluidStack((Fluid)AunisFluids.moltenNaquadahRefined, 0));
        this.tank = new FluidTankElement(this, 151, 18, 16, 54, container.tankNaquadah);
        this.diodes.add(new Diode((GuiScreen)this, 8, 55, I18n.func_135052_a((String)"gui.dhd.crystalStatus", (Object[])new Object[0])).setDiodeStatus(Diode.DiodeStatus.OFF).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.no_crystal", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.crystal_ok", (Object[])new Object[0])).setStatusMapper(() -> container.slotCrystal.func_75216_d() ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((GuiScreen)this, 17, 55, I18n.func_135052_a((String)"gui.dhd.linkStatus", (Object[])new Object[0])).setDiodeStatus(Diode.DiodeStatus.OFF).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.linked", (Object[])new Object[0])).setStatusMapper(() -> container.dhdMilkyWayTile.isLinkedClient ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((GuiScreen)this, 26, 55, I18n.func_135052_a((String)"gui.dhd.reactorStatus", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.no_fuel", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.WARN, I18n.func_135052_a((String)"gui.dhd.standby", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.running", (Object[])new Object[0])).setStatusMapper(() -> {
            switch (container.dhdMilkyWayTile.getReactorState()) {
                case NOT_LINKED: 
                case NO_CRYSTAL: 
                case NO_FUEL: {
                    return Diode.DiodeStatus.OFF;
                }
                case ONLINE: {
                    return Diode.DiodeStatus.ON;
                }
                case STANDBY: {
                    return Diode.DiodeStatus.WARN;
                }
            }
            return Diode.DiodeStatus.OFF;
        }).setStatusStringMapper(() -> {
            switch (container.dhdMilkyWayTile.getReactorState()) {
                case NOT_LINKED: {
                    return I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0]);
                }
                case NO_CRYSTAL: {
                    return I18n.func_135052_a((String)"gui.dhd.no_crystal", (Object[])new Object[0]);
                }
            }
            return null;
        }));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.overlayTab = (TabBiomeOverlay)TabBiomeOverlay.builder().setSupportedOverlays(this.container.dhdMilkyWayTile.getSupportedOverlays()).setSlotTexture(176, 86).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(69, 2).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.func_135052_a((String)"gui.stargate.biome_overlay", (Object[])new Object[0])).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 256).setBackgroundTextureLocation(0, 194).setIconRenderPos(107, 7).setIconSize(20, 18).setIconTextureLocation(176, 104).build();
        this.tabs.add(this.overlayTab);
        this.container.field_75151_b.set(5, this.overlayTab.createAndSaveSlot((SlotItemHandler)this.container.func_75139_a(5)));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        Tab.updatePositions(this.tabs);
        ((Tab.SlotTab)this.container.func_75139_a(5)).updatePos();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            tab.render(this.field_146289_q, mouseX, mouseY);
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.container.slotCrystal.func_75216_d()) {
            GlStateManager.func_179147_l();
            this.func_73729_b(this.field_147003_i + 76, this.field_147009_r + 16, 176, 0, 24, 32);
            GlStateManager.func_179084_k();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.container.dhdMilkyWayTile.getReactorState() == ReactorStateEnum.ONLINE) {
            int i;
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(AunisFluids.moltenNaquadahRefined.getStill().toString());
            for (i = 0; i < 3; ++i) {
                this.func_175175_a(this.field_147003_i + 102 + 16 * i, this.field_147009_r + 55, sprite, 16, 16);
            }
            for (i = 0; i < 5; ++i) {
                GuiHelper.drawTexturedRectScaled(this.field_147003_i + 86 + 16 * i, this.field_147009_r + 82, sprite, 16, 16, 0.625f);
            }
        }
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(this.field_147003_i + 102, this.field_147009_r + 55, 0, 168, 48, 16);
        this.func_73729_b(this.field_147003_i + 83, this.field_147009_r + 72, 0, 184, 84, 10);
        GlStateManager.func_179084_k();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int i;
        String fusion = I18n.func_135052_a((String)"gui.dhd.fusion", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(fusion, 168 - this.field_146289_q.func_78256_a(fusion) + 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.upgrades", (Object[])new Object[0]), 7, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.tank.renderTank();
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(151, 18, 176, 32, 16, 54);
        GlStateManager.func_179084_k();
        boolean[] statuses = new boolean[this.diodes.size()];
        for (i = 0; i < this.diodes.size(); ++i) {
            statuses[i] = this.diodes.get(i).render(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        for (i = 0; i < this.diodes.size(); ++i) {
            if (!statuses[i]) continue;
            this.diodes.get(i).renderTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        this.tank.renderTooltip(mouseX, mouseY);
        for (Tab tab : this.tabs) {
            tab.renderFg((GuiScreen)this, this.field_146289_q, mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab(mouseX, mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                this.container.setOpenTabId(i);
            } else {
                this.container.setOpenTabId(-1);
            }
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new SetOpenTabToServer(this.container.getOpenTabId()));
            break;
        }
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.tabs.stream().map(tab -> tab.getArea()).collect(Collectors.toList());
    }
}

