/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui.container;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mrjake.aunis.beamer.BeamerModeEnum;
import mrjake.aunis.beamer.BeamerStatusEnum;
import mrjake.aunis.gui.container.BeamerContainer;
import mrjake.aunis.gui.element.Diode;
import mrjake.aunis.gui.element.FluidTankElement;
import mrjake.aunis.gui.element.Tab;
import mrjake.aunis.gui.element.TabRedstone;
import mrjake.aunis.gui.element.TabSideEnum;
import mrjake.aunis.gui.element.TabbedContainerInterface;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.BeamerChangeRoleToServer;
import mrjake.aunis.stargate.power.StargateAbstractEnergyStorage;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.SlotItemHandler;

public class BeamerContainerGui
extends GuiContainer
implements TabbedContainerInterface {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("aunis", "textures/gui/container_beamer.png");
    private BeamerContainer container;
    private FluidTankElement tank;
    private List<Diode> diodes = new ArrayList<Diode>();
    private List<Tab> tabs = new ArrayList<Tab>();
    private TabRedstone tabRedstone;
    private boolean updated = false;

    public BeamerContainerGui(BeamerContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 168;
        this.tank = new FluidTankElement(this, this.field_147003_i + 11, this.field_147009_r + 17, 16, 54, container.tank);
        for (int i = 1; i < 5; ++i) {
            container.field_75151_b.set(i, new BeamerSlot((SlotItemHandler)container.func_75139_a(i)));
        }
        int x = 125;
        this.diodes.add(new Diode((GuiScreen)this, x, 40, I18n.func_135052_a((String)"gui.dhd.crystalStatus", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.no_crystal", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.crystal_ok", (Object[])new Object[0])).setStatusMapper(() -> container.beamerTile.getStatus() != BeamerStatusEnum.NO_CRYSTAL ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((GuiScreen)this, x += 9, 40, I18n.func_135052_a((String)"gui.dhd.linkStatus", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.linked", (Object[])new Object[0])).setStatusMapper(() -> container.beamerTile.getStatus() != BeamerStatusEnum.NOT_LINKED ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((GuiScreen)this, x += 9, 40, I18n.func_135052_a((String)"gui.beamer.beamer_status", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.beamer.beamer_ok", (Object[])new Object[0])).setStatusMapper(() -> {
            switch (container.beamerTile.getStatus()) {
                case OBSTRUCTED: 
                case NOT_LINKED: 
                case NO_CRYSTAL: {
                    return Diode.DiodeStatus.OFF;
                }
                case CLOSED: {
                    return Diode.DiodeStatus.WARN;
                }
            }
            return Diode.DiodeStatus.ON;
        }).setStatusStringMapper(() -> {
            switch (container.beamerTile.getStatus()) {
                case NOT_LINKED: {
                    return I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0]);
                }
                case NO_CRYSTAL: {
                    return I18n.func_135052_a((String)"gui.beamer.no_crystal", (Object[])new Object[0]);
                }
                case CLOSED: {
                    return I18n.func_135052_a((String)"gui.beamer.closed", (Object[])new Object[0]);
                }
                case OBSTRUCTED: {
                    return I18n.func_135052_a((String)"gui.beamer.obstructed", (Object[])new Object[0]);
                }
            }
            return null;
        }));
        this.diodes.add(new Diode((GuiScreen)this, x += 9, 40, I18n.func_135052_a((String)"gui.beamer.beamer_link_status", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.running", (Object[])new Object[0])).setStatusMapper(() -> {
            switch (container.beamerTile.getStatus()) {
                case OBSTRUCTED: 
                case OBSTRUCTED_TARGET: 
                case NO_BEAMER: 
                case NOT_LINKED: 
                case NO_CRYSTAL: 
                case CLOSED: {
                    return Diode.DiodeStatus.OFF;
                }
            }
            return Diode.DiodeStatus.ON;
        }).setStatusStringMapper(() -> {
            switch (container.beamerTile.getStatus()) {
                case NOT_LINKED: {
                    return I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0]);
                }
                case NO_CRYSTAL: {
                    return I18n.func_135052_a((String)"gui.beamer.no_crystal", (Object[])new Object[0]);
                }
                case NO_BEAMER: {
                    return I18n.func_135052_a((String)"gui.beamer.no_beamer", (Object[])new Object[0]);
                }
                case CLOSED: {
                    return I18n.func_135052_a((String)"gui.beamer.closed", (Object[])new Object[0]);
                }
                case OBSTRUCTED: {
                    return I18n.func_135052_a((String)"gui.beamer.obstructed", (Object[])new Object[0]);
                }
                case OBSTRUCTED_TARGET: {
                    return I18n.func_135052_a((String)"gui.beamer.obstructed_target", (Object[])new Object[0]);
                }
            }
            return null;
        }));
        this.diodes.add(new Diode((GuiScreen)this, x += 9, 40, I18n.func_135052_a((String)"gui.beamer.role_status", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.role_ok", (Object[])new Object[0])).setStatusMapper(() -> {
            switch (container.beamerTile.getStatus()) {
                case OBSTRUCTED: 
                case OBSTRUCTED_TARGET: 
                case TWO_TRANSMITTERS: 
                case TWO_RECEIVERS: 
                case MODE_MISMATCH: 
                case BEAMER_DISABLED: 
                case BEAMER_DISABLED_TARGET: 
                case NO_BEAMER: 
                case NOT_LINKED: 
                case NO_CRYSTAL: 
                case CLOSED: {
                    return Diode.DiodeStatus.OFF;
                }
                case INCOMING: 
                case BEAMER_DISABLED_BY_LOGIC: 
                case BEAMER_DISABLED_BY_LOGIC_TARGET: {
                    return Diode.DiodeStatus.WARN;
                }
                case OK: {
                    return Diode.DiodeStatus.ON;
                }
            }
            return Diode.DiodeStatus.OFF;
        }).setStatusStringMapper(() -> {
            switch (container.beamerTile.getStatus()) {
                case OBSTRUCTED: {
                    return I18n.func_135052_a((String)"gui.beamer.obstructed", (Object[])new Object[0]);
                }
                case OBSTRUCTED_TARGET: {
                    return I18n.func_135052_a((String)"gui.beamer.obstructed_target", (Object[])new Object[0]);
                }
                case TWO_TRANSMITTERS: {
                    return I18n.func_135052_a((String)"gui.beamer.two_transmitters", (Object[])new Object[0]);
                }
                case TWO_RECEIVERS: {
                    return I18n.func_135052_a((String)"gui.beamer.two_receivers", (Object[])new Object[0]);
                }
                case MODE_MISMATCH: {
                    return I18n.func_135052_a((String)"gui.beamer.mode_mismatch", (Object[])new Object[0]);
                }
                case BEAMER_DISABLED: {
                    return I18n.func_135052_a((String)"gui.beamer.disabled", (Object[])new Object[0]);
                }
                case BEAMER_DISABLED_TARGET: {
                    return I18n.func_135052_a((String)"gui.beamer.disabled_target", (Object[])new Object[0]);
                }
                case NO_BEAMER: {
                    return I18n.func_135052_a((String)"gui.beamer.no_beamer", (Object[])new Object[0]);
                }
                case NOT_LINKED: {
                    return I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0]);
                }
                case NO_CRYSTAL: {
                    return I18n.func_135052_a((String)"gui.beamer.no_crystal", (Object[])new Object[0]);
                }
                case CLOSED: {
                    return I18n.func_135052_a((String)"gui.beamer.closed", (Object[])new Object[0]);
                }
                case INCOMING: {
                    return I18n.func_135052_a((String)"gui.beamer.incoming", (Object[])new Object[0]);
                }
                case BEAMER_DISABLED_BY_LOGIC: {
                    return I18n.func_135052_a((String)"gui.beamer.disabled_by_logic", (Object[])new Object[0]);
                }
                case BEAMER_DISABLED_BY_LOGIC_TARGET: {
                    return I18n.func_135052_a((String)"gui.beamer.disabled_by_logic_target", (Object[])new Object[0]);
                }
                case OK: {
                    return I18n.func_135052_a((String)"gui.beamer.running", (Object[])new Object[0]);
                }
            }
            return null;
        }));
        x += 9;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 124, this.field_147009_r + 18, 46, 20, "Change"));
        this.tabRedstone = (TabRedstone)TabRedstone.builder().setFontRenderer(this.field_146289_q).setRedstoneModeGetter(() -> this.container.beamerTile.getRedstoneMode()).setBeamerModeGetter(() -> this.container.beamerTile.getMode()).setBlockPos(this.container.pos).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 2).setOpenX(-128).setTabSize(128, 80).setTabTitle(I18n.func_135052_a((String)"gui.beamer.activation", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 256).setBackgroundTextureLocation(0, 176).setIconRenderPos(1, 7).setIconSize(20, 18).setIconTextureLocation(128, 176).build();
        this.updated = false;
        this.tabs.clear();
        this.tabs.add(this.tabRedstone);
    }

    public void updateStartStopInactivity() {
        if (this.updated) {
            return;
        }
        this.updated = true;
        this.tabRedstone.setText(0, this.container.beamerTile.getStart());
        this.tabRedstone.setText(1, this.container.beamerTile.getStop());
        this.tabRedstone.setText(2, this.container.beamerTile.getInactivity());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        Tab.updatePositions(this.tabs);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            tab.render(this.field_146289_q, mouseX, mouseY);
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        switch (this.container.beamerTile.getMode()) {
            case POWER: {
                this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 15, 176, 0, 27, 24);
                this.func_73729_b(this.field_147003_i + 9, this.field_147009_r + 60, 0, 168, 158, 8);
                StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.container.beamerTile.getCapability(CapabilityEnergy.ENERGY, null));
                int width = Math.round((float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored() * 156.0f);
                this.func_73733_a(this.field_147003_i + 10, this.field_147009_r + 61, this.field_147003_i + 10 + width, this.field_147009_r + 61 + 6, -3397592, -9234922);
                break;
            }
            case FLUID: {
                this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 15, 203, 0, 27, 24);
                this.func_73729_b(this.field_147003_i + 10, this.field_147009_r + 16, 176, 86, 18, 56);
                break;
            }
            case ITEMS: {
                this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 15, 203, 24, 27, 24);
                this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 17, 193, 48, 36, 36);
                break;
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int i;
        String role = I18n.func_135052_a((String)this.container.beamerTile.getRole().translationKey, (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(role, 168 - this.field_146289_q.func_78256_a(role) + 2, 8, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.beamer.name", (Object[])new Object[0]), 7, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        boolean[] statuses = new boolean[this.diodes.size()];
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        for (i = 0; i < this.diodes.size(); ++i) {
            statuses[i] = this.diodes.get(i).render(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        for (i = 0; i < this.diodes.size(); ++i) {
            if (!statuses[i]) continue;
            this.diodes.get(i).renderTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        GlStateManager.func_179140_f();
        switch (this.container.beamerTile.getMode()) {
            case POWER: {
                StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.container.beamerTile.getCapability(CapabilityEnergy.ENERGY, null));
                int energyStored = energyStorage.getEnergyStored();
                int maxEnergyStored = energyStorage.getMaxEnergyStored();
                String energyPercent = String.format("%.2f", Float.valueOf((float)energyStored / (float)maxEnergyStored * 100.0f)) + " %";
                this.field_146289_q.func_78276_b(energyPercent, 170 - this.field_146289_q.func_78256_a(energyPercent), 71, 0x404040);
                int transferred = this.container.beamerTile.getEnergyTransferredLastTick();
                TextFormatting transferredFormatting = TextFormatting.GRAY;
                String transferredSign = "";
                if (transferred > 0) {
                    transferredFormatting = TextFormatting.GREEN;
                    transferredSign = "+";
                } else if (transferred < 0) {
                    transferredFormatting = TextFormatting.RED;
                }
                if (!this.func_146978_c(10, 61, 156, 6, mouseX, mouseY)) break;
                List<String> power = Arrays.asList(I18n.func_135052_a((String)"gui.stargate.energyBuffer", (Object[])new Object[0]), TextFormatting.GRAY + String.format("%,d / %,d RF", energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored()), transferredFormatting + transferredSign + String.format("%,d RF/t", transferred));
                this.func_146283_a(power, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                break;
            }
            case FLUID: {
                this.tank.renderTank();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
                this.func_73729_b(11, 18, 176, 32, 16, 54);
                GlStateManager.func_179084_k();
                this.tank.renderTooltip(mouseX, mouseY);
                break;
            }
            case ITEMS: {
                break;
            }
        }
        for (Tab tab : this.tabs) {
            tab.renderFg((GuiScreen)this, this.field_146289_q, mouseX, mouseY);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        AunisPacketHandler.INSTANCE.sendToServer((IMessage)new BeamerChangeRoleToServer(this.container.pos));
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.tabRedstone.keyTyped(typedChar, keyCode);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.tabRedstone.updateScreen();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab(mouseX, mouseY)) continue;
            Tab.tabsInteract(this.tabs, i);
            break;
        }
        this.tabRedstone.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.tabs.stream().map(tab -> tab.getArea()).collect(Collectors.toList());
    }

    private class BeamerSlot
    extends SlotItemHandler {
        public BeamerSlot(SlotItemHandler slot) {
            super(slot.getItemHandler(), slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
            this.field_75222_d = slot.field_75222_d;
        }

        public boolean func_111238_b() {
            return ((BeamerContainerGui)BeamerContainerGui.this).container.beamerTile.getMode() == BeamerModeEnum.ITEMS;
        }
    }
}

