/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mrjake.aunis.Aunis;
import mrjake.aunis.gui.base.AunisGuiBase;
import mrjake.aunis.gui.base.AunisGuiButton;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.transportrings.SaveRingsParametersToServer;
import mrjake.aunis.state.transportrings.TransportRingsGuiState;
import mrjake.aunis.transportrings.TransportRings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RingsGUI
extends AunisGuiBase {
    private BlockPos pos;
    public TransportRingsGuiState state;
    private List<GuiTextField> textFields = new ArrayList<GuiTextField>();
    private GuiTextField addressTextField;
    private GuiTextField nameTextField;
    private AunisGuiButton saveButton;

    public RingsGUI(BlockPos pos, TransportRingsGuiState state) {
        super(196, 160, 8, -16777216, -232314061, 7042700, 4);
        this.pos = pos;
        this.state = state;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addressTextField = this.createTextField(50, 20, 1, this.state.isInGrid() ? "" + this.state.getAddress() : "");
        this.textFields.add(this.addressTextField);
        this.nameTextField = this.createTextField(50, 35, 16, this.state.getName());
        this.textFields.add(this.nameTextField);
        this.saveButton = new AunisGuiButton(this.id++, this.getBottomRightInside(false) - 90, this.getBottomRightInside(true) - 20, 90, 20, Aunis.proxy.localize("tile.aunis.transportrings_block.rings_save", new Object[0]));
        this.field_146292_n.add(this.saveButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        mouseX -= this.getTopLeftAbsolute(false);
        mouseY -= this.getTopLeftAbsolute(true);
        GlStateManager.func_179094_E();
        this.translateToCenter();
        this.drawBackground();
        if (this.state.isInGrid()) {
            this.drawVerticallCenteredString(new TextComponentTranslation("tile.aunis.transportrings_block.rings_no", new Object[]{this.state.getAddress()}).func_150254_d(), 0, 0, 0xAA5500);
        } else {
            this.drawVerticallCenteredString(Aunis.proxy.localize("tile.aunis.transportrings_block.rings_not_in_grid", new Object[0]), 0, 0, 11756130);
        }
        this.drawString(Aunis.proxy.localize("tile.aunis.transportrings_block.rings_address", new Object[0]) + ": ", 0, 20, 43520);
        this.drawString(Aunis.proxy.localize("tile.aunis.transportrings_block.rings_name", new Object[0]) + ": ", 0, 35, 43690);
        for (GuiTextField tf : this.textFields) {
            this.drawTextBox(tf);
        }
        int y = 50;
        for (TransportRings rings : this.state.getRings()) {
            this.drawString("" + rings.getAddress(), 60, y, 43520);
            this.drawString(rings.getName(), 70, y, 43690);
            y += 12;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.saveButton) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            try {
                int address = Integer.valueOf(this.addressTextField.func_146179_b());
                String name = this.nameTextField.func_146179_b();
                if (address > 0 && address <= 6) {
                    AunisPacketHandler.INSTANCE.sendToServer((IMessage)new SaveRingsParametersToServer(this.pos, address, name));
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.transportrings_block.wrong_address", new Object[0]), true);
                }
            }
            catch (NumberFormatException e) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.transportrings_block.wrong_address", new Object[0]), true);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (GuiTextField tf : this.textFields) {
            tf.func_146201_a(typedChar, keyCode);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField tf : this.textFields) {
            tf.func_146178_a();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX -= this.getTopLeftAbsolute(false), mouseY -= this.getTopLeftAbsolute(true), mouseButton);
        for (GuiTextField tf : this.textFields) {
            tf.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }
}

