/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import mrjake.aunis.Aunis;
import mrjake.aunis.gui.GuiSendCode;
import mrjake.aunis.gui.PageRenameGui;
import mrjake.aunis.gui.entry.NotebookEntryChangeGui;
import mrjake.aunis.gui.entry.OCEntryChangeGui;
import mrjake.aunis.gui.entry.UniverseEntryChangeGui;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.dialer.UniverseDialerActionEnum;
import mrjake.aunis.item.dialer.UniverseDialerActionPacketToServer;
import mrjake.aunis.item.dialer.UniverseDialerItem;
import mrjake.aunis.item.gdo.GDOActionEnum;
import mrjake.aunis.item.gdo.GDOActionPacketToServer;
import mrjake.aunis.item.gdo.GDOMode;
import mrjake.aunis.item.notebook.NotebookActionEnum;
import mrjake.aunis.item.notebook.NotebookActionPacketToServer;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InputHandlerClient {
    private static final KeyBinding MODE_SCROLL = new KeyBinding("config.aunis.mode_scroll", 29, "Aunis");
    private static final KeyBinding ADDRESS_SCROLL = new KeyBinding("config.aunis.address_scroll", 42, "Aunis");
    private static final KeyBinding MODE_UP = new KeyBinding("config.aunis.mode_up", 0, "Aunis");
    private static final KeyBinding MODE_DOWN = new KeyBinding("config.aunis.mode_down", 0, "Aunis");
    private static final KeyBinding ADDRESS_UP = new KeyBinding("config.aunis.address_up", 0, "Aunis");
    private static final KeyBinding ADDRESS_DOWN = new KeyBinding("config.aunis.address_down", 0, "Aunis");
    private static final KeyBinding ADDRESS_EDIT = new KeyBinding("config.aunis.address_edit", 210, "Aunis");
    private static final Method METHOD_UNPRESS = ObfuscationReflectionHelper.findMethod(KeyBinding.class, (String)"func_74505_d", Void.TYPE, (Class[])new Class[0]);
    private static final KeyBinding[] KEY_BINDINGS = new KeyBinding[]{MODE_SCROLL, ADDRESS_SCROLL, MODE_UP, MODE_DOWN, ADDRESS_UP, ADDRESS_DOWN, ADDRESS_EDIT};

    public static void registerKeybindings() {
        for (KeyBinding keyb : KEY_BINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyb);
        }
    }

    @Nullable
    public static EnumHand getHand(Item item) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        EnumHand hand = null;
        if (player == null) {
            return null;
        }
        if (player.func_184614_ca().func_77973_b() == item) {
            hand = EnumHand.MAIN_HAND;
        } else if (player.func_184592_cb().func_77973_b() == item) {
            hand = EnumHand.OFF_HAND;
        }
        return hand;
    }

    @Nullable
    public static ItemStack getItemStack(EntityPlayer player, Item item) {
        EnumHand hand = InputHandlerClient.getHand(item);
        if (hand != null) {
            return player.func_184586_b(hand);
        }
        return null;
    }

    public static boolean checkForItem(Item item) {
        return InputHandlerClient.getHand(item) != null;
    }

    @SubscribeEvent
    public static void onMouseEvent(MouseEvent event) {
        boolean next;
        if (event.getDwheel() == 0) {
            ItemStack itemStack;
            if (InputHandlerClient.checkForItem(AunisItems.GDO) && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && (itemStack = InputHandlerClient.getItemStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g, AunisItems.GDO)).func_77942_o() && itemStack.func_77978_p().func_74764_b("linkedGate") && GDOMode.valueOf(itemStack.func_77978_p().func_74771_c("mode")) == GDOMode.CODE_SENDER) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSendCode(InputHandlerClient.getHand(AunisItems.GDO)));
            }
            return;
        }
        boolean bl = next = event.getDwheel() < 0;
        if (InputHandlerClient.checkForItem(AunisItems.UNIVERSE_DIALER)) {
            EnumHand hand = InputHandlerClient.getHand(AunisItems.UNIVERSE_DIALER);
            UniverseDialerActionEnum action = null;
            if (Minecraft.func_71410_x().field_71439_g.func_184586_b(hand).func_77952_i() != UniverseDialerItem.UniverseDialerVariants.BROKEN.meta) {
                if (MODE_SCROLL.func_151470_d()) {
                    action = UniverseDialerActionEnum.MODE_CHANGE;
                } else if (ADDRESS_SCROLL.func_151470_d()) {
                    action = UniverseDialerActionEnum.ADDRESS_CHANGE;
                }
                if (action != null) {
                    AunisSoundHelper.playSoundEventClientSide((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_180425_c(), SoundEventEnum.UNIVERSE_DIALER_MODE_CHANGE);
                    event.setCanceled(true);
                    AunisPacketHandler.INSTANCE.sendToServer((IMessage)new UniverseDialerActionPacketToServer(action, hand, next));
                }
            }
        } else if (InputHandlerClient.checkForItem(AunisItems.GDO)) {
            EnumHand hand = InputHandlerClient.getHand(AunisItems.GDO);
            GDOActionEnum action = null;
            if (MODE_SCROLL.func_151470_d()) {
                action = GDOActionEnum.MODE_CHANGE;
            } else if (ADDRESS_SCROLL.func_151470_d()) {
                action = GDOActionEnum.ADDRESS_CHANGE;
            }
            if (action != null) {
                event.setCanceled(true);
                AunisPacketHandler.INSTANCE.sendToServer((IMessage)new GDOActionPacketToServer(action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem(AunisItems.NOTEBOOK_ITEM)) {
            EnumHand hand = InputHandlerClient.getHand(AunisItems.NOTEBOOK_ITEM);
            NotebookActionEnum action = null;
            if (ADDRESS_SCROLL.func_151470_d()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
            }
            if (action != null) {
                event.setCanceled(true);
                AunisPacketHandler.INSTANCE.sendToServer((IMessage)new NotebookActionPacketToServer(action, hand, next));
            }
        }
    }

    @SubscribeEvent
    public static void onKeyboardEvent(TickEvent.ClientTickEvent event) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean next;
        Enum action;
        EnumHand hand;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (InputHandlerClient.checkForItem(AunisItems.UNIVERSE_DIALER)) {
            hand = InputHandlerClient.getHand(AunisItems.UNIVERSE_DIALER);
            action = null;
            next = false;
            if (MODE_UP.func_151468_f()) {
                action = UniverseDialerActionEnum.MODE_CHANGE;
                next = false;
            } else if (MODE_DOWN.func_151468_f()) {
                action = UniverseDialerActionEnum.MODE_CHANGE;
                next = true;
            } else if (ADDRESS_UP.func_151468_f()) {
                action = UniverseDialerActionEnum.ADDRESS_CHANGE;
                next = false;
            } else if (ADDRESS_DOWN.func_151468_f()) {
                action = UniverseDialerActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                AunisSoundHelper.playSoundEventClientSide((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_180425_c(), SoundEventEnum.UNIVERSE_DIALER_MODE_CHANGE);
                AunisPacketHandler.INSTANCE.sendToServer((IMessage)new UniverseDialerActionPacketToServer((UniverseDialerActionEnum)action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem(AunisItems.GDO)) {
            hand = InputHandlerClient.getHand(AunisItems.GDO);
            action = null;
            next = false;
            if (MODE_UP.func_151468_f()) {
                action = GDOActionEnum.MODE_CHANGE;
                next = false;
            } else if (MODE_DOWN.func_151468_f()) {
                action = GDOActionEnum.MODE_CHANGE;
                next = true;
            } else if (ADDRESS_UP.func_151468_f()) {
                action = GDOActionEnum.ADDRESS_CHANGE;
                next = false;
            } else if (ADDRESS_DOWN.func_151468_f()) {
                action = GDOActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                AunisPacketHandler.INSTANCE.sendToServer((IMessage)new GDOActionPacketToServer((GDOActionEnum)action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem(AunisItems.NOTEBOOK_ITEM)) {
            hand = InputHandlerClient.getHand(AunisItems.NOTEBOOK_ITEM);
            action = null;
            next = false;
            if (ADDRESS_UP.func_151468_f()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
                next = false;
            } else if (ADDRESS_DOWN.func_151468_f()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                AunisPacketHandler.INSTANCE.sendToServer((IMessage)new NotebookActionPacketToServer((NotebookActionEnum)action, hand, next));
            }
        }
        if (ADDRESS_EDIT.func_151468_f()) {
            InputHandlerClient.tryOpenAddressGui((EntityPlayer)player);
        }
        for (KeyBinding keyBinding : KEY_BINDINGS) {
            if (keyBinding == MODE_SCROLL || keyBinding == ADDRESS_SCROLL) continue;
            METHOD_UNPRESS.invoke((Object)keyBinding, new Object[0]);
        }
    }

    private static void tryOpenAddressGui(EntityPlayer player) {
        EnumHand hand = InputHandlerClient.getHand(AunisItems.PAGE_NOTEBOOK_ITEM);
        if (hand != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77960_j() == 1) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new PageRenameGui(hand, stack));
            }
            return;
        }
        hand = InputHandlerClient.getHand(AunisItems.NOTEBOOK_ITEM);
        if (hand != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new NotebookEntryChangeGui(hand, player.func_184586_b(hand).func_77978_p()));
            return;
        }
        hand = InputHandlerClient.getHand(AunisItems.UNIVERSE_DIALER);
        if (hand != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new UniverseEntryChangeGui(hand, player.func_184586_b(hand).func_77978_p()));
            return;
        }
        hand = InputHandlerClient.getHand(AunisItems.GDO);
        if (hand != null && Aunis.ocWrapper.isModLoaded()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new OCEntryChangeGui(hand, player.func_184586_b(hand).func_77978_p(), null));
            return;
        }
    }
}

