/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.event;

import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.raycaster.RaycasterDHD;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class AunisEventHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        AunisEventHandler.onRightClick((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        AunisEventHandler.onRightClick((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        AunisEventHandler.onRightClick((PlayerInteractEvent)event);
    }

    private static void onRightClick(PlayerInteractEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        if (!player.func_175149_v()) {
            BlockPos pos = player.func_180425_c();
            EnumFacing playerFacing = player.func_174811_aO();
            EnumFacing left = playerFacing.func_176735_f();
            EnumFacing right = playerFacing.func_176746_e();
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177972_a(left).func_177977_b().func_177972_a(playerFacing.func_176734_d()), (BlockPos)pos.func_177972_a(right).func_177984_a().func_177972_a(playerFacing));
            for (BlockPos activatedBlock : blocks) {
                Block block = world.func_180495_p(activatedBlock).func_177230_c();
                if (block != AunisBlocks.DHD_BLOCK && block != AunisBlocks.DHD_PEGASUS_BLOCK || !event.isCancelable() || !RaycasterDHD.INSTANCE.onActivated(world, activatedBlock, player, event.getHand(), player.func_70093_af())) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        LootEntryTable entry;
        if (event.getName().toString().equals("minecraft:chests/end_city_treasure")) {
            entry = new LootEntryTable(new ResourceLocation("aunis", "end_city_treasure"), 1, 0, new LootCondition[0], "universe_dialer");
            pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "univese_dialer_pool");
            event.getTable().addPool(pool);
        }
        if (event.getName().toString().equals("minecraft:chests/nether_bridge")) {
            entry = new LootEntryTable(new ResourceLocation("aunis", "nether_bridge"), 1, 0, new LootCondition[0], "zpm");
            pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(2.0f), new RandomValueRange(0.0f), "zpm_pool");
            event.getTable().addPool(pool);
        }
    }

    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == AunisBlocks.IRIS_BLOCK) {
            event.setCanceled(true);
        }
    }
}

