/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.config;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import mrjake.aunis.Aunis;
import mrjake.aunis.config.StargateDimensionConfigEntry;
import mrjake.aunis.stargate.power.StargateEnergyRequired;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class StargateDimensionConfig {
    private static final Map<String, StargateDimensionConfigEntry> DEFAULTS_MAP = new HashMap<String, StargateDimensionConfigEntry>();
    private static File dimensionConfigFile;
    private static Map<String, StargateDimensionConfigEntry> dimensionStringMap;
    private static Map<DimensionType, StargateDimensionConfigEntry> dimensionMap;

    public static StargateEnergyRequired getCost(DimensionType from, DimensionType to) {
        StargateDimensionConfigEntry reqFrom = dimensionMap.get(StargateDimensionConfig.fixDimType(from));
        StargateDimensionConfigEntry reqTo = dimensionMap.get(StargateDimensionConfig.fixDimType(to));
        if (reqFrom == null || reqTo == null) {
            Aunis.logger.error("Tried to get a cost of a non-existing dimension. This is a bug.");
            Aunis.logger.error("FromId: {}, FromName: {}, ToId: {}, ToName: {}, FromEntryNull: {}, ToEntryNull: {}", (Object)from.func_186068_a(), (Object)from.func_186065_b(), (Object)to.func_186068_a(), (Object)to.func_186065_b(), (Object)(reqFrom == null ? 1 : 0), (Object)(reqTo == null ? 1 : 0));
            Aunis.logger.error("Aunis dimension entries:{}{}", (Object)System.lineSeparator(), (Object)dimensionMap.entrySet().stream().map(en -> ((DimensionType)en.getKey()).func_186065_b() + " | " + ((StargateDimensionConfigEntry)en.getValue()).toString()).collect(Collectors.joining(System.lineSeparator())));
            return new StargateEnergyRequired(0, 0);
        }
        int energyToOpen = Math.abs(reqFrom.energyToOpen - reqTo.energyToOpen);
        int keepAlive = Math.abs(reqFrom.keepAlive - reqTo.keepAlive);
        return new StargateEnergyRequired(energyToOpen, keepAlive);
    }

    public static boolean isGroupEqual(DimensionType from, DimensionType to) {
        StargateDimensionConfigEntry reqFrom = dimensionMap.get(StargateDimensionConfig.fixDimType(from));
        StargateDimensionConfigEntry reqTo = dimensionMap.get(StargateDimensionConfig.fixDimType(to));
        if (reqFrom == null || reqTo == null) {
            Aunis.logger.error("Tried to perform a group check for a non-existing dimension. This is a bug.");
            Aunis.logger.error("FromId: {}, FromName: {}, ToId: {}, ToName: {}, FromEntryNull: {}, ToEntryNull: {}", (Object)from.func_186068_a(), (Object)from.func_186065_b(), (Object)to.func_186068_a(), (Object)to.func_186065_b(), (Object)(reqFrom == null ? 1 : 0), (Object)(reqTo == null ? 1 : 0));
            Aunis.logger.error("Aunis dimension entries:{}{}", (Object)System.lineSeparator(), (Object)dimensionMap.entrySet().stream().map(en -> ((DimensionType)en.getKey()).func_186065_b() + " | " + ((StargateDimensionConfigEntry)en.getValue()).toString()).collect(Collectors.joining(System.lineSeparator())));
            return false;
        }
        return reqFrom.isGroupEqual(reqTo);
    }

    private static DimensionType fixDimType(DimensionType type) {
        return type.func_186065_b().equals("Nether") && type.func_186068_a() == -1 ? DimensionType.NETHER : type;
    }

    public static boolean netherOverworld8thSymbol() {
        return !StargateDimensionConfig.isGroupEqual(DimensionType.OVERWORLD, DimensionType.NETHER);
    }

    public static void load(File modConfigDir) {
        dimensionMap = null;
        dimensionConfigFile = new File(modConfigDir, "aunis_dimensions.json");
        try {
            Type typeOfHashMap = new TypeToken<Map<String, StargateDimensionConfigEntry>>(){}.getType();
            dimensionStringMap = (Map)new GsonBuilder().create().fromJson((Reader)new FileReader(dimensionConfigFile), typeOfHashMap);
        }
        catch (FileNotFoundException exception) {
            dimensionStringMap = new HashMap<String, StargateDimensionConfigEntry>();
        }
    }

    public static void update() throws IOException {
        if (dimensionMap == null) {
            dimensionMap = new HashMap<DimensionType, StargateDimensionConfigEntry>();
            for (String string : dimensionStringMap.keySet()) {
                try {
                    dimensionMap.put(DimensionType.func_193417_a((String)string), dimensionStringMap.get(string));
                }
                catch (IllegalArgumentException ex) {
                    Aunis.logger.debug("DimensionType not found: " + string);
                }
            }
        }
        int originalSize = dimensionMap.size();
        for (DimensionType dimType : DimensionManager.getRegisteredDimensions().keySet()) {
            if (dimensionMap.containsKey(dimType)) continue;
            if (dimType.func_186065_b().equals("Nether") && dimType.func_186068_a() == -1) {
                dimType = DimensionType.NETHER;
            }
            if (DEFAULTS_MAP.containsKey(dimType.func_186065_b())) {
                dimensionMap.put(dimType, DEFAULTS_MAP.get(dimType.func_186065_b()));
                continue;
            }
            dimensionMap.put(dimType, new StargateDimensionConfigEntry(0, 0, null));
        }
        if (originalSize != dimensionMap.size()) {
            FileWriter fileWriter = new FileWriter(dimensionConfigFile);
            dimensionStringMap.clear();
            for (DimensionType dimType : dimensionMap.keySet()) {
                dimensionStringMap.put(dimType.func_186065_b(), dimensionMap.get(dimType));
            }
            fileWriter.write(new GsonBuilder().setPrettyPrinting().create().toJson(dimensionStringMap));
            fileWriter.close();
        }
    }

    static {
        DEFAULTS_MAP.put("overworld", new StargateDimensionConfigEntry(0, 0, "netherOv"));
        DEFAULTS_MAP.put("the_nether", new StargateDimensionConfigEntry(3686400, 1600, "netherOv"));
        DEFAULTS_MAP.put("the_end", new StargateDimensionConfigEntry(5529600, 2400, null));
        DEFAULTS_MAP.put("moon.moon", new StargateDimensionConfigEntry(0x708000, 3200, null));
        DEFAULTS_MAP.put("planet.mars", new StargateDimensionConfigEntry(11059200, 4800, null));
        DEFAULTS_MAP.put("planet.venus", new StargateDimensionConfigEntry(0xBB8000, 5334, null));
        DEFAULTS_MAP.put("planet.asteroids", new StargateDimensionConfigEntry(0xE10000, 6400, null));
    }
}

