/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.config;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrjake.aunis.util.ItemMetaPair;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ItemMetaParser {
    @Nonnull
    static List<ItemMetaPair> parseConfig(String[] config) {
        ArrayList<ItemMetaPair> list = new ArrayList<ItemMetaPair>();
        for (String line : config) {
            ItemMetaPair stack = ItemMetaParser.getItemMetaPairFromString(line);
            if (stack == null) continue;
            list.add(stack);
        }
        return list;
    }

    @Nullable
    static ItemMetaPair getItemMetaPairFromString(String line) {
        String[] parts = line.trim().split(":", 3);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1]));
        if (item != null) {
            if (parts.length == 2 || parts[2].equals("*")) {
                return new ItemMetaPair(item, 0);
            }
            try {
                return new ItemMetaPair(item, Integer.parseInt(parts[2]));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

