/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.BiomeParser;
import mrjake.aunis.config.BlockMetaParser;
import mrjake.aunis.config.ItemMetaParser;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.util.ItemMetaPair;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;

@Config(modid="aunis", name="aunis")
public class AunisConfig {
    @Config.Name(value="Stargate size")
    @Config.RequiresWorldRestart
    public static StargateSizeEnum stargateSize = StargateSizeEnum.MEDIUM;
    @Config.Name(value="Check for updates")
    public static boolean enableAutoUpdater = true;
    @Config.Name(value="Stargate config options")
    public static StargateConfig stargateConfig = new StargateConfig();
    @Config.Name(value="Iris/shield config options")
    public static IrisConfig irisConfig = new IrisConfig();
    @Config.Name(value="DHD config options")
    public static DHDConfig dhdConfig = new DHDConfig();
    @Config.Name(value="Transport rings options")
    public static RingsConfig ringsConfig = new RingsConfig();
    @Config.Name(value="Power draw options")
    public static PowerConfig powerConfig = new PowerConfig();
    @Config.Name(value="Debug options")
    public static DebugConfig debugConfig = new DebugConfig();
    @Config.Name(value="Developer options")
    public static DevConfig devConfig = new DevConfig();
    @Config.Name(value="Mysterious Page options")
    public static MysteriousConfig mysteriousConfig = new MysteriousConfig();
    @Config.Name(value="AutoClose options")
    public static AutoCloseConfig autoCloseConfig = new AutoCloseConfig();
    @Config.Name(value="Open time limit config")
    public static OpenLimitConfig openLimitConfig = new OpenLimitConfig();
    @Config.Name(value="Beamer options")
    public static BeamerConfig beamerConfig = new BeamerConfig();
    @Config.Name(value="Recipe options")
    public static RecipeConfig recipeConfig = new RecipeConfig();
    @Config.Name(value="Audio/Video")
    public static AudioVideoConfig avConfig = new AudioVideoConfig();
    @Config.Name(value="WorldGen config")
    public static WorldGenConfig worldgenConfig = new WorldGenConfig();
    @Config.Name(value="MainMenu config")
    public static MainMenuConfig mainMenuConfig = new MainMenuConfig();
    @Config.Name(value="Integrations config")
    public static IntegrationsConfig integrationsConfig = new IntegrationsConfig();
    @Config.Name(value="Random incoming config")
    public static RandomIncomingConfig randomIncoming = new RandomIncomingConfig();

    public static void resetCache() {
        stargateConfig.cachedInvincibleBlocks = null;
        stargateConfig.cachedBiomeMatchesReverse = null;
        stargateConfig.cachedBiomeOverrideBlocks = null;
        stargateConfig.cachedBiomeOverrideBlocksReverse = null;
    }

    public static class DevConfig {
        @Config.Name(value="Enable peg gates with myst pages")
        public boolean pegGatesMyst = false;
    }

    public static class RandomIncomingConfig {
        @Config.Name(value="Enable random incoming wormholes")
        @Config.Comment(value={"Enable random incoming wormholes generator"})
        public boolean enableRandomIncoming = true;
        @Config.Name(value="Chance of spawning")
        @Config.Comment(value={"10 = 1%"})
        @Config.RangeInt(min=1, max=100)
        public int chance = 1;
        @Config.Name(value="Entities to spawn")
        @Config.Comment(value={"Format: \"modid:entityid\", for example: ", "\"minecraft:zombie\"", "\"minecraft:creeper\""})
        public String[] entitiesToSpawn = new String[]{"minecraft:zombie", "minecraft:skeleton"};
    }

    public static class IntegrationsConfig {
        @Config.Name(value="Enable Tinkers' Construct integration")
        public boolean tConstructIntegration = true;
        @Config.Name(value="Enable Open Computers integration")
        public boolean ocIntegration = true;
        @Config.Name(value="Enable Thermal Expansion integration")
        public boolean tExpansionIntegration = true;
    }

    public static class MainMenuConfig {
        @Config.Name(value="Disable Aunis main menu - WARNING: Requires reloading")
        @Config.Comment(value={"Disables showing custom main menu"})
        public boolean disableAunisMainMenu = false;
        @Config.Name(value="Disable custom positions of buttons")
        @Config.Comment(value={"Disables custom positions of buttons in main menu"})
        public boolean disablePosButtons = false;
        @Config.Name(value="Enable debug mode")
        public boolean debugMode = false;
        @Config.Name(value="Enable event horizon in mainmenu")
        @Config.Comment(value={"Do you want gate activation when starting game?"})
        public boolean enableEventHorizon = true;
        @Config.Name(value="Enable changing gate overlay")
        @Config.Comment(value={"Enable/disable random gate overlays in main menu"})
        public boolean changingGateOverlay = true;
        @Config.Name(value="Enable gate rotation")
        @Config.Comment(value={"Should ring of gate be static in main menu?"})
        public boolean gateRotation = true;
        @Config.Name(value="Play music in main menu")
        public boolean playMusic = true;
    }

    public static class WorldGenConfig {
        @Config.Name(value="Enable Naquadah ore generation")
        @Config.Comment(value={"Do you want to spawn naquadah ores in the Nether?"})
        public boolean naquadahEnable = true;
        @Config.Name(value="Naquadah vein size")
        public int naquadahVeinSize = 8;
        @Config.Name(value="Naquadah max veins in chunk")
        public int naquadahMaxVeinInChunk = 16;
        @Config.Name(value="Enable Trinium ore generation")
        @Config.Comment(value={"Do you want to spawn trinium ores in the End?"})
        public boolean triniumEnabled = true;
        @Config.Name(value="Trinium vein size")
        public int triniumVeinSize = 2;
        @Config.Name(value="Trinium max veins in chunk")
        public int triniumMaxVeinInChunk = 4;
        @Config.Name(value="Enable Titanium ore generation")
        @Config.Comment(value={"Do you want to spawn naquadah ores in the Overworld?"})
        public boolean titaniumEnable = true;
        @Config.Name(value="Titanium vein size")
        public int titaniumVeinSize = 4;
        @Config.Name(value="Titanium max veins in chunk")
        public int titaniumMaxVeinInChunk = 8;
    }

    public static class AudioVideoConfig {
        @Config.Name(value="Notebook page Glyph transparency")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double glyphTransparency = 0.75;
        @Config.Name(value="Aunis volume")
        @Config.RangeDouble(min=0.0, max=1.0)
        public float volume = 1.0f;
        @Config.Name(value="Notebook Page offset")
        @Config.Comment(value={"Greater values render the Page more to the center of the screen, smaller render it closer to the borders.", "0 - for standard 16:9 (default),", "0.2 - for 4:3."})
        public float pageNarrowing = 0.0f;
    }

    public static class RecipeConfig {
    }

    public static class BeamerConfig {
        @Config.Name(value="Fluid buffer capacity")
        @Config.RangeInt(min=1)
        public int fluidCapacity = 60000;
        @Config.Name(value="Energy buffer capacity")
        @Config.RangeInt(min=1)
        public int energyCapacity = 17820000;
        @Config.Name(value="Energy buffer max transfer")
        @Config.RangeInt(min=1)
        public int energyTransfer = 26360;
        @Config.Name(value="Fluid max transfer")
        @Config.RangeInt(min=1)
        public int fluidTransfer = 100;
        @Config.Name(value="Item max transfer")
        @Config.RangeInt(min=1)
        public int itemTransfer = 4;
        @Config.Name(value="Max gate-beamer distance")
        public int reach = 10;
        @Config.Name(value="Should the beam be responsive to fluid color")
        public boolean enableFluidBeamColorization = true;
        @Config.Name(value="Interval of signals being send to OC about transfers (in ticks)")
        @Config.RangeInt(min=1)
        public int signalIntervalTicks = 20;
    }

    public static class OpenLimitConfig {
        @Config.Name(value="Maximum seconds of gate should be open")
        @Config.Comment(value={"(in seconds (2280 = 38 minutes))"})
        @Config.RangeInt(min=5, max=3000)
        public int maxOpenedSeconds = 240;
        @Config.Name(value="What happens after the open time reach this time")
        @Config.Comment(value={"U can use: closeGate, drawMorePower"})
        public String maxOpenedWhat = "drawMorePower";
        @Config.Name(value="Enable max open time?")
        public boolean maxOpenedEnabled = true;
        @Config.Name(value="Power draw after opened time limit")
        @Config.RangeInt(min=0, max=50000)
        public int maxOpenedPowerDrawAfterLimit = 10000;
    }

    public static class AutoCloseConfig {
        @Config.Name(value="Autoclose enabled")
        public boolean autocloseEnabled = true;
        @Config.Name(value="Seconds to autoclose with no players nearby")
        @Config.RangeInt(min=1, max=300)
        public int secondsToAutoclose = 5;
    }

    public static class MysteriousConfig {
        @Config.Name(value="Max overworld XZ-coords generation")
        @Config.RangeInt(min=1, max=30000000)
        public int maxOverworldCoords = 30000;
        @Config.Name(value="Min overworld XZ-coords generation")
        @Config.RangeInt(min=1, max=30000000)
        public int minOverworldCoords = 15000;
        @Config.Name(value="Chance of despawning DHD")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double despawnDhdChance = 0.05;
        @Config.Name(value="Mysterious page cooldown")
        @Config.RangeInt(min=0)
        public int pageCooldown = 40;
    }

    public static class DebugConfig {
        @Config.Name(value="Check gate merge")
        public boolean checkGateMerge = true;
        @Config.Name(value="Render bounding boxes")
        public boolean renderBoundingBoxes = false;
        @Config.Name(value="Render whole kawoosh bounding box")
        public boolean renderWholeKawooshBoundingBox = false;
        @Config.Name(value="Render invisible blocks")
        public boolean renderInvisibleBlocks = false;
        @Config.Name(value="Show loading texture in log")
        public boolean logTexturesLoading = false;
    }

    public static class DHDConfig {
        @Config.Name(value="DHD range's radius horizontal")
        @Config.RangeInt(min=1)
        public int rangeFlat = 10;
        @Config.Name(value="Pegasus DHD do dial animation")
        @Config.Comment(value={"Disable this, to disable animation when dial gate with DHD (pegasus)"})
        public boolean animatePegDHDDial = true;
        @Config.Name(value="DHD range's radius vertical")
        @Config.RangeInt(min=1)
        public int rangeVertical = 5;
        @Config.Name(value="DHD's max fluid capacity")
        @Config.RangeInt(min=1)
        public int fluidCapacity = 60000;
        @Config.Name(value="Energy per 1mB Naquadah")
        @Config.RangeInt(min=1)
        public int energyPerNaquadah = 10240;
        @Config.Name(value="Generation multiplier")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Energy per 1mB is multiplied by this", "Consumed mB/t is equal to this"})
        public int powerGenerationMultiplier = 1;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double activationLevel = 0.4;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double deactivationLevel = 0.98;
    }

    public static class RingsConfig {
        @Config.Name(value="Rings range's radius horizontal")
        @Config.RangeInt(min=1, max=256)
        public int rangeFlat = 25;
        @Config.Name(value="Rings vertical reach")
        @Config.RangeInt(min=1, max=256)
        public int rangeVertical = 256;
        @Config.Name(value="Ignore rings check for blocks to replace")
        public boolean ignoreObstructionCheck = false;
    }

    public static class PowerConfig {
        @Config.Name(value="Stargate's internal buffer size")
        @Config.RangeInt(min=0)
        public int stargateEnergyStorage = 71280000;
        @Config.Name(value="Stargate's max power throughput")
        @Config.RangeInt(min=1)
        public int stargateMaxEnergyTransfer = 26360;
        @Config.Name(value="Stargate wormhole open power draw")
        @Config.RangeInt(min=0)
        public int openingBlockToEnergyRatio = 4608;
        @Config.Name(value="Stargate wormhole sustain power draw")
        @Config.RangeInt(min=0)
        public int keepAliveBlockToEnergyRatioPerTick = 2;
        @Config.Name(value="Stargate instability threshold")
        @Config.Comment(value={"Seconds of energy left before gate becomes unstable"})
        @Config.RangeInt(min=1)
        public int instabilitySeconds = 20;
        @Config.Name(value="Orlin's gate energy multiplier")
        @Config.RangeDouble(min=0.0)
        public double stargateOrlinEnergyMul = 2.0;
        @Config.Name(value="Universe gate energy multiplier")
        @Config.RangeDouble(min=0.0)
        public double stargateUniverseEnergyMul = 1.5;
        @Config.Name(value="Capacitors supported by Universe gates")
        public int universeCapacitors = 0;
        @Config.Name(value="ZPM Capacity")
        @Config.RangeInt(min=0)
        public int zpmEnergyStorage = 2000000000;
    }

    public static class IrisConfig {
        @Config.Name(value="Iris kills at destination")
        @Config.Comment(value={"If set to 'false' player get killed by iris on entering event horizon"})
        public boolean killAtDestination = true;
        @Config.Name(value="Titanium iris durability")
        @Config.Comment(value={"Durability of Titanium iris", "set it to 0, if u want to make it unbreakable"})
        @Config.RangeInt(min=0)
        public int titaniumIrisDurability = 500;
        @Config.Name(value="Trinium iris durability")
        @Config.Comment(value={"Durability of Trinium iris", "set it to 0, if u want to make it unbreakable"})
        @Config.RangeInt(min=0)
        public int triniumIrisDurability = 1000;
        @Config.Name(value="Shield power draw")
        @Config.Comment(value={"Energy/tick used for make shield closed"})
        @Config.RangeInt(min=0)
        public int shieldPowerDraw = 500;
        @Config.Name(value="Allow creative bypass")
        @Config.Comment(value={"Set it to true, if u want to bypass", "shield/iris damage by creative gamemode"})
        public boolean allowCreative = false;
        @Config.Name(value="Maximum iris code length")
        @Config.RangeInt(min=0, max=32)
        public int irisCodeLength = 9;
        @Config.Name(value="Can iris destroy blocks")
        public boolean irisDestroysBlocks = false;
        @Config.Name(value="Unbreaking chance per level")
        @Config.Comment(value={"0 - disables unbreaking on iris", "100 - unbreaking makes iris unbreakable"})
        @Config.RangeInt(min=0, max=100)
        public int unbreakingChance = 10;
    }

    public static class StargateConfig {
        @Config.Name(value="Orlin's gate max open count")
        @Config.RangeInt(min=0)
        public int stargateOrlinMaxOpenCount = 2;
        @Config.Name(value="Universe dialer max horizontal reach radius")
        @Config.RangeInt(min=0, max=64)
        public int universeDialerReach = 10;
        @Config.Name(value="Universe dialer nearby radius")
        public int universeGateNearbyReach = 1024;
        @Config.Name(value="Use 8 chevrons between MW and PG gates")
        @Config.Comment(value={"Change this to true, if you want to use 8 chevrons between pegasus and milkyway gates"})
        public boolean pegAndMilkUseEightChevrons = true;
        @Config.Name(value="Faster MilkyWay gate computer dial")
        @Config.Comment(value={"Speed up dialing with computer on MW gate"})
        public boolean fasterMWGateDial = false;
        @Config.Name(value="Milky/Uni gate speed factor")
        @Config.Comment(value={"Speed factor of Milkyway and Universe gate"})
        @Config.RangeDouble(min=1.649999976158142, max=3.0)
        public float classicGateSpinSpeed = 1.8f;
        @Config.Name(value="Enable opening last chevron while dialing with dhd")
        @Config.Comment(value={"Enable opening last chevron while dialing milkyway gate with dhd"})
        public boolean dhdLastOpen = true;
        @Config.Name(value="Smooth dialing on pegasus gate DHD")
        @Config.Comment(value={"Enable smooth dialing on pegasus DHD"})
        public boolean pegasContinueDial = true;
        @Config.Name(value="Disable animated Event Horizon")
        @Config.Comment(value={"Changing this option will require you to reload resources manually.", "Just press F3+Q once in-game."})
        public boolean disableAnimatedEventHorizon = false;
        @Config.Name(value="Temperature threshold for frosty overlay")
        @Config.Comment(value={"Below this biome temperature the gate will receive frosty texture.", "Set to negative value to disable."})
        public float frostyTemperatureThreshold = 0.1f;
        @Config.Name(value="Allow incoming animations")
        @Config.Comment(value={"If the incoming animations of gates generate issues, set it to false"})
        public boolean allowIncomingAnimations = true;
        @Config.Name(value="Connect to dialing gate")
        @Config.Comment(value={"If target gate is dialing and this option is set to true,", "the target gate stop dialing and open incoming wormhole.", "If this is set to false and the dialed gate dialing address,", "the connection will not established.", "If it cause issues, set it to false."})
        public boolean allowConnectToDialing = true;
        @Config.Name(value="Kawoosh invincible blocks")
        @Config.Comment(value={"Format: \"modid:blockid[:meta]\", for example: ", "\"minecraft:wool:7\"", "\"minecraft:stone\""})
        public String[] kawooshInvincibleBlocks = new String[0];
        private List<IBlockState> cachedInvincibleBlocks = null;
        @Config.Name(value="Biome overlay biome matches")
        @Config.Comment(value={"This check comes last (after block is directly under sky (except Nether) and temperature is high enough).", "You can disable the temperature check by setting it to a negative value.", "Format: \"modid:biomename\", for example: ", "\"minecraft:dark_forest\"", "\"minecraft:forest\""})
        public Map<String, String[]> biomeMatches = new HashMap<String, String[]>(){
            {
                this.put(BiomeOverlayEnum.NORMAL.toString(), new String[0]);
                this.put(BiomeOverlayEnum.FROST.toString(), new String[0]);
                this.put(BiomeOverlayEnum.MOSSY.toString(), new String[]{"minecraft:jungle", "minecraft:jungle_hills", "minecraft:jungle_edge", "minecraft:mutated_jungle", "minecraft:mutated_jungle_edge"});
                this.put(BiomeOverlayEnum.AGED.toString(), new String[0]);
                this.put(BiomeOverlayEnum.SOOTY.toString(), new String[]{"minecraft:hell"});
            }
        };
        private Map<Biome, BiomeOverlayEnum> cachedBiomeMatchesReverse = null;
        @Config.Name(value="Biome overlay override blocks")
        @Config.Comment(value={"Format: \"modid:blockid[:meta]\", for example: ", "\"minecraft:wool:7\"", "\"minecraft:stone\""})
        public Map<String, String[]> biomeOverrideBlocks = new HashMap<String, String[]>(){
            {
                this.put(BiomeOverlayEnum.NORMAL.toString(), new String[]{"minecraft:stone"});
                this.put(BiomeOverlayEnum.FROST.toString(), new String[]{"minecraft:ice"});
                this.put(BiomeOverlayEnum.MOSSY.toString(), new String[]{"minecraft:vine"});
                this.put(BiomeOverlayEnum.AGED.toString(), new String[]{"minecraft:cobblestone"});
                this.put(BiomeOverlayEnum.SOOTY.toString(), new String[]{"minecraft:coal_block"});
            }
        };
        private Map<BiomeOverlayEnum, List<ItemMetaPair>> cachedBiomeOverrideBlocks = null;
        private Map<ItemMetaPair, BiomeOverlayEnum> cachedBiomeOverrideBlocksReverse = null;

        public boolean canKawooshDestroyBlock(IBlockState state) {
            if (state.func_177230_c() == AunisBlocks.IRIS_BLOCK) {
                return false;
            }
            if (this.cachedInvincibleBlocks == null) {
                this.cachedInvincibleBlocks = BlockMetaParser.parseConfig(this.kawooshInvincibleBlocks);
            }
            return !this.cachedInvincibleBlocks.contains(state);
        }

        private void genBiomeOverrideBiomeCache() {
            this.cachedBiomeMatchesReverse = new HashMap<Biome, BiomeOverlayEnum>();
            for (Map.Entry<String, String[]> entry : this.biomeMatches.entrySet()) {
                List<Biome> parsedList = BiomeParser.parseConfig(entry.getValue());
                BiomeOverlayEnum biomeOverlay = BiomeOverlayEnum.fromString(entry.getKey());
                for (Biome biome : parsedList) {
                    this.cachedBiomeMatchesReverse.put(biome, biomeOverlay);
                }
            }
        }

        public Map<Biome, BiomeOverlayEnum> getBiomeOverrideBiomes() {
            if (this.cachedBiomeMatchesReverse == null) {
                this.genBiomeOverrideBiomeCache();
            }
            return this.cachedBiomeMatchesReverse;
        }

        private void genBiomeOverrideCache() {
            this.cachedBiomeOverrideBlocks = new HashMap<BiomeOverlayEnum, List<ItemMetaPair>>();
            this.cachedBiomeOverrideBlocksReverse = new HashMap<ItemMetaPair, BiomeOverlayEnum>();
            for (Map.Entry<String, String[]> entry : this.biomeOverrideBlocks.entrySet()) {
                List<ItemMetaPair> parsedList = ItemMetaParser.parseConfig(entry.getValue());
                BiomeOverlayEnum biomeOverlay = BiomeOverlayEnum.fromString(entry.getKey());
                this.cachedBiomeOverrideBlocks.put(biomeOverlay, parsedList);
                for (ItemMetaPair stack : parsedList) {
                    this.cachedBiomeOverrideBlocksReverse.put(stack, biomeOverlay);
                }
            }
        }

        public Map<BiomeOverlayEnum, List<ItemMetaPair>> getBiomeOverrideBlocks() {
            if (this.cachedBiomeOverrideBlocks == null) {
                this.genBiomeOverrideCache();
            }
            return this.cachedBiomeOverrideBlocks;
        }

        public Map<ItemMetaPair, BiomeOverlayEnum> getBiomeOverrideItemMetaPairs() {
            if (this.cachedBiomeOverrideBlocksReverse == null) {
                this.genBiomeOverrideCache();
            }
            return this.cachedBiomeOverrideBlocksReverse;
        }
    }
}

