/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.block.zpm;

import java.util.List;
import javax.annotation.Nullable;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.gui.GuiIdEnum;
import mrjake.aunis.tileentity.energy.ZPMHubTile;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.ItemHandlerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ZPMHubBlock
extends Block {
    private static final String blockName = "zpmhub_block";
    public static final BlockMatcher SNOW_MATCHER = BlockMatcher.func_177642_a((Block)Blocks.field_150431_aC);

    public ZPMHubBlock() {
        super(Material.field_151573_f);
        this.setRegistryName("aunis:zpmhub_block");
        this.func_149663_c("aunis.zpmhub_block");
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149713_g(0);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AunisProps.ROTATION_HORIZONTAL, AunisProps.SNOWY});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AunisProps.ROTATION_HORIZONTAL);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AunisProps.ROTATION_HORIZONTAL, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)AunisProps.SNOWY, (Comparable)Boolean.valueOf(ZPMHubBlock.isSnowAroundBlock(world, pos)));
    }

    public static boolean isSnowAroundBlock(IBlockAccess world, BlockPos inPos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos pos = inPos.func_177972_a(facing);
            if (SNOW_MATCHER.apply(world.func_180495_p(pos))) continue;
            return false;
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K) {
            int facing = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            world.func_180501_a(pos, state.func_177226_a((IProperty)AunisProps.ROTATION_HORIZONTAL, (Comparable)Integer.valueOf(facing)), 3);
        }
    }

    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        String alert = "Work in progress item!";
        tooltip.add(alert);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ZPMHubTile tile = (ZPMHubTile)world.func_175625_s(pos);
        if (tile == null) {
            return !player.func_70093_af();
        }
        if (!player.func_70093_af()) {
            if (!tile.tryInsertZPM(player, hand)) {
                player.openGui((Object)Aunis.instance, GuiIdEnum.GUI_ZPMHUB.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else if (!tile.tryGetZPM(player, hand)) {
            player.openGui((Object)Aunis.instance, GuiIdEnum.GUI_ZPMHUB.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return !player.func_70093_af();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ZPMHubTile tile = (ZPMHubTile)world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null) {
            ItemHandlerHelper.dropInventoryItems(world, pos, (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        super.func_180663_b(world, pos, state);
    }

    private int getPower(IBlockAccess world, BlockPos pos) {
        ZPMHubTile tile = (ZPMHubTile)world.func_175625_s(pos);
        if (tile == null) {
            return 0;
        }
        int level = 0;
        for (int i = 0; i < 3; ++i) {
            level += tile.getEnergyLevelOfZPM(i);
        }
        return level;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPower(world, pos);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPower(world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ZPMHubTile();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AunisAxisAlignedBB(1.0, 0.0, 1.0, 0.0, 1.0, 0.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AunisAxisAlignedBB(1.0, 0.0, 1.0, 0.0, 1.0, 0.0);
    }
}

