/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.block.stargate;

import java.util.List;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.stargate.StargateAbstractBaseBlock;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.stargate.merging.StargateOrlinMergeHelper;
import mrjake.aunis.stargate.network.StargateNetwork;
import mrjake.aunis.stargate.power.StargateEnergyRequired;
import mrjake.aunis.tileentity.stargate.StargateOrlinBaseTile;
import mrjake.aunis.worldgen.StargateGeneratorNether;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class StargateOrlinBaseBlock
extends StargateAbstractBaseBlock {
    public StargateOrlinBaseBlock() {
        super("stargate_orlin_base_block");
        this.func_149752_b(16.0f);
    }

    @Override
    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        worldIn.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0f, true, true).func_77278_a();
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("openCount")) {
            tooltip.add(Aunis.proxy.localize("tile.aunis.stargate_orlin_base_block.open_count", compound.func_74762_e("openCount"), AunisConfig.stargateConfig.stargateOrlinMaxOpenCount));
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("openCount", 0);
        stack.func_77982_d(compound);
        items.add((Object)stack);
    }

    @Override
    protected void showGateInfo(EntityPlayer player, EnumHand hand, World world, BlockPos pos) {
        StargateOrlinBaseTile gateTile = (StargateOrlinBaseTile)world.func_175625_s(pos);
        IEnergyStorage energyStorage = (IEnergyStorage)gateTile.getCapability(CapabilityEnergy.ENERGY, null);
        String energy = String.format("%,d", energyStorage.getEnergyStored());
        StargateEnergyRequired energyRequired = gateTile.getEnergyRequiredToDial();
        String required = String.format("%,d", energyRequired.energyToOpen);
        int energyStored = gateTile.getEnergyStored();
        boolean hasEnergy = energyStored >= energyRequired.energyToOpen;
        int missing = energyRequired.energyToOpen - energyStored;
        float secondsLeft = 0.0f;
        if (missing > 0 && gateTile.getEnergyTransferedLastTick() > 0) {
            secondsLeft = (float)missing / (float)gateTile.getEnergyTransferedLastTick() / 20.0f;
        }
        String left = String.format("%.2f", Float.valueOf(secondsLeft));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.orlins.energyStored", new Object[]{(hasEnergy ? TextFormatting.GREEN : TextFormatting.RED) + energy, TextFormatting.DARK_GREEN + required, TextFormatting.DARK_GREEN + left}));
    }

    @Override
    protected IBlockState createMemberState(IBlockState memberState, EnumFacing facing, int meta) {
        return memberState.func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)AunisProps.ORLIN_VARIANT, (Comparable)facing);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        StargateOrlinBaseTile gateTile = (StargateOrlinBaseTile)world.func_175625_s(pos);
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        if (!world.field_72995_K) {
            state = state.func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)facing).func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true));
            world.func_175656_a(pos, state);
            gateTile.initializeFromItemStack(stack);
            gateTile.updateFacing(facing, true);
            gateTile.updateMergeState(StargateOrlinMergeHelper.INSTANCE.checkBlocks((IBlockAccess)world, pos, facing), facing);
            if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
                StargateNetwork network = StargateNetwork.get(world);
                if (!network.hasNetherGate()) {
                    network.setNetherGate(StargateGeneratorNether.place(world.func_73046_m().func_71218_a(DimensionType.NETHER.func_186068_a()), new BlockPos(pos.func_177958_n() / 8, 32, pos.func_177952_p() / 8)));
                }
                gateTile.updateNetherAddress();
                Aunis.logger.debug("nether address: " + network.getNetherGate());
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        StargateOrlinBaseTile gateTile = (StargateOrlinBaseTile)world.func_175625_s(pos);
        gateTile.addDrops((List<ItemStack>)drops);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        StargateOrlinBaseTile gateTile = (StargateOrlinBaseTile)world.func_175625_s(pos);
        gateTile.redstonePowerUpdate(world.func_175640_z(pos));
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new StargateOrlinBaseTile();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)AunisProps.RENDER_BLOCK) != false ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)AunisProps.RENDER_BLOCK) != false ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }
}

