/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.block.stargate;

import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.block.dialhomedevice.DHDBlock;
import mrjake.aunis.block.stargate.StargateAbstractMemberBlock;
import mrjake.aunis.block.stargate.StargateClassicBaseBlock;
import mrjake.aunis.block.stargate.StargateClassicMemberBlockBakedModel;
import mrjake.aunis.gui.GuiIdEnum;
import mrjake.aunis.stargate.CamoPropertiesHelper;
import mrjake.aunis.stargate.EnumMemberVariant;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateClassicMemberTile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class StargateClassicMemberBlock
extends StargateAbstractMemberBlock {
    private static final IProperty[] LISTED_PROPS = new IProperty[]{AunisProps.RENDER_BLOCK, AunisProps.FACING_HORIZONTAL, AunisProps.MEMBER_VARIANT};
    private static final IUnlistedProperty[] UNLISTED_PROPS = new IUnlistedProperty[]{AunisProps.CAMO_BLOCKSTATE};

    public StargateClassicMemberBlock(String blockName) {
        super(blockName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.RING)).func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return 0;
        }
        StargateClassicMemberTile memberTile = (StargateClassicMemberTile)world.func_175625_s(pos);
        if (memberTile != null) {
            return memberTile.isLitUp(state) ? 7 : 0;
        }
        return 0;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> items) {
        for (EnumMemberVariant variant : EnumMemberVariant.values()) {
            items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)variant)))));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        EnumMemberVariant variant = (EnumMemberVariant)((Object)state.func_177229_b((IProperty)AunisProps.MEMBER_VARIANT));
        return new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)variant))));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumMemberVariant variant = (EnumMemberVariant)((Object)state.func_177229_b((IProperty)AunisProps.MEMBER_VARIANT));
        drops.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)variant)))));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, LISTED_PROPS, UNLISTED_PROPS);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMemberVariant)((Object)state.func_177229_b((IProperty)AunisProps.MEMBER_VARIANT))).id << 3 | ((Boolean)state.func_177229_b((IProperty)AunisProps.RENDER_BLOCK) != false ? 4 : 0) | ((EnumFacing)state.func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.byId(meta >> 3 & 1))).func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState camoBlockState;
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return state;
        }
        StargateClassicMemberTile memberTile = (StargateClassicMemberTile)world.func_175625_s(pos);
        if (memberTile != null && (camoBlockState = memberTile.getCamoState()) != null) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)AunisProps.CAMO_BLOCKSTATE, (Object)camoBlockState);
        }
        return state;
    }

    public void registerCustomModel(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            String variant = "";
            for (IProperty prop : state.func_177227_a()) {
                Comparable value = state.func_177229_b(prop);
                variant = variant + prop.func_177701_a() + "=" + value.toString() + ",";
            }
            variant = variant.substring(0, variant.length() - 1);
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(this.getRegistryName(), variant);
            IBakedModel defaultModel = (IBakedModel)registry.func_82594_a((Object)modelResourceLocation);
            StargateClassicMemberBlockBakedModel memberBlockBakedModel = new StargateClassicMemberBlockBakedModel(this, defaultModel);
            registry.func_82595_a((Object)modelResourceLocation, (Object)memberBlockBakedModel);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        StargateClassicMemberTile memberTile = (StargateClassicMemberTile)world.func_175625_s(pos);
        if (!world.field_72995_K && memberTile != null && (memberTile.isMerged() && memberTile.getCamoState() == null || DHDBlock.SNOW_MATCHER.apply(memberTile.getCamoState()))) {
            boolean snowAround = DHDBlock.isSnowAroundBlock((IBlockAccess)world, pos);
            memberTile.setCamoState(snowAround ? Blocks.field_150431_aC.func_176223_P() : null);
            world.func_175656_a(pos, state.func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(snowAround)));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        Item heldItem = heldItemStack.func_77973_b();
        Block heldBlock = Block.func_149634_a((Item)heldItemStack.func_77973_b());
        StargateClassicMemberTile memberTile = (StargateClassicMemberTile)world.func_175625_s(pos);
        if (!world.field_72995_K) {
            Block camoBlock;
            IBlockState camoBlockState = memberTile.getCamoState();
            if (!memberTile.isMerged() || heldBlock instanceof StargateClassicMemberBlock || heldBlock instanceof StargateClassicBaseBlock) {
                return false;
            }
            if (!(heldItem instanceof ItemBlock) && camoBlockState == null) {
                BlockPos basePos = memberTile.getBasePos();
                player.openGui((Object)Aunis.instance, GuiIdEnum.GUI_STARGATE.id, world, basePos.func_177958_n(), basePos.func_177956_o(), basePos.func_177952_p());
                return true;
            }
            if (camoBlockState != null && (camoBlock = camoBlockState.func_177230_c()).func_176201_c(camoBlockState) == heldItemStack.func_77960_j() && (camoBlock instanceof BlockSlab && heldBlock instanceof BlockSlab ? ((BlockSlab)camoBlock).func_176552_j() : camoBlock == heldBlock)) {
                return false;
            }
            if (!(camoBlockState == null || camoBlockState.func_177230_c() instanceof BlockSlab && heldBlock instanceof BlockSlab && !((BlockSlab)camoBlockState.func_177230_c()).func_176552_j())) {
                int meta;
                camoBlock = camoBlockState.func_177230_c();
                int quantity = 1;
                if (camoBlock instanceof BlockSlab) {
                    BlockSlab blockSlab = (BlockSlab)camoBlock;
                    meta = blockSlab.func_176201_c(camoBlockState);
                    if (blockSlab.func_176552_j()) {
                        quantity = 2;
                        if (blockSlab == Blocks.field_150334_T) {
                            camoBlock = Blocks.field_150333_U;
                        } else if (blockSlab == Blocks.field_180388_cO) {
                            camoBlock = Blocks.field_180389_cP;
                        } else if (blockSlab == Blocks.field_150373_bw) {
                            camoBlock = Blocks.field_150376_bx;
                        } else if (blockSlab == Blocks.field_185770_cW) {
                            camoBlock = Blocks.field_185771_cX;
                        }
                    }
                } else {
                    meta = camoBlock.func_176201_c(camoBlockState);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(camoBlock, quantity, meta));
                }
                SoundType soundtype = camoBlock.getSoundType(camoBlock.func_176223_P(), world, pos, (Entity)player);
                world.func_184133_a(null, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                memberTile.setCamoState(null);
                camoBlockState = null;
            }
            if (heldItem instanceof ItemBlock) {
                int meta;
                Block block = null;
                if (camoBlockState != null && camoBlockState.func_177230_c() == heldBlock && camoBlockState.func_177230_c().func_176201_c(camoBlockState) == heldItemStack.func_77960_j()) {
                    BlockSlab blockSlab = (BlockSlab)camoBlockState.func_177230_c();
                    meta = blockSlab.func_176201_c(camoBlockState);
                    if (facing != EnumFacing.UP) {
                        return false;
                    }
                    if (blockSlab == Blocks.field_150333_U) {
                        block = Blocks.field_150334_T;
                    } else if (blockSlab == Blocks.field_180389_cP) {
                        block = Blocks.field_180388_cO;
                    } else if (blockSlab == Blocks.field_150376_bx) {
                        block = Blocks.field_150373_bw;
                    } else if (blockSlab == Blocks.field_185771_cX) {
                        block = Blocks.field_185770_cW;
                    }
                } else {
                    if (camoBlockState != null && !player.field_71075_bZ.field_75098_d) {
                        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(camoBlockState.func_177230_c(), 1, camoBlockState.func_177230_c().func_176201_c(camoBlockState)));
                    }
                    block = Block.func_149634_a((Item)heldItemStack.func_77973_b());
                    meta = heldItemStack.func_77960_j();
                }
                memberTile.setCamoState(block.func_176203_a(meta));
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItemStack.func_190918_g(1);
                }
                SoundType soundtype = block.getSoundType(block.func_176223_P(), world, pos, (Entity)player);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                world.func_180501_a(pos, state.func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)), 0);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(false)), 0);
            }
            return true;
        }
        return heldItem != Item.func_150898_a((Block)AunisBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK) && heldItem != Item.func_150898_a((Block)AunisBlocks.STARGATE_MILKY_WAY_BASE_BLOCK) && heldItem != Item.func_150898_a((Block)AunisBlocks.STARGATE_UNIVERSE_BASE_BLOCK) && heldItem != Item.func_150898_a((Block)AunisBlocks.STARGATE_UNIVERSE_MEMBER_BLOCK) && heldItem != Item.func_150898_a((Block)AunisBlocks.STARGATE_PEGASUS_BASE_BLOCK) && heldItem != Item.func_150898_a((Block)AunisBlocks.STARGATE_PEGASUS_MEMBER_BLOCK);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            state = state.func_177226_a((IProperty)AunisProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.byId(stack.func_77960_j() >> 3 & 1))).func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)facing);
            world.func_175656_a(pos, state);
            StargateAbstractBaseTile gateTile = this.getMergeHelper().findBaseTile((IBlockAccess)world, pos, facing);
            if (gateTile != null && !gateTile.isMerged()) {
                gateTile.updateMergeState(gateTile.getMergeHelper().checkBlocks((IBlockAccess)world, gateTile.func_174877_v(), (EnumFacing)world.func_180495_p(gateTile.func_174877_v()).func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL)), facing);
            }
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        StargateClassicMemberTile memberTile;
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K && (memberTile = (StargateClassicMemberTile)world.func_175625_s(pos)).getCamoItemStack() != null) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)memberTile.getCamoItemStack());
        }
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CamoPropertiesHelper.getLightOpacity(state, world, pos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return CamoPropertiesHelper.getStargateBlockBoundingBox(state, access, pos, false);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return CamoPropertiesHelper.getStargateBlockBoundingBox(state, access, pos, true);
    }
}

