/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.block.stargate;

import java.util.List;
import javax.annotation.Nullable;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.stargate.EnumMemberVariant;
import mrjake.aunis.stargate.merging.StargateAbstractMergeHelper;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class StargateAbstractBaseBlock
extends Block {
    public StargateAbstractBaseBlock(String blockName) {
        super(Material.field_151573_f);
        this.setRegistryName("aunis:" + blockName);
        this.func_149663_c("aunis." + blockName);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(Aunis.aunisGatesCreativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)));
        this.func_149713_g(0);
        this.func_149711_c(3.0f);
        this.func_149752_b(60.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        worldIn.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0f, true, true).func_77278_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AunisProps.FACING_HORIZONTAL, AunisProps.RENDER_BLOCK});
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)AunisProps.RENDER_BLOCK) != false ? 4 : 0) | ((EnumFacing)state.func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AunisProps.RENDER_BLOCK, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!(world.field_72995_K || player.func_70093_af() || this.tryAutobuild(player, world, pos, hand))) {
            this.showGateInfo(player, hand, world, pos);
        }
        return !player.func_70093_af();
    }

    protected abstract void showGateInfo(EntityPlayer var1, EnumHand var2, World var3, BlockPos var4);

    protected boolean tryAutobuild(EntityPlayer player, World world, BlockPos basePos, EnumHand hand) {
        BlockPos pos;
        List<BlockPos> posList;
        EnumMemberVariant variant;
        StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(basePos);
        EnumFacing facing = gateTile.getFacing();
        StargateAbstractMergeHelper mergeHelper = gateTile.getMergeHelper();
        ItemStack stack = player.func_184586_b(hand);
        if (!gateTile.isMerged() && (variant = mergeHelper.getMemberVariantFromItemStack(stack)) != null && !(posList = mergeHelper.getAbsentBlockPositions((IBlockAccess)world, basePos, facing, variant)).isEmpty() && world.func_180495_p(pos = posList.get(0)).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            IBlockState memberState = mergeHelper.getMemberBlock().func_176223_P();
            world.func_175656_a(pos, this.createMemberState(memberState, facing, stack.func_77960_j()));
            SoundType soundtype = memberState.func_177230_c().getSoundType(memberState, world, pos, (Entity)player);
            world.func_184133_a(null, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (posList.size() == 1) {
                gateTile.updateMergeState(gateTile.getMergeHelper().checkBlocks((IBlockAccess)world, basePos, facing), facing);
            }
            return true;
        }
        return false;
    }

    protected abstract IBlockState createMemberState(IBlockState var1, EnumFacing var2, int var3);

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(pos);
            gateTile.updateMergeState(false, (EnumFacing)state.func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL));
            gateTile.onBlockBroken();
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(pos);
        gateTile.refresh();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)AunisProps.RENDER_BLOCK)).booleanValue()) {
            return EnumBlockRenderType.MODEL;
        }
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

