/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.block.beamer;

import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.beamer.BeamerLinkingHelper;
import mrjake.aunis.gui.GuiIdEnum;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundPositionedEnum;
import mrjake.aunis.tileentity.BeamerTile;
import mrjake.aunis.util.ItemHandlerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BeamerBlock
extends Block {
    public static final String BLOCK_NAME = "beamer_block";

    public BeamerBlock() {
        super(Material.field_151573_f);
        this.setRegistryName("aunis:beamer_block");
        this.func_149663_c("aunis.beamer_block");
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(Aunis.aunisGatesCreativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AunisProps.FACING_HORIZONTAL, AunisProps.BEAMER_MODE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BeamerTile beamerTile = (BeamerTile)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)AunisProps.BEAMER_MODE, (Comparable)((Object)beamerTile.getMode()));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        BeamerTile beamerTile = (BeamerTile)world.func_175625_s(pos);
        return beamerTile.getComparatorOutput();
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BeamerTile tile;
        if (!(world.field_72995_K || player.func_70093_af() || FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, null) || (tile = (BeamerTile)world.func_175625_s(pos)).tryInsertUpgrade(player, hand))) {
            player.openGui((Object)Aunis.instance, GuiIdEnum.GUI_BEAMER.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return !player.func_70093_af();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        state = state.func_177226_a((IProperty)AunisProps.FACING_HORIZONTAL, (Comparable)facing);
        world.func_175656_a(pos, state);
        if (!world.field_72995_K) {
            BeamerLinkingHelper.findGateInFrontAndLink(world, pos, facing);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BeamerTile beamerTile = (BeamerTile)world.func_175625_s(pos);
        if (!world.field_72995_K) {
            ItemHandlerHelper.dropInventoryItems(world, pos, (IItemHandler)beamerTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            if (beamerTile.isLinked()) {
                beamerTile.getLinkedGateTile().removeLinkedBeamer(pos);
            }
            beamerTile.clearTargetBeamerPos();
            AunisSoundHelper.playPositionedSound(world, pos, SoundPositionedEnum.BEAMER_LOOP, false);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BeamerTile();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

