/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis;

import java.io.IOException;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.capability.endpoint.ItemEndpointCapability;
import mrjake.aunis.chunkloader.ChunkLoadingCallback;
import mrjake.aunis.command.AunisCommands;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateDimensionConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.creativetabs.AunisEnergyCreativeTabBuilder;
import mrjake.aunis.creativetabs.AunisGatesCreativeTabBuilder;
import mrjake.aunis.creativetabs.AunisItemsCreativeTabBuilder;
import mrjake.aunis.creativetabs.AunisOresCreativeTabBuilder;
import mrjake.aunis.creativetabs.AunisRingsCreativeTabBuilder;
import mrjake.aunis.datafixer.TileNamesFixer;
import mrjake.aunis.fluid.AunisFluids;
import mrjake.aunis.gui.base.AunisGuiHandler;
import mrjake.aunis.integration.OCWrapperInterface;
import mrjake.aunis.integration.ThermalIntegration;
import mrjake.aunis.integration.tconstruct.TConstructIntegration;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.proxy.IProxy;
import mrjake.aunis.worldgen.AunisWorldGen;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

@Mod(modid="aunis", name="Aunis", version="1.12.2-4.9.4.2", acceptedMinecraftVersions="1.12.2", dependencies="after:cofhcore@[4.6.0,);after:opencomputers")
public class Aunis {
    public static final String ModID = "aunis";
    public static final String Name = "Aunis";
    public static final String Version = "1.12.2-4.9.4.2";
    public static final int DATA_VERSION = 10;
    public static final String MCVersion = "1.12.2";
    public static final String CLIENT = "mrjake.aunis.proxy.ProxyClient";
    public static final String SERVER = "mrjake.aunis.proxy.ProxyServer";
    public static SoundCategory AUNIS_SOUNDS;
    public static final AunisGatesCreativeTabBuilder aunisGatesCreativeTab;
    public static final AunisRingsCreativeTabBuilder aunisRingsCreativeTab;
    public static final AunisItemsCreativeTabBuilder aunisItemsCreativeTab;
    public static final AunisOresCreativeTabBuilder aunisOresCreativeTab;
    public static final AunisEnergyCreativeTabBuilder aunisEnergyCreativeTab;
    @Mod.Instance(value="aunis")
    public static Aunis instance;
    @SidedProxy(clientSide="mrjake.aunis.proxy.ProxyClient", serverSide="mrjake.aunis.proxy.ProxyServer")
    public static IProxy proxy;
    public static Logger logger;
    private static final String OC_WRAPPER_LOADED = "mrjake.aunis.integration.OCWrapperLoaded";
    private static final String OC_WRAPPER_NOT_LOADED = "mrjake.aunis.integration.OCWrapperNotLoaded";
    private static final String IC2_WRAPPER_LOADED = "mrjake.aunis.integration.IC2WrapperLoaded";
    private static final String IC2_WRAPPER_NOT_LOADED = "mrjake.aunis.integration.IC2WrapperNotLoaded";
    public static OCWrapperInterface ocWrapper;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Aunis.info("Started loading Aunis mod!");
        AUNIS_SOUNDS = SoundCategory.BLOCKS;
        AunisPacketHandler.registerPackets();
        Aunis.info("Successfully registered Packets!");
        AunisFluids.registerFluids();
        if (Loader.isModLoaded((String)"tconstruct") && AunisConfig.integrationsConfig.tConstructIntegration) {
            Aunis.info("TConstruct found and connection is enabled... Connecting...");
            TConstructIntegration.initFluids();
            Aunis.info("Successfully connected into TConstruct!");
        }
        Aunis.info("Successfully registered Fluids!");
        StargateDimensionConfig.load(event.getModConfigurationDirectory());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new AunisWorldGen(), (int)0);
        Aunis.info("Successfully registered World Generation!");
        if (Loader.isModLoaded((String)"thermalexpansion") && AunisConfig.integrationsConfig.tExpansionIntegration) {
            Aunis.info("Thermal Expansion found... Connecting...");
            ThermalIntegration.registerRecipes();
            Aunis.info("Successfully connected into Thermal Expansion!");
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new AunisGuiHandler());
        ItemEndpointCapability.register();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)ChunkLoadingCallback.INSTANCE);
        OreDictionary.registerOre((String)"oreNaquadah", (Block)AunisBlocks.ORE_NAQUADAH_BLOCK);
        OreDictionary.registerOre((String)"oreNaquadah", (Block)AunisBlocks.ORE_NAQUADAH_BLOCK_STONE);
        OreDictionary.registerOre((String)"gemNaquadah", (Item)AunisItems.NAQUADAH_SHARD);
        OreDictionary.registerOre((String)"ingotNaquadah", (Item)AunisItems.NAQUADAH_ALLOY_RAW);
        OreDictionary.registerOre((String)"ingotNaquadahRefined", (Item)AunisItems.NAQUADAH_ALLOY);
        OreDictionary.registerOre((String)"blockNaquadahRefined", (Block)AunisBlocks.NAQUADAH_BLOCK);
        OreDictionary.registerOre((String)"blockNaquadahRaw", (Block)AunisBlocks.NAQUADAH_BLOCK_RAW);
        OreDictionary.registerOre((String)"oreTrinium", (Block)AunisBlocks.ORE_TRINIUM_BLOCK);
        OreDictionary.registerOre((String)"oreTitanium", (Block)AunisBlocks.ORE_TITANIUM_BLOCK);
        OreDictionary.registerOre((String)"ingotTrinium", (Item)AunisItems.TRINIUM_INGOT);
        OreDictionary.registerOre((String)"ingotTitanium", (Item)AunisItems.TITANIUM_INGOT);
        OreDictionary.registerOre((String)"blockTrinium", (Block)AunisBlocks.TRINIUM_BLOCK);
        OreDictionary.registerOre((String)"blockTitanium", (Block)AunisBlocks.TITANIUM_BLOCK);
        Aunis.info("Successfully registered OreDictionary!");
        try {
            if (Loader.isModLoaded((String)"opencomputers") && AunisConfig.integrationsConfig.ocIntegration) {
                Aunis.info("OpenComputers found... Connecting...");
                ocWrapper = (OCWrapperInterface)Class.forName(OC_WRAPPER_LOADED).newInstance();
                Aunis.info("Successfully connected into OpenComputers!");
            } else {
                ocWrapper = (OCWrapperInterface)Class.forName(OC_WRAPPER_NOT_LOADED).newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("Exception loading OpenComputers wrapper");
            e.printStackTrace();
        }
        ModFixs modFixs = FMLCommonHandler.instance().getDataFixer().init(ModID, 10);
        modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileNamesFixer());
        StargateSizeEnum.init();
        Aunis.info("Successfully registered Stargate sizes!");
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws IOException {
        proxy.postInit(event);
        Aunis.info("Aunis loaded!");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        AunisCommands.registerCommands(event);
        Aunis.info("Successfully registered Commands!");
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) throws IOException {
        StargateDimensionConfig.update();
        Aunis.info("Server started!");
    }

    public static void info(String string) {
        logger.info(string);
    }

    public static void warn(String string) {
        logger.warn(string);
    }

    public static void error(String string) {
        logger.error(string);
    }

    static {
        aunisGatesCreativeTab = new AunisGatesCreativeTabBuilder();
        aunisRingsCreativeTab = new AunisRingsCreativeTabBuilder();
        aunisItemsCreativeTab = new AunisItemsCreativeTabBuilder();
        aunisOresCreativeTab = new AunisOresCreativeTabBuilder();
        aunisEnergyCreativeTab = new AunisEnergyCreativeTabBuilder();
        FluidRegistry.enableUniversalBucket();
    }
}

