/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.utility;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import logictechcorp.libraryex.IModData;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.item.crafting.RecipeRepairItemMod;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.commons.io.FileUtils;

public class RecipeHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> USED_REGISTRY_NAMES = new HashSet<String>();
    private static final Map<OreIngredient, String> ORE_INGREDIENTS = new HashMap<OreIngredient, String>();

    private static IRecipe createShapelessRecipe(IModData data, ItemStack output, Object ... inputs) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (Object input : inputs) {
            Ingredient ingredient = CraftingHelper.getIngredient((Object)input);
            if (ingredient instanceof OreIngredient) {
                ORE_INGREDIENTS.put((OreIngredient)ingredient, (String)input);
            }
            ingredients.add((Object)ingredient);
        }
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("No ingredients for shapeless recipe!");
        }
        if (ingredients.size() > 9) {
            throw new IllegalArgumentException("Too many ingredients for shapeless recipe!");
        }
        return (IRecipe)new ShapelessRecipes(data.getModId(), output, ingredients).setRegistryName(RecipeHelper.generateRegistryName(data, output));
    }

    private static IRecipe createShapedRecipe(IModData data, ItemStack output, Object ... inputs) {
        ArrayList<String> pattern = new ArrayList<String>();
        HashMap<String, Ingredient> key = new HashMap<String, Ingredient>();
        Iterator<Object> inputItr = Arrays.asList(inputs).iterator();
        while (inputItr.hasNext()) {
            Object object = inputItr.next();
            if (object instanceof String) {
                String string = (String)object;
                if (string.length() > 3) {
                    throw new IllegalArgumentException("Invalid string length for recipe " + string.length());
                }
                if (pattern.size() <= 2) {
                    pattern.add(string);
                    continue;
                }
                throw new IllegalArgumentException("Recipe has too many crafting rows!");
            }
            if (object instanceof Character) {
                key.put(((Character)object).toString(), CraftingHelper.getIngredient((Object)inputItr.next()));
                continue;
            }
            throw new IllegalArgumentException("Unexpected argument of type " + object.getClass().toString());
        }
        int width = ((String)pattern.get(0)).length();
        int height = pattern.size();
        key.put(" ", Ingredient.field_193370_a);
        NonNullList<Ingredient> ingredients = RecipeHelper.deserializeIngredients(pattern.toArray(new String[0]), key, width, height);
        return (IRecipe)new ShapedRecipes(data.getModId(), width, height, ingredients, output).setRegistryName(RecipeHelper.generateRegistryName(data, output));
    }

    private static IRecipe createRepairRecipe(IModData data, ItemStack output, Object input, int repairAmount) {
        Ingredient ingredient = CraftingHelper.getIngredient((Object)input);
        if (ingredient == null) {
            throw new IllegalArgumentException("Invalid type for ingredient " + input.getClass().toString());
        }
        if (ingredient instanceof OreIngredient) {
            ORE_INGREDIENTS.put((OreIngredient)ingredient, (String)input);
        }
        return (IRecipe)new RecipeRepairItemMod(output, ingredient, repairAmount).setRegistryName(RecipeHelper.generateRegistryName(data, output));
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList ingredients = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet<String> set = new HashSet<String>(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                ingredients.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return ingredients;
    }

    private static ResourceLocation generateRegistryName(IModData data, ItemStack output) {
        ResourceLocation baseRegistryName;
        ResourceLocation retRegistryName = baseRegistryName = new ResourceLocation(data.getModId() + ":" + output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (USED_REGISTRY_NAMES.contains(retRegistryName.toString())) {
            retRegistryName = new ResourceLocation(data.getModId() + ":" + baseRegistryName.func_110623_a() + "_" + ++index);
        }
        USED_REGISTRY_NAMES.add(retRegistryName.toString());
        return retRegistryName;
    }

    private static void writeRecipeJson(IRecipe recipe) {
        ResourceLocation registryName = recipe.getRegistryName();
        if (recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes) {
            String json = RecipeHelper.createRecipeJson(recipe);
            File recipeFile = new File(LibraryEx.CONFIG_DIRECTORY, registryName.func_110624_b() + "/recipes/" + registryName.func_110623_a() + ".json");
            try {
                FileUtils.writeStringToFile((File)recipeFile, (String)json, (Charset)StandardCharsets.US_ASCII);
            }
            catch (Exception e) {
                LibraryEx.LOGGER.error("Could not write recipe to file " + recipeFile.getName());
            }
        }
    }

    private static String createRecipeJson(IRecipe recipe) {
        JsonObject root = new JsonObject();
        if (!recipe.func_193358_e().isEmpty()) {
            root.add("group", (JsonElement)new JsonPrimitive(recipe.func_193358_e()));
        }
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
            BiMap<String, Ingredient> keyMap = RecipeHelper.createShapedRecipeKey((NonNullList<Ingredient>)recipe.func_192400_c());
            String[] pattern = RecipeHelper.createShapedPattern(shapedRecipe, keyMap);
            String type = "minecraft:crafting_shaped";
            JsonArray patternJsonArray = new JsonArray();
            for (String row : pattern) {
                patternJsonArray.add(row);
            }
            JsonObject keyObj = new JsonObject();
            for (String key : keyMap.keySet()) {
                Ingredient ingredient = (Ingredient)keyMap.get((Object)key);
                if (ingredient instanceof OreIngredient) {
                    type = "forge:ore_shaped";
                }
                keyObj.add(key, (JsonElement)RecipeHelper.createIngredientJson(ingredient));
            }
            root.add("type", (JsonElement)new JsonPrimitive(type));
            root.add("pattern", (JsonElement)patternJsonArray);
            root.add("key", (JsonElement)keyObj);
        } else if (recipe instanceof ShapelessRecipes) {
            String type = "minecraft:crafting_shapeless";
            JsonArray ingredientsArray = new JsonArray();
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient.func_193365_a().length > 1 && !(ingredient instanceof OreIngredient)) {
                    throw new IllegalArgumentException("Cannot create key for ingredient matching multiple stacks!");
                }
                if (ingredient.func_193365_a().length == 0) continue;
                if (ingredient instanceof OreIngredient) {
                    type = "forge:ore_shapeless";
                }
                ingredientsArray.add((JsonElement)RecipeHelper.createIngredientJson(ingredient));
            }
            root.add("type", (JsonElement)new JsonPrimitive(type));
            root.add("ingredients", (JsonElement)ingredientsArray);
        }
        root.add("result", (JsonElement)RecipeHelper.createItemStackJson(recipe.func_77571_b()));
        return GSON.toJson((JsonElement)root);
    }

    private static JsonObject createIngredientJson(Ingredient ingredient) {
        JsonObject ret;
        if (ingredient instanceof OreIngredient) {
            ret = new JsonObject();
            ret.add("type", (JsonElement)new JsonPrimitive("forge:ore_dict"));
            ret.add("ore", (JsonElement)new JsonPrimitive(ORE_INGREDIENTS.get(ingredient)));
        } else {
            ret = RecipeHelper.createItemStackJson(ingredient.func_193365_a()[0]);
        }
        return ret;
    }

    private static JsonObject createItemStackJson(ItemStack stack) {
        JsonObject ret = new JsonObject();
        ret.add("item", (JsonElement)new JsonPrimitive(stack.func_77973_b().getRegistryName().toString()));
        if (stack.func_190916_E() != 1) {
            ret.add("count", (JsonElement)new JsonPrimitive((Number)stack.func_190916_E()));
        }
        if (stack.func_77960_j() != 0 || stack.func_77981_g()) {
            ret.add("data", (JsonElement)new JsonPrimitive((Number)stack.func_77960_j()));
        }
        return ret;
    }

    private static String[] createShapedPattern(ShapedRecipes recipe, BiMap<String, Ingredient> keyMap) {
        int i;
        String[] pattern = new String[recipe.field_77577_c];
        for (i = 0; i < pattern.length; ++i) {
            pattern[i] = "";
        }
        if (keyMap.isEmpty()) {
            return pattern;
        }
        for (i = 0; i < recipe.func_192400_c().size(); ++i) {
            int row;
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
            String key = " ";
            if (ingredient.func_193365_a().length > 1 && !(ingredient instanceof OreIngredient)) {
                throw new IllegalArgumentException("Cannot generate json for a recipe matching multiple stacks!");
            }
            if (ingredient.func_193365_a().length != 0) {
                key = (String)keyMap.inverse().get((Object)ingredient);
            }
            int n = row = i / recipe.field_77576_b;
            pattern[n] = pattern[n] + key;
        }
        return pattern;
    }

    private static BiMap<String, Ingredient> createShapedRecipeKey(NonNullList<Ingredient> ingredients) {
        HashSet<Ingredient> ingredientsSet = new HashSet<Ingredient>((Collection<Ingredient>)ingredients);
        HashBiMap key = HashBiMap.create();
        int fallbackCount = 0;
        for (Ingredient ingredient : ingredientsSet) {
            if (ingredient.func_193365_a().length > 1 && !(ingredient instanceof OreIngredient)) {
                throw new IllegalArgumentException("Cannot create key for ingredient matching multiple stacks!");
            }
            if (ingredient.func_193365_a().length == 0) continue;
            if (fallbackCount == 0) {
                key.put((Object)RecipeHelper.getFallbackRecipeKey(fallbackCount), (Object)ingredient);
                ++fallbackCount;
                continue;
            }
            String letterKey = ingredient.func_193365_a()[0].func_77973_b().getRegistryName().func_110623_a().substring(0, 1).toUpperCase();
            if (!key.containsKey((Object)letterKey)) {
                key.put((Object)letterKey, (Object)ingredient);
                continue;
            }
            String fallbackKey = RecipeHelper.getFallbackRecipeKey(fallbackCount);
            if (key.containsKey((Object)fallbackKey)) {
                throw new RuntimeException("Fallback key " + fallbackKey + " is already present!");
            }
            key.put((Object)fallbackKey, (Object)ingredient);
            ++fallbackCount;
        }
        return key;
    }

    private static String getFallbackRecipeKey(int index) {
        switch (index) {
            case 1: {
                return "*";
            }
            case 2: {
                return "@";
            }
            case 3: {
                return "%";
            }
            case 4: {
                return "+";
            }
            case 5: {
                return "-";
            }
            case 6: {
                return "~";
            }
            case 7: {
                return "=";
            }
            case 8: {
                return "?";
            }
        }
        return "#";
    }

    public static IRecipe addShapedRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.createShapedRecipe(data, output, inputs);
    }

    public static IRecipe addShapelessRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.createShapelessRecipe(data, output, inputs);
    }

    public static IRecipe addRepairRecipe(IModData data, ItemStack output, Object ingredient, int repairAmount) {
        return RecipeHelper.createRepairRecipe(data, output, ingredient, repairAmount);
    }

    public static void addSmelting(ItemStack output, ItemStack input, float xp) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, xp);
    }

    public static void addBrewing(PotionType input, Item reagent, PotionType output) {
        PotionHelper.func_193357_a((PotionType)input, (Item)reagent, (PotionType)output);
    }

    public static void addBrewing(PotionType input, Ingredient ingredient, PotionType output) {
        PotionHelper.func_193356_a((PotionType)input, (Ingredient)ingredient, (PotionType)output);
    }

    public static IRecipe add1x2Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "#", "#", Character.valueOf('#'), input);
    }

    public static IRecipe add1x3Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "#", "#", "#", Character.valueOf('#'), input);
    }

    public static IRecipe add2x1Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "##", Character.valueOf('#'), input);
    }

    public static IRecipe add2x2Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "##", "##", Character.valueOf('#'), input);
    }

    public static IRecipe add2x3Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "##", "##", "##", Character.valueOf('#'), input);
    }

    public static IRecipe add3x1Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "###", Character.valueOf('#'), input);
    }

    public static IRecipe add3x2Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "###", "###", Character.valueOf('#'), input);
    }

    public static IRecipe add3x3Recipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "###", "###", "###", Character.valueOf('#'), input);
    }

    public static IRecipe addSurroundedRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, "###", "#*#", "###", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addCrossRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, " # ", "###", " # ", Character.valueOf('#'), input);
    }

    public static IRecipe addFilledCrossRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, " # ", "#*#", " # ", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addStairRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "#  ", "## ", "###", Character.valueOf('#'), input);
    }

    public static IRecipe addFenceRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, "#*#", "#*#", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addWallRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "###", "###", Character.valueOf('#'), input);
    }

    public static IRecipe addSwordRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, " # ", " # ", " * ", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addPickaxeRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, "###", " * ", " * ", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addShovelRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, " # ", " * ", " * ", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addAxeRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, "##", "#*", " *", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addHoeRecipe(IModData data, ItemStack output, Object ... inputs) {
        return RecipeHelper.addShapedRecipe(data, output, "##", " *", " *", Character.valueOf('#'), inputs[0], Character.valueOf('*'), inputs[1]);
    }

    public static IRecipe addHelmetRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "###", "# #", Character.valueOf('#'), input);
    }

    public static IRecipe addChestplateRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "# #", "###", "###", Character.valueOf('#'), input);
    }

    public static IRecipe addLeggingsRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "###", "# #", "# #", Character.valueOf('#'), input);
    }

    public static IRecipe addBootsRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "# #", "# #", Character.valueOf('#'), input);
    }

    public static IRecipe addBoatRecipe(IModData data, ItemStack output, Object input) {
        return RecipeHelper.addShapedRecipe(data, output, "# #", "###", Character.valueOf('#'), input);
    }
}

