/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.util.commands.ii;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemToolUpgrade;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityFieldHowitzer;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMachinegun;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMortar;
import pl.pabilo8.immersiveintelligence.common.entity.EntityVehicleSeat;
import pl.pabilo8.immersiveintelligence.common.entity.hans.HansUtils;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletMagazine;
import pl.pabilo8.immersiveintelligence.common.items.armor.ItemIIArmorUpgrade;
import pl.pabilo8.immersiveintelligence.common.items.weapons.ItemIIRailgunOverride;
import pl.pabilo8.immersiveintelligence.common.items.weapons.ItemIIWeaponUpgrade;

public class CommandIIHans
extends CommandBase {
    static final HashMap<ResourceLocation, HansSquad> squadList = new HashMap();
    static final String[] DEPLOYMENT_LINES;

    @Nonnull
    public String func_71517_b() {
        return "hans";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "Summons ze H A N S, usage: ii hans <squad_id> <amount> <team> <airborne>";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        block8: {
            try {
                if (server.func_130014_f_().field_72995_K || args.length < 1) {
                    throw new Exception();
                }
                World world = sender.func_130014_f_();
                Entity commandSenderEntity = sender.func_174793_f();
                Vec3d spawnPosition = this.getSpawnPosition(sender);
                HansSquad squad = squadList.get(new ResourceLocation(args[0]));
                int amount = args.length > 1 ? Integer.parseInt(args[1]) : 1;
                ScorePlayerTeam team = args.length > 2 ? world.func_96441_U().func_96508_e(args[2]) : null;
                boolean parachute = args.length > 3 && Boolean.parseBoolean(args[3]);
                float yaw = 0.0f;
                float pitch = 0.0f;
                if (commandSenderEntity != null) {
                    yaw = MathHelper.func_76142_g((float)commandSenderEntity.field_70125_A);
                    pitch = commandSenderEntity.field_70125_A;
                }
                if (amount < 1) {
                    throw new WrongUsageException("Squads MUST contain at least one Hans", new Object[0]);
                }
                if (squad != null) {
                    EntityHans hans = squad.spawnHanses(world, spawnPosition, amount, (Team)team, parachute, yaw, pitch);
                    if (commandSenderEntity != null) {
                        commandSenderEntity.func_145747_a((ITextComponent)new TextComponentTranslation(DEPLOYMENT_LINES[(int)((double)(DEPLOYMENT_LINES.length - 1) * Utils.RAND.nextDouble())], new Object[]{hans.func_145748_c_().func_150255_a(new Style().func_150209_a(hans.func_174823_aP()))}));
                    }
                    break block8;
                }
                throw new WrongUsageException("There is no squad with that id, use tab to see available options", new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof WrongUsageException) {
                    throw (WrongUsageException)e;
                }
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return CommandIIHans.func_175762_a((String[])args, squadList.keySet());
            }
            case 2: {
                return Collections.singletonList("1");
            }
            case 3: {
                return CommandIIHans.func_175762_a((String[])args, (Collection)sender.func_130014_f_().func_96441_U().func_96531_f());
            }
            case 4: {
                return CommandIIHans.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
            }
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    @Nonnull
    public Vec3d getSpawnPosition(@Nonnull ICommandSender sender) {
        Entity commandSenderEntity = sender.func_174793_f();
        if (commandSenderEntity == null) {
            return sender.func_174791_d();
        }
        float blockReachDistance = 100.0f;
        Vec3d vec3d = commandSenderEntity.func_174824_e(0.0f);
        Vec3d vec3d1 = commandSenderEntity.func_70676_i(0.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
        RayTraceResult traceResult = commandSenderEntity.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
        if (traceResult == null || traceResult.field_72313_a == RayTraceResult.Type.MISS) {
            return sender.func_174791_d();
        }
        return new Vec3d((Vec3i)traceResult.func_178782_a().func_177984_a());
    }

    static {
        squadList.clear();
        squadList.put(new ResourceLocation("immersiveintelligence", "smg"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, new ItemIIArmorUpgrade.ArmorUpgrades[0]);
                ItemStack magazine = ItemIIBulletMagazine.getMagazine("submachinegun", IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_brass", "piercing", new String[0]));
                HansUtils.setSubmachinegun(hans, magazine, new ItemIIWeaponUpgrade.WeaponUpgrades[0]);
                hans.mainInventory.set(0, (Object)magazine.func_77946_l());
                hans.mainInventory.set(1, (Object)magazine.func_77946_l());
                hans.mainInventory.set(2, (Object)magazine.func_77946_l());
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "smg_drum"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, new ItemIIArmorUpgrade.ArmorUpgrades[0]);
                ItemStack magazine = ItemIIBulletMagazine.getMagazine("submachinegun_drum", IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_brass", "piercing", new String[0]));
                HansUtils.setSubmachinegun(hans, magazine, ItemIIWeaponUpgrade.WeaponUpgrades.BOTTOM_LOADING);
                hans.mainInventory.set(0, (Object)magazine.func_77946_l());
                hans.mainInventory.set(1, (Object)magazine.func_77946_l());
                hans.mainInventory.set(2, (Object)magazine.func_77946_l());
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "smg_spec_ops"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, ItemIIArmorUpgrade.ArmorUpgrades.GASMASK);
                ItemStack magazine = ItemIIBulletMagazine.getMagazine("submachinegun_drum", IIContent.itemAmmoSubmachinegun.getBulletWithParams("core_tungsten", "piercing", new String[0]));
                HansUtils.setSubmachinegun(hans, magazine, ItemIIWeaponUpgrade.WeaponUpgrades.BOTTOM_LOADING, ItemIIWeaponUpgrade.WeaponUpgrades.FOLDING_STOCK, ItemIIWeaponUpgrade.WeaponUpgrades.SUPPRESSOR);
                hans.mainInventory.set(0, (Object)magazine.func_77946_l());
                hans.mainInventory.set(1, (Object)magazine.func_77946_l());
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "revolver"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, new ItemIIArmorUpgrade.ArmorUpgrades[0]);
                ItemStack stack = new ItemStack((Item)IEContent.itemRevolver);
                hans.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "railgun"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, new ItemIIArmorUpgrade.ArmorUpgrades[0]);
                ItemStack stack = new ItemStack((Item)IEContent.itemRailgun);
                hans.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                ItemStack ammo = IIContent.itemRailgunGrenade.getBulletWithParams("core_brass", "canister", "tnt");
                ammo.func_190920_e(8);
                hans.mainInventory.set(0, (Object)ammo.func_77946_l());
                hans.mainInventory.set(1, (Object)ammo.func_77946_l());
                ItemStack backpack = new ItemStack((Item)IIContent.itemAdvancedPowerPack);
                EnergyHelper.insertFlux((ItemStack)backpack, (int)9999999, (boolean)false);
                hans.func_184201_a(EntityEquipmentSlot.CHEST, backpack);
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "railgun_sniper"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, new ItemIIArmorUpgrade.ArmorUpgrades[0]);
                ItemStack stack = new ItemStack((Item)IEContent.itemRailgun);
                ItemIIRailgunOverride itemRailgun = (ItemIIRailgunOverride)IEContent.itemRailgun;
                NonNullList upgrades = NonNullList.func_191197_a((int)itemRailgun.getSlotCount(stack), (Object)ItemStack.field_190927_a);
                upgrades.set(0, (Object)new ItemStack((Item)IEContent.itemToolUpgrades, 1, ItemToolUpgrade.ToolUpgrades.RAILGUN_SCOPE.ordinal()));
                itemRailgun.setContainedItems(stack, upgrades);
                itemRailgun.recalculateUpgrades(stack);
                itemRailgun.finishUpgradeRecalculation(stack);
                hans.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                ItemStack ammo = new ItemStack((Item)IEContent.itemGraphiteElectrode, 16);
                hans.mainInventory.set(0, (Object)ammo.func_77946_l());
                hans.mainInventory.set(1, (Object)ammo.func_77946_l());
                ItemStack backpack = new ItemStack((Item)IIContent.itemAdvancedPowerPack);
                EnergyHelper.insertFlux((ItemStack)backpack, (int)9999999, (boolean)false);
                hans.func_184201_a(EntityEquipmentSlot.CHEST, backpack);
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "chemthrower"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, ItemIIArmorUpgrade.ArmorUpgrades.GASMASK);
                ItemStack stack = new ItemStack((Item)IEContent.itemChemthrower);
                hans.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"Fluid", (NBTTagCompound)new FluidStack(IEContent.fluidCreosote, 2000).writeToNBT(new NBTTagCompound()));
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "observer"), new HansSquadHandWeapon(){

            @Override
            public void setItems(EntityHans hans, int id) {
                HansUtils.setHelmet(hans, ItemIIArmorUpgrade.ArmorUpgrades.GASMASK);
                ItemStack stack = new ItemStack((Item)IIContent.itemBinoculars);
                hans.func_184611_a(EnumHand.MAIN_HAND, stack);
            }
        });
        squadList.put(new ResourceLocation("immersiveintelligence", "heavy_mg"), new HansSquadMG());
        squadList.put(new ResourceLocation("immersiveintelligence", "mortar"), new HansSquadMortar());
        squadList.put(new ResourceLocation("immersiveintelligence", "field_howi"), new HansSquadFieldHowitzer());
        squadList.put(new ResourceLocation("immersiveintelligence", "eselschreck"), new HansSquadTeamWeapon<EntityDonkey>(){

            @Override
            @Nullable
            protected EntityDonkey spawnTeamWeapon(World world, Vec3d pos, Team team, boolean parachute, float yaw, float pitch) {
                ItemStack mgstack = new ItemStack((Item)IIContent.itemMachinegun);
                NonNullList upgrades = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
                upgrades.set(0, (Object)new ItemStack((Item)IIContent.itemWeaponUpgrade, 1, ItemIIWeaponUpgrade.WeaponUpgrades.TRIPOD.ordinal()));
                upgrades.set(1, (Object)new ItemStack((Item)IIContent.itemWeaponUpgrade, 1, ItemIIWeaponUpgrade.WeaponUpgrades.HEAVY_BARREL.ordinal()));
                IIContent.itemMachinegun.setContainedItems(mgstack, upgrades);
                IIContent.itemMachinegun.recalculateUpgrades(mgstack);
                IIContent.itemMachinegun.finishUpgradeRecalculation(mgstack);
                EntityMachinegun mg = new EntityMachinegun(world, new BlockPos(pos).func_177977_b(), yaw, 0.0f, mgstack);
                world.func_72838_d((Entity)mg);
                EntityDonkey donkey = new EntityDonkey(world);
                donkey.func_70107_b(pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c);
                if (team != null) {
                    world.func_96441_U().func_151392_a(donkey.func_110124_au().toString(), team.func_96661_b());
                }
                world.func_72838_d((Entity)donkey);
                mg.func_184205_a((Entity)donkey, true);
                return donkey;
            }

            @Override
            protected EntityHans addCrewmen(World world, Vec3d pos, Team team, boolean parachute, EntityDonkey teamWeapon) {
                EntityHans hans = this.createCrewman(world, pos, team, parachute);
                teamWeapon.func_184779_b(hans.func_110124_au());
                teamWeapon.func_110234_j(true);
                teamWeapon.func_110251_o(true);
                if (teamWeapon.func_184188_bt().size() > 0) {
                    hans.func_184205_a((Entity)teamWeapon.func_184188_bt().get(0), true);
                }
                return hans;
            }
        });
        DEPLOYMENT_LINES = new String[]{"%s ist Einsatzbereit!", "Ein neues %s is Bereit zum Kampf", "%s - bereit zum Einsatz", "%s wartet auf deine Befehle", "%s ist Kampfbereit", "Wir haben ein neues %s!", "Der %s ist bereit!", "%s - bereit zum Dienst!", "Ein neues %s ist Kriegsbereit!"};
    }

    private static class HansSquadFieldHowitzer
    extends HansSquadTeamWeapon<EntityFieldHowitzer> {
        private HansSquadFieldHowitzer() {
        }

        @Override
        @Nullable
        protected EntityFieldHowitzer spawnTeamWeapon(World world, Vec3d pos, Team team, boolean parachute, float yaw, float pitch) {
            EntityFieldHowitzer howi = new EntityFieldHowitzer(world);
            howi.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, MathHelper.func_76142_g((float)(yaw + 180.0f)), 0.0f);
            world.func_72838_d((Entity)howi);
            if (parachute) {
                HansUtils.setParachute(howi);
            }
            return howi;
        }

        @Override
        protected EntityHans addCrewmen(World world, Vec3d pos, Team team, boolean parachute, EntityFieldHowitzer teamWeapon) {
            EntityHans hans1 = this.createCrewman(world, pos.func_72441_c(parachute ? 8.0 : 0.0, 0.0, 0.0), team, parachute);
            EntityHans hans2 = this.createCrewman(world, pos.func_72441_c(parachute ? -8.0 : 0.0, 0.0, 0.0), team, parachute);
            if (parachute) {
                hans1.markCrewman(EntityVehicleSeat.getOrCreateSeat(teamWeapon, 0));
                hans2.markCrewman(EntityVehicleSeat.getOrCreateSeat(teamWeapon, 1));
            } else {
                hans1.func_184220_m(EntityVehicleSeat.getOrCreateSeat(teamWeapon, 0));
                hans2.func_184220_m(EntityVehicleSeat.getOrCreateSeat(teamWeapon, 1));
            }
            return hans1;
        }

        @Override
        protected boolean isAirDroppable() {
            return true;
        }
    }

    private static class HansSquadMortar
    extends HansSquadTeamWeapon<EntityMortar> {
        private HansSquadMortar() {
        }

        @Override
        protected EntityMortar spawnTeamWeapon(World world, Vec3d pos, Team team, boolean parachute, float yaw, float pitch) {
            EntityMortar mortar = new EntityMortar(world);
            mortar.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, yaw, 80.0f);
            world.func_72838_d((Entity)mortar);
            return mortar;
        }

        @Override
        protected EntityHans addCrewmen(World world, Vec3d pos, Team team, boolean parachute, EntityMortar teamWeapon) {
            EntityHans hans = this.createCrewman(world, pos, team, parachute);
            hans.func_184220_m(teamWeapon);
            hans.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, teamWeapon.field_70177_z, 0.0f);
            hans.func_70034_d(teamWeapon.field_70177_z);
            return hans;
        }
    }

    private static class HansSquadMG
    extends HansSquadTeamWeapon<EntityMachinegun> {
        private HansSquadMG() {
        }

        @Override
        protected EntityMachinegun spawnTeamWeapon(World world, Vec3d pos, Team team, boolean parachute, float yaw, float pitch) {
            ItemStack mgstack = new ItemStack((Item)IIContent.itemMachinegun);
            NonNullList upgrades = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
            upgrades.set(0, (Object)new ItemStack((Item)IIContent.itemWeaponUpgrade, 1, ItemIIWeaponUpgrade.WeaponUpgrades.TRIPOD.ordinal()));
            upgrades.set(1, (Object)new ItemStack((Item)IIContent.itemWeaponUpgrade, 1, ItemIIWeaponUpgrade.WeaponUpgrades.HEAVY_BARREL.ordinal()));
            IIContent.itemMachinegun.setContainedItems(mgstack, upgrades);
            IIContent.itemMachinegun.recalculateUpgrades(mgstack);
            IIContent.itemMachinegun.finishUpgradeRecalculation(mgstack);
            EntityMachinegun mg = new EntityMachinegun(world, new BlockPos(pos).func_177977_b(), yaw, 0.0f, mgstack);
            world.func_72838_d((Entity)mg);
            return mg;
        }

        @Override
        protected EntityHans addCrewmen(World world, Vec3d pos, Team team, boolean parachute, EntityMachinegun teamWeapon) {
            EntityHans hans = this.createCrewman(world, pos, team, parachute);
            hans.func_184220_m(teamWeapon);
            return hans;
        }
    }

    private static abstract class HansSquadTeamWeapon<T extends Entity>
    extends HansSquad {
        private HansSquadTeamWeapon() {
        }

        @Override
        public EntityHans spawnHanses(World world, Vec3d pos, int amount, @Nullable Team team, boolean parachute, float yaw, float pitch) {
            T teamWeapon;
            if (this.isAirDroppable() && parachute) {
                pos = pos.func_72441_c(0.0, 60.0, 0.0);
            }
            if ((teamWeapon = this.spawnTeamWeapon(world, pos, team, parachute, yaw, pitch)) != null) {
                return this.addCrewmen(world, pos, team, parachute, teamWeapon);
            }
            return null;
        }

        @Nullable
        protected abstract T spawnTeamWeapon(World var1, Vec3d var2, Team var3, boolean var4, float var5, float var6);

        protected abstract EntityHans addCrewmen(World var1, Vec3d var2, Team var3, boolean var4, T var5);

        protected EntityHans createCrewman(World world, Vec3d pos, Team team, boolean parachute) {
            EntityHans hans = new EntityHans(world);
            hans.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            world.func_72838_d((Entity)hans);
            HansUtils.setHelmet(hans, new ItemIIArmorUpgrade.ArmorUpgrades[0]);
            if (team != null) {
                world.func_96441_U().func_151392_a(hans.func_110124_au().toString(), team.func_96661_b());
            }
            if (this.isAirDroppable() && parachute) {
                HansUtils.setParachute((Entity)hans);
            }
            return hans;
        }

        protected boolean isAirDroppable() {
            return false;
        }
    }

    private static abstract class HansSquadHandWeapon
    extends HansSquad {
        private HansSquadHandWeapon() {
        }

        @Override
        public EntityHans spawnHanses(World world, Vec3d pos, int amount, @Nullable Team team, boolean parachute, float yaw, float pitch) {
            EntityHans firstHans = null;
            if (parachute) {
                pos = pos.func_72441_c(0.0, 60.0, 0.0);
            }
            int rsof = parachute ? 8 : 1;
            int row = (int)Math.floor(Math.sqrt(amount));
            int roff = (int)Math.floor((float)row / 2.0f) * rsof;
            for (int i = 0; i < amount; ++i) {
                Vec3d offset = pos.func_72441_c((double)(-roff), 0.0, (double)(-roff)).func_178787_e(new Vec3d(Math.floor((float)i / (float)row) * (double)rsof, 0.0, (double)(i % row * rsof)));
                EntityHans hans = new EntityHans(world);
                hans.func_70107_b(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                if (team != null) {
                    world.func_96441_U().func_151392_a(hans.func_110124_au().toString(), team.func_96661_b());
                }
                if (parachute) {
                    HansUtils.setParachute((Entity)hans);
                }
                this.setItems(hans, i);
                world.func_72838_d((Entity)hans);
                if (i == 0) {
                    firstHans = hans;
                    continue;
                }
                firstHans.func_70108_f((Entity)hans);
            }
            return firstHans;
        }

        public abstract void setItems(EntityHans var1, int var2);
    }

    private static abstract class HansSquad {
        private HansSquad() {
        }

        public abstract EntityHans spawnHanses(World var1, Vec3d var2, int var3, @Nullable Team var4, boolean var5, float var6, float var7);
    }
}

