/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import pl.pabilo8.immersiveintelligence.client.ClientEventHandler;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;

public class MessageParticleGunfire
implements IMessage {
    boolean usesEntity;
    int entityID;
    public Vec3d pos;
    public Vec3d dir;
    public float size;

    public MessageParticleGunfire(Vec3d pos, Vec3d dir, float size) {
        this.usesEntity = false;
        this.pos = pos;
        this.dir = dir;
        this.size = size;
    }

    public MessageParticleGunfire(Entity entity, float size) {
        this.usesEntity = true;
        this.entityID = entity.func_145782_y();
        this.size = size;
    }

    public MessageParticleGunfire() {
    }

    public void fromBytes(ByteBuf buf) {
        this.usesEntity = buf.readBoolean();
        if (this.usesEntity) {
            this.entityID = buf.readInt();
        } else {
            this.pos = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            this.dir = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        this.size = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.usesEntity);
        if (this.usesEntity) {
            buf.writeInt(this.entityID);
        } else {
            buf.writeDouble(this.pos.field_72450_a);
            buf.writeDouble(this.pos.field_72448_b);
            buf.writeDouble(this.pos.field_72449_c);
            buf.writeDouble(this.dir.field_72450_a);
            buf.writeDouble(this.dir.field_72448_b);
            buf.writeDouble(this.dir.field_72449_c);
        }
        buf.writeFloat(this.size);
    }

    public static class HandlerClient
    implements IMessageHandler<MessageParticleGunfire, IMessage> {
        public IMessage onMessage(MessageParticleGunfire message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null) {
                    if (message.usesEntity) {
                        Entity entity = world.func_73045_a(message.entityID);
                        if (entity instanceof EntityLivingBase) {
                            ClientEventHandler.gunshotEntities.put((EntityLivingBase)entity, Float.valueOf(message.size));
                        }
                    } else {
                        ParticleUtils.spawnGunfireFX(message.pos.field_72450_a, message.pos.field_72448_b, message.pos.field_72449_c, message.dir.field_72450_a, message.dir.field_72448_b, message.dir.field_72449_c, message.size);
                    }
                }
            });
            return null;
        }
    }
}

