/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;

public class MessageExplosion
implements IMessage {
    boolean flaming;
    boolean damagesTerrain;
    float radius;
    float strength;
    public double x;
    public double y;
    public double z;

    public MessageExplosion(boolean flaming, boolean damagesTerrain, float radius, float strength, double x, double y, double z) {
        this.flaming = flaming;
        this.damagesTerrain = damagesTerrain;
        this.radius = radius;
        this.strength = strength;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MessageExplosion() {
    }

    public void fromBytes(ByteBuf buf) {
        this.flaming = buf.readBoolean();
        this.damagesTerrain = buf.readBoolean();
        this.radius = buf.readFloat();
        this.strength = buf.readFloat();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.flaming);
        buf.writeBoolean(this.damagesTerrain);
        buf.writeFloat(this.radius);
        buf.writeFloat(this.strength);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static class HandlerClient
    implements IMessageHandler<MessageExplosion, IMessage> {
        public IMessage onMessage(MessageExplosion message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null) {
                    ParticleUtils.spawnExplosionBoomFX(world, message.x, message.y, message.z, message.radius, message.strength, message.flaming, message.damagesTerrain);
                }
            });
            return null;
        }
    }
}

