/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;

public class MessageBeginMachineUpgrade
implements IMessage {
    int entityID;
    BlockPos pos;
    boolean install;
    String machineID;

    public MessageBeginMachineUpgrade(TileEntity tile, String machineID, Entity user, boolean install) {
        this.entityID = user.func_145782_y();
        this.pos = tile.func_174877_v();
        this.install = install;
        this.machineID = machineID;
    }

    public MessageBeginMachineUpgrade() {
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.install = buf.readBoolean();
        this.machineID = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.pos.func_177958_n()).writeInt(this.pos.func_177956_o()).writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.install);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.machineID);
    }

    public static class HandlerClient
    implements IMessageHandler<MessageBeginMachineUpgrade, IMessage> {
        public IMessage onMessage(MessageBeginMachineUpgrade message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null) {
                    TileEntity tile = world.func_175625_s(message.pos);
                    MachineUpgrade upgrade = MachineUpgrade.getUpgradeByID(message.machineID);
                    if (message.install) {
                        if (tile instanceof IUpgradableMachine && ((IUpgradableMachine)tile).getInstallProgress() == 0 && upgrade != null && ((IUpgradableMachine)tile).upgradeMatches(upgrade)) {
                            ((IUpgradableMachine)tile).startUpgrade(upgrade);
                        }
                    } else if (tile instanceof IUpgradableMachine) {
                        ((IUpgradableMachine)tile).removeUpgrade(upgrade);
                    }
                }
            });
            return null;
        }
    }

    public static class HandlerServer
    implements IMessageHandler<MessageBeginMachineUpgrade, IMessage> {
        public IMessage onMessage(MessageBeginMachineUpgrade message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof EntityLivingBase && world.func_175667_e(message.pos)) {
                    TileEntity tile = world.func_175625_s(message.pos);
                    MachineUpgrade upgrade = MachineUpgrade.getUpgradeByID(message.machineID);
                    if (message.install) {
                        IItemHandler capability;
                        if (tile instanceof IUpgradableMachine && ((IUpgradableMachine)tile).getInstallProgress() == 0 && upgrade != null && ((IUpgradableMachine)tile).upgradeMatches(upgrade) && (capability = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                            if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_()) {
                                for (IngredientStack requiredStack : upgrade.getRequiredStacks()) {
                                    int reqSize = requiredStack.inputSize;
                                    for (int slot = 0; slot < capability.getSlots(); ++slot) {
                                        ItemStack inSlot = capability.getStackInSlot(slot);
                                        if (inSlot.func_190926_b() || !requiredStack.matchesItemStackIgnoringSize(inSlot)) continue;
                                        int ii = Math.min(inSlot.func_190916_E(), reqSize);
                                        capability.extractItem(slot, ii, false);
                                        if ((reqSize -= ii) <= 0) break;
                                    }
                                    if (reqSize <= 0) continue;
                                    return;
                                }
                            }
                            ((IUpgradableMachine)tile).startUpgrade(upgrade);
                            IIPacketHandler.INSTANCE.sendToAllTracking((IMessage)message, Utils.targetPointFromTile(tile, 32));
                        }
                    } else if (tile instanceof IUpgradableMachine) {
                        ((IUpgradableMachine)tile).removeUpgrade(upgrade);
                        IIPacketHandler.INSTANCE.sendToAllTracking((IMessage)message, Utils.targetPointFromTile(tile, 32));
                    }
                }
            });
            return null;
        }
    }
}

