/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.tools;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIDrillHead
extends ItemIIBase
implements IDrillHead {
    public DrillHeadPerm[] perms;

    public ItemIIDrillHead() {
        super("drillhead", 1, "tungsten", "iron_diamond_tip", "steel_diamond_tip", "tungsten_diamond_tip");
        this.perms = new DrillHeadPerm[this.subNames.length];
        this.addPerm(0, new DrillHeadPerm("ingotTungsten", 5, 1, 4, 11.0f, 10, 14000, "immersiveintelligence:items/drillhead/display/tungsten"));
        this.addPerm(1, new DrillHeadPerm("ingotIron", 2, 1, 3, 9.0f, 8, 8000, "immersiveintelligence:items/drillhead/display/iron_tip"));
        this.addPerm(2, new DrillHeadPerm("ingotSteel", 3, 1, 4, 10.0f, 9, 12000, "immersiveintelligence:items/drillhead/display/steel_tip"));
        this.addPerm(3, new DrillHeadPerm("ingotTungsten", 5, 1, 5, 11.0f, 12, 18000, "immersiveintelligence:items/drillhead/display/tungsten_tip"));
    }

    private void addPerm(int i, DrillHeadPerm perm) {
        if (i < this.perms.length) {
            this.perms[i] = perm;
        }
    }

    private DrillHeadPerm getHeadPerm(ItemStack stack) {
        if (stack.func_77952_i() >= 0 && stack.func_77952_i() < this.perms.length) {
            return this.perms[stack.func_77952_i()];
        }
        return new DrillHeadPerm("", 0, 0, 0, 0.0f, 0, 0, "immersiveengineering:items/drill_diesel");
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77952_i() < this.getSubNames().length) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drillhead.size", (Object[])new Object[]{this.getHeadPerm((ItemStack)stack).drillSize, this.getHeadPerm((ItemStack)stack).drillDepth}));
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drillhead.level", (Object[])new Object[]{Utils.getHarvestLevelName((int)this.getMiningLevel(stack))}));
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drillhead.speed", (Object[])new Object[]{Utils.formatDouble((double)this.getMiningSpeed(stack), (String)"0.###")}));
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drillhead.damage", (Object[])new Object[]{Utils.formatDouble((double)this.getAttackDamage(stack), (String)"0.###")}));
            int maxDmg = this.getMaximumHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            String status = "" + ((double)quote < 0.1 ? TextFormatting.RED : ((double)quote < 0.3 ? TextFormatting.GOLD : ((double)quote < 0.6 ? TextFormatting.YELLOW : TextFormatting.GREEN)));
            String s = status + (this.getMaximumHeadDamage(stack) - this.getHeadDamage(stack)) + "/" + this.getMaximumHeadDamage(stack);
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.durability", (Object[])new Object[]{s}));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.getSubNames().length; ++i) {
                ItemStack s = new ItemStack((Item)this, 1, i);
                if (!ApiUtils.isExistingOreName((String)this.getHeadPerm((ItemStack)s).repairMaterial)) continue;
                list.add((Object)s);
            }
        }
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return Utils.compareToOreName((ItemStack)material, (String)this.getHeadPerm((ItemStack)stack).repairMaterial);
    }

    public boolean beforeBlockbreak(ItemStack drill, ItemStack head, EntityPlayer player) {
        return false;
    }

    public void afterBlockbreak(ItemStack drill, ItemStack head, EntityPlayer player) {
    }

    public int getMiningLevel(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillLevel;
    }

    public float getMiningSpeed(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillSpeed;
    }

    public float getAttackDamage(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillAttack;
    }

    public int getHeadDamage(ItemStack head) {
        return ItemNBTHelper.getInt((ItemStack)head, (String)"headDamage");
    }

    public int getMaximumHeadDamage(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).maxDamage;
    }

    public void damageHead(ItemStack head, int dmg) {
        ItemNBTHelper.setInt((ItemStack)head, (String)"headDamage", (int)(ItemNBTHelper.getInt((ItemStack)head, (String)"headDamage") + dmg));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getDrillTexture(ItemStack drill, ItemStack head) {
        return this.getHeadPerm((ItemStack)head).sprite;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"headDamage") / (double)this.getMaximumHeadDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"headDamage") > 0;
    }

    public ImmutableList<BlockPos> getExtraBlocksDug(ItemStack head, World world, EntityPlayer player, RayTraceResult mop) {
        EnumFacing side = mop.field_178784_b;
        int diameter = this.getHeadPerm((ItemStack)head).drillSize;
        int depth = this.getHeadPerm((ItemStack)head).drillDepth;
        BlockPos startPos = mop.func_178782_a();
        IBlockState state = world.func_180495_p(startPos);
        Block block = state.func_177230_c();
        float maxHardness = 1.0f;
        if (block != null && !block.isAir(state, (IBlockAccess)world, startPos)) {
            maxHardness = state.func_185903_a(player, world, startPos) * 0.6f;
        }
        if (maxHardness < 0.0f) {
            maxHardness = 0.0f;
        }
        if (diameter % 2 == 0) {
            float hx = (float)mop.field_72307_f.field_72450_a - (float)mop.func_178782_a().func_177958_n();
            float hy = (float)mop.field_72307_f.field_72448_b - (float)mop.func_178782_a().func_177956_o();
            float hz = (float)mop.field_72307_f.field_72449_c - (float)mop.func_178782_a().func_177952_p();
            if (side.func_176740_k() == EnumFacing.Axis.Y && (double)hx < 0.5 || side.func_176740_k() == EnumFacing.Axis.Z && (double)hx < 0.5) {
                startPos = startPos.func_177982_a(-diameter / 2, 0, 0);
            }
            if (side.func_176740_k() != EnumFacing.Axis.Y && (double)hy < 0.5) {
                startPos = startPos.func_177982_a(0, -diameter / 2, 0);
            }
            if (side.func_176740_k() == EnumFacing.Axis.Y && (double)hz < 0.5 || side.func_176740_k() == EnumFacing.Axis.X && (double)hz < 0.5) {
                startPos = startPos.func_177982_a(0, 0, -diameter / 2);
            }
        } else {
            startPos = startPos.func_177982_a(-(side.func_176740_k() == EnumFacing.Axis.X ? 0 : diameter / 2), -(side.func_176740_k() == EnumFacing.Axis.Y ? 0 : diameter / 2), -(side.func_176740_k() == EnumFacing.Axis.Z ? 0 : diameter / 2));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int dd = 0; dd < depth; ++dd) {
            for (int dw = 0; dw < diameter; ++dw) {
                for (int dh = 0; dh < diameter; ++dh) {
                    boolean hardness;
                    BlockPos pos = startPos.func_177982_a(side.func_176740_k() == EnumFacing.Axis.X ? dd : dw, side.func_176740_k() == EnumFacing.Axis.Y ? dd : dh, side.func_176740_k() == EnumFacing.Axis.Y ? dh : (side.func_176740_k() == EnumFacing.Axis.X ? dw : dd));
                    if (pos.equals((Object)mop.func_178782_a())) continue;
                    state = world.func_180495_p(pos);
                    block = state.func_177230_c();
                    float h = state.func_185903_a(player, world, pos);
                    boolean canHarvest = block.canHarvestBlock((IBlockAccess)world, pos, player);
                    boolean drillMat = ((ItemDrill)IEContent.itemDrill).isEffective(state.func_185904_a());
                    boolean bl = hardness = h > maxHardness;
                    if (!canHarvest || !drillMat || !hardness) continue;
                    b.add((Object)pos);
                }
            }
        }
        return b.build();
    }

    public static class DrillHeadPerm {
        public final String texture;
        final String repairMaterial;
        final int drillSize;
        final int drillDepth;
        final int drillLevel;
        final float drillSpeed;
        final float drillAttack;
        final int maxDamage;
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite sprite;

        public DrillHeadPerm(String repairMaterial, int drillSize, int drillDepth, int drillLevel, float drillSpeed, int drillAttack, int maxDamage, String texture) {
            this.repairMaterial = repairMaterial;
            this.drillSize = drillSize;
            this.drillDepth = drillDepth;
            this.drillLevel = drillLevel;
            this.drillSpeed = drillSpeed;
            this.drillAttack = drillAttack;
            this.maxDamage = maxDamage;
            this.texture = texture;
        }
    }
}

