/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.tools;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemPowerpack;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.client.model.armor.ModelAdvancedPowerpackArmor;
import pl.pabilo8.immersiveintelligence.common.IIContent;

public class ItemIIAdvancedPowerPack
extends ItemArmor
implements ISpecialArmor,
EnergyHelper.IIEEnergyItem,
IElectricEquipment,
IEItemInterfaces.IColouredItem {
    public static final String NBT_Colour = "II:AdvancedPowerpackColour";

    public ItemIIAdvancedPowerPack() {
        super(ItemArmor.ArmorMaterial.IRON, 0, EntityEquipmentSlot.CHEST);
        this.func_77656_e(0);
        String name = "advanced_powerpack";
        this.func_77655_b("immersiveintelligence." + name);
        this.func_77637_a(ImmersiveIntelligence.creativeTab);
        IIContent.ITEMS.add((Item)this);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "immersiveintelligence:textures/armor/empty.png";
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return ModelAdvancedPowerpackArmor.getModel(armorSlot, itemStack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
        String hexCol = Integer.toHexString(this.func_82814_b(stack));
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int energy = this.getEnergyStored(itemStack);
        if (energy > 0) {
            int pre = energy;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (!EnergyHelper.isFluxItem((ItemStack)player.func_184582_a(slot)) || player.func_184582_a(slot).func_77973_b() instanceof ItemPowerpack) continue;
                energy -= EnergyHelper.insertFlux((ItemStack)player.func_184582_a(slot), (int)Math.min(energy, 4096), (boolean)false);
            }
            if (pre != energy) {
                EnergyHelper.extractFlux((ItemStack)itemStack, (int)(pre - energy), (boolean)false);
            }
        }
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public int getMaxEnergyStored(ItemStack container) {
        return Config.IIConfig.Tools.advanced_powerpack_capacity;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new ICapabilityProvider(){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == CapabilityEnergy.ENERGY ? this.energyStorage : null);
                }
            };
        }
        return super.initCapabilities(stack, nbt);
    }

    public void onStrike(ItemStack stack, EntityEquipmentSlot eqSlot, EntityLivingBase entity, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        this.receiveEnergy(stack, (int)(Math.floor(dmg.dmg) * (double)Config.IEConfig.Machines.teslacoil_consumption_active), false);
        dmg.dmg = 0.0f;
    }

    public boolean hasCustomItemColours() {
        return true;
    }

    public int getColourForIEItem(ItemStack stack, int renderPass) {
        if (renderPass == 0) {
            return 0xFFFFFF;
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)NBT_Colour)) {
            return 4746388;
        }
        return ItemNBTHelper.getInt((ItemStack)stack, (String)NBT_Colour);
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)NBT_Colour)) {
            return 4746388;
        }
        return ItemNBTHelper.getInt((ItemStack)stack, (String)NBT_Colour);
    }

    public void func_82815_c(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)NBT_Colour)) {
            ItemNBTHelper.remove((ItemStack)stack, (String)NBT_Colour);
        }
    }

    public void func_82813_b(ItemStack stack, int color) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)NBT_Colour, (int)color);
    }
}

