/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.armor;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIArmorUpgrade
extends ItemIIBase
implements IUpgrade {
    public ItemIIArmorUpgrade() {
        super("armor_upgrade", 1, ArmorUpgrades.parse());
        this.setMetaHidden(new int[]{ArmorUpgrades.HELIPACK.ordinal()});
    }

    public static TextFormatting getFormattingForWeapon(String weapon) {
        switch (weapon) {
            case "LIGHT_ENGINEER_HELMET": {
                return TextFormatting.GOLD;
            }
            case "LIGHT_ENGINEER_CHESTPLATE": {
                return TextFormatting.YELLOW;
            }
            case "LIGHT_ENGINEER_LEGGINGS": {
                return TextFormatting.GREEN;
            }
            case "LIGHT_ENGINEER_BOOTS": {
                return TextFormatting.DARK_GREEN;
            }
        }
        return TextFormatting.RESET;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77952_i() < this.getSubNames().length) {
            for (String upgradeType : this.getUpgradeTypes(stack)) {
                list.add(ItemIIArmorUpgrade.getFormattingForWeapon(upgradeType) + I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade.item." + upgradeType.toLowerCase()), (Object[])new Object[0]));
            }
            String[] flavour = ImmersiveEngineering.proxy.splitStringOnWidth(I18n.func_135052_a((String)("desc.immersiveintelligence.toolupgrade." + this.getSubNames()[stack.func_77952_i()]), (Object[])new Object[0]), 200);
            list.addAll(Arrays.asList(flavour));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return ArmorUpgrades.get(stack.func_77960_j()).stackSize;
    }

    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return ArmorUpgrades.get(upgrade.func_77960_j()).toolset;
    }

    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        BiPredicate check = ArmorUpgrades.get(upgrade.func_77960_j()).applyCheck;
        if (check != null && target.func_77973_b() instanceof IUpgradeableTool) {
            return check.test(target, upgrade);
        }
        return true;
    }

    public void applyUpgrades(ItemStack target, ItemStack upgrade, NBTTagCompound modifications) {
        ArmorUpgrades.get(upgrade.func_77960_j()).function.accept(upgrade, modifications);
    }

    public static enum ArmorUpgrades {
        GASMASK((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_HELMET"), 1, (target, upgrade) -> true, (upgrade, modifications) -> modifications.func_74757_a("gasmask", true)),
        INFILTRATOR_GEAR((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_HELMET"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("headgear"), (upgrade, modifications) -> {
            modifications.func_74757_a("infiltrator_gear", true);
            modifications.func_74757_a("headgear", true);
        }),
        TECHNICIAN_GEAR((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_HELMET"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("headgear"), (upgrade, modifications) -> {
            modifications.func_74757_a("technician_gear", true);
            modifications.func_74757_a("headgear", true);
        }),
        ENGINEER_GEAR((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_HELMET"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("headgear"), (upgrade, modifications) -> {
            modifications.func_74757_a("engineer_gear", true);
            modifications.func_74757_a("headgear", true);
        }),
        STEEL_ARMOR_PLATES((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_HELMET", (Object)"LIGHT_ENGINEER_CHESTPLATE", (Object)"LIGHT_ENGINEER_LEGGINGS"), 3, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("composite_plates"), (upgrade, modifications) -> {
            modifications.func_74757_a("steel_plates", true);
            modifications.func_74780_a("toughness_increase", (double)upgrade.func_190916_E() * 0.5);
            modifications.func_74780_a("armor_increase", (double)upgrade.func_190916_E());
        }),
        COMPOSITE_ARMOR_PLATES((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_HELMET", (Object)"LIGHT_ENGINEER_CHESTPLATE", (Object)"LIGHT_ENGINEER_LEGGINGS"), 3, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("steel_plates"), (upgrade, modifications) -> {
            modifications.func_74757_a("composite_plates", true);
            modifications.func_74780_a("toughness_increase", (double)upgrade.func_190916_E());
            modifications.func_74780_a("armor_increase", (double)upgrade.func_190916_E());
        }),
        HAZMAT_COATING((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_HELMET", (Object)"LIGHT_ENGINEER_CHESTPLATE", (Object)"LIGHT_ENGINEER_LEGGINGS", (Object)"LIGHT_ENGINEER_BOOTS"), 1, (target, upgrade) -> true, (upgrade, modifications) -> modifications.func_74757_a("hazmat", true)),
        HEAT_RESISTANT_COATING((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_CHESTPLATE"), 1, (target, upgrade) -> true, (upgrade, modifications) -> modifications.func_74757_a("heat_coating", true)),
        ANTI_STATIC_MESH((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_CHESTPLATE"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("mesh"), (upgrade, modifications) -> {
            modifications.func_74757_a("anti_static_mesh", true);
            modifications.func_74757_a("mesh", true);
        }),
        CAMOUFLAGE_MESH((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_CHESTPLATE"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("mesh"), (upgrade, modifications) -> {
            modifications.func_74757_a("camo_mesh", true);
            modifications.func_74757_a("mesh", true);
        }),
        INFRARED_ABSORBING_MESH((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_CHESTPLATE"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("mesh"), (upgrade, modifications) -> {
            modifications.func_74757_a("ir_mesh", true);
            modifications.func_74757_a("mesh", true);
        }),
        SCUBA_TANK((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_CHESTPLATE"), 1, (target, upgrade) -> true, (upgrade, modifications) -> modifications.func_74757_a("scuba", true)),
        HELIPACK((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_CHESTPLATE"), 1, (target, upgrade) -> true, (upgrade, modifications) -> modifications.func_74757_a("helipack", true)),
        EXOSKELETON((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_LEGGINGS"), 1, (target, upgrade) -> true, (upgrade, modifications) -> modifications.func_74757_a("exoskeleton", true)),
        BOOT_REINFORCEMENT((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_BOOTS"), 1, (target, upgrade) -> true, (upgrade, modifications) -> {
            modifications.func_74757_a("reinforced", true);
            modifications.func_74780_a("toughness_increase", 1.0);
            modifications.func_74780_a("armor_increase", 1.0);
        }),
        SNOW_RACKETS((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_BOOTS"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("flippers"), (upgrade, modifications) -> modifications.func_74757_a("snow_rackets", true)),
        FLIPPERS((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_BOOTS"), 1, (target, upgrade) -> !IIContent.itemLightEngineerHelmet.getUpgrades((ItemStack)target).func_74764_b("snow_rackets"), (upgrade, modifications) -> modifications.func_74757_a("flippers", true)),
        INTERNAL_SPRINGS((ImmutableSet<String>)ImmutableSet.of((Object)"LIGHT_ENGINEER_BOOTS"), 1, (target, upgrade) -> true, (upgrade, modifications) -> modifications.func_74757_a("springs", true));

        private ImmutableSet<String> toolset;
        private int stackSize = 1;
        private BiPredicate<ItemStack, ItemStack> applyCheck;
        private BiConsumer<ItemStack, NBTTagCompound> function;

        private ArmorUpgrades(ImmutableSet<String> toolset, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, 1, function);
        }

        private ArmorUpgrades(ImmutableSet<String> toolset, int stackSize, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, stackSize, null, function);
        }

        private ArmorUpgrades(ImmutableSet<String> toolset, int stackSize, BiPredicate<ItemStack, ItemStack> applyCheck, BiConsumer<ItemStack, NBTTagCompound> function) {
            this.toolset = toolset;
            this.stackSize = stackSize;
            this.applyCheck = applyCheck;
            this.function = function;
        }

        static String[] parse() {
            String[] ret = new String[ArmorUpgrades.values().length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = ArmorUpgrades.values()[i].toString().toLowerCase(Locale.US);
            }
            return ret;
        }

        static ArmorUpgrades get(int meta) {
            if (meta >= 0 && meta < ArmorUpgrades.values().length) {
                return ArmorUpgrades.values()[meta];
            }
            return GASMASK;
        }

        public boolean isValidFor(String weapon) {
            return this.toolset.contains((Object)weapon);
        }
    }
}

