/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.ammunition;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class ItemIIBulletMagazine
extends ItemIIBase
implements IEItemInterfaces.ITextureOverride {
    public ItemIIBulletMagazine() {
        super("bullet_magazine", 1, "machinegun", "submachinegun", "automatic_revolver", "submachinegun_drum", "assault_rifle", "autocannon", "cpds_drum");
        this.setMetaHidden(new int[]{2});
    }

    public static void makeDefault(ItemStack stack) {
        ItemStack bullet;
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullets")) {
            return;
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour0")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour0", (int)-1);
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour1")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour1", (int)-1);
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour2")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour2", (int)-1);
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour3")) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour3", (int)-1);
        }
        int bc = ItemIIBulletMagazine.getBulletCapactity(stack);
        NonNullList<ItemStack> cartridge = ItemIIBulletMagazine.readInventory(ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("bullets"), bc);
        ArrayList<ItemStack> already = new ArrayList<ItemStack>();
        int i = 0;
        Iterator iterator = cartridge.iterator();
        while (iterator.hasNext() && !(bullet = (ItemStack)iterator.next()).func_190926_b() && i <= 3) {
            boolean contains = false;
            for (ItemStack s : already) {
                if (!ItemStack.func_77989_b((ItemStack)bullet, (ItemStack)s)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            already.add(bullet);
            ItemNBTHelper.setInt((ItemStack)stack, (String)("colour" + i), (int)((IBullet)bullet.func_77973_b()).getPaintColor(bullet));
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)("bullet" + i), (boolean)true);
            ++i;
        }
        if (already.size() < 1) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"bullet0");
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour0", (int)-1);
        }
        if (already.size() < 2) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"bullet1");
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour1", (int)-1);
        }
        if (already.size() < 3) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"bullet2");
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour2", (int)-1);
        }
        if (already.size() < 4) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"bullet3");
            ItemNBTHelper.setInt((ItemStack)stack, (String)"colour3", (int)-1);
        }
    }

    public static NonNullList<ItemStack> takeAll(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullets")) {
            int bc = ItemIIBulletMagazine.getBulletCapactity(stack);
            NonNullList<ItemStack> cartridge = ItemIIBulletMagazine.readInventory(ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("bullets"), bc);
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("bullets", (NBTBase)ItemIIBulletMagazine.writeInventory((NonNullList<ItemStack>)NonNullList.func_191197_a((int)ItemIIBulletMagazine.getBulletCapactity(stack), (Object)ItemStack.field_190927_a)));
            return cartridge;
        }
        ItemIIBulletMagazine.makeDefault(stack);
        return NonNullList.func_191196_a();
    }

    public static ItemStack takeBullet(ItemStack stack, boolean doTake) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullets")) {
            int bc = ItemIIBulletMagazine.getBulletCapactity(stack);
            NonNullList<ItemStack> cartridge = ItemIIBulletMagazine.readInventory(ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("bullets"), bc);
            ItemStack ammo = ((ItemStack)cartridge.get(0)).func_77946_l();
            if (!doTake) {
                return ammo;
            }
            cartridge.set(0, (Object)ItemStack.field_190927_a);
            for (int i = 1; i < bc; ++i) {
                if (!((ItemStack)cartridge.get(i - 1)).func_190926_b()) continue;
                cartridge.set(i - 1, cartridge.get(i));
                cartridge.set(i, (Object)ItemStack.field_190927_a);
            }
            NBTTagCompound list = ItemIIBulletMagazine.writeInventory(cartridge);
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("bullets", (NBTBase)list);
            return ammo;
        }
        ItemIIBulletMagazine.makeDefault(stack);
        return ItemStack.field_190927_a;
    }

    public static boolean hasNoBullets(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return true;
        }
        int bc = ItemIIBulletMagazine.getBulletCapactity(stack);
        NonNullList<ItemStack> cartridge = ItemIIBulletMagazine.readInventory(ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("bullets"), bc);
        return ((ItemStack)cartridge.get(0)).func_190926_b();
    }

    public static int getBulletCapactity(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 48;
            }
            case 1: {
                return 24;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 64;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 128;
            }
        }
        return 0;
    }

    public static IBullet getMatchingType(ItemStack stack) {
        switch (stack.func_77960_j()) {
            default: {
                return IIContent.itemAmmoMachinegun;
            }
            case 1: 
            case 3: {
                return IIContent.itemAmmoSubmachinegun;
            }
            case 2: {
                return IIContent.itemAmmoRevolver;
            }
            case 4: {
                return IIContent.itemAmmoAssaultRifle;
            }
            case 5: 
        }
        return IIContent.itemAmmoAutocannon;
    }

    public static ItemStack getMagazine(String type, ItemStack ... bullets) {
        ItemStack stack = new ItemStack((Item)IIContent.itemBulletMagazine, 1, IIContent.itemBulletMagazine.getMetaBySubname(type));
        NonNullList l = NonNullList.func_191197_a((int)ItemIIBulletMagazine.getBulletCapactity(stack), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < l.size(); ++i) {
            int t = i % bullets.length;
            l.set(i, (Object)bullets[t]);
        }
        NBTTagCompound list = ItemIIBulletMagazine.writeInventory((NonNullList<ItemStack>)l);
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("bullets", (NBTBase)list);
        ItemIIBulletMagazine.makeDefault(stack);
        return stack;
    }

    public String getModelCacheKey(ItemStack stack) {
        return this.subNames[stack.func_77960_j()] + "_" + this.checkBullets(stack) + "_" + this.checkColors(stack);
    }

    public int checkBullets(ItemStack stack) {
        ItemIIBulletMagazine.makeDefault(stack);
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return 0;
        }
        int num = ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet0") ? 1 : 0;
        num += ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet1") ? 1 : 0;
        num += ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet2") ? 1 : 0;
        return num += ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet3") ? 1 : 0;
    }

    public String checkColors(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return "";
        }
        StringBuilder ss = new StringBuilder();
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour0") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour0") != -1) {
            ss.append("0");
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour1") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour1") != -1) {
            ss.append("1");
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour2") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour2") != -1) {
            ss.append("2");
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour3") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour3") != -1) {
            ss.append("3");
        }
        return ss.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> l = new ArrayList<ResourceLocation>();
        String name = this.getSubNames()[stack.func_77960_j()];
        l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/main"));
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return l;
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet0")) {
            if (this.getMetadata(stack) == 1 || this.getMetadata(stack) == 4) {
                l.remove(0);
                l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/main_disp"));
            }
            l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet0"));
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour0") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour0") != -1) {
                l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint0"));
            } else {
                l.add(new ResourceLocation("immersiveintelligence:blocks/empty"));
            }
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet1")) {
                l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet1"));
                if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour1") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour1") != -1) {
                    l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint1"));
                } else {
                    l.add(new ResourceLocation("immersiveintelligence:blocks/empty"));
                }
                if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet2")) {
                    l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet2"));
                    if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour2") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour2") != -1) {
                        l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint2"));
                    } else {
                        l.add(new ResourceLocation("immersiveintelligence:blocks/empty"));
                    }
                    if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"bullet3")) {
                        l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/bullet3"));
                        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"colour3") && ItemNBTHelper.getInt((ItemStack)stack, (String)"colour3") != -1) {
                            l.add(new ResourceLocation("immersiveintelligence:items/bullets/magazines/" + name + "/paint3"));
                        } else {
                            l.add(new ResourceLocation("immersiveintelligence:blocks/empty"));
                        }
                    }
                }
            }
        }
        return l;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomItemColours() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch (pass) {
            case 2: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour0");
            }
            case 4: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour1");
            }
            case 6: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour2");
            }
            case 8: {
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"colour3");
            }
        }
        return -1;
    }

    public static int getRemainingBulletCount(ItemStack stack) {
        NonNullList<ItemStack> cartridge = ItemIIBulletMagazine.readInventory(ItemNBTHelper.getTag((ItemStack)stack).func_74775_l("bullets"), ItemIIBulletMagazine.getBulletCapactity(stack));
        int count = 0;
        for (ItemStack s : cartridge) {
            if (s.func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public static NonNullList<ItemStack> readInventory(NBTTagCompound nbt, int size) {
        NonNullList inv = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        ArrayList<ItemStack> dictionary = new ArrayList<ItemStack>();
        NBTTagList listDict = nbt.func_150295_c("dictionary", 10);
        NBTTagList listInventory = nbt.func_150295_c("inventory", 3);
        for (NBTBase tag : listDict) {
            if (!(tag instanceof NBTTagCompound)) continue;
            dictionary.add(new ItemStack((NBTTagCompound)tag));
        }
        if (dictionary.size() == 0) {
            return inv;
        }
        int max = listInventory.func_74745_c();
        for (int i = 0; i < Math.min(max, size); ++i) {
            int id = listInventory.func_186858_c(i);
            if (id < 0 || id >= dictionary.size()) continue;
            inv.set(i, (Object)((ItemStack)dictionary.get(id)).func_77946_l());
        }
        return inv;
    }

    public static NBTTagCompound writeInventory(NonNullList<ItemStack> inv) {
        ArrayList<ItemStack> dictionary = new ArrayList<ItemStack>();
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < inv.size(); ++i) {
            int id;
            ItemStack stack2 = (ItemStack)inv.get(i);
            if (stack2.func_190926_b()) continue;
            Optional<ItemStack> found = dictionary.stream().filter(stack1 -> ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack1, (ItemStack)stack2)).findFirst();
            if (!found.isPresent()) {
                dictionary.add(stack2);
                id = dictionary.size() - 1;
            } else {
                id = dictionary.indexOf(found.get());
            }
            invList.func_74742_a((NBTBase)new NBTTagInt(id));
        }
        NBTTagList dictList = new NBTTagList();
        dictionary.forEach(stack -> dictList.func_74742_a((NBTBase)stack.serializeNBT()));
        NBTTagCompound output = new NBTTagCompound();
        output.func_74782_a("dictionary", (NBTBase)dictList);
        output.func_74782_a("inventory", (NBTBase)invList);
        return output;
    }
}

