/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.ammunition;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCore;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public abstract class ItemIIBulletBase
extends ItemIIBase
implements IBullet,
IEItemInterfaces.ITextureOverride {
    public static final int BULLET = 0;
    public static final int CORE = 1;
    public final String NAME;

    public ItemIIBulletBase(String name, int stacksize) {
        super("bullet_" + name.toLowerCase(), stacksize, "bullet", "core");
        this.setMetaHidden(new int[]{0, 1});
        this.NAME = name;
    }

    public void makeDefault(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)"core_brass");
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)this.getAllowedCoreTypes()[0].func_176610_l());
        }
        if (stack.func_77960_j() == 0 && !ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
            ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)this.getAllowedFuseTypes()[0].func_176610_l());
        }
    }

    @Override
    public IBulletCore getCore(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
            this.makeDefault(stack);
        }
        return BulletRegistry.INSTANCE.getCore(ItemNBTHelper.getString((ItemStack)stack, (String)"core"));
    }

    @Override
    public BulletRegistry.EnumCoreTypes getCoreType(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
            this.makeDefault(stack);
        }
        return BulletRegistry.EnumCoreTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"core_type"));
    }

    @Override
    public int getPaintColor(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"paint_color")) {
            return ItemNBTHelper.getInt((ItemStack)stack, (String)"paint_color");
        }
        return -1;
    }

    @Override
    public void registerSprites(TextureMap map) {
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/base"));
        for (BulletRegistry.EnumCoreTypes coreType : this.getAllowedCoreTypes()) {
            ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/" + coreType.func_176610_l()));
        }
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/paint"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/core"));
    }

    @Override
    public IBulletComponent[] getComponents(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"components")) {
            ArrayList<IBulletComponent> arrayList = new ArrayList<IBulletComponent>();
            NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("components");
            for (int i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(BulletRegistry.INSTANCE.getComponent(components.func_150307_f(i)));
            }
            return arrayList.toArray(new IBulletComponent[0]);
        }
        return new IBulletComponent[0];
    }

    @Override
    public NBTTagCompound[] getComponentsNBT(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"component_nbt")) {
            ArrayList<NBTTagCompound> arrayList = new ArrayList<NBTTagCompound>();
            NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("component_nbt");
            for (int i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(components.func_150305_b(i));
            }
            return arrayList.toArray(new NBTTagCompound[0]);
        }
        return new NBTTagCompound[0];
    }

    @Override
    public void addComponents(ItemStack stack, IBulletComponent component, NBTTagCompound componentNBT) {
        NBTTagList comps = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("components", 8);
        NBTTagList nbts = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("component_nbt", 10);
        comps.func_74742_a((NBTBase)new NBTTagString(component.getName()));
        nbts.func_74742_a((NBTBase)componentNBT.func_74737_b());
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)comps);
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbts);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.makeDefault(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean b;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        boolean bl = b = stack.func_77960_j() == 0;
        if (b) {
            tooltip.add(this.getFormattedBulletTypeName(stack));
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.core", (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_core_type." + this.getCoreType(stack).func_176610_l()), (Object[])new Object[0]), I18n.func_135052_a((String)("item.immersiveintelligence.bullet.component." + this.getCore(stack).getName() + ".name"), (Object[])new Object[0])}));
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.fuse", (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_fuse." + this.getFuseType(stack).func_176610_l()), (Object[])new Object[0])}));
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.mass", (Object[])new Object[]{Float.valueOf(this.getMass(stack))}));
        }
        tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.caliber", (Object[])new Object[]{Utils.formatDouble((double)this.getCaliber(), (String)"#.#")}));
    }

    private String getFormattedBulletTypeName(ItemStack stack) {
        HashSet<BulletRegistry.EnumComponentRole> collect = new HashSet<BulletRegistry.EnumComponentRole>();
        if (this.getCoreType(stack).getRole() != null) {
            collect.add(this.getCoreType(stack).getRole());
        }
        collect.addAll(Arrays.stream(this.getComponents(stack)).map(IBulletComponent::getRole).collect(Collectors.toSet()));
        StringBuilder builder = new StringBuilder();
        for (BulletRegistry.EnumComponentRole enumComponentRole : collect) {
            if (enumComponentRole == BulletRegistry.EnumComponentRole.GENERAL_PURPOSE) continue;
            builder.append(I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + enumComponentRole.func_176610_l()), (Object[])new Object[0]));
            builder.append(" - ");
        }
        if (builder.toString().isEmpty()) {
            builder.append(I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + BulletRegistry.EnumComponentRole.GENERAL_PURPOSE.func_176610_l()), (Object[])new Object[0]));
            builder.append(" - ");
        }
        String s = builder.toString();
        return I18n.func_135052_a((String)s.substring(0, Math.max(s.length() - 3, 0)), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return I18n.func_135052_a((String)("item.immersiveintelligence." + this.NAME + ".bullet.name"), (Object[])new Object[0]);
            }
            case 1: {
                return I18n.func_135052_a((String)("item.immersiveintelligence." + this.NAME + ".core.name"), (Object[])new Object[0]);
            }
        }
        return "DO NOT USE, MAY CRASH";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomItemColours() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch (stack.func_77960_j()) {
            case 0: {
                switch (pass) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return this.getCore(stack).getColour();
                    }
                    case 2: {
                        return this.getPaintColor(stack);
                    }
                }
            }
            case 1: {
                return this.getCore(stack).getColour();
            }
        }
        return -1;
    }

    @Override
    public ItemStack getBulletWithParams(String core, String coreType, String ... components) {
        ItemStack stack = new ItemStack((Item)this, 1, 0);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
        NBTTagList tagList = new NBTTagList();
        Arrays.stream(components).map(NBTTagString::new).forEachOrdered(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
        if (tagList.func_74745_c() > 0) {
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)tagList);
            NBTTagList nbt = new NBTTagList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                nbt.func_74742_a((NBTBase)new NBTTagCompound());
            }
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbt);
        }
        return stack;
    }

    @Override
    public ItemStack getBulletCore(String core, String coreType) {
        ItemStack stack = new ItemStack((Item)this, 1, 1);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
        return stack;
    }

    @Override
    public boolean isBulletCore(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    @Override
    public ItemStack setPaintColour(ItemStack stack, int color) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"paint_color", (int)color);
        return stack;
    }

    @Override
    public ItemStack setComponentNBT(ItemStack stack, NBTTagCompound ... tagCompounds) {
        NBTTagList component_nbt = new NBTTagList();
        for (NBTTagCompound tagCompound : tagCompounds) {
            component_nbt.func_74742_a((NBTBase)tagCompound);
        }
        assert (stack.func_77978_p() != null);
        stack.func_77978_p().func_74782_a("component_nbt", (NBTBase)component_nbt);
        return stack;
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public void setFuseType(ItemStack stack, BulletRegistry.EnumFuseTypes type) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)type.func_176610_l());
    }

    @Override
    public BulletRegistry.EnumFuseTypes getFuseType(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
            this.makeDefault(stack);
        }
        return BulletRegistry.EnumFuseTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"fuse"));
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    public String getModelCacheKey(ItemStack stack) {
        return String.format("%s%s_%s%s", stack.func_77960_j() == 1 ? "core" : "bullet", this.NAME, this.getPaintColor(stack) == -1 ? "no_" : "paint_", this.getCoreType(stack).func_176610_l());
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> a = new ArrayList<ResourceLocation>();
        if (stack.func_77960_j() == 0) {
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/base"));
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
            if (this.getPaintColor(stack) != -1) {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
            }
        } else if (stack.func_77960_j() == 1) {
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
        }
        return a;
    }
}

