/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.ammunition;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCore;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.bullet.ModelBullet1bCal;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;

public class ItemIIAmmoRevolver
extends ItemBullet
implements IBullet,
BulletHandler.IBullet {
    public static final int UNUSED = 0;
    public static final int CORE = 1;
    public static final int BULLET = 2;
    public final String NAME = "revolver_1bCal";

    public ItemIIAmmoRevolver() {
        this.itemName = "bullet_" + "revolver_1bCal".toLowerCase();
        this.subNames = new String[]{"casing", "core", "bullet"};
        this.func_77627_a(true);
        this.setMetaHidden(new int[]{0, 1, 2});
        this.fixupItem();
        BulletHandler.emptyCasing = new ItemStack((Item)IEContent.itemBullet, 1, 0);
        BulletHandler.emptyShell = new ItemStack((Item)IEContent.itemBullet, 1, 1);
        BulletHandler.basicCartridge = new ItemStack((Item)IEContent.itemBullet, 1, 2);
    }

    public void fixupItem() {
        Item rItem = (Item)IEContent.registeredIEItems.remove(IEContent.registeredIEItems.size() - 1);
        if (rItem != this) {
            throw new IllegalStateException("fixupItem was not called at the appropriate time");
        }
        this.func_77655_b("immersiveintelligence." + this.itemName);
        this.func_77637_a(ImmersiveIntelligence.creativeTab);
        IIContent.ITEMS.add((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public void makeDefault(ItemStack stack) {
        if (stack.func_77960_j() != 0) {
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
                ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)"core_brass");
            }
            if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
                ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)this.getAllowedCoreTypes()[0].func_176610_l());
            }
            if (stack.func_77960_j() == 2 && !ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
                ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)this.getAllowedFuseTypes()[0].func_176610_l());
            }
        }
    }

    @Override
    public IBulletCore getCore(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return null;
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core")) {
            this.makeDefault(stack);
        }
        return BulletRegistry.INSTANCE.getCore(ItemNBTHelper.getString((ItemStack)stack, (String)"core"));
    }

    @Override
    public BulletRegistry.EnumCoreTypes getCoreType(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return null;
        }
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"core_type")) {
            this.makeDefault(stack);
        }
        return BulletRegistry.EnumCoreTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"core_type"));
    }

    @Override
    public int getPaintColor(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"paint_color")) {
            return ItemNBTHelper.getInt((ItemStack)stack, (String)"paint_color");
        }
        return -1;
    }

    @Override
    public void registerSprites(TextureMap map) {
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/base"));
        for (BulletRegistry.EnumCoreTypes coreType : this.getAllowedCoreTypes()) {
            ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/" + coreType.func_176610_l()));
        }
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/paint"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/core"));
    }

    @Override
    public IBulletComponent[] getComponents(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"components")) {
            ArrayList<IBulletComponent> arrayList = new ArrayList<IBulletComponent>();
            NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("components");
            for (int i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(BulletRegistry.INSTANCE.getComponent(components.func_150307_f(i)));
            }
            return arrayList.toArray(new IBulletComponent[0]);
        }
        return new IBulletComponent[0];
    }

    @Override
    public void addComponents(ItemStack stack, IBulletComponent component, NBTTagCompound componentNBT) {
        NBTTagList comps = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("components", 8);
        NBTTagList nbts = ItemNBTHelper.getTag((ItemStack)stack).func_150295_c("component_nbt", 10);
        comps.func_74742_a((NBTBase)new NBTTagString(component.getName()));
        nbts.func_74742_a((NBTBase)componentNBT.func_74737_b());
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)comps);
        ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbts);
    }

    @Override
    public NBTTagCompound[] getComponentsNBT(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"component_nbt")) {
            ArrayList<NBTTagCompound> arrayList = new ArrayList<NBTTagCompound>();
            NBTTagList components = (NBTTagList)ItemNBTHelper.getTag((ItemStack)stack).func_74781_a("component_nbt");
            for (int i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(components.func_150305_b(i));
            }
            return arrayList.toArray(new NBTTagCompound[0]);
        }
        return new NBTTagCompound[0];
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean b;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        boolean bl = b = stack.func_77960_j() == 2;
        if (b) {
            tooltip.add(this.getFormattedBulletTypeName(stack));
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.core", (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_core_type." + this.getCoreType(stack).func_176610_l()), (Object[])new Object[0]), I18n.func_135052_a((String)("item.immersiveintelligence.bullet.component." + this.getCore(stack).getName() + ".name"), (Object[])new Object[0])}));
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.mass", (Object[])new Object[]{Float.valueOf(this.getMass(stack))}));
        }
        tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.caliber", (Object[])new Object[]{Utils.formatDouble((double)this.getCaliber(), (String)"#.#")}));
    }

    private String getFormattedBulletTypeName(ItemStack stack) {
        HashSet<BulletRegistry.EnumComponentRole> collect = new HashSet<BulletRegistry.EnumComponentRole>();
        if (this.getCoreType(stack).getRole() != null) {
            collect.add(this.getCoreType(stack).getRole());
        }
        collect.addAll(Arrays.stream(this.getComponents(stack)).map(IBulletComponent::getRole).collect(Collectors.toSet()));
        StringBuilder builder = new StringBuilder();
        for (BulletRegistry.EnumComponentRole enumComponentRole : collect) {
            if (enumComponentRole == BulletRegistry.EnumComponentRole.GENERAL_PURPOSE) continue;
            builder.append(I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + enumComponentRole.func_176610_l()), (Object[])new Object[0]));
            builder.append(" - ");
        }
        if (builder.toString().isEmpty()) {
            builder.append(I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + BulletRegistry.EnumComponentRole.GENERAL_PURPOSE.func_176610_l()), (Object[])new Object[0]));
        }
        String s = builder.toString();
        return I18n.func_135052_a((String)s.substring(0, Math.max(s.length() - 3, 0)), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 2: {
                return I18n.func_135052_a((String)"item.immersiveintelligence.revolver_1bCal.bullet.name", (Object[])new Object[0]);
            }
            case 0: {
                return I18n.func_135052_a((String)"item.immersiveintelligence.revolver_1bCal.casing.name", (Object[])new Object[0]);
            }
            case 1: {
                return I18n.func_135052_a((String)"item.immersiveintelligence.revolver_1bCal.core.name", (Object[])new Object[0]);
            }
        }
        return "DO NOT USE, MAY CRASH";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomItemColours() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch (stack.func_77960_j()) {
            case 2: {
                switch (pass) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return this.getCore(stack).getColour();
                    }
                    case 2: {
                        return this.getPaintColor(stack);
                    }
                }
            }
            case 1: {
                return this.getCore(stack).getColour();
            }
        }
        return -1;
    }

    @Override
    public ItemStack getBulletWithParams(String core, String coreType, String ... components) {
        ItemStack stack = new ItemStack((Item)this, 1, 2);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
        ItemNBTHelper.setString((ItemStack)stack, (String)"bullet", (String)"ii_bullet");
        NBTTagList tagList = new NBTTagList();
        Arrays.stream(components).map(NBTTagString::new).forEachOrdered(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
        if (tagList.func_74745_c() > 0) {
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("components", (NBTBase)tagList);
            NBTTagList nbt = new NBTTagList();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                nbt.func_74742_a((NBTBase)new NBTTagCompound());
            }
            ItemNBTHelper.getTag((ItemStack)stack).func_74782_a("component_nbt", (NBTBase)nbt);
        }
        return stack;
    }

    @Override
    public ItemStack getBulletCore(String core, String coreType) {
        ItemStack stack = new ItemStack((Item)this, 1, 1);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core", (String)core);
        ItemNBTHelper.setString((ItemStack)stack, (String)"core_type", (String)coreType);
        return stack;
    }

    @Override
    public boolean isBulletCore(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    @Override
    public BulletRegistry.EnumFuseTypes[] getAllowedFuseTypes() {
        return new BulletRegistry.EnumFuseTypes[]{BulletRegistry.EnumFuseTypes.CONTACT};
    }

    @Override
    public void setFuseType(ItemStack stack, BulletRegistry.EnumFuseTypes type) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"fuse", (String)type.func_176610_l());
    }

    @Override
    public BulletRegistry.EnumFuseTypes getFuseType(ItemStack stack) {
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"fuse")) {
            this.makeDefault(stack);
        }
        return BulletRegistry.EnumFuseTypes.v(ItemNBTHelper.getString((ItemStack)stack, (String)"fuse"));
    }

    @Override
    public ItemStack setPaintColour(ItemStack stack, int color) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"paint_color", (int)color);
        return stack;
    }

    @Override
    public ItemStack setComponentNBT(ItemStack stack, NBTTagCompound ... tagCompounds) {
        NBTTagList component_nbt = new NBTTagList();
        for (NBTTagCompound tagCompound : tagCompounds) {
            component_nbt.func_74742_a((NBTBase)tagCompound);
        }
        assert (stack.func_77978_p() != null);
        stack.func_77978_p().func_74782_a("component_nbt", (NBTBase)component_nbt);
        return stack;
    }

    @Override
    public ItemStack getCasingStack(int amount) {
        return this.getCasing(null);
    }

    @Override
    public String getName() {
        return "revolver_1bCal";
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    public String getModelCacheKey(ItemStack stack) {
        return String.format("%s%s_%s%s", stack.func_77960_j() == 1 ? "core" : "bullet", "revolver_1bCal", this.getPaintColor(stack) == -1 ? "no_" : "paint_", this.getCoreType(stack).func_176610_l());
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> a = new ArrayList<ResourceLocation>();
        if (stack.func_77960_j() == 2) {
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + "revolver_1bCal".toLowerCase() + "/base"));
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + "revolver_1bCal".toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
            if (this.getPaintColor(stack) != -1) {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + "revolver_1bCal".toLowerCase() + "/paint"));
            }
        } else if (stack.func_77960_j() == 1) {
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + "revolver_1bCal".toLowerCase() + "/core"));
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + "revolver_1bCal".toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
        }
        return a;
    }

    @Override
    public float getComponentMultiplier() {
        return 0.125f;
    }

    @Override
    public int getGunpowderNeeded() {
        return 25;
    }

    @Override
    public int getCoreMaterialNeeded() {
        return 6;
    }

    @Override
    public float getInitialMass() {
        return 0.0625f;
    }

    @Override
    public float getDefaultVelocity() {
        return 6.0f;
    }

    @Override
    public float getCaliber() {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Class<? extends IBulletModel> getModel() {
        return ModelBullet1bCal.class;
    }

    @Override
    public float getDamage() {
        return 8.0f;
    }

    @Override
    public BulletRegistry.EnumCoreTypes[] getAllowedCoreTypes() {
        return new BulletRegistry.EnumCoreTypes[]{BulletRegistry.EnumCoreTypes.SOFTPOINT, BulletRegistry.EnumCoreTypes.PIERCING, BulletRegistry.EnumCoreTypes.CANISTER};
    }

    public boolean isProperCartridge() {
        return false;
    }

    public boolean isValidForTurret() {
        return true;
    }

    public Entity getProjectile(@Nullable EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean charged) {
        Vec3d vec = new Vec3d(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y).func_72432_b();
        Vec3d vv = projectile.func_174791_d();
        EntityBullet e = BulletHelper.createBullet(projectile.field_70170_p, cartridge, vv, vec);
        if (shooter != null) {
            e.setShooters((Entity)shooter, new Entity[0]);
        }
        return e;
    }

    public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
    }

    public ItemStack getCasing(ItemStack stack) {
        return BulletHandler.emptyCasing.func_77946_l();
    }

    public ResourceLocation[] getTextures() {
        return new ResourceLocation[0];
    }

    public int getColour(ItemStack stack, int layer) {
        return 0;
    }
}

