/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.items.ammunition;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleExplosion;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.client.model.bullet.ModelBulletMortar6bCal;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletBase;

public class ItemIIAmmoMortar
extends ItemIIBulletBase {
    public ItemIIAmmoMortar() {
        super("mortar_6bCal", 1);
    }

    @Override
    public float getComponentMultiplier() {
        return 0.65f;
    }

    @Override
    public int getGunpowderNeeded() {
        return 350;
    }

    @Override
    public int getCoreMaterialNeeded() {
        return 3;
    }

    @Override
    public float getInitialMass() {
        return 1.125f;
    }

    @Override
    public float getDefaultVelocity() {
        return 8.0f;
    }

    @Override
    public float getCaliber() {
        return 6.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Class<? extends IBulletModel> getModel() {
        return ModelBulletMortar6bCal.class;
    }

    @Override
    public float getDamage() {
        return 30.0f;
    }

    @Override
    public ItemStack getCasingStack(int amount) {
        return Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "mortar_6bCal", amount);
    }

    @Override
    public BulletRegistry.EnumCoreTypes[] getAllowedCoreTypes() {
        return new BulletRegistry.EnumCoreTypes[]{BulletRegistry.EnumCoreTypes.PIERCING, BulletRegistry.EnumCoreTypes.SHAPED, BulletRegistry.EnumCoreTypes.CANISTER};
    }

    @Override
    public BulletRegistry.EnumFuseTypes[] getAllowedFuseTypes() {
        return new BulletRegistry.EnumFuseTypes[]{BulletRegistry.EnumFuseTypes.CONTACT, BulletRegistry.EnumFuseTypes.TIMED, BulletRegistry.EnumFuseTypes.PROXIMITY};
    }

    @Override
    public float getSupressionRadius() {
        return 3.0f;
    }

    @Override
    public int getSuppressionPower() {
        return 20;
    }

    @Override
    public boolean shouldLoadChunks() {
        return true;
    }

    @Override
    public void registerSprites(TextureMap map) {
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
        ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
        for (BulletRegistry.EnumCoreTypes coreType : this.getAllowedCoreTypes()) {
            ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/" + coreType.func_176610_l()));
            ApiUtils.getRegisterSprite((TextureMap)map, (String)("immersiveintelligence:items/bullets/ammo/" + this.getName().toLowerCase() + "/base_" + coreType.func_176610_l()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColourForIEItem(ItemStack stack, int pass) {
        switch (stack.func_77960_j()) {
            case 0: {
                switch (pass) {
                    case 0: {
                        return this.getCore(stack).getColour();
                    }
                    case 1: {
                        return -1;
                    }
                    case 2: {
                        return this.getPaintColor(stack);
                    }
                }
            }
            case 1: {
                return this.getCore(stack).getColour();
            }
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        ArrayList<ResourceLocation> a = new ArrayList<ResourceLocation>();
        if (stack.func_77960_j() == 0) {
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/base_" + this.getCoreType(stack).func_176610_l()));
            if (this.getPaintColor(stack) != -1) {
                a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/paint"));
            }
        } else if (stack.func_77960_j() == 1) {
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/core"));
            a.add(new ResourceLocation("immersiveintelligence:items/bullets/ammo/" + this.NAME.toLowerCase() + "/" + this.getCoreType(stack).func_176610_l()));
        }
        return a;
    }

    @SideOnly(value=Side.CLIENT)
    public void doPuff(EntityBullet bullet) {
        for (int i = 0; i < 20; ++i) {
            Vec3d v = bullet.getBaseMotion().func_178789_a(-90.0f).func_178785_b((float)i / 20.0f * 360.0f);
            ParticleExplosion particle = new ParticleExplosion((World)ClientUtils.mc().field_71441_e, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, v.field_72450_a * 0.125, v.field_72448_b * 0.0125, v.field_72449_c * 0.125, 3.25f);
            ParticleUtils.particleRenderer.addEffect(particle);
        }
    }
}

