/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class HansWalkNodeProcessor
extends WalkNodeProcessor {
    private boolean canBreakBlocks = false;
    private boolean breakableFlag = false;

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        this.breakableFlag = false;
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public int func_186320_a(@Nonnull PathPoint[] pathOptions, PathPoint currentPoint, @Nonnull PathPoint targetPoint, float maxDistance) {
        AxisAlignedBB aabb1;
        double d1;
        boolean flag3;
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            j = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos blockpos = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double d0 = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos).field_72337_e);
        PathPoint pathpoint = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
        PathPoint pathpoint1 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.WEST);
        PathPoint pathpoint2 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.EAST);
        PathPoint pathpoint3 = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
        PathPoint ladderUp = this.func_176159_a(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        PathPoint ladderDown = this.func_176159_a(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c);
        if (pathpoint != null && !pathpoint.field_75842_i && pathpoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.field_75842_i && pathpoint1.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.field_75842_i && pathpoint2.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint3;
        }
        IBlockState ladderCheck = this.field_176169_a.func_180495_p(new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c));
        if (!ladderUp.field_75842_i && ladderUp.func_75829_a(targetPoint) < maxDistance && ladderCheck.func_177230_c().isLadder(ladderCheck, this.field_176169_a, new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c), (EntityLivingBase)this.field_186326_b)) {
            pathOptions[i++] = ladderUp;
        }
        IBlockState ladderCheckDown = this.field_176169_a.func_180495_p(new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c));
        if (!ladderDown.field_75842_i && ladderDown.func_75829_a(targetPoint) < maxDistance && ladderCheckDown.func_177230_c().isLadder(ladderCheckDown, this.field_176169_a, new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c), (EntityLivingBase)this.field_186326_b)) {
            pathOptions[i++] = ladderDown;
        }
        boolean flag = pathpoint3 == null || pathpoint3.field_186287_m == PathNodeType.OPEN || pathpoint3.field_186286_l != 0.0f;
        boolean flag1 = pathpoint == null || pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186286_l != 0.0f;
        boolean flag2 = pathpoint2 == null || pathpoint2.field_186287_m == PathNodeType.OPEN || pathpoint2.field_186286_l != 0.0f;
        boolean bl = flag3 = pathpoint1 == null || pathpoint1.field_186287_m == PathNodeType.OPEN || pathpoint1.field_186286_l != 0.0f;
        if (flag && flag3) {
            PathPoint pathpoint4 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a - 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c - 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a - 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c - 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && pathpoint4 != null && !pathpoint4.field_75842_i && pathpoint4.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[i++] = pathpoint4;
            }
        }
        if (flag && flag2) {
            PathPoint pathpoint5 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a + 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c - 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a + 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c - 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && pathpoint5 != null && !pathpoint5.field_75842_i && pathpoint5.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[i++] = pathpoint5;
            }
        }
        if (flag1 && flag3) {
            PathPoint pathpoint6 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a - 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c + 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a - 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c + 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && pathpoint6 != null && !pathpoint6.field_75842_i && pathpoint6.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[i++] = pathpoint6;
            }
        }
        if (flag1 && flag2) {
            PathPoint pathpoint7 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
            d1 = (double)this.field_186326_b.field_70130_N / 2.0;
            aabb1 = new AxisAlignedBB((double)currentPoint.field_75839_a + 0.5 - d1 + 0.5, (double)currentPoint.field_75837_b + 1.001, (double)currentPoint.field_75838_c + 0.5 - d1 + 0.5, (double)currentPoint.field_75839_a + 0.5 + d1 + 0.5, (double)((float)currentPoint.field_75837_b + 1.0f + this.field_186326_b.field_70131_O), (double)currentPoint.field_75838_c + 0.5 + d1 + 0.5);
            if (!this.field_186326_b.field_70170_p.func_184143_b(aabb1) && pathpoint7 != null && !pathpoint7.field_75842_i && pathpoint7.func_75829_a(targetPoint) < maxDistance) {
                pathOptions[i++] = pathpoint7;
            }
        }
        return i;
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int p_186332_4_, double p_186332_5_, EnumFacing facing) {
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockPos blockpos1 = blockpos.func_177977_b();
        double d0 = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos1).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos1).field_72337_e);
        if (d0 - p_186332_5_ > 1.125) {
            return null;
        }
        this.breakableFlag = false;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
        float f = this.field_186326_b.func_184643_a(pathnodetype);
        double d1 = (double)this.field_186326_b.field_70130_N / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
            if (this.breakableFlag) {
                pathpoint.field_186286_l += 1.0f;
            }
        }
        if (pathnodetype != PathNodeType.WALKABLE) {
            if (pathpoint == null && p_186332_4_ > 0 && pathnodetype != PathNodeType.FENCE && pathnodetype != PathNodeType.TRAPDOOR && (pathpoint = this.getSafePoint(x, y + 1, z, p_186332_4_ - 1, p_186332_5_, facing)) != null && (pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
                double d2 = (double)(x - facing.func_82601_c()) + 0.5;
                double d3 = (double)(z - facing.func_82599_e()) + 0.5;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(d2 - d1, (double)y + 0.001, d3 - d1, d2 + d1, (double)((float)y + this.field_186326_b.field_70131_O), d3 + d1);
                AxisAlignedBB axisalignedbb1 = this.field_176169_a.func_180495_p(blockpos).func_185900_c(this.field_176169_a, blockpos);
                AxisAlignedBB axisalignedbb2 = axisalignedbb.func_72321_a(0.0, axisalignedbb1.field_72337_e - 0.002, 0.0);
                if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb2)) {
                    pathpoint = null;
                }
            }
            if (pathnodetype == PathNodeType.OPEN) {
                PathNodeType pathnodetype1;
                AxisAlignedBB axisalignedbb3 = new AxisAlignedBB((double)x - d1 + 0.5, (double)y + 0.001, (double)z - d1 + 0.5, (double)x + d1 + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + d1 + 0.5);
                if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb3)) {
                    return null;
                }
                if (this.field_186326_b.field_70130_N >= 1.0f && (pathnodetype1 = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                    pathpoint = this.func_176159_a(x, y, z);
                    pathpoint.field_186287_m = PathNodeType.WALKABLE;
                    pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                    if (this.breakableFlag) {
                        pathpoint.field_186286_l += 1.0f;
                    }
                    return pathpoint;
                }
                int i = 0;
                while (y > 0 && pathnodetype == PathNodeType.OPEN) {
                    --y;
                    if (i++ >= this.field_186326_b.func_82143_as()) {
                        return null;
                    }
                    pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
                    f = this.field_186326_b.func_184643_a(pathnodetype);
                    if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                        pathpoint = this.func_176159_a(x, y, z);
                        pathpoint.field_186287_m = pathnodetype;
                        pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                        if (!this.breakableFlag) break;
                        pathpoint.field_186286_l += 1.0f;
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    return null;
                }
            }
        }
        return pathpoint;
    }

    @Nonnull
    protected PathNodeType func_189553_b(IBlockAccess acc, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState iblockstate = acc.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (this.field_186326_b != null && block.isLadder(iblockstate, acc, blockpos, (EntityLivingBase)this.field_186326_b)) {
            return PathNodeType.WALKABLE;
        }
        return this.defaultNode(acc, iblockstate, blockpos, block);
    }

    private PathNodeType defaultNode(IBlockAccess acc, IBlockState iblockstate, BlockPos blockpos, Block block) {
        Material material = iblockstate.func_185904_a();
        PathNodeType type = block.getAiPathNodeType(iblockstate, acc, blockpos, this.field_186326_b);
        if (type != null) {
            return type;
        }
        if (material == Material.field_151579_a || iblockstate.func_185890_d(acc, blockpos) == Block.field_185506_k) {
            return PathNodeType.OPEN;
        }
        if (block instanceof BlockTrapDoor || block instanceof BlockLilyPad) {
            return PathNodeType.TRAPDOOR;
        }
        if (block instanceof BlockFire) {
            return PathNodeType.DAMAGE_FIRE;
        }
        if (block instanceof BlockCactus) {
            return PathNodeType.DAMAGE_CACTUS;
        }
        if (block instanceof BlockDoor) {
            return this.getDoorType(iblockstate);
        }
        if (block instanceof BlockRailBase) {
            return PathNodeType.RAIL;
        }
        if (this.isFence(acc, iblockstate, blockpos, block)) {
            return PathNodeType.FENCE;
        }
        if (material == Material.field_151586_h) {
            return PathNodeType.WATER;
        }
        if (material == Material.field_151587_i) {
            return PathNodeType.LAVA;
        }
        return block.func_176205_b(acc, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
    }

    public boolean canBreakBlocks() {
        return this.canBreakBlocks;
    }

    public void setBreakBlocks(boolean flag) {
        this.canBreakBlocks = flag;
    }

    private boolean isFence(IBlockAccess acc, IBlockState iblockstate, BlockPos blockpos, Block block) {
        if (block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) {
            return true;
        }
        if (this.field_186326_b != null) {
            AxisAlignedBB collision2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(blockpos.func_177984_a());
            ArrayList list = Lists.newArrayList();
            iblockstate.func_185908_a(this.field_186326_b.field_70170_p, blockpos, collision2, (List)list, null, false);
            return !list.isEmpty();
        }
        return false;
    }

    private PathNodeType getDoorType(IBlockState state) {
        boolean open = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        if (!open) {
            if (state.func_185904_a() == Material.field_151575_d) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            return PathNodeType.DOOR_IRON_CLOSED;
        }
        return PathNodeType.DOOR_OPEN;
    }
}

