/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.hans;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import pl.pabilo8.immersiveintelligence.common.entity.EntityHans;

public class HansAnimations {
    public static void putMouthShape(EntityHans entityHans, char c, double start, double end) {
        MouthShapes shape = HansAnimations.getShapeFromChar(c);
        if (shape != null) {
            entityHans.mouthShapeQueue.add((Tuple<Integer, MouthShapes>)new Tuple((Object)((int)((end - start) * 20.0)), (Object)shape));
        }
    }

    @Nullable
    private static MouthShapes getShapeFromChar(char c) {
        for (MouthShapes shape : MouthShapes.values()) {
            if (shape.alphabeticName != c) continue;
            return shape;
        }
        return null;
    }

    public static double[] getEyeEmotionInBetween(EyeEmotions e1, EyeEmotions e2, double percent) {
        return new double[]{MathHelper.func_151238_b((double)e1.eyebrowHeightDiffRight, (double)e2.eyebrowHeightDiffRight, (double)(percent * 2.5)), MathHelper.func_151238_b((double)e1.eyebrowHeightDiffLeft, (double)e2.eyebrowHeightDiffLeft, (double)(percent * 2.5)), MathHelper.func_151238_b((double)e1.eyebrowThickness, (double)e2.eyebrowThickness, (double)(percent * 2.5))};
    }

    public static double[] getMouthShapeInBetween(MouthShapes e1, MouthShapes e2, MouthEmotions e3, double percent) {
        return new double[]{MathHelper.func_151238_b((double)e1.lipBottomOffset, (double)e2.lipBottomOffset, (double)(percent * 2.0)) + e3.lipBottomOffset, MathHelper.func_151238_b((double)e1.lipBottomWidth, (double)e2.lipBottomWidth, (double)(percent * 2.0)) + e3.lipBottomWidth, MathHelper.func_151238_b((double)e1.lipTopOffset, (double)e2.lipTopOffset, (double)(percent * 2.0)) + e3.lipTopOffset, MathHelper.func_151238_b((double)e1.lipTopWidth, (double)e2.lipTopWidth, (double)(percent * 2.0)) + e3.lipTopWidth, MathHelper.func_151238_b((double)e1.tongueHeight, (double)e2.tongueHeight, (double)(percent * 2.0))};
    }

    public static enum HansLegAnimation {
        STANDING(1.0f),
        SNEAKING(1.0f),
        KNEELING(0.0f),
        SQUATTING(0.0f),
        LYING(0.5f, 0.625f, 0.8f),
        KAZACHOK(0.5f);

        public final float walkSpeedModifier;
        public final float aabbWidth;
        public final float aabbHeight;

        private HansLegAnimation(float walkSpeedModifier) {
            this(walkSpeedModifier, 0.625f, 1.8f);
        }

        private HansLegAnimation(float walkSpeedModifier, float aabbWidth, float aabbHeight) {
            this.walkSpeedModifier = walkSpeedModifier;
            this.aabbWidth = aabbWidth;
            this.aabbHeight = aabbHeight;
        }
    }

    public static enum MouthShapes {
        CLOSED('A', 0.0, 1.0, 0.0, 1.0, false, 0.0),
        SLIGHTLY_OPEN('B', 0.55, 1.0, 0.55, 1.0, false, 0.0),
        OPEN('C', 0.75, 1.25, 0.75, 1.25, false, 0.0),
        WIDE_OPEN('D', 1.0, 1.5, 1.0, 1.5, false, 0.0),
        SLIGHTLY_ROUNDED('E', 0.75, 0.75, 0.75, 0.75, false, 0.0),
        PUCKERED_LIPS('F', 0.5, 0.6, 0.5, 0.6, false, 0.0),
        UPPER_TEETH_CLENCHING('G', 0.0, 1.0, 0.45, 1.0, true, 0.0),
        L_SHAPE('H', 0.85, 1.35, 0.85, 1.35, false, 1.0),
        SPEAKING_PAUSE('X', 0.25, 1.25, 0.25, 1.25, false, 0.0);

        private final char alphabeticName;
        public final double lipBottomOffset;
        public final double lipBottomWidth;
        public final double lipTopOffset;
        public final double lipTopWidth;
        public final double tongueHeight;
        public final boolean upperTeethVisible;

        private MouthShapes(char c, double lipBottomOffset, double lipBottomWidth, double lipTopOffset, double lipTopWidth, boolean upperTeethVisible, double tongueHeight) {
            this.alphabeticName = c;
            this.lipBottomOffset = lipBottomOffset;
            this.lipBottomWidth = lipBottomWidth;
            this.lipTopOffset = lipTopOffset;
            this.lipTopWidth = lipTopWidth;
            this.tongueHeight = tongueHeight;
            this.upperTeethVisible = upperTeethVisible;
        }

        public static MouthShapes v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(MouthShapes.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(CLOSED);
        }
    }

    public static enum MouthEmotions {
        NEUTRAL(0.0, 0.0, 0.0, 0.0),
        ANGRY(0.75, 0.0, 0.5, 0.0),
        HAPPY(0.5, 0.125, 0.25, 0.5),
        LAUGHING(0.75, 0.125, 0.5, 0.5);

        public final double lipBottomOffset;
        public final double lipBottomWidth;
        public final double lipTopOffset;
        public final double lipTopWidth;

        private MouthEmotions(double lipBottomOffset, double lipBottomWidth, double lipTopOffset, double lipTopWidth) {
            this.lipBottomOffset = lipBottomOffset;
            this.lipBottomWidth = lipBottomWidth;
            this.lipTopOffset = lipTopOffset;
            this.lipTopWidth = lipTopWidth;
        }
    }

    public static enum EyeEmotions {
        NEUTRAL(0.0, 0.0, 1.0),
        FROWNING(-0.25, -0.25, 1.0),
        SURPRISED(0.25, 0.25, 1.0),
        HAPPY(0.0625, 0.0625, 0.75),
        SUSPICIOUS(0.0, 0.0, 0.25),
        SLEEPY(0.0625, -0.0625, 0.25);

        public final double eyebrowHeightDiffRight;
        public final double eyebrowHeightDiffLeft;
        public final double eyebrowThickness;

        private EyeEmotions(double eyebrowHeightDiffRight, double eyebrowHeightDiffLeft, double eyebrowThickness) {
            this.eyebrowHeightDiffRight = eyebrowHeightDiffRight;
            this.eyebrowHeightDiffLeft = eyebrowHeightDiffLeft;
            this.eyebrowThickness = eyebrowThickness;
        }
    }
}

