/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.entity.bullets;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.MultipleRayTracer;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCore;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.common.IIDamageSources;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageEntityNBTSync;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityBullet
extends Entity
implements ILightProvider,
IEntityAdditionalSpawnData {
    public static final int MAX_TICKS = 600;
    public static final float DRAG = 0.0f;
    public static final float GRAVITY = 0.15f;
    public static float DEV_SLOMO = 1.0f;
    public static boolean DEV_DECAY = true;
    public IBullet bullet;
    public IBulletCore core;
    public BulletRegistry.EnumCoreTypes coreType;
    public BulletRegistry.EnumFuseTypes fuseType = BulletRegistry.EnumFuseTypes.CONTACT;
    public int fuseParameter = 0;
    public IBulletComponent[] components = new IBulletComponent[0];
    public NBTTagCompound[] componentNBT = new NBTTagCompound[0];
    protected Entity shooter = null;
    boolean isPainted = false;
    boolean shouldLoadChunks = false;
    public double baseMotionX = 0.0;
    public double baseMotionY = 0.0;
    public double baseMotionZ = 0.0;
    public double gravityMotionY = 0.0;
    public int paintColor = -1;
    public int fuse = -1;
    public float penetrationHardness = 1.0f;
    public float force = 1.0f;
    public float initialForce = 1.0f;
    public float baseDamage = 0.0f;
    public float mass = 0.0f;
    ArrayList<Entity> hitEntities = new ArrayList();
    ArrayList<BlockPos> hitPos = new ArrayList();
    protected boolean wasSynced;
    private ForgeChunkManager.Ticket ticket = null;

    public EntityBullet(World worldIn) {
        super(worldIn);
        this.hitEntities.add(this);
        this.func_70105_a(0.5f, 0.5f);
        this.wasSynced = !worldIn.field_72995_K;
    }

    public EntityBullet(World worldIn, ItemStack stack, double x, double y, double z, float velocityMod, double motionX, double motionY, double motionZ) {
        super(worldIn);
        this.fromStack(stack);
        this.func_70107_b(x, y, z);
        this.force = this.bullet.getDefaultVelocity() * velocityMod;
        this.initialForce = this.bullet.getDefaultVelocity();
        this.baseMotionX = motionX;
        this.baseMotionY = motionY;
        this.baseMotionZ = motionZ;
        this.setMotion();
        if (!this.field_70170_p.field_72995_K && this.shouldLoadChunks) {
            this.ticket = ForgeChunkManager.requestTicket((Object)ImmersiveIntelligence.INSTANCE, (World)this.func_130014_f_(), (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            if (this.ticket != null) {
                this.ticket.bindEntity((Entity)this);
            }
        }
    }

    public void setShooters(@Nonnull Entity shooter, Entity ... others) {
        this.shooter = shooter;
        this.hitEntities.add(shooter);
        if (shooter.func_184218_aH()) {
            this.hitEntities.add(shooter.func_184208_bv());
            this.hitEntities.addAll(shooter.func_184208_bv().func_184182_bu());
        }
        this.hitEntities.addAll(Arrays.asList(others));
    }

    public void setShootPos(BlockPos ... others) {
        this.hitPos.addAll(Arrays.asList(others));
    }

    private void setMotion() {
        this.field_70159_w = this.baseMotionX * (double)DEV_SLOMO * (double)this.force;
        this.field_70181_x = (this.baseMotionY * (double)this.force + this.gravityMotionY) * (double)DEV_SLOMO;
        this.field_70179_y = this.baseMotionZ * (double)DEV_SLOMO * (double)this.force;
    }

    protected void fromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof IBullet) {
            this.bullet = (IBullet)stack.func_77973_b();
            this.core = this.bullet.getCore(stack);
            this.coreType = this.bullet.getCoreType(stack);
            this.fuseType = this.bullet.getFuseType(stack);
            this.fuseParameter = this.bullet.getFuseParameter(stack);
            this.components = this.bullet.getComponents(stack);
            this.componentNBT = this.bullet.getComponentsNBT(stack);
            this.paintColor = this.bullet.getPaintColor(stack);
            if (this.fuseType == BulletRegistry.EnumFuseTypes.TIMED) {
                this.fuse = this.fuseParameter;
            }
            this.refreshBullet();
        }
    }

    private void refreshBullet() {
        if (this.core == null || this.bullet == null || this.coreType == null) {
            this.func_70106_y();
            return;
        }
        this.penetrationHardness = this.fuseType == BulletRegistry.EnumFuseTypes.PROXIMITY ? 1.0f : this.core.getPenetrationHardness();
        double compMass = 1.0 + Arrays.stream(this.components).mapToDouble(IBulletComponent::getDensity).sum();
        this.baseDamage = (float)((double)this.bullet.getDamage() * (compMass += (double)this.core.getDensity()) * (double)this.core.getDamageModifier());
        this.shouldLoadChunks = this.bullet.shouldLoadChunks();
        this.mass = this.bullet.getCoreMass(this.core, this.components);
        if (this.paintColor == -1) {
            this.isPainted = false;
        }
        this.setBulletSize();
    }

    public void onUpdateSuper() {
        super.func_70071_h_();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70071_h_() {
        this.onUpdateSuper();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_70014_b(nbt);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageEntityNBTSync(this, nbt), Utils.targetPointFromEntity(this, 32));
        } else if (this.field_70170_p.field_72995_K && !this.wasSynced) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
        } else if (!this.shouldLoadChunks && this.field_70173_aa > 600 && DEV_DECAY || this.field_70163_u < 0.0) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.func_82737_E() % 6L == 0L) {
            // empty if block
        }
        if (this.field_70128_L) {
            return;
        }
        if (this.penetrationHardness == 0.0f) {
            this.baseMotionX = 0.0;
            this.baseMotionY = 0.0;
            this.baseMotionZ = 0.0;
        } else {
            this.force -= 0.0f * this.force * DEV_SLOMO;
            this.gravityMotionY -= (double)(0.15f * this.mass * DEV_SLOMO);
            this.setMotion();
            MultipleRayTracer tracer = MultipleRayTracer.MultipleTracerBuilder.setPos(this.field_70170_p, this.func_174791_d(), this.getNextPositionVector()).setAABB(this.func_174813_aQ().func_186662_g(this.fuseType == BulletRegistry.EnumFuseTypes.PROXIMITY ? (double)this.fuseParameter : 0.0).func_191194_a(this.func_174791_d().func_186678_a(-1.0))).setFilters(this.hitEntities, this.hitPos).volumetricTrace();
            int i = 0;
            block4: for (RayTraceResult hit : tracer.hits) {
                if (hit != null) {
                    switch (hit.field_72313_a) {
                        case BLOCK: {
                            BlockPos pos = hit.func_178782_a();
                            this.hitPos.add(pos);
                            if (this.field_70170_p.field_72995_K) break;
                            PenetrationRegistry.IPenetrationHandler penetrationHandler = PenetrationRegistry.getPenetrationHandler(this.field_70170_p.func_180495_p(pos));
                            BulletRegistry.PenMaterialTypes penType = penetrationHandler.getPenetrationType();
                            float pen = this.penetrationHardness * this.coreType.getPenMod(penType);
                            float dmg = this.baseDamage * this.coreType.getDamageMod(penType) / 4.0f;
                            float hardness = this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos);
                            if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150357_h) {
                                hardness = pen * 20.0f;
                            }
                            if (hardness < 0.0f) {
                                hardness = 2.1474836E9f + hardness;
                            }
                            if (pen > hardness / penetrationHandler.getDensity()) {
                                if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_180495_p(pos).func_185904_a().func_76224_d()) {
                                    BulletHelper.dealBlockDamage(this.field_70170_p, dmg, pos, penetrationHandler);
                                    this.playHitSound(PenetrationRegistry.HitEffect.IMPACT, this.field_70170_p, hit.func_178782_a(), penetrationHandler);
                                }
                                this.penetrationHardness *= hardness * 1.5f / pen;
                                this.force *= 0.85f;
                                break;
                            }
                            if (pen > 0.0f) {
                                if (!this.field_70170_p.field_72995_K) {
                                    if (!this.field_70170_p.func_180495_p(pos).func_185904_a().func_76224_d()) {
                                        BulletHelper.dealBlockDamage(this.field_70170_p, dmg * (hardness / penetrationHandler.getDensity()), pos, penetrationHandler);
                                        this.playHitSound(PenetrationRegistry.HitEffect.IMPACT, this.field_70170_p, hit.func_178782_a(), penetrationHandler);
                                    }
                                    if (this.fuse == -1) {
                                        this.performEffect(hit);
                                    }
                                }
                                this.stopAtPoint(hit);
                                this.penetrationHardness = 0.0f;
                                break block4;
                            }
                            if (this.force > hardness && penetrationHandler.getPenetrationType().canRicochetOff() && i == 0) {
                                this.ricochet(hardness / 2.0f, pos);
                                if (this.field_70170_p.field_72995_K) break block4;
                                this.playHitSound(PenetrationRegistry.HitEffect.RICOCHET, this.field_70170_p, hit.func_178782_a(), penetrationHandler);
                                break block4;
                            }
                            if (!this.field_70170_p.field_72995_K && this.fuse == -1) {
                                this.performEffect(hit);
                            }
                            this.stopAtPoint(hit);
                            break block4;
                        }
                        case ENTITY: {
                            this.hitEntities.add(hit.field_72308_g);
                            if (hit.field_72308_g == this || hit.field_72308_g == null) break;
                            Entity e = hit.field_72308_g;
                            if (e instanceof EntityBullet) {
                                if (((EntityBullet)e).shooter == this.shooter) break;
                                e.func_70106_y();
                                this.func_70106_y();
                                ((EntityBullet)e).performEffect(new RayTraceResult(e));
                                this.performEffect(new RayTraceResult((Entity)this));
                                break block4;
                            }
                            int armor = 0;
                            int toughness = 1;
                            if (e instanceof EntityLivingBase) {
                                armor = MathHelper.func_76128_c((double)((EntityLivingBase)e).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e());
                                toughness += MathHelper.func_76128_c((double)((EntityLivingBase)e).func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e());
                            }
                            BulletRegistry.PenMaterialTypes penType = toughness > 0 || armor > 0 ? BulletRegistry.PenMaterialTypes.METAL : BulletRegistry.PenMaterialTypes.FLESH;
                            float pen = this.penetrationHardness * this.coreType.getPenMod(penType) * Math.min(this.force, 1.15f);
                            float dmg = this.baseDamage * this.coreType.getDamageMod(penType);
                            if (pen > (float)toughness * 6.0f) {
                                if (!this.field_70170_p.field_72995_K) {
                                    BulletHelper.breakArmour(e, (int)(this.baseDamage * this.coreType.getPenMod(penType) / 6.0f));
                                    e.field_70172_ad = 0;
                                    if (!e.func_70097_a(IIDamageSources.causeBulletDamage(this, this.shooter, e), dmg)) {
                                        this.performEffect(hit);
                                    }
                                }
                                this.stopAtPoint(hit);
                                this.penetrationHardness *= (float)toughness * 4.0f / pen;
                                this.force *= 0.85f;
                                break;
                            }
                            if (pen > 0.0f) {
                                if (!this.field_70170_p.field_72995_K) {
                                    float depth = (pen - (float)toughness * 6.0f) / pen;
                                    BulletHelper.breakArmour(e, (int)(this.baseDamage * this.coreType.getPenMod(penType) / 8.0f));
                                    e.field_70172_ad = 0;
                                    if (!e.func_70097_a(IIDamageSources.causeBulletDamage(this, this.shooter, e), dmg)) {
                                        this.performEffect(hit);
                                    }
                                    this.penetrationHardness = 0.0f;
                                    if (this.fuse == -1) {
                                        this.performEffect(hit);
                                    }
                                }
                                this.stopAtPoint(hit);
                                break block4;
                            }
                            if (this.force > (float)toughness * 1.5f && penType.canRicochetOff() && i == 0) {
                                this.ricochet((float)toughness / 2.0f, hit.func_178782_a());
                                this.hitEntities.add(hit.field_72308_g);
                            } else if (!this.field_70170_p.field_72995_K && this.fuse == -1) {
                                this.performEffect(hit);
                            }
                            this.stopAtPoint(hit);
                            break block4;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.fuse != -1 && this.field_70173_aa > this.fuse) {
            this.performEffect(new RayTraceResult((Entity)this));
            return;
        }
        this.setMotion();
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70170_p.field_72995_K) {
            if (this.penetrationHardness == 0.0f) return;
            Vec3d normalized = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
            float motionXZ = MathHelper.func_76133_a((double)(normalized.field_72450_a * normalized.field_72450_a + normalized.field_72449_c * normalized.field_72449_c));
            this.field_70177_z = (float)(Math.atan2(normalized.field_72450_a, normalized.field_72449_c) * 180.0 / 3.1415927410125732);
            this.field_70125_A = -((float)(Math.atan2(normalized.field_72448_b, motionXZ) * 180.0 / 3.1415927410125732));
            for (int j = 0; j < this.components.length; ++j) {
                IBulletComponent c = this.components[j];
                if (!c.hasTrail()) continue;
                c.spawnParticleTrail(this, this.componentNBT[j]);
            }
            return;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.field_70170_p.func_175726_f(this.func_180425_c()).func_76632_l());
    }

    private void stopAtPoint(RayTraceResult hit) {
        this.gravityMotionY = 0.0;
        this.penetrationHardness = 0.0f;
        this.baseMotionX = 0.0;
        this.baseMotionY = 0.0;
        this.baseMotionZ = 0.0;
        this.func_70634_a(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b + (double)this.field_70131_O, hit.field_72307_f.field_72449_c);
        this.setMotion();
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_70014_b(nbt);
            nbt.func_74757_a("stopped", true);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageEntityNBTSync(this, nbt), Utils.targetPointFromEntity(this, 32));
        }
    }

    private void ricochet(float force, BlockPos currentPos) {
        this.force = force;
        this.baseMotionX *= -1.0;
        this.baseMotionY *= -1.0;
        this.hitEntities.clear();
        this.hitEntities.add(this);
        this.hitPos.clear();
        this.hitPos.add(currentPos);
    }

    protected void performEffect(RayTraceResult hit) {
        this.func_70106_y();
        this.func_70107_b(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
        float str = this.bullet.getComponentMultiplier() * this.core.getExplosionModifier() * this.coreType.getComponentEffectivenessMod();
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || i >= this.componentNBT.length || this.componentNBT[i] == null) continue;
            this.components[i].onEffect(str, this.coreType, this.componentNBT[i], hit.field_72307_f, new Vec3d(this.baseMotionX, this.baseMotionY, this.baseMotionZ).func_72432_b(), this.field_70170_p);
        }
    }

    public Entity getShooter() {
        return this.shooter;
    }

    public Vec3d getNextPositionVector() {
        return this.func_174791_d().func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(NBTTagCompound compound) {
        int i;
        NBTTagList components;
        if (compound.func_74764_b("basemotion_x")) {
            this.baseMotionX = compound.func_74769_h("basemotion_x");
            this.baseMotionY = compound.func_74769_h("basemotion_y");
            this.baseMotionZ = compound.func_74769_h("basemotion_z");
            this.force = compound.func_74760_g("force");
            this.initialForce = compound.func_74760_g("initalForce");
            float motionXZ = MathHelper.func_76133_a((double)(this.baseMotionX * this.baseMotionX + this.baseMotionZ * this.baseMotionZ));
            this.field_70177_z = (float)(Math.atan2(this.baseMotionX, this.baseMotionZ) * 180.0 / 3.1415927410125732);
            this.field_70125_A = -((float)(Math.atan2(this.baseMotionY, motionXZ) * 180.0 / 3.1415927410125732));
        }
        if (compound.func_74764_b("casing")) {
            this.bullet = BulletRegistry.INSTANCE.getBulletItem(compound.func_74779_i("casing"));
        }
        if (compound.func_74764_b("core")) {
            this.core = BulletRegistry.INSTANCE.getCore(compound.func_74779_i("core"));
        }
        if (compound.func_74764_b("core_type")) {
            this.coreType = BulletRegistry.EnumCoreTypes.v(compound.func_74779_i("core_type"));
        }
        if (compound.func_74764_b("fuse_type")) {
            this.fuseType = BulletRegistry.EnumFuseTypes.v(compound.func_74779_i("fuse_type"));
        }
        if (compound.func_74764_b("fuse_parameter")) {
            this.fuseParameter = compound.func_74762_e("fuse_parameter");
        }
        if (compound.func_74764_b("components")) {
            ArrayList<IBulletComponent> arrayList = new ArrayList<IBulletComponent>();
            components = (NBTTagList)compound.func_74781_a("components");
            for (i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(BulletRegistry.INSTANCE.getComponent(components.func_150307_f(i)));
            }
            this.components = arrayList.toArray(new IBulletComponent[0]);
        }
        if (compound.func_74764_b("component_nbt")) {
            ArrayList<NBTTagCompound> arrayList = new ArrayList<NBTTagCompound>();
            components = (NBTTagList)compound.func_74781_a("component_nbt");
            for (i = 0; i < components.func_74745_c(); ++i) {
                arrayList.add(components.func_150305_b(i));
            }
            this.componentNBT = arrayList.toArray(new NBTTagCompound[0]);
        }
        if (compound.func_74764_b("paint_color")) {
            this.paintColor = compound.func_74762_e("paint_color");
        }
        this.refreshBullet();
        if (compound.func_74764_b("stopped")) {
            this.gravityMotionY = 0.0;
            this.penetrationHardness = 0.0f;
            this.baseMotionX = 0.0;
            this.baseMotionY = 0.0;
            this.baseMotionZ = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.wasSynced = true;
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("casing", this.bullet.getName());
        compound.func_74778_a("core", this.core.getName());
        compound.func_74778_a("core_type", this.coreType.func_176610_l());
        compound.func_74778_a("fuse_type", this.fuseType.func_176610_l());
        compound.func_74768_a("fuse_parameter", this.fuseParameter);
        NBTTagList tagList = new NBTTagList();
        Arrays.stream(this.components).map(IBulletComponent::getName).map(NBTTagString::new).forEachOrdered(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
        if (tagList.func_74745_c() > 0) {
            compound.func_74782_a("components", (NBTBase)tagList);
        }
        tagList = new NBTTagList();
        Arrays.stream(this.componentNBT).forEachOrdered(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
        if (tagList.func_74745_c() > 0) {
            compound.func_74782_a("component_nbt", (NBTBase)tagList);
        }
        compound.func_74768_a("paint_color", this.paintColor);
        compound.func_74780_a("basemotion_x", this.baseMotionX);
        compound.func_74780_a("basemotion_y", this.baseMotionY);
        compound.func_74780_a("basemotion_z", this.baseMotionZ);
        compound.func_74776_a("force", this.force);
        compound.func_74776_a("initalForce", this.initialForce);
    }

    private void playHitSound(PenetrationRegistry.HitEffect effect, World world, BlockPos pos, PenetrationRegistry.IPenetrationHandler handler) {
        MinecraftServer server;
        IBlockState state = world.func_180495_p(pos);
        SoundEvent event = handler.getSpecialSound(effect);
        if (event == null) {
            SoundType type = state.func_177230_c().getSoundType(state, world, pos, (Entity)this);
            SoundEvent soundEvent = event = effect == PenetrationRegistry.HitEffect.IMPACT ? type.func_185845_c() : type.func_185844_d();
        }
        if ((server = world.func_73046_m()) != null) {
            server.func_184103_al().func_148543_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0, this.field_70170_p.field_73011_w.getDimension(), (Packet)new SPacketSoundEffect(event, SoundCategory.BLOCKS, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, 1.0f));
        }
    }

    public Vec3d getBaseMotion() {
        return new Vec3d(this.baseMotionX, this.baseMotionY, this.baseMotionZ);
    }

    private void setBulletSize() {
        float cal;
        this.field_70130_N = cal = this.bullet.getCaliber() / 16.0f;
        this.field_70131_O = cal;
        this.func_174826_a(new AxisAlignedBB((double)(-(cal *= 16.0f)), (double)(-cal), (double)(-cal), (double)cal, (double)cal, (double)cal));
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Light provideLight() {
        if (this.wasSynced) {
            for (int j = 0; j < this.components.length; ++j) {
                IBulletComponent c = this.components[j];
                if (!c.hasTrail()) continue;
                return Light.builder().pos((Entity)this).radius(this.bullet.getComponentMultiplier() * 16.0f).color(c.getNBTColour(this.componentNBT[j]), false).build();
            }
        }
        return null;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public void func_70015_d(int seconds) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_70014_b(compound);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)additionalData);
        if (compound != null) {
            this.func_70037_a(compound);
        }
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_191954_d(float delay) {
        this.func_184185_a(IISounds.bullet_wind, 2.0f, 1.0f / this.bullet.getCaliber());
        return delay + 5.0f;
    }
}

