/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.PrecissionAssembler")
@ZenRegister
public class PrecissionAssemblerRecipeTweaker {
    @ZenMethod
    public static void addRecipe(IItemStack itemOutput, IItemStack trash, IIngredient[] itemInputs, String[] tools, String[] animations, int energy, int timeMultiplier) {
        Object[] adds = null;
        if (itemInputs != null) {
            adds = new Object[itemInputs.length];
            for (int i = 0; i < itemInputs.length; ++i) {
                adds[i] = CraftTweakerHelper.toObject((IIngredient)itemInputs[i]);
            }
        }
        if (adds == null) {
            CraftTweakerAPI.getLogger().logError("Did not add precission assembler recipe for " + itemOutput.getDisplayName() + ", no valid inputs were provided");
            return;
        }
        if (tools == null) {
            CraftTweakerAPI.getLogger().logError("Did not add precission assembler recipe for " + itemOutput.getDisplayName() + ", no tools were provided");
            return;
        }
        if (animations == null) {
            CraftTweakerAPI.getLogger().logError("Did not add precission assembler recipe for " + itemOutput.getDisplayName() + ", no valid animations were provided");
            return;
        }
        PrecissionAssemblerRecipe r = new PrecissionAssemblerRecipe(CraftTweakerHelper.toStack((IItemStack)itemOutput), CraftTweakerHelper.toStack((IItemStack)trash), adds, tools, animations, energy, timeMultiplier);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack itemOutput) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)itemOutput)));
    }

    private static class Remove
    implements IAction {
        List<PrecissionAssemblerRecipe> removedRecipes;
        ItemStack f1;

        public Remove(ItemStack stack) {
            this.f1 = stack;
        }

        public void apply() {
            this.removedRecipes = PrecissionAssemblerRecipe.removeRecipesForOutput(this.f1);
        }

        public String describe() {
            return "Removing Precission Assembler Recipe for " + this.f1.func_77977_a();
        }
    }

    private static class Add
    implements IAction {
        private final PrecissionAssemblerRecipe recipe;

        public Add(PrecissionAssemblerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            PrecissionAssemblerRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Precission Assembler Recipe for " + this.recipe.output.func_77977_a();
        }
    }
}

