/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.MultipleRayTracer;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeArray;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeEntity;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.IBooleanAnimatedPartsBlock;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IVehicleMultiPart;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.gui.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.MultiblockEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageBooleanAnimatedPartsSync;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class TileEntityEmplacement
extends TileEntityMultiblockMetal<TileEntityEmplacement, MultiblockRecipe>
implements IBooleanAnimatedPartsBlock,
IDataDevice,
IUpgradableMachine,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IGuiTile,
ILightProvider {
    public static final HashMap<String, Supplier<EmplacementWeapon>> weaponRegistry = new HashMap();
    public static final HashMap<String, BiFunction<NBTTagCompound, TileEntityEmplacement, EmplacementTask>> targetRegistry = new HashMap();
    public String owner = "";
    public boolean redstoneControl = true;
    public boolean dataControl = true;
    public int defaultTargetMode = 0;
    public NBTTagCompound[] defaultTaskNBT = new NBTTagCompound[]{this.createDefaultTask(), this.createDefaultTask(), this.createDefaultTask(), this.createDefaultTask()};
    public boolean isDoorOpened = false;
    public int repairTick = Config.IIConfig.Machines.Emplacement.repairDelay;
    public boolean forcedRepair = false;
    public boolean firstRepairTick = true;
    public float autoRepairAmount = 0.25f;
    public int progress = 0;
    public int upgradeProgress = 0;
    public int clientUpgradeProgress = 0;
    public EmplacementWeapon currentWeapon = null;
    BlockPos[] allBlocks = null;
    public boolean isShooting = false;
    @Nullable
    private MachineUpgrade currentlyInstalled = null;
    EmplacementTask task = new EmplacementTaskCustom(this.defaultTaskNBT[this.defaultTargetMode]);
    private float[] target = null;
    public boolean sendAttackSignal = false;

    public TileEntityEmplacement() {
        super((MultiblockHandler.IMultiblock)MultiblockEmplacement.instance, new int[]{6, 3, 3}, Config.IIConfig.Machines.Emplacement.energyCapacity, true);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || !this.func_145830_o()) {
            return;
        }
        if (this.field_145850_b.field_72995_K && (float)this.clientUpgradeProgress < this.getMaxClientProgress()) {
            this.clientUpgradeProgress = (int)Math.min((float)this.clientUpgradeProgress + (float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f, this.getMaxClientProgress());
        }
        boolean wasDoorOpened = this.isDoorOpened;
        if (this.currentlyInstalled != null) {
            this.isDoorOpened = true;
        } else if (this.currentWeapon != null && (this.forcedRepair && this.currentWeapon.getHealth() != this.currentWeapon.getMaxHealth() || this.currentWeapon.requiresPlatformRefill())) {
            this.isDoorOpened = false;
        } else if (this.currentWeapon != null && (float)this.currentWeapon.getHealth() / (float)this.currentWeapon.getMaxHealth() <= this.autoRepairAmount) {
            this.forcedRepair = true;
            this.isDoorOpened = false;
        } else if (!this.field_145850_b.field_72995_K && this.redstoneControl && this.isDoorOpened ^ this.field_145850_b.func_175640_z(this.getBlockPosForPos(this.getRedstonePos()[0]))) {
            this.isDoorOpened = this.field_145850_b.func_175640_z(this.getBlockPosForPos(this.getRedstonePos()[0]));
        }
        if (!this.field_145850_b.field_72995_K && wasDoorOpened ^ this.isDoorOpened) {
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(this.isDoorOpened, 0, this.func_174877_v()), Utils.targetPointFromTile((TileEntity)this, 48));
        }
        if (this.currentWeapon != null) {
            if (this.forcedRepair) {
                boolean bl = this.forcedRepair = this.currentWeapon.getHealth() != this.currentWeapon.getMaxHealth();
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 60L == 0L) {
                this.currentWeapon.syncWeaponHealth(this);
            }
            if (this.currentWeapon.isDead()) {
                if (this.field_145850_b.field_72995_K) {
                    this.currentWeapon.spawnDebrisExplosion(this);
                } else {
                    this.currentWeapon.syncWeaponHealth(this);
                }
                if (this.currentWeapon.entity != null) {
                    this.currentWeapon.entity.func_70106_y();
                }
                this.currentWeapon = null;
            }
        }
        if (this.field_145850_b.field_72995_K && this.currentWeapon != null) {
            this.currentWeapon.handleSounds((TileEntityEmplacement)this.getTileForPos(49), this);
        }
        if (this.isDoorOpened) {
            if (this.progress < Config.IIConfig.Machines.Emplacement.lidTime) {
                ++this.progress;
            } else if (this.currentWeapon != null && this.energyStorage.extractEnergy(this.currentWeapon.getEnergyUpkeepCost(), true) >= this.currentWeapon.getEnergyUpkeepCost()) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energyStorage.modifyEnergyStored(-this.currentWeapon.getEnergyUpkeepCost());
                }
                if (this.currentWeapon.isSetUp(true)) {
                    this.currentWeapon.tick(this, true);
                    if (this.task != null) {
                        if (this.field_145850_b.func_82737_E() % (long)Config.IIConfig.Machines.Emplacement.sightUpdateTime == 0L) {
                            this.task.updateTargets(this);
                        }
                        this.target = this.task.getPositionVector(this);
                        if (this.target != null) {
                            this.target[0] = MathHelper.func_76142_g((float)this.target[0]);
                            this.target[1] = MathHelper.func_76142_g((float)this.target[1]);
                            this.currentWeapon.aimAt(this.target[0], this.target[1]);
                            if (this.currentWeapon.isAimedAt(this.target[0], this.target[1])) {
                                if (this.currentWeapon.canShoot(this)) {
                                    this.isShooting = true;
                                    this.currentWeapon.shoot(this);
                                    this.task.onShot();
                                } else {
                                    this.isShooting = false;
                                }
                            } else {
                                this.isShooting = false;
                            }
                        } else {
                            this.isShooting = false;
                            this.currentWeapon.aimAt(this.currentWeapon.yaw, this.currentWeapon.pitch);
                        }
                    }
                    if (this.task == null || !this.task.shouldContinue()) {
                        this.task = this.defaultTargetMode == -1 ? null : new EmplacementTaskCustom(this.defaultTaskNBT[this.defaultTargetMode]);
                    }
                } else {
                    this.currentWeapon.doSetUp(true);
                }
            }
        } else if (this.currentWeapon != null) {
            this.currentWeapon.tick(this, false);
            if (this.progress == 0 && !this.forcedRepair && this.currentWeapon.requiresPlatformRefill()) {
                if (!this.field_145850_b.field_72995_K) {
                    this.currentWeapon.performPlatformRefill(this);
                }
            } else if (this.currentWeapon.health != this.currentWeapon.getMaxHealth() && this.progress == 0) {
                BlockPos repairPos;
                if (this.field_145850_b.field_72995_K && this.energyStorage.getEnergyStored() >= Config.IIConfig.Machines.Emplacement.repairCost) {
                    ImmersiveEngineering.proxy.handleTileSound(IISounds.welding_mid, (TileEntity)this.getTileForPos(31), true, 5.0f, 1.0f);
                }
                if (this.firstRepairTick) {
                    repairPos = this.getBlockPosForPos(31);
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_184148_a(null, (double)repairPos.func_177958_n(), (double)(repairPos.func_177956_o() + 1), (double)repairPos.func_177952_p(), IISounds.welding_start, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    }
                    this.firstRepairTick = false;
                }
                if (this.repairTick > 0) {
                    --this.repairTick;
                } else if (this.energyStorage.getEnergyStored() >= Config.IIConfig.Machines.Emplacement.repairCost) {
                    this.energyStorage.extractEnergy(Config.IIConfig.Machines.Emplacement.repairCost, false);
                    this.currentWeapon.health = Math.min(this.currentWeapon.health + Config.IIConfig.Machines.Emplacement.repairAmount, this.currentWeapon.getMaxHealth());
                    this.repairTick = Config.IIConfig.Machines.Emplacement.repairDelay;
                }
                if (this.currentWeapon.health == this.currentWeapon.getMaxHealth()) {
                    repairPos = this.getBlockPosForPos(31);
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_184148_a(null, (double)repairPos.func_177958_n(), (double)(repairPos.func_177956_o() + 1), (double)repairPos.func_177952_p(), IISounds.welding_end, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    }
                    this.forcedRepair = false;
                    this.firstRepairTick = true;
                }
            }
            if (this.currentWeapon.isSetUp(false)) {
                if (this.progress > 0) {
                    --this.progress;
                }
                this.currentWeapon.aimAt(0.0f, -90.0f);
            } else {
                this.currentWeapon.doSetUp(false);
            }
        } else if (this.progress > 0) {
            --this.progress;
        }
    }

    public BlockPos[] getAllBlocks() {
        TileEntityEmplacement master = (TileEntityEmplacement)this.master();
        if (master == this || master == null) {
            if (this.allBlocks == null) {
                ArrayList<BlockPos> pp = new ArrayList<BlockPos>();
                for (int i = 0; i < this.structureDimensions[0] * this.structureDimensions[1] * this.structureDimensions[2]; ++i) {
                    pp.add(this.getBlockPosForPos(i));
                }
                this.allBlocks = pp.toArray(new BlockPos[0]);
            }
            return this.allBlocks;
        }
        return master.getAllBlocks();
    }

    public boolean finishedDoorAction() {
        return this.isDoorOpened ? this.progress == Config.IIConfig.Machines.Emplacement.lidTime : this.progress == 0;
    }

    protected MultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    public int[] getEnergyPos() {
        return new int[]{1};
    }

    public int[] getRedstonePos() {
        return new int[]{6};
    }

    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[0];
    }

    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
        if (output.func_190926_b()) {
            return;
        }
        BlockPos pos = this.getBlockPosForPos(8).func_177972_a(this.facing.func_176746_e());
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)this.facing.func_176735_f());
        }
        if (!output.func_190926_b()) {
            blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pos, (ItemStack)output, (EnumFacing)this.facing);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<MultiblockRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 0;
    }

    public int getProcessQueueMaxLength() {
        return 0;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public NonNullList<ItemStack> getInventory() {
        return this.currentWeapon == null ? NonNullList.func_191196_a() : this.currentWeapon.getBaseInventory();
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public void disassemble() {
        super.disassemble();
        if (!this.isDummy() && this.currentWeapon != null && this.currentWeapon.entity != null) {
            this.currentWeapon.entity.func_70106_y();
        }
        this.currentWeapon = null;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.progress = nbt.func_74762_e("progress");
        this.upgradeProgress = nbt.func_74762_e("upgradeProgress");
        this.isDoorOpened = nbt.func_74767_n("isDoorOpened");
        this.redstoneControl = nbt.func_74767_n("redstoneControl");
        this.forcedRepair = nbt.func_74767_n("forcedRepair");
        this.autoRepairAmount = nbt.func_74760_g("autoRepairAmount");
        this.dataControl = nbt.func_74767_n("dataControl");
        this.sendAttackSignal = nbt.func_74767_n("sendAttackSignal");
        this.currentlyInstalled = MachineUpgrade.getUpgradeByID(nbt.func_74779_i("currentlyInstalled"));
        this.upgradeProgress = nbt.func_74762_e("upgradeProgress");
        this.owner = nbt.func_74779_i("owner");
        this.defaultTargetMode = nbt.func_74762_e("defaultTargetMode");
        this.defaultTaskNBT[0] = nbt.func_74775_l("defaultTaskNBT1");
        this.defaultTaskNBT[1] = nbt.func_74775_l("defaultTaskNBT2");
        this.defaultTaskNBT[2] = nbt.func_74775_l("defaultTaskNBT3");
        this.defaultTaskNBT[3] = nbt.func_74775_l("defaultTaskNBT4");
        if (!this.isDummy() && !descPacket) {
            NBTTagCompound taskNBT;
            BiFunction<NBTTagCompound, TileEntityEmplacement, EmplacementTask> name;
            if (nbt.func_74764_b("currentWeapon")) {
                this.currentWeapon = this.getWeaponFromName(nbt.func_74779_i("weaponName"));
                if (this.currentWeapon != null) {
                    this.currentWeapon.readFromNBT(nbt.func_74775_l("currentWeapon"));
                    this.currentWeapon.init(this, false);
                }
            }
            if (nbt.func_74764_b("task") && (name = targetRegistry.get((taskNBT = nbt.func_74775_l("task")).func_74779_i("name"))) != null) {
                this.task = name.apply(taskNBT, this);
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        nbt.func_74757_a("isDoorOpened", this.isDoorOpened);
        nbt.func_74757_a("redstoneControl", this.redstoneControl);
        nbt.func_74757_a("forcedRepair", this.forcedRepair);
        nbt.func_74776_a("autoRepairAmount", this.autoRepairAmount);
        nbt.func_74757_a("dataControl", this.dataControl);
        nbt.func_74757_a("sendAttackSignal", this.sendAttackSignal);
        nbt.func_74768_a("upgradeProgress", this.upgradeProgress);
        nbt.func_74778_a("currentlyInstalled", this.currentlyInstalled == null ? "" : this.currentlyInstalled.toString());
        nbt.func_74778_a("owner", this.owner);
        nbt.func_74768_a("defaultTargetMode", this.defaultTargetMode);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74782_a("defaultTaskNBT1", (NBTBase)this.defaultTaskNBT[0]);
        nbt.func_74782_a("defaultTaskNBT2", (NBTBase)this.defaultTaskNBT[1]);
        nbt.func_74782_a("defaultTaskNBT3", (NBTBase)this.defaultTaskNBT[2]);
        nbt.func_74782_a("defaultTaskNBT4", (NBTBase)this.defaultTaskNBT[3]);
        if (!this.isDummy()) {
            if (this.currentWeapon != null) {
                nbt.func_74778_a("weaponName", this.currentWeapon.getName());
                nbt.func_74782_a("currentWeapon", (NBTBase)this.currentWeapon.saveToNBT(false));
            }
            if (this.task != null) {
                nbt.func_74782_a("task", (NBTBase)this.task.saveToNBT());
            }
        }
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isDummy()) {
            return;
        }
        if (message.func_74764_b("isDoorOpened")) {
            this.isDoorOpened = message.func_74767_n("isDoorOpened");
        }
        if (message.func_74764_b("redstoneControl")) {
            this.redstoneControl = message.func_74767_n("redstoneControl");
        }
        if (message.func_74764_b("autoRepairAmount")) {
            this.autoRepairAmount = message.func_74760_g("autoRepairAmount");
        }
        if (message.func_74764_b("dataControl")) {
            this.dataControl = message.func_74767_n("dataControl");
        }
        if (message.func_74764_b("sendAttackSignal")) {
            this.sendAttackSignal = message.func_74767_n("sendAttackSignal");
        }
        if (message.func_74764_b("progress")) {
            this.progress = message.func_74762_e("progress");
        }
        if (message.func_74764_b("currentlyInstalled")) {
            this.currentlyInstalled = MachineUpgrade.getUpgradeByID(message.func_74779_i("currentlyInstalled"));
            this.clientUpgradeProgress = this.upgradeProgress = message.func_74762_e("upgradeProgress");
        }
        if (message.func_74764_b("defaultTaskNBT1")) {
            this.defaultTaskNBT[0] = message.func_74775_l("defaultTaskNBT1");
        }
        if (message.func_74764_b("defaultTaskNBT2")) {
            this.defaultTaskNBT[1] = message.func_74775_l("defaultTaskNBT2");
        }
        if (message.func_74764_b("defaultTaskNBT3")) {
            this.defaultTaskNBT[2] = message.func_74775_l("defaultTaskNBT3");
        }
        if (message.func_74764_b("defaultTaskNBT4")) {
            this.defaultTaskNBT[3] = message.func_74775_l("defaultTaskNBT4");
        }
        if (message.func_74764_b("sendAttackSignal")) {
            this.sendAttackSignal = message.func_74767_n("sendAttackSignal");
        }
        if (message.func_74764_b("health") && this.currentWeapon != null) {
            this.currentWeapon.health = message.func_74762_e("health");
        }
        if (!this.isDummy()) {
            if (message.func_74764_b("weaponName")) {
                if (message.func_74779_i("weaponName").isEmpty()) {
                    this.currentWeapon = null;
                } else {
                    if (this.currentWeapon == null || !this.currentWeapon.getName().equals(message.func_74779_i("weaponName"))) {
                        this.currentWeapon = this.getWeaponFromName(message.func_74779_i("weaponName"));
                    }
                    if (this.currentWeapon != null) {
                        if (this.currentlyInstalled instanceof EmplacementWeapon.MachineUpgradeEmplacementWeapon) {
                            this.resetInstallProgress();
                        }
                        this.currentWeapon.readFromNBT(message.func_74775_l("currentWeapon"));
                        this.currentWeapon.init(this, false);
                    }
                }
            }
            if (message.func_74764_b("task")) {
                NBTTagCompound taskNBT = message.func_74775_l("task");
                BiFunction<NBTTagCompound, TileEntityEmplacement, EmplacementTask> name = targetRegistry.get(taskNBT.func_74779_i("name"));
                this.task = name != null ? name.apply(taskNBT, this) : null;
            }
        }
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
        super.receiveMessageFromClient(message);
        if (this.isDummy()) {
            return;
        }
        if (message.func_74764_b("redstoneControl")) {
            this.redstoneControl = message.func_74767_n("redstoneControl");
        }
        if (message.func_74764_b("dataControl")) {
            this.dataControl = message.func_74767_n("dataControl");
        }
        if (message.func_74764_b("autoRepairAmount")) {
            this.autoRepairAmount = message.func_74760_g("autoRepairAmount");
        }
        if (message.func_74764_b("sendAttackSignal")) {
            this.sendAttackSignal = message.func_74767_n("sendAttackSignal");
        }
        if (message.func_74764_b("defaultTargetMode")) {
            this.defaultTargetMode = message.func_74762_e("defaultTargetMode");
        }
        boolean taskChanged = false;
        if (message.func_74764_b("defaultTaskNBT1")) {
            this.defaultTaskNBT[0] = message.func_74775_l("defaultTaskNBT1");
            taskChanged = true;
        }
        if (message.func_74764_b("defaultTaskNBT2")) {
            this.defaultTaskNBT[1] = message.func_74775_l("defaultTaskNBT2");
            taskChanged = true;
        }
        if (message.func_74764_b("defaultTaskNBT3")) {
            this.defaultTaskNBT[2] = message.func_74775_l("defaultTaskNBT3");
            taskChanged = true;
        }
        if (message.func_74764_b("defaultTaskNBT4")) {
            this.defaultTaskNBT[3] = message.func_74775_l("defaultTaskNBT4");
            taskChanged = true;
        }
        if (taskChanged && this.task instanceof EmplacementTaskCustom) {
            this.task = this.defaultTargetMode == -1 ? null : new EmplacementTaskCustom(this.defaultTaskNBT[this.defaultTargetMode]);
            this.syncTask();
        }
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, message), Utils.targetPointFromTile((TileEntity)this, 32));
    }

    private EmplacementWeapon getWeaponFromName(String weaponName) {
        if (weaponName == null) {
            return null;
        }
        if (weaponRegistry.containsKey(weaponName)) {
            return weaponRegistry.get(weaponName).get();
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isDummy()) {
            return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() - 8), (double)(this.func_174877_v().func_177952_p() + 1));
        }
        return super.getRenderBoundingBox();
    }

    public void doGraphicalUpdates(int slot) {
    }

    public void syncTask() {
        NBTTagCompound taskTag = new NBTTagCompound();
        if (this.task != null) {
            taskTag.func_74782_a("task", (NBTBase)this.task.saveToNBT());
        }
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, taskTag), Utils.targetPointFromTile((TileEntity)this, 32));
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        if (part == 0) {
            this.isDoorOpened = state;
        }
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        if (part == 0) {
            this.isDoorOpened = state;
        }
        IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(this.isDoorOpened, 1, this.func_174877_v()), Utils.targetPointFromTile((TileEntity)this, 32));
    }

    @Override
    public void onReceive(DataPacket packet, EnumFacing side) {
        if (this.field_174879_c != 0) {
            return;
        }
        IDataType i = packet.variables.get(Character.valueOf('i'));
        IDataType b = packet.variables.get(Character.valueOf('b'));
        IDataType c = packet.variables.get(Character.valueOf('c'));
        IDataType w = packet.variables.get(Character.valueOf('w'));
        IDataType e = packet.variables.get(Character.valueOf('e'));
        IDataType a = packet.variables.get(Character.valueOf('a'));
        IDataType x = packet.variables.get(Character.valueOf('x'));
        IDataType y = packet.variables.get(Character.valueOf('y'));
        IDataType p = packet.variables.get(Character.valueOf('p'));
        IDataType z = packet.variables.get(Character.valueOf('z'));
        TileEntityEmplacement master = (TileEntityEmplacement)this.master();
        if (master == null || !master.dataControl) {
            return;
        }
        if (master.currentWeapon != null) {
            master.currentWeapon.handleDataPacket(packet.clone());
        }
        if (c instanceof DataPacketTypeString) {
            switch (((DataPacketTypeString)c).value) {
                case "opendoor": {
                    master.isDoorOpened = true;
                    IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(true, 0, master.func_174877_v()), Utils.targetPointFromTile((TileEntity)master, 48));
                    break;
                }
                case "closedoor": {
                    master.isDoorOpened = false;
                    IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(false, 0, master.func_174877_v()), Utils.targetPointFromTile((TileEntity)master, 48));
                    break;
                }
                case "door": {
                    if (!(b instanceof DataPacketTypeBoolean)) break;
                    master.isDoorOpened = ((DataPacketTypeBoolean)b).value;
                    IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBooleanAnimatedPartsSync(master.isDoorOpened, 0, master.func_174877_v()), Utils.targetPointFromTile((TileEntity)master, 48));
                    break;
                }
                case "rscontrol": {
                    if (!(b instanceof DataPacketTypeBoolean)) break;
                    master.redstoneControl = ((DataPacketTypeBoolean)b).value;
                    break;
                }
                case "reload": {
                    break;
                }
                case "stop": {
                    master.forcedRepair = false;
                    if (master.defaultTargetMode == -1) {
                        master.task = null;
                        break;
                    }
                    master.task = new EmplacementTaskCustom(this.defaultTaskNBT[this.defaultTargetMode]);
                    break;
                }
                case "repair": {
                    if (master.currentWeapon == null) break;
                    boolean bl = master.forcedRepair = master.currentWeapon.getHealth() != master.currentWeapon.getMaxHealth();
                    if (!master.forcedRepair) break;
                    master.firstRepairTick = true;
                    break;
                }
                case "target": {
                    if (!(i instanceof DataPacketTypeInteger)) break;
                    master.defaultTargetMode = MathHelper.func_76125_a((int)((DataPacketTypeInteger)i).value, (int)0, (int)4) - 1;
                    master.task = master.defaultTargetMode == -1 ? null : new EmplacementTaskCustom(this.defaultTaskNBT[this.defaultTargetMode]);
                    master.syncTask();
                    break;
                }
                case "targetreset": {
                    if (master.defaultTargetMode == -1) {
                        master.task = null;
                    } else if (!(this.task instanceof EmplacementTaskCustom)) {
                        master.task = new EmplacementTaskCustom(this.defaultTaskNBT[this.defaultTargetMode]);
                    }
                    master.syncTask();
                    break;
                }
                case "targetshells": {
                    master.task = new EmplacementTaskShells();
                    master.syncTask();
                    break;
                }
                case "fire": {
                    if (e instanceof DataPacketTypeNull) {
                        if (master.defaultTargetMode == -1) {
                            master.task = null;
                        } else if (!(this.task instanceof EmplacementTaskCustom)) {
                            master.task = new EmplacementTaskCustom(this.defaultTaskNBT[this.defaultTargetMode]);
                        }
                        master.syncTask();
                        break;
                    }
                    if (e instanceof DataPacketTypeInteger || e instanceof DataPacketTypeEntity && ((DataPacketTypeEntity)e).dimensionID == this.field_145850_b.field_73011_w.getDimension()) {
                        int id = e instanceof DataPacketTypeInteger ? ((DataPacketTypeInteger)e).value : ((DataPacketTypeEntity)e).entityID;
                        Entity entityByID = this.field_145850_b.func_73045_a(id);
                        if (entityByID == null) break;
                        master.task = new EmplacementTaskEntity(entityByID);
                        master.syncTask();
                        break;
                    }
                    if (x instanceof DataPacketTypeInteger && y instanceof DataPacketTypeInteger && z instanceof DataPacketTypeInteger) {
                        int xx = ((DataPacketTypeInteger)x).value;
                        int yy = ((DataPacketTypeInteger)y).value;
                        int zz = ((DataPacketTypeInteger)z).value;
                        int amount = a instanceof DataPacketTypeInteger ? ((DataPacketTypeInteger)a).value : 1;
                        master.task = new EmplacementTaskPosition(new BlockPos(xx, yy, zz).func_177971_a((Vec3i)this.getBlockPosForPos(49)), amount);
                        master.syncTask();
                        break;
                    }
                    if (!(y instanceof DataPacketTypeInteger) || !(p instanceof DataPacketTypeInteger)) break;
                    int yy = ((DataPacketTypeInteger)y).value;
                    int pp = ((DataPacketTypeInteger)p).value;
                    double true_angle = Math.toRadians(-yy);
                    double true_angle2 = Math.toRadians(pp);
                    int amount = a instanceof DataPacketTypeInteger ? ((DataPacketTypeInteger)a).value : 1;
                    IDataType d = packet.getPacketVariable(Character.valueOf('d'));
                    int distance = 40;
                    if (d instanceof DataPacketTypeInteger) {
                        distance = ((DataPacketTypeInteger)d).value;
                    }
                    master.task = new EmplacementTaskPosition(new BlockPos(Utils.offsetPosDirection(distance, true_angle, true_angle2)).func_177971_a((Vec3i)this.getBlockPosForPos(49)), amount);
                    master.syncTask();
                }
            }
        }
    }

    private void handleSendingEnemyPos(Entity[] spottedEntity) {
        DataPacket packet = new DataPacket();
        BlockPos center = this.getBlockPosForPos(49);
        IDataType[] entities = (DataPacketTypeEntity[])Arrays.stream(spottedEntity).map(entity -> new DataPacketTypeEntity((Entity)entity, center)).toArray(DataPacketTypeEntity[]::new);
        DataPacketTypeArray arr = new DataPacketTypeArray(entities);
        packet.setVariable(Character.valueOf('e'), arr);
        IDataConnector conn = Utils.findConnectorFacing(this.getBlockPosForPos(0), this.field_145850_b, this.facing.func_176735_f());
        if (conn != null) {
            conn.sendPacket(packet);
        }
    }

    @Override
    public void onSend() {
    }

    @Override
    public boolean addUpgrade(MachineUpgrade upgrade, boolean test) {
        if (upgrade instanceof EmplacementWeapon.MachineUpgradeEmplacementWeapon && this.currentWeapon == null) {
            this.currentWeapon = this.getWeaponFromName(upgrade.getName());
            this.currentWeapon.init(this, true);
            if (!this.field_145850_b.field_72995_K) {
                this.currentWeapon.syncWithClient(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUpgrade(MachineUpgrade upgrade) {
        return this.currentWeapon != null && upgrade.getName().equals(this.currentWeapon.getName());
    }

    @Override
    public boolean upgradeMatches(MachineUpgrade upgrade) {
        if (this.currentWeapon == null) {
            return upgrade instanceof EmplacementWeapon.MachineUpgradeEmplacementWeapon;
        }
        return false;
    }

    @Override
    public <T extends TileEntity> T getUpgradeMaster() {
        return (T)this.master();
    }

    @Override
    @Deprecated
    public void saveUpgradesToNBT(NBTTagCompound tag) {
    }

    @Override
    @Deprecated
    public void getUpgradesFromNBT(NBTTagCompound tag) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderWithUpgrades(MachineUpgrade ... upgrades) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        Utils.bindTexture(EmplacementRenderer.texture);
        GlStateManager.func_179137_b((double)-0.5, (double)-3.0625, (double)1.5);
        EmplacementRenderer.model.platformModel[0].render();
        EmplacementRenderer.model.platformModel[2].render();
        GlStateManager.func_179137_b((double)0.5, (double)3.0625, (double)-1.5);
        for (MachineUpgrade upgrade : upgrades) {
            if (!(upgrade instanceof EmplacementWeapon.MachineUpgradeEmplacementWeapon)) continue;
            ((EmplacementWeapon.MachineUpgradeEmplacementWeapon)upgrade).render(this);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public List<MachineUpgrade> getUpgrades() {
        if (this.isDummy()) {
            return ((TileEntityEmplacement)this.master()).getUpgrades();
        }
        if (this.currentWeapon != null) {
            return Collections.singletonList(this.weaponToUpgrade());
        }
        return new ArrayList<MachineUpgrade>();
    }

    @Override
    @Nullable
    public MachineUpgrade getCurrentlyInstalled() {
        return this.currentlyInstalled;
    }

    @Override
    public int getInstallProgress() {
        return this.upgradeProgress;
    }

    @Override
    public boolean addUpgradeInstallProgress(int toAdd) {
        if (this.finishedDoorAction()) {
            this.upgradeProgress += toAdd;
            return true;
        }
        return false;
    }

    @Override
    public boolean resetInstallProgress() {
        this.currentlyInstalled = null;
        if (this.upgradeProgress > 0) {
            this.upgradeProgress = 0;
            this.clientUpgradeProgress = 0;
            return true;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        return false;
    }

    @Override
    public void startUpgrade(@Nonnull MachineUpgrade upgrade) {
        this.currentlyInstalled = upgrade;
        this.upgradeProgress = 0;
        this.clientUpgradeProgress = 0;
    }

    @Override
    public void removeUpgrade(MachineUpgrade upgrade) {
        if (this.currentWeapon == null) {
            return;
        }
        if (this.currentWeapon.entity != null) {
            this.currentWeapon.entity.func_70106_y();
        }
        this.currentWeapon = null;
        this.upgradeProgress = 0;
        this.clientUpgradeProgress = 0;
    }

    private EmplacementWeapon.MachineUpgradeEmplacementWeapon weaponToUpgrade() {
        return (EmplacementWeapon.MachineUpgradeEmplacementWeapon)MachineUpgrade.getUpgradeByID(this.currentWeapon.getName());
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (this.offset[1] == 1) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        } else {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
        }
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        TileEntityEmplacement master = (TileEntityEmplacement)this.master();
        if (master != null && master.currentWeapon != null && (this.field_174879_c == 2 || this.field_174879_c == 8)) {
            boolean in;
            boolean bl = in = this.field_174879_c == 2;
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == this.facing.func_176746_e()) {
                return master.currentWeapon.getItemHandler(in) != null;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == this.facing.func_176746_e()) {
                return master.currentWeapon.getFluidHandler(in) != null;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntityEmplacement master = (TileEntityEmplacement)this.master();
        if (master != null && master.currentWeapon != null && (this.field_174879_c == 2 || this.field_174879_c == 8)) {
            boolean in;
            boolean bl = in = this.field_174879_c == 2;
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == this.facing.func_176746_e()) {
                return (T)master.currentWeapon.getItemHandler(in);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == this.facing.func_176746_e()) {
                return (T)master.currentWeapon.getFluidHandler(in);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shoudlPlaySound(String sound) {
        TileEntityEmplacement master = (TileEntityEmplacement)this.master();
        if (master != null) {
            switch (sound) {
                case "immersiveintelligence:emplacement_rotation_h": {
                    return master.target != null && master.currentWeapon != null && MathHelper.func_188209_b((int)Math.round(master.currentWeapon.yaw)) == MathHelper.func_188209_b((int)Math.round(master.target[0]));
                }
                case "immersiveintelligence:emplacement_rotation_v": {
                    return master.target != null && master.currentWeapon != null && MathHelper.func_188209_b((int)Math.round(master.currentWeapon.pitch)) == MathHelper.func_188209_b((int)Math.round(master.target[1]));
                }
                case "immersiveintelligence:welding_mid": {
                    return this.progress == 0 && master.currentWeapon != null && master.currentWeapon.health != master.currentWeapon.getMaxHealth() && master.energyStorage.getEnergyStored() >= Config.IIConfig.Machines.Emplacement.repairCost;
                }
                case "immersiveintelligence:emplacement_platform": {
                    float v = (float)master.progress / (float)Config.IIConfig.Machines.Emplacement.lidTime;
                    return !master.finishedDoorAction() && (v > 0.25f && v < 0.65f || v > 0.85f);
                }
                case "immersiveintelligence:emplacement_door_open": {
                    float v = (float)master.progress / (float)Config.IIConfig.Machines.Emplacement.lidTime;
                    return !master.finishedDoorAction() && (master.isDoorOpened ? v < 0.25f : v > 0.65f && v < 0.85f);
                }
                case "immersiveintelligence:emplacement_door_close": {
                    float v = (float)master.progress / (float)Config.IIConfig.Machines.Emplacement.lidTime;
                    return !master.finishedDoorAction() && (!master.isDoorOpened ? v < 0.25f : v > 0.65f && v < 0.85f);
                }
            }
            return false;
        }
        return false;
    }

    public boolean canOpenGui(EntityPlayer player) {
        if (this.hasOwnerRights(player)) {
            return true;
        }
        ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.notOwner", new Object[]{this.owner})});
        return false;
    }

    protected boolean hasOwnerRights(EntityPlayer player) {
        if (this.owner.isEmpty()) {
            this.owner = player.func_70005_c_();
        }
        if (player.field_71075_bZ.field_75098_d || this.owner.isEmpty()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.func_70005_c_());
    }

    public boolean canOpenGui() {
        return false;
    }

    public int getGuiID() {
        return IIGuiList.GUI_EMPLACEMENT_STORAGE.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public Light provideLight() {
        if (this.isDummy()) {
            return null;
        }
        if (this.currentWeapon != null && this.forcedRepair && this.progress == 0) {
            BlockPos pp = this.getBlockPosForPos(31);
            float f = Math.abs((float)(this.field_145850_b.func_82737_E() % 6L) / 6.0f - 0.5f) * 2.0f;
            return new Light((float)pp.func_177958_n(), (float)pp.func_177956_o(), (float)pp.func_177952_p(), (159.0f + f * 40.0f) / 255.0f, (213.0f + f * 40.0f) / 255.0f, (215.0f + f * 40.0f) / 255.0f, 1.0f, 3.0f);
        }
        return null;
    }

    public Vec3d getWeaponCenter() {
        return new Vec3d((Vec3i)this.getBlockPosForPos(49).func_177984_a()).func_72441_c(0.5, 0.0, 0.5);
    }

    private static float[] getPosForEntityTask(TileEntityEmplacement emplacement, Entity entity) {
        if (entity != null && entity.func_70089_S()) {
            Entity[] parts;
            if (entity instanceof IEntityMultiPart && (parts = entity.func_70021_al()) != null && parts.length > 0) {
                Entity t = Arrays.stream(parts).max((o1, o2) -> (int)(o1.field_70130_N * o1.field_70131_O - o2.field_70130_N * o2.field_70131_O)).orElse(parts[0]);
                return emplacement.currentWeapon.getAnglePrediction(emplacement.getWeaponCenter(), t.func_174791_d().func_72441_c((double)(-t.field_70130_N / 2.0f), (double)(t.field_70131_O / 2.0f), (double)(-t.field_70130_N / 2.0f)), new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y));
            }
            return emplacement.currentWeapon.getAnglePrediction(emplacement.getWeaponCenter(), entity.func_174791_d().func_72441_c((double)(-entity.field_70130_N / 2.0f), (double)(entity.field_70131_O / 2.0f), (double)(-entity.field_70130_N / 2.0f)), new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y));
        }
        return new float[]{emplacement.currentWeapon.yaw, emplacement.currentWeapon.pitch};
    }

    private NBTTagCompound createDefaultTask() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        NBTTagCompound taskCompound = new NBTTagCompound();
        taskCompound.func_74778_a("type", "mobs");
        taskCompound.func_74757_a("negation", false);
        list.func_74742_a((NBTBase)taskCompound);
        compound.func_74782_a("filters", (NBTBase)list);
        return compound;
    }

    static {
        targetRegistry.put("target_custom", (tagCompound, emplacement) -> new EmplacementTaskCustom((NBTTagCompound)tagCompound));
        targetRegistry.put("target_shells", (tagCompound, emplacement) -> new EmplacementTaskShells());
        targetRegistry.put("target_position", (tagCompound, emplacement) -> new EmplacementTaskPosition((NBTTagCompound)tagCompound));
        targetRegistry.put("target_entity", (tagCompound, emplacement) -> new EmplacementTaskEntity((TileEntityEmplacement)emplacement, (NBTTagCompound)tagCompound));
    }

    private static class EmplacementTaskPosition
    extends EmplacementTask {
        int shotAmount;
        final BlockPos pos;

        public EmplacementTaskPosition(BlockPos pos, int shotAmount) {
            this.pos = pos;
            this.shotAmount = shotAmount;
        }

        public EmplacementTaskPosition(NBTTagCompound tagCompound) {
            this(new BlockPos(tagCompound.func_74762_e("x"), tagCompound.func_74762_e("y"), tagCompound.func_74762_e("z")), tagCompound.func_74762_e("shotAmount"));
        }

        @Override
        public float[] getPositionVector(TileEntityEmplacement emplacement) {
            return emplacement.currentWeapon.getAnglePrediction(emplacement.getWeaponCenter(), new Vec3d((Vec3i)this.pos).func_72441_c(0.5, 0.0, 0.5), Vec3d.field_186680_a);
        }

        @Override
        public void onShot() {
            --this.shotAmount;
        }

        @Override
        public boolean shouldContinue() {
            return this.shotAmount > 0;
        }

        @Override
        public String getName() {
            return "target_position";
        }

        @Override
        public NBTTagCompound saveToNBT() {
            NBTTagCompound compound = super.saveToNBT();
            compound.func_74768_a("x", this.pos.func_177958_n());
            compound.func_74768_a("y", this.pos.func_177956_o());
            compound.func_74768_a("z", this.pos.func_177952_p());
            compound.func_74768_a("shotAmount", this.shotAmount);
            return compound;
        }

        @Override
        public void updateTargets(TileEntityEmplacement emplacement) {
        }
    }

    private static class EmplacementTaskEntity
    extends EmplacementTask {
        Entity entity;

        public EmplacementTaskEntity(Entity entity) {
            this.entity = entity;
        }

        public EmplacementTaskEntity(TileEntityEmplacement emplacement, NBTTagCompound tagCompound) {
            this(emplacement.field_145850_b.func_73045_a(tagCompound.func_74762_e("target_uuid")));
        }

        @Override
        public float[] getPositionVector(TileEntityEmplacement emplacement) {
            return TileEntityEmplacement.getPosForEntityTask(emplacement, this.entity);
        }

        @Override
        public boolean shouldContinue() {
            return this.entity != null && this.entity.func_70089_S();
        }

        @Override
        public String getName() {
            return "target_entity";
        }

        @Override
        public NBTTagCompound saveToNBT() {
            NBTTagCompound compound = super.saveToNBT();
            compound.func_74768_a("target_uuid", this.entity.func_145782_y());
            return compound;
        }

        @Override
        public void updateTargets(TileEntityEmplacement emplacement) {
        }
    }

    private static class EmplacementTaskShells
    extends EmplacementTaskEntities {
        public EmplacementTaskShells() {
            super(input -> input instanceof EntityBullet && !input.field_70128_L && (double)((EntityBullet)input).mass > 0.4);
        }

        @Override
        public String getName() {
            return "target_shells";
        }
    }

    private static class EmplacementTaskCustom
    extends EmplacementTaskEntities {
        private final NBTTagCompound tagCompound;

        public EmplacementTaskCustom(NBTTagCompound tagCompound) {
            super(EmplacementTaskCustom.buildPredicate(tagCompound));
            this.tagCompound = tagCompound;
        }

        private static Predicate<Entity> buildPredicate(NBTTagCompound nbt) {
            Predicate<Entity> mainFilter = entity -> entity != null && entity.func_70089_S();
            ArrayList<Predicate<Entity>> typeFilter = new ArrayList<Predicate<Entity>>();
            ArrayList<Predicate<Entity>> nameFilter = new ArrayList<Predicate<Entity>>();
            ArrayList<Predicate<Entity>> teamFilter = new ArrayList<Predicate<Entity>>();
            NBTTagList tagList = nbt.func_150295_c("filters", 10);
            for (NBTBase nbtBase : tagList) {
                if (!(nbtBase instanceof NBTTagCompound)) continue;
                NBTTagCompound tag = (NBTTagCompound)nbtBase;
                String filter = tag.func_74779_i("filter");
                boolean negation = tag.func_74767_n("negation");
                switch (tag.func_74779_i("type")) {
                    case "mobs": {
                        if (!filter.isEmpty()) {
                            teamFilter.add(entity -> {
                                EntityEntry entry = EntityRegistry.getEntry(entity.getClass());
                                if (entry == null) {
                                    return false;
                                }
                                return negation ^ new ResourceLocation(filter).equals((Object)entry.getRegistryName());
                            });
                            break;
                        }
                        typeFilter.add(entity -> entity instanceof IMob);
                        break;
                    }
                    case "animals": {
                        if (!filter.isEmpty()) {
                            teamFilter.add(entity -> {
                                EntityEntry entry = EntityRegistry.getEntry(entity.getClass());
                                if (entry == null) {
                                    return false;
                                }
                                return negation ^ new ResourceLocation(filter).equals((Object)entry.getRegistryName());
                            });
                            break;
                        }
                        typeFilter.add(entity -> entity instanceof EntityAnimal);
                        break;
                    }
                    case "players": {
                        typeFilter.add(entity -> entity instanceof EntityPlayer);
                    }
                    case "npcs": {
                        typeFilter.add(entity -> entity instanceof INpc);
                        break;
                    }
                    case "vehicles": {
                        typeFilter.add(entity -> entity instanceof IVehicleMultiPart);
                    }
                    case "shells": {
                        typeFilter.add(entity -> entity instanceof EntityBullet && ((EntityBullet)entity).bullet.getCaliber() >= 6.0f);
                        break;
                    }
                    case "team": {
                        if (!filter.isEmpty()) {
                            teamFilter.add(entity -> entity.func_96124_cp() != null && negation ^ entity.func_96124_cp().func_96661_b().equals(filter));
                            break;
                        }
                        teamFilter.add(entity -> entity.func_96124_cp() == null);
                        break;
                    }
                    case "name": {
                        if (!filter.isEmpty()) {
                            nameFilter.add(entity -> negation ^ entity.func_70005_c_().equals(filter));
                            break;
                        }
                        nameFilter.add(entity -> entity.func_70005_c_().isEmpty());
                    }
                }
            }
            if (typeFilter.size() > 0) {
                mainFilter = mainFilter.and(EmplacementTaskCustom.predicateFromList(typeFilter));
            }
            if (nameFilter.size() > 0) {
                mainFilter = mainFilter.and(EmplacementTaskCustom.predicateFromList(nameFilter));
            }
            if (teamFilter.size() > 0) {
                mainFilter = mainFilter.and(EmplacementTaskCustom.predicateFromList(teamFilter));
            }
            return mainFilter;
        }

        private static Predicate<Entity> predicateFromList(ArrayList<Predicate<Entity>> list) {
            Predicate<Entity> pred = list.get(0);
            if (list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    pred = pred.or(list.get(i));
                }
            }
            return pred;
        }

        @Override
        public String getName() {
            return "target_custom";
        }

        @Override
        public NBTTagCompound saveToNBT() {
            NBTTagCompound nbt = super.saveToNBT();
            nbt.func_179237_a(this.tagCompound);
            return nbt;
        }
    }

    private static abstract class EmplacementTaskEntities
    extends EmplacementTask {
        private final Predicate<Entity> predicate;
        Entity[] spottedEntities = new Entity[0];
        Entity currentTarget = null;

        public EmplacementTaskEntities(Predicate<Entity> predicate) {
            this.predicate = predicate;
        }

        @Override
        public float[] getPositionVector(TileEntityEmplacement emplacement) {
            BlockPos[] allBlocks = emplacement.getAllBlocks();
            Vec3d vEmplacement = emplacement.getWeaponCenter();
            if (this.currentTarget != null && this.predicate.test(this.currentTarget) && this.currentTarget.func_70089_S() && this.canEntityBeSeen(this.currentTarget, vEmplacement, allBlocks, 2)) {
                return TileEntityEmplacement.getPosForEntityTask(emplacement, this.currentTarget);
            }
            for (Entity entity : this.spottedEntities) {
                if (!this.canEntityBeSeen(entity, vEmplacement, allBlocks, 2)) continue;
                this.currentTarget = entity;
                return TileEntityEmplacement.getPosForEntityTask(emplacement, entity);
            }
            return null;
        }

        private boolean canEntityBeSeen(Entity entity, Vec3d vEmplacement, BlockPos[] allBlocks, int maxBlocks) {
            Vec3d vEntity = entity.func_174791_d().func_72441_c((double)(-entity.field_70130_N / 2.0f), (double)(entity.field_70131_O / 2.0f), (double)(-entity.field_70130_N / 2.0f));
            ArrayList<RayTraceResult> hits = MultipleRayTracer.volumetricTrace((World)entity.field_70170_p, (Vec3d)vEmplacement, (Vec3d)vEntity, (AxisAlignedBB)new AxisAlignedBB((double)-0.00625, (double)-0.00625, (double)-0.00625, (double)0.00625, (double)0.00625, (double)0.00625), (boolean)true, (boolean)false, (boolean)false, Collections.singletonList(entity), Arrays.asList(allBlocks)).hits;
            int h = 0;
            for (RayTraceResult hit : hits) {
                if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                    ++h;
                }
                if (h <= maxBlocks) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldContinue() {
            return true;
        }

        @Override
        public NBTTagCompound saveToNBT() {
            return super.saveToNBT();
        }

        @Override
        public void updateTargets(TileEntityEmplacement emplacement) {
            this.spottedEntities = (Entity[])emplacement.field_145850_b.func_175647_a(Entity.class, emplacement.currentWeapon.getVisionAABB(), input -> emplacement.currentWeapon.canSeeEntity((Entity)input) && this.predicate.test((Entity)input)).stream().sorted((o1, o2) -> (int)(o1.field_70130_N * o1.field_70131_O - o2.field_70130_N * o2.field_70131_O) * 10).toArray(Entity[]::new);
            if (!((TileEntityEmplacement)emplacement).field_145850_b.field_72995_K && emplacement.sendAttackSignal) {
                emplacement.handleSendingEnemyPos(this.spottedEntities);
            }
        }
    }

    public static abstract class EmplacementTask {
        public abstract float[] getPositionVector(TileEntityEmplacement var1);

        public void onShot() {
        }

        public abstract boolean shouldContinue();

        public abstract String getName();

        public NBTTagCompound saveToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", this.getName());
            return nbt;
        }

        public abstract void updateTargets(TileEntityEmplacement var1);
    }

    public static abstract class EmplacementWeapon {
        public EntityEmplacementWeapon entity = null;
        protected float pitch = 0.0f;
        protected float yaw = 0.0f;
        protected float nextPitch = 0.0f;
        protected float nextYaw = 0.0f;
        protected int health = 0;

        public abstract String getName();

        public float getYawTurnSpeed() {
            return 2.0f;
        }

        public float getPitchTurnSpeed() {
            return 2.0f;
        }

        public boolean isAimedAt(float yaw, float pitch) {
            return pitch == this.pitch && MathHelper.func_76142_g((float)yaw) == MathHelper.func_76142_g((float)this.yaw);
        }

        public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
            Vec3d vv = posTurret.func_178788_d(posTarget).func_178787_e(motion).func_72432_b();
            float yy = (float)(Math.atan2(vv.field_72450_a, vv.field_72449_c) * 180.0 / 3.1415927410125732);
            float pp = (float)Math.toDegrees(Math.atan2(vv.field_72448_b, vv.func_72438_d(new Vec3d(0.0, vv.field_72448_b, 0.0))));
            return new float[]{yy, pp};
        }

        public void aimAt(float yaw, float pitch) {
            this.nextPitch = pitch;
            this.nextYaw = MathHelper.func_76142_g((float)yaw);
            float p = pitch - this.pitch;
            this.pitch += Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)this.getPitchTurnSpeed());
            float y = MathHelper.func_76142_g((float)(360.0f + this.nextYaw - this.yaw));
            if (Math.abs(p) < this.getPitchTurnSpeed() * 0.5f) {
                this.pitch = this.nextPitch;
            }
            this.yaw = Math.abs(y) < this.getYawTurnSpeed() * 0.5f ? this.nextYaw : MathHelper.func_76142_g((float)(this.yaw + Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)this.getYawTurnSpeed())));
            this.pitch %= 180.0f;
        }

        public abstract boolean isSetUp(boolean var1);

        public void doSetUp(boolean door) {
        }

        public abstract boolean requiresPlatformRefill();

        public void init(TileEntityEmplacement te, boolean firstTime) {
            if (firstTime) {
                this.health = this.getMaxHealth();
                te.sendAttackSignal = false;
                this.pitch = -90.0f;
                this.nextPitch = -90.0f;
                if (!((TileEntityEmplacement)te).field_145850_b.field_72995_K) {
                    Vec3d vv = te.getWeaponCenter().func_178786_a(0.0, 1.0, 0.0);
                    this.entity = new EntityEmplacementWeapon(te.field_145850_b);
                    this.entity.func_70107_b(vv.field_72450_a, vv.field_72448_b, vv.field_72449_c);
                    te.field_145850_b.func_72838_d((Entity)this.entity);
                }
            }
        }

        public void tick(TileEntityEmplacement te, boolean active) {
        }

        public void shoot(TileEntityEmplacement te) {
            if (this.entity != null) {
                blusunrize.immersiveengineering.common.util.Utils.attractEnemies((EntityLivingBase)this.entity, (float)24.0f);
            }
        }

        @Nonnull
        public NBTTagCompound saveToNBT(boolean forClient) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("yaw", this.yaw);
            tag.func_74776_a("pitch", this.pitch);
            tag.func_74768_a("health", this.health);
            return tag;
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            this.yaw = tagCompound.func_74760_g("yaw");
            this.pitch = tagCompound.func_74760_g("pitch");
            this.health = tagCompound.func_74764_b("health") ? tagCompound.func_74762_e("health") : this.getMaxHealth();
        }

        public void syncWithClient(TileEntityEmplacement te) {
            if (!te.func_145831_w().field_72995_K) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("weaponName", this.getName());
                nbt.func_74782_a("currentWeapon", (NBTBase)this.saveToNBT(true));
                ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)te, nbt), Utils.targetPointFromTile((TileEntity)te, 32));
            }
        }

        public abstract boolean canShoot(TileEntityEmplacement var1);

        @Nullable
        public IFluidHandler getFluidHandler(boolean in) {
            return null;
        }

        @Nullable
        public IItemHandler getItemHandler(boolean in) {
            return null;
        }

        public void handleDataPacket(DataPacket packet) {
        }

        @SideOnly(value=Side.CLIENT)
        public void render(TileEntityEmplacement te, float partialTicks) {
        }

        @SideOnly(value=Side.CLIENT)
        public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        }

        public static MachineUpgrade register(Supplier<EmplacementWeapon> supplier) {
            EmplacementWeapon w = supplier.get();
            weaponRegistry.put(w.getName(), supplier);
            return new MachineUpgradeEmplacementWeapon(w);
        }

        public void handleSounds(@Nullable TileEntityEmplacement tile, TileEntityEmplacement master) {
            boolean n;
            TileEntityEmplacement t1 = (TileEntityEmplacement)master.getTileForPos(49);
            TileEntityEmplacement t2 = (TileEntityEmplacement)master.getTileForPos(48);
            TileEntityEmplacement t3 = (TileEntityEmplacement)master.getTileForPos(47);
            TileEntityEmplacement t4 = (TileEntityEmplacement)master.getTileForPos(46);
            TileEntityEmplacement t5 = (TileEntityEmplacement)master.getTileForPos(45);
            float[] target = master.target;
            boolean bl = n = master.task != null && target != null;
            if (t1 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IISounds.emplacement_rotation_h, (TileEntity)t1, t1.shoudlPlaySound("immersiveintelligence:emplacement_rotation_h"), 1.5f, 0.5f);
            }
            if (t2 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IISounds.emplacement_rotation_v, (TileEntity)t2, t2.shoudlPlaySound("immersiveintelligence:emplacement_rotation_v"), 1.5f, 0.5f);
            }
            if (t3 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IISounds.emplacement_platform, (TileEntity)t3, t3.shoudlPlaySound("immersiveintelligence:emplacement_platform"), 4.0f, 0.5f);
            }
            if (t4 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IISounds.emplacement_door_open, (TileEntity)t4, t4.shoudlPlaySound("immersiveintelligence:emplacement_door_open"), 4.0f, 0.5f);
            }
            if (t5 != null) {
                ImmersiveEngineering.proxy.handleTileSound(IISounds.emplacement_door_close, (TileEntity)t5, t5.shoudlPlaySound("immersiveintelligence:emplacement_door_close"), 4.0f, 0.5f);
            }
        }

        @Nonnull
        public abstract AxisAlignedBB getVisionAABB();

        public boolean canSeeEntity(Entity entity) {
            return !entity.func_82150_aj();
        }

        public void syncWithEntity(EntityEmplacementWeapon entity) {
            if (this.entity == null) {
                this.entity = entity;
            }
            if (this.entity != entity) {
                return;
            }
            entity.field_70177_z = this.yaw;
            entity.field_70125_A = this.pitch;
            entity.func_70606_j(this.health);
            entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getMaxHealth());
        }

        public abstract EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes();

        public void syncWeaponHealth(TileEntityEmplacement te) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("health", this.health);
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)te, tag), Utils.targetPointFromTile((TileEntity)te, 32));
        }

        public abstract NonNullList<ItemStack> getBaseInventory();

        @SideOnly(value=Side.CLIENT)
        public abstract void renderStorageInventory(GuiEmplacementPageStorage var1, int var2, int var3, float var4, boolean var5);

        public abstract void performPlatformRefill(TileEntityEmplacement var1);

        public abstract int getEnergyUpkeepCost();

        public abstract int getMaxHealth();

        public int getHealth() {
            return this.health;
        }

        public void applyDamage(float damage) {
            this.health = (int)((float)this.health - damage);
        }

        public boolean isDead() {
            return this.health <= 0;
        }

        @SideOnly(value=Side.CLIENT)
        public void spawnDebrisExplosion(TileEntityEmplacement te) {
            double true_angle = Math.toRadians(-this.yaw > 180.0f ? (double)(360.0f - -this.yaw) : (double)(-this.yaw));
            double true_angle2 = Math.toRadians(-this.yaw - 90.0f > 180.0f ? (double)(360.0f - (-this.yaw - 90.0f)) : (double)(-this.yaw - 90.0f));
            Random rand = new Random(431L);
            Tuple<ResourceLocation, List<ModelRendererTurbo>> stuff = this.getDebris();
            List models = (List)stuff.func_76340_b();
            ResourceLocation texture = (ResourceLocation)stuff.func_76341_a();
            Vec3d weaponCenter = te.getWeaponCenter();
            ParticleUtils.spawnExplosionBoomFX(this.entity.field_70170_p, weaponCenter.field_72450_a, weaponCenter.field_72448_b, weaponCenter.field_72449_c, 5.0f, 4.0f, true, true);
            for (ModelRendererTurbo mod : models) {
                Vec3d vx = Utils.offsetPosDirection((float)((double)mod.field_78800_c * 0.0625), true_angle, 0.0);
                Vec3d vz = Utils.offsetPosDirection((float)((double)(-mod.field_78798_e) * 0.0625), true_angle + 90.0, 0.0);
                Vec3d vo = weaponCenter.func_178787_e(vx).func_178787_e(Utils.offsetPosDirection((float)((double)mod.field_78797_d * 0.0625), -true_angle2, 0.0)).func_178787_e(vz);
                Vec3d vecDir = new Vec3d(rand.nextGaussian() * 0.075, rand.nextGaussian() * 0.15, rand.nextGaussian() * 0.075);
                ParticleUtils.spawnTMTModelFX(vo.field_72450_a, vo.field_72448_b, vo.field_72449_c, (vx.field_72450_a + vz.field_72450_a + vecDir.field_72450_a) / 1.5, (0.25 + vecDir.field_72448_b) / 1.5, (vx.field_72449_c + vz.field_72449_c + vecDir.field_72449_c) / 1.5, 0.0625f, mod, texture);
            }
        }

        @SideOnly(value=Side.CLIENT)
        protected abstract Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris();

        public static class MachineUpgradeEmplacementWeapon
        extends MachineUpgrade {
            private final EmplacementWeapon weapon;

            public MachineUpgradeEmplacementWeapon(EmplacementWeapon weapon) {
                super(weapon.getName(), new ResourceLocation("immersiveintelligence", "textures/gui/upgrade/" + weapon.getName() + ".png"));
                this.weapon = weapon;
            }

            @SideOnly(value=Side.CLIENT)
            public void render(TileEntityEmplacement te) {
                this.weapon.render(te, 0.0f);
            }

            @SideOnly(value=Side.CLIENT)
            public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
                this.weapon.renderUpgradeProgress(clientProgress, serverProgress, partialTicks);
            }
        }
    }
}

