/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal.inserter;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.DataWireNetwork;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_Connector;

public abstract class TileEntityInserterBase
extends TileEntityImmersiveConnectable
implements IIEInventory,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IHammerInteraction,
ITickable,
IEBlockInterfaces.IBlockBounds,
IDataConnector {
    public int energyStorage = 0;
    public int pickProgress = 0;
    public int takeAmount = 64;
    public EnumFacing defaultOutputFacing = EnumFacing.NORTH;
    public EnumFacing defaultInputFacing = EnumFacing.SOUTH;
    public int defaultOutputDistance = 2;
    public int defaultInputDistance = 2;
    @Nullable
    public InserterTask current = null;
    ArrayList<InserterTask> tasks = new ArrayList();
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public IItemHandler insertionHandler = new IEInventoryHandler(1, (IIEInventory)this);
    protected DataWireNetwork wireNetwork = new DataWireNetwork().add(this);
    private boolean refreshWireNetwork = false;
    private WireType secondCable;
    public boolean nextTaskAfterFinish = true;

    protected boolean canTakeLV() {
        return this.getAcceptedPowerWires().contains("LV");
    }

    protected boolean canTakeMV() {
        return this.getAcceptedPowerWires().contains("MV");
    }

    protected boolean canTakeHV() {
        return this.getAcceptedPowerWires().contains("HV");
    }

    public boolean canConnect() {
        return true;
    }

    public boolean isEnergyOutput() {
        return true;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < this.getEnergyCapacity()) {
            if (!simulate) {
                int rec = Math.min(this.getEnergyCapacity() - this.energyStorage, this.getEnergyUsage());
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(this.getEnergyCapacity() - this.energyStorage, this.getEnergyUsage());
        }
        return 0;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        int tc = this.getTargetedConnector(target);
        return this.canAttach(cableType, tc);
    }

    private boolean canAttach(WireType toAttach, int conn) {
        String attachCat = toAttach.getCategory();
        if (attachCat == null) {
            return false;
        }
        if (conn == 0) {
            return attachCat.equals("DATA") && this.limitType == null;
        }
        if (conn == 1) {
            return this.getAcceptedPowerWires().contains(attachCat) && this.secondCable == null;
        }
        return false;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                if (this.limitType != null) break;
                DataWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.wireNetwork);
                this.limitType = cableType;
                break;
            }
            case 1: {
                if (this.secondCable != null) break;
                this.secondCable = cableType;
            }
        }
        this.markContainingBlockForUpdate(null);
    }

    public WireType getCableLimiter(TargetingInfo target) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                return this.limitType;
            }
            case 1: {
                return this.secondCable;
            }
        }
        return null;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (type == null) {
            this.limitType = null;
            this.secondCable = null;
        }
        if (type == this.limitType) {
            this.wireNetwork.removeFromNetwork(this);
            this.limitType = null;
        }
        if (type == this.secondCable) {
            this.secondCable = null;
        }
        this.markContainingBlockForUpdate(null);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        boolean right = con.cableType == this.limitType;
        return this.getConnectionOffset(right);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink) {
        return this.getConnectionOffset(this.getTargetedConnector(target) == 0);
    }

    private Vec3d getConnectionOffset(boolean data) {
        if (data) {
            return new Vec3d(0.875, 0.5, 0.875);
        }
        return new Vec3d(0.125, (double)0.475f, 0.125);
    }

    public int getTargetedConnector(TargetingInfo target) {
        if (target.hitX < 1.0f && (double)target.hitX > 0.75 && target.hitZ < 1.0f && (double)target.hitZ > 0.75) {
            return 0;
        }
        return 1;
    }

    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("pickProgress")) {
            this.pickProgress = message.func_74762_e("pickProgress");
        }
        if (message.func_74764_b("takeAmount")) {
            this.takeAmount = Math.min(message.func_74762_e("takeAmount"), this.getMaxTakeAmount());
        }
        if (message.func_74764_b("nextTaskAfterFinish")) {
            this.nextTaskAfterFinish = message.func_74767_n("nextTaskAfterFinish");
        }
        if (message.func_74764_b("energyStorage")) {
            this.energyStorage = message.func_74762_e("energyStorage");
        }
        if (message.func_74764_b("outputFacing")) {
            this.defaultOutputFacing = EnumFacing.func_82600_a((int)message.func_74762_e("outputFacing"));
        }
        if (message.func_74764_b("inputFacing")) {
            this.defaultInputFacing = EnumFacing.func_82600_a((int)message.func_74762_e("inputFacing"));
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)1);
        }
        if (message.func_74764_b("tasks")) {
            this.readTasks(message.func_150295_c("tasks", 10));
        }
        if (message.func_74764_b("current")) {
            NBTTagCompound tag = message.func_74775_l("current");
            Function<NBTTagCompound, InserterTask> name = this.getAvailableTasks().get(tag.func_74779_i("name"));
            if (name != null) {
                this.current = name.apply(tag);
            }
        } else {
            this.current = null;
        }
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)1);
        }
        if (nbt.func_74764_b("pickProgress")) {
            this.pickProgress = nbt.func_74762_e("pickProgress");
        }
        if (nbt.func_74764_b("takeAmount")) {
            this.takeAmount = Math.min(nbt.func_74762_e("takeAmount"), this.getMaxTakeAmount());
        }
        if (nbt.func_74764_b("nextTaskAfterFinish")) {
            this.nextTaskAfterFinish = nbt.func_74767_n("nextTaskAfterFinish");
        }
        if (nbt.func_74764_b("defaultOutputFacing")) {
            this.defaultOutputFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("outputFacing"));
        }
        if (nbt.func_74764_b("defaultInputFacing")) {
            this.defaultInputFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("inputFacing"));
        }
        if (nbt.func_74764_b("secondCable")) {
            WireType wireType = this.secondCable = nbt.func_74764_b("secondCable") ? ApiUtils.getWireTypeFromNBT((NBTTagCompound)nbt, (String)"secondCable") : null;
        }
        if (nbt.func_74764_b("energyStorage")) {
            this.energyStorage = nbt.func_74762_e("energyStorage");
        }
        if (nbt.func_74764_b("tasks")) {
            this.readTasks(nbt.func_150295_c("tasks", 10));
        }
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        nbt.func_74768_a("pickProgress", this.pickProgress);
        nbt.func_74768_a("takeAmount", Math.min(this.takeAmount, this.getMaxTakeAmount()));
        nbt.func_74757_a("nextTaskAfterFinish", this.nextTaskAfterFinish);
        nbt.func_74768_a("outputFacing", this.defaultOutputFacing.ordinal());
        nbt.func_74768_a("inputFacing", this.defaultInputFacing.ordinal());
        if (this.secondCable != null) {
            nbt.func_74778_a("secondCable", this.secondCable.getUniqueName());
        }
        nbt.func_74782_a("tasks", (NBTBase)this.writeTasks());
        nbt.func_74768_a("energyStorage", this.energyStorage);
    }

    public NBTTagList writeTasks() {
        NBTTagList tagTasks = new NBTTagList();
        for (InserterTask task : this.tasks) {
            NBTTagCompound tag = task.toNBT();
            tag.func_74778_a("name", task.getName());
            tagTasks.func_74742_a((NBTBase)tag);
        }
        return tagTasks;
    }

    private void readTasks(NBTTagList tagTasks) {
        this.tasks.clear();
        for (NBTBase task : tagTasks) {
            if (!(task instanceof NBTTagCompound)) continue;
            NBTTagCompound tag = (NBTTagCompound)task;
            Function<NBTTagCompound, InserterTask> name = this.getAvailableTasks().get(tag.func_74779_i("name"));
            if (name == null) continue;
            this.tasks.add(name.apply(tag));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
        } else if (!this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.energyStorage > Config.IIConfig.Machines.Inserter.energyUsage) {
            this.performTasks();
        }
    }

    protected void performTasks() {
        if (this.tasks.size() == 0) {
            return;
        }
        if (this.current == null) {
            for (InserterTask task : this.tasks) {
                BlockPos posOut;
                EnumFacing facingIn = task.facingIn == null ? this.defaultInputFacing : task.facingIn;
                EnumFacing facingOut = task.facingOut == null ? this.defaultOutputFacing : task.facingOut;
                BlockPos posIn = this.field_174879_c.func_177967_a(facingIn, task.distanceIn > 0 ? task.distanceIn : this.defaultInputDistance);
                if (!task.canExecute(this, this.field_145850_b, posIn, posOut = this.field_174879_c.func_177967_a(facingOut, task.distanceOut > 0 ? task.distanceOut : this.defaultOutputDistance), facingIn, facingOut, true) || !task.canExecute(this, this.field_145850_b, posIn, posOut, facingIn, facingOut, false)) continue;
                this.current = task;
                if (this.field_145850_b.field_72995_K) break;
                this.sendUpdate();
                break;
            }
        }
        if (this.current != null) {
            EnumFacing facingIn = this.current.facingIn == null ? this.defaultInputFacing : this.current.facingIn;
            EnumFacing facingOut = this.current.facingOut == null ? this.defaultOutputFacing : this.current.facingOut;
            BlockPos posIn = this.field_174879_c.func_177967_a(facingIn, this.current.distanceIn > 0 ? this.current.distanceIn : this.defaultInputDistance);
            BlockPos posOut = this.field_174879_c.func_177967_a(facingOut, this.current.distanceOut > 0 ? this.current.distanceOut : this.defaultOutputDistance);
            int maxProgress = (int)((float)this.getPickupSpeed() * (1.0f + this.current.getTimeModifier()));
            if (this.pickProgress == 0) {
                if (!this.field_145850_b.field_72995_K) {
                    if (this.current.canExecute(this, this.field_145850_b, posIn, posOut, facingIn, facingOut, true)) {
                        this.current.execute(this, this.field_145850_b, posIn, posOut, facingIn, facingOut, true);
                        ++this.pickProgress;
                    } else {
                        this.current = null;
                    }
                    this.sendUpdate();
                } else {
                    ++this.pickProgress;
                }
            } else if (this.pickProgress == maxProgress) {
                if (!this.field_145850_b.field_72995_K) {
                    if (this.current.execute(this, this.field_145850_b, posIn, posOut, facingIn, facingOut, false)) {
                        int id = this.tasks.indexOf(this.current);
                        if (!this.current.shouldContinue()) {
                            this.tasks.remove(this.current);
                        }
                        this.current = this.tasks.size() > 0 ? this.tasks.get((id + (this.nextTaskAfterFinish ? 1 : 0)) % this.tasks.size()) : null;
                        this.pickProgress = 0;
                        this.sendUpdate();
                    }
                } else if (this.current.canExecute(this, this.field_145850_b, posIn, posOut, facingIn, facingOut, false)) {
                    this.pickProgress = 0;
                }
            } else if (this.pickProgress < maxProgress) {
                ++this.pickProgress;
            }
        }
    }

    protected void sendUpdate() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        nbt.func_74768_a("pickProgress", this.pickProgress);
        nbt.func_74768_a("takeAmount", this.takeAmount);
        nbt.func_74757_a("nextTaskAfterFinish", this.nextTaskAfterFinish);
        nbt.func_74768_a("outputFacing", this.defaultOutputFacing.ordinal());
        nbt.func_74768_a("inputFacing", this.defaultInputFacing.ordinal());
        nbt.func_74782_a("tasks", (NBTBase)this.writeTasks());
        nbt.func_74768_a("energyStorage", this.energyStorage);
        if (this.current != null) {
            NBTTagCompound cNBT = this.current.toNBT();
            cNBT.func_74778_a("name", this.current.getName());
            nbt.func_74782_a("current", (NBTBase)cNBT);
        }
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 24));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nonnull
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f};
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            this.receiveMessageFromServer(stack.func_77978_p());
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return this.current != null && this.current.overrideTakeAmount != -1 ? this.current.overrideTakeAmount : this.takeAmount;
    }

    public void doGraphicalUpdates(int slot) {
    }

    public boolean hammerUseSide(@Nonnull EnumFacing side, @Nonnull EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        EnumFacing hitside = null;
        if (Utils.isPointInRectangle(0.25, 0.75, 0.75, 1.0, hitX, hitZ)) {
            hitside = EnumFacing.SOUTH;
        } else if (Utils.isPointInRectangle(0.25, 0.0, 0.75, 0.25, hitX, hitZ)) {
            hitside = EnumFacing.NORTH;
        } else if (Utils.isPointInRectangle(0.75, 0.25, 1.0, 0.75, hitX, hitZ)) {
            hitside = EnumFacing.EAST;
        } else if (Utils.isPointInRectangle(0.0, 0.25, 0.25, 0.75, hitX, hitZ)) {
            hitside = EnumFacing.WEST;
        }
        if (hitside != null) {
            if (player.func_70093_af()) {
                if (this.defaultInputFacing == hitside) {
                    this.defaultInputFacing = EnumFacing.UP;
                }
                this.defaultOutputFacing = hitside;
            } else {
                if (this.defaultOutputFacing == hitside) {
                    this.defaultOutputFacing = EnumFacing.UP;
                }
                this.defaultInputFacing = hitside;
            }
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("inputFacing", this.defaultInputFacing.ordinal());
        nbt.func_74768_a("outputFacing", this.defaultOutputFacing.ordinal());
        ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 24));
        return true;
    }

    @Override
    public DataWireNetwork getDataNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void setDataNetwork(DataWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public void onDataChange() {
        if (!this.func_145837_r()) {
            this.func_70296_d();
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.markContainingBlockForUpdate(stateHere);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
    }

    @Override
    public void sendPacket(DataPacket packet) {
    }

    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }

    @Nonnull
    public ItemStack getTileDrop(@Nullable EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, IIBlockTypes_Connector.INSERTER.getMeta());
        ItemNBTHelper.setInt((ItemStack)stack, (String)"outputFacing", (int)this.defaultOutputFacing.ordinal());
        ItemNBTHelper.setInt((ItemStack)stack, (String)"inputFacing", (int)this.defaultInputFacing.ordinal());
        return stack;
    }

    @Nonnull
    protected abstract Set<String> getAcceptedPowerWires();

    public abstract int getPickupSpeed();

    public abstract int getEnergyUsage();

    public abstract int getEnergyCapacity();

    public abstract int getMaxTakeAmount();

    @Nonnull
    protected abstract HashMap<String, Function<NBTTagCompound, InserterTask>> getAvailableTasks();

    @SideOnly(value=Side.CLIENT)
    protected abstract void handleSounds();

    @ParametersAreNonnullByDefault
    public static abstract class InserterTask {
        @Nullable
        public EnumFacing facingIn = null;
        @Nullable
        public EnumFacing facingOut = null;
        public int distanceIn = -1;
        public int distanceOut = -1;
        IngredientStack stack = new IngredientStack("*");
        public int overrideTakeAmount = -1;
        public boolean strictAmount = false;
        boolean isJob = true;

        public InserterTask(@Nullable EnumFacing facingIn, @Nullable EnumFacing facingOut) {
            this.facingIn = facingIn;
            this.facingOut = facingOut;
        }

        public InserterTask(NBTTagCompound nbt) {
            if (nbt.func_74764_b("facingIn")) {
                this.facingIn = EnumFacing.func_82600_a((int)nbt.func_74762_e("facingIn"));
                if (nbt.func_74764_b("distanceIn")) {
                    this.distanceIn = nbt.func_74762_e("distanceIn");
                }
            }
            if (nbt.func_74764_b("facingOut")) {
                this.facingOut = EnumFacing.func_82600_a((int)nbt.func_74762_e("facingOut"));
                if (nbt.func_74764_b("distanceOut")) {
                    this.distanceOut = nbt.func_74762_e("distanceOut");
                }
            }
            nbt.func_74782_a("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
            this.isJob = nbt.func_74767_n("isJob");
            this.strictAmount = nbt.func_74767_n("strictAmount");
            if (nbt.func_74764_b("overrideTakeAmount")) {
                this.overrideTakeAmount = nbt.func_74762_e("overrideTakeAmount");
            }
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.facingIn != null) {
                nbt.func_74768_a("facingIn", this.facingIn.func_176745_a());
                if (this.distanceIn != -1) {
                    nbt.func_74768_a("distanceOut", this.distanceIn);
                }
            }
            if (this.facingOut != null) {
                nbt.func_74768_a("facingOut", this.facingOut.func_176745_a());
                if (this.distanceOut != -1) {
                    nbt.func_74768_a("distanceOut", this.distanceOut);
                }
            }
            IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("stack"));
            nbt.func_74757_a("isJob", this.isJob);
            nbt.func_74757_a("strictAmount", this.strictAmount);
            if (this.overrideTakeAmount != -1) {
                nbt.func_74768_a("overrideTakeAmount", this.overrideTakeAmount);
            }
            return nbt;
        }

        public boolean shouldContinue() {
            return true;
        }

        public abstract boolean canExecute(TileEntityInserterBase var1, World var2, BlockPos var3, BlockPos var4, EnumFacing var5, EnumFacing var6, boolean var7);

        public abstract boolean execute(TileEntityInserterBase var1, World var2, BlockPos var3, BlockPos var4, EnumFacing var5, EnumFacing var6, boolean var7);

        abstract String getName();

        public abstract float getTimeModifier();
    }
}

