/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.energy.wires.redstone.RedstoneWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.radio.IRadioDevice;
import pl.pabilo8.immersiveintelligence.api.data.radio.RadioNetwork;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;

public class TileEntityRadioExplosives
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IDirectionalTile,
IRadioDevice,
IRedstoneConnector {
    public int frequency = 0;
    public DataPacket programmedPacket = new DataPacket();
    public int coreColor = 0xFFFFFF;
    public ItemStack mineStack = ItemStack.field_190927_a;
    private static final Vec3d CONN_OFFSET = new Vec3d(0.5, 0.25, 0.5);
    public EnumFacing facing = EnumFacing.NORTH;
    protected RedstoneWireNetwork wireNetwork = new RedstoneWireNetwork().add((IRedstoneConnector)this);
    private boolean refreshWireNetwork = false;
    private boolean armed = true;

    public void readCustomNBT(NBTTagCompound nbtTagCompound, boolean b) {
        this.armed = nbtTagCompound.func_74767_n("armed");
        this.facing = EnumFacing.func_82600_a((int)nbtTagCompound.func_74762_e("facing"));
        this.readOnPlacement(null, new ItemStack(nbtTagCompound.func_74775_l("mineStack")));
    }

    public void writeCustomNBT(NBTTagCompound nbtTagCompound, boolean b) {
        nbtTagCompound.func_74757_a("armed", this.armed);
        nbtTagCompound.func_74768_a("facing", this.facing.func_176745_a());
        nbtTagCompound.func_74782_a("mineStack", (NBTBase)this.mineStack.serializeNBT());
        RadioNetwork.INSTANCE.addDevice(this);
    }

    public void explode() {
        if (!this.armed) {
            return;
        }
        RadioNetwork.INSTANCE.removeDevice(this);
        if (!this.field_145850_b.field_72995_K && this.mineStack.func_77973_b() instanceof IBullet) {
            EntityBullet bullet = BulletHelper.createBullet(this.field_145850_b, this.mineStack, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, 0.0), 1.0f);
            bullet.fuse = 1;
            this.field_145850_b.func_72838_d((Entity)bullet);
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    public float[] getBlockBounds() {
        switch (this.facing) {
            case NORTH: {
                return new float[]{0.0625f, 0.125f, 0.0f, 0.9375f, 0.875f, 0.5625f};
            }
            case SOUTH: {
                return new float[]{0.0625f, 0.125f, 0.4375f, 0.9375f, 0.875f, 1.0f};
            }
            case EAST: {
                return new float[]{0.4375f, 0.125f, 0.0625f, 1.0f, 0.875f, 0.9375f};
            }
            case WEST: {
                return new float[]{0.0f, 0.125f, 0.0625f, 0.5625f, 0.875f, 0.9375f};
            }
            case UP: {
                return new float[]{0.0625f, 0.4375f, 0.125f, 0.9375f, 1.0f, 0.875f};
            }
            case DOWN: {
                return new float[]{0.0625f, 0.0f, 0.125f, 0.9375f, 0.5625f, 0.875f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.armed && heldItem.func_77973_b().getToolClasses(heldItem).contains("IE_WIRECUTTER")) {
            heldItem.func_77972_a(8, (EntityLivingBase)player);
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            this.armed = false;
        }
        return false;
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IBullet) {
            this.mineStack = stack;
            this.coreColor = ((IBullet)item).getCore(stack).getColour();
            this.programmedPacket = new DataPacket().fromNBT(ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"programmed_data"));
        }
    }

    public ItemStack getTileDrop(@Nullable EntityPlayer player, IBlockState state) {
        return this.mineStack;
    }

    public NonNullList<ItemStack> getTileDrops(@Nullable EntityPlayer player, IBlockState state) {
        this.explode();
        return NonNullList.func_193580_a((Object)(this.armed ? ItemStack.field_190927_a : this.mineStack), (Object[])new ItemStack[0]);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void onRadioSend(DataPacket packet) {
    }

    @Override
    public boolean onRadioReceive(DataPacket packet) {
        if (packet.equals(this.programmedPacket)) {
            this.explode();
        }
        return false;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public void setFrequency(int value) {
        this.frequency = value;
    }

    @Override
    public boolean isBasicRadio() {
        return true;
    }

    @Override
    public float getRange() {
        return Config.IIConfig.Weapons.Mines.radioRange;
    }

    @Override
    public float getWeatherRangeDecrease() {
        return (float)Config.IIConfig.Weapons.Mines.weatherHarshness;
    }

    @Override
    public DimensionBlockPos getDevicePosition() {
        return new DimensionBlockPos((TileEntity)this);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return CONN_OFFSET;
    }

    protected boolean isRelay() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    public void setNetwork(RedstoneWireNetwork net) {
        this.wireNetwork = net;
    }

    public RedstoneWireNetwork getNetwork() {
        return this.wireNetwork;
    }

    public void onChange() {
        if (this.wireNetwork.getPowerOutput(0) > 0) {
            this.explode();
        }
    }

    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    public void updateInput(byte[] signals) {
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            this.wireNetwork.updateValues();
        }
    }
}

