/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.client.render.metal_device.MedicalCrateRenderer;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.TileEntityEffectCrate;

public class TileEntityMedicalCrate
extends TileEntityEffectCrate
implements IEBlockInterfaces.ITileDrop {
    public static final Predicate<FluidStack> HEALTH_POTION = resource -> resource.getFluid() == IEContent.fluidPotion && resource.tag != null && resource.tag.func_74779_i("Potion").equals("minecraft:regeneration");
    public static final Predicate<FluidStack> BOOST_POTION = resource -> resource.getFluid() == IEContent.fluidPotion && resource.tag != null && resource.tag.func_74779_i("Potion").equals("minecraft:absorption");
    public static final Predicate<ItemStack> BOOST_POTION_ITEM = resource -> resource.func_77973_b() == Items.field_151153_ao;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(Config.IIConfig.Machines.EffectCrates.mediCrateTankSize), new FluidTank(Config.IIConfig.Machines.EffectCrates.mediCrateTankSize)};
    FluidWrapper fluidWrapper = new FluidWrapper(this);
    public boolean shouldHeal = true;
    public boolean shouldBoost = true;

    public TileEntityMedicalCrate() {
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.insertionHandler = new IEInventoryHandler(4, (IIEInventory)this);
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack tileDrop = super.getTileDrop(player, state);
        ItemNBTHelper.setTagCompound((ItemStack)tileDrop, (String)"tank", (NBTTagCompound)this.tanks[0].writeToNBT(new NBTTagCompound()));
        ItemNBTHelper.setTagCompound((ItemStack)tileDrop, (String)"potion_tank", (NBTTagCompound)this.tanks[1].writeToNBT(new NBTTagCompound()));
        return tileDrop;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.tanks[0].readFromNBT(nbt.func_74775_l("tank"));
        }
        this.tanks[1].readFromNBT(nbt.func_74775_l("potion_tank"));
        this.shouldHeal = nbt.func_74767_n("shouldHeal");
        this.shouldBoost = nbt.func_74767_n("shouldBoost");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("potion_tank", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("shouldHeal", this.shouldHeal);
        nbt.func_74757_a("shouldBoost", this.shouldBoost);
    }

    @Override
    boolean isSupplied() {
        return this.shouldHeal && this.tanks[0].getFluidAmount() >= Config.IIConfig.Machines.EffectCrates.mediCrateFluidDrain || this.shouldBoost && this.tanks[1].getFluidAmount() >= Config.IIConfig.Machines.EffectCrates.mediCrateFluidDrain;
    }

    @Override
    void useSupplies() {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean u = Utils.handleBucketTankInteraction((IFluidTank[])this.tanks, (NonNullList)this.inventory, (int)0, (int)1, (int)0, (boolean)false, HEALTH_POTION);
        if (this.tanks[1].getFluidAmount() < this.tanks[1].getCapacity() - 200 && BOOST_POTION_ITEM.test((ItemStack)this.inventory.get(2))) {
            NBTTagCompound potionNBT = new NBTTagCompound();
            potionNBT.func_74778_a("Potion", "minecraft:absorption");
            if (this.tanks[1].fill(new FluidStack(IEContent.fluidPotion, 250, potionNBT), true) > 0) {
                ((ItemStack)this.inventory.get(2)).func_190918_g(1);
            }
            u = true;
        }
        if (u) {
            this.markContainingBlockForUpdate(null);
            this.doGraphicalUpdates(0);
        }
    }

    @Override
    void affectEntity(Entity entity, boolean upgraded) {
        if (!upgraded || Config.IIConfig.Machines.EffectCrates.repairCrateEnergyPerAction <= this.energyStorage) {
            boolean healed = false;
            if (entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70644_a(IIPotions.medical_treatment)) {
                if (this.shouldHeal && this.tanks[0].getFluidAmount() >= Config.IIConfig.Machines.EffectCrates.mediCrateFluidDrain) {
                    this.tanks[0].drain(Config.IIConfig.Machines.EffectCrates.mediCrateFluidDrain, true);
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(IIPotions.medical_treatment, upgraded ? 200 : 400, upgraded ? 1 : 0, true, true));
                }
                if (this.shouldBoost && this.tanks[1].getFluidAmount() >= Config.IIConfig.Machines.EffectCrates.mediCrateFluidDrain) {
                    this.tanks[1].drain(Config.IIConfig.Machines.EffectCrates.mediCrateFluidDrain, true);
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(IIPotions.iron_will, upgraded ? 200 : 400, upgraded ? 1 : 0, true, true));
                }
                healed = true;
            }
            if (!upgraded && healed) {
                this.energyStorage -= Config.IIConfig.Machines.EffectCrates.mediCrateEnergyPerAction;
            }
        }
    }

    @Override
    boolean checkEntity(Entity entity) {
        return entity instanceof EntityLivingBase;
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return new Vec3d(0.5, 0.5, 0.5);
    }

    public int getGuiID() {
        return IIGuiList.GUI_MEDICRATE.ordinal();
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderWithUpgrades(MachineUpgrade ... upgrades) {
        MedicalCrateRenderer.renderWithUpgrade(upgrades);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.hasUpgrade(IIContent.UPGRADE_INSERTER) && facing == this.facing.func_176734_d() && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasUpgrade(IIContent.UPGRADE_INSERTER) && facing == this.facing.func_176734_d() && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidWrapper;
        }
        return super.getCapability(capability, facing);
    }

    private boolean canFillTankFrom(int i, FluidStack resource) {
        return i == 0 ? HEALTH_POTION.test(resource) : BOOST_POTION.test(resource);
    }

    @Override
    public void onAnimationChangeClient(boolean state, int part) {
        if (part == 1) {
            this.shouldHeal = state;
        } else if (part == 2) {
            this.shouldBoost = state;
        } else {
            super.onAnimationChangeClient(state, part);
        }
    }

    @Override
    public void onAnimationChangeServer(boolean state, int part) {
        if (part == 1) {
            this.shouldHeal = state;
        } else if (part == 2) {
            this.shouldBoost = state;
        } else {
            super.onAnimationChangeServer(state, part);
        }
    }

    public static class FluidWrapper
    implements IFluidHandler {
        final TileEntityMedicalCrate tile;

        public FluidWrapper(TileEntityMedicalCrate tile) {
            this.tile = tile;
        }

        public IFluidTankProperties[] getTankProperties() {
            IFluidTankProperties[] array = new IFluidTankProperties[2];
            for (int i = 0; i < this.tile.tanks.length; ++i) {
                array[i] = new FluidTankProperties(this.tile.tanks[i].getFluid(), this.tile.tanks[i].getCapacity());
            }
            return array;
        }

        public int fill(FluidStack resource, boolean doFill) {
            FluidTank tank;
            int i;
            int fill = -1;
            for (i = 0; !(i >= this.tile.tanks.length || (tank = this.tile.tanks[i]) != null && this.tile.canFillTankFrom(i, resource) && tank.getFluid() != null && tank.getFluid().isFluidEqual(resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
            }
            if (fill == -1) {
                for (i = 0; !(i >= this.tile.tanks.length || (tank = this.tile.tanks[i]) != null && this.tile.canFillTankFrom(i, resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
                }
            }
            if (fill > 0) {
                this.tile.markBlockForUpdate(this.tile.field_174879_c, null);
            }
            return Math.max(fill, 0);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

