/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.DataWireNetwork;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.IDataDevice;
import pl.pabilo8.immersiveintelligence.common.wire.IIDataWireType;

public class TileEntityDataConnector
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IDataConnector,
IOBJModelCallback<IBlockState>,
IEBlockInterfaces.IBlockOverlayText {
    public EnumFacing facing = EnumFacing.DOWN;
    public int color = 0;
    protected DataWireNetwork wireNetwork = new DataWireNetwork().add(this);
    private boolean refreshWireNetwork = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
    }

    @Override
    public void setDataNetwork(DataWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public DataWireNetwork getDataNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void onDataChange() {
        if (!this.func_145837_r()) {
            this.func_70296_d();
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.markContainingBlockForUpdate(stateHere);
            this.markBlockForUpdate(this.field_174879_c.func_177972_a(this.facing), stateHere);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
        if (packet.matchesConnector(EnumDyeColor.func_176764_b((int)this.color), -1)) {
            BlockPos devicePos = this.field_174879_c.func_177972_a(this.facing);
            TileEntity device = this.field_145850_b.func_175625_s(devicePos);
            if (this.field_145850_b.func_175667_e(devicePos) && device instanceof IDataDevice) {
                IDataDevice d = (IDataDevice)device;
                d.onReceive(packet, this.facing.func_176734_d());
            }
        }
    }

    @Override
    public void sendPacket(DataPacket packet) {
        this.getDataNetwork().sendPacket(packet.setPacketColor(EnumDyeColor.func_176764_b((int)this.color)), this);
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.color = Utils.cycleInt(player.func_70093_af(), this.color, 0, 15);
        this.onDataChange();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (!cableType.getCategory().equals("DATA")) {
            return false;
        }
        return this.limitType == null;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        super.connectCable(cableType, target, other);
        DataWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.wireNetwork);
    }

    public void removeCable(@Nullable ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        this.wireNetwork.removeFromNetwork(this);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74768_a("color", this.color);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.color = nbt.func_74762_e("color");
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.func_82601_c() * (0.25 - conRadius), 0.5 + (double)side.func_96559_d() * (0.25 - conRadius), 0.5 + (double)side.func_82599_e() * (0.25 - conRadius));
    }

    public void onConnectivityUpdate(BlockPos pos, int dimension) {
        this.refreshWireNetwork = false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int inc = this.getRenderRadiusIncrease();
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - inc), (double)(this.field_174879_c.func_177956_o() - inc), (double)(this.field_174879_c.func_177952_p() - inc), (double)(this.field_174879_c.func_177958_n() + inc + 1), (double)(this.field_174879_c.func_177956_o() + inc + 1), (double)(this.field_174879_c.func_177952_p() + inc + 1));
    }

    int getRenderRadiusIncrease() {
        return IIDataWireType.DATA.getMaxLength();
    }

    public float[] getBlockBounds() {
        float length = 0.75f;
        float wMin = 0.25f;
        float wMax = 0.75f;
        switch (this.facing.func_176734_d()) {
            case UP: {
                return new float[]{wMin, 0.0f, wMin, wMax, length, wMax};
            }
            case DOWN: {
                return new float[]{wMin, 1.0f - length, wMin, wMax, 1.0f, wMax};
            }
            case SOUTH: {
                return new float[]{wMin, wMin, 0.0f, wMax, wMax, length};
            }
            case NORTH: {
                return new float[]{wMin, wMin, 1.0f - length, wMax, wMax, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, wMin, wMin, length, wMax, wMax};
            }
            case WEST: {
                return new float[]{1.0f - length, wMin, wMin, 1.0f, wMax, wMax};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer) {
            return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel", (Object[])new Object[]{I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.color).func_176762_d()), (Object[])new Object[0])})};
        }
        return new String[0];
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

