/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFermenter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnaceAdvanced;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.common.IIContent;

public class TileEntityCO2Filter
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks {
    int dummy = 0;
    public EnumFacing facing = EnumFacing.NORTH;
    public FluidTank tank = new FluidTank(1000);
    FluidWrapper fluidWrapper = new FluidWrapper(this);
    IItemHandler insertionHandler = new CO2ItemHandler(this);
    public static final HashMap<Class, CO2Handler> handlerMap = new HashMap();

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.func_74762_e("dummy");
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("noSetup", true);
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
    }

    public void func_73660_a() {
        int output;
        CO2Handler handlerBelow;
        if (!this.isDummy() && (handlerBelow = this.getHandlerBelow()) != null && (output = handlerBelow.getOutput(this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.facing.func_176734_d())))) > 0) {
            IFluidHandler capability;
            EnumFacing ff = this.facing == EnumFacing.UP ? EnumFacing.NORTH : this.facing;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a().func_177972_a(ff));
            if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ff.func_176734_d()) && (capability = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ff.func_176734_d())) != null) {
                capability.fill(new FluidStack(IIContent.gasCO2, output), true);
            }
        }
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing == EnumFacing.DOWN ? EnumFacing.UP : facing;
    }

    public EnumFacing getFacingForPlacement(EntityLivingBase placer, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        return side == EnumFacing.DOWN ? EnumFacing.UP : side;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = 1; i <= 2; ++i) {
            this.field_145850_b.func_175656_a(pos.func_177982_a(0, i, 0), state);
            ((TileEntityCO2Filter)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)i, (int)0))).dummy = i;
            ((TileEntityCO2Filter)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)i, (int)0))).facing = this.facing;
        }
    }

    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0)) instanceof TileEntityCO2Filter)) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0));
        }
    }

    public boolean isDummy() {
        return this.dummy > 0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.dummy == 1 && facing == (this.getFacing() == EnumFacing.UP ? EnumFacing.NORTH : this.facing) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (!(this.isDummy() || facing != null && facing.func_176740_k() == EnumFacing.Axis.Y || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.dummy == 1 && facing == (this.getFacing() == EnumFacing.UP ? EnumFacing.NORTH : this.facing) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidWrapper;
        }
        if (!(this.isDummy() || facing != null && facing.func_176740_k() == EnumFacing.Axis.Y || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return (T)this.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    private CO2Handler getHandlerBelow() {
        TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(this.facing.func_176734_d()));
        return te != null ? handlerMap.get(te.getClass()) : null;
    }

    static {
        handlerMap.put(TileEntityFermenter.class, new CO2Handler(){

            @Override
            public int getOutput(TileEntity tile) {
                if (!(tile instanceof TileEntityFermenter)) {
                    return 0;
                }
                if (((TileEntityFermenter)tile).field_174879_c != 0) {
                    return 0;
                }
                TileEntityFermenter fermenter = (TileEntityFermenter)((TileEntityFermenter)tile).master();
                if (fermenter == null) {
                    return 0;
                }
                int i = 0;
                for (TileEntityMultiblockMetal.MultiblockProcess process : fermenter.processQueue) {
                    if (!process.canProcess((TileEntityMultiblockMetal)fermenter) || process.processTick % Config.IIConfig.Machines.CO2Collector.fermenterCollectTime != 0) continue;
                    i += Config.IIConfig.Machines.CO2Collector.fermenterCollectAmount;
                }
                return i;
            }
        });
        handlerMap.put(TileEntityBlastFurnaceAdvanced.class, new CO2Handler(){

            @Override
            public int getOutput(TileEntity tile) {
                if (!(tile instanceof TileEntityBlastFurnaceAdvanced)) {
                    return 0;
                }
                if (((TileEntityBlastFurnaceAdvanced)tile).field_174879_c != 31) {
                    return 0;
                }
                TileEntityBlastFurnaceAdvanced furnace = (TileEntityBlastFurnaceAdvanced)((TileEntityBlastFurnaceAdvanced)tile).master();
                if (furnace == null) {
                    return 0;
                }
                return furnace.burnTime % Config.IIConfig.Machines.CO2Collector.blastFurnaceCollectTime == 0 && furnace.active ? Config.IIConfig.Machines.CO2Collector.blastFurnaceCollectAmount : 0;
            }
        });
    }

    public static abstract class CO2Handler {
        public abstract int getOutput(TileEntity var1);
    }

    public static class CO2ItemHandler
    implements IItemHandlerModifiable {
        TileEntityCO2Filter tile;

        public CO2ItemHandler(TileEntityCO2Filter tile) {
            this.tile = tile;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            IItemHandler handlerBelow = this.getHandlerBelow();
            if (handlerBelow != null) {
                return handlerBelow.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            IItemHandler handlerBelow = this.getHandlerBelow();
            if (handlerBelow != null) {
                return handlerBelow.getSlotLimit(slot);
            }
            return 64;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }

        @Nullable
        public IItemHandler getHandlerBelow() {
            TileEntity te = this.tile.func_145831_w().func_175625_s(this.tile.field_174879_c.func_177977_b());
            return te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) : null;
        }
    }

    public static class FluidWrapper
    implements IFluidHandler {
        final TileEntityCO2Filter tile;

        public FluidWrapper(TileEntityCO2Filter tile) {
            this.tile = tile;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.tile.tank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

