/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.fortification;

import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.common.blocks.BlockIIBase;
import pl.pabilo8.immersiveintelligence.common.blocks.fortification.TileEntityChainFence;

public abstract class BlockIIFenceBase<E extends Enum<E>>
extends BlockIIBase<E>
implements ITileEntityProvider {
    public static final PropertyBool FORCED_POST = PropertyBool.func_177716_a((String)"forced_post");

    public BlockIIFenceBase(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object ... additionalProperties) {
        super(name, material, mainProperty, itemBlock, BlockWall.field_176254_b, BlockWall.field_176258_N, BlockWall.field_176259_O, BlockWall.field_176257_M, BlockWall.field_176256_a, FORCED_POST, additionalProperties);
    }

    protected IBlockState getInitDefaultState() {
        return super.getInitDefaultState().func_177226_a((IProperty)FORCED_POST, (Comparable)Boolean.valueOf(false));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityChainFence();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState connector = world.func_180495_p(pos.func_177972_a(facing));
        return connector.func_177230_c() instanceof BlockIIFenceBase;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean contacts;
        state = super.func_176221_a(state, world, pos);
        boolean north = Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.NORTH, (Material)this.field_149764_J);
        boolean south = Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.SOUTH, (Material)this.field_149764_J);
        boolean east = Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.EAST, (Material)this.field_149764_J);
        boolean west = Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.WEST, (Material)this.field_149764_J);
        boolean forced = false;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityChainFence) {
            forced = ((TileEntityChainFence)te).hasPost;
        }
        boolean none = !north && !south && !east && !west;
        boolean corner = north && east || north && west || south && east || south && west;
        boolean bl = contacts = (north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0) == 2;
        if (none || corner || !contacts) {
            forced = false;
        }
        return state.func_177226_a((IProperty)BlockWall.field_176254_b, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)BlockWall.field_176258_N, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)BlockWall.field_176257_M, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)BlockWall.field_176259_O, (Comparable)Boolean.valueOf(west)).func_177226_a((IProperty)FORCED_POST, (Comparable)Boolean.valueOf(forced)).func_177226_a((IProperty)BlockWall.field_176256_a, (Comparable)Boolean.valueOf(forced || none || corner || !contacts));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        BlockIIFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.field_185671_f);
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176526_a)).booleanValue()) {
            BlockIIFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.field_185668_C);
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176525_b)).booleanValue()) {
            BlockIIFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.field_185669_D);
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176527_M)).booleanValue()) {
            BlockIIFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.field_185672_g);
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockFence.field_176528_N)).booleanValue()) {
            BlockIIFenceBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.field_185667_B);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.WEST, (Material)this.field_149764_J) ? 0.0 : 0.375, 0.0, Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.NORTH, (Material)this.field_149764_J) ? 0.0 : 0.375, Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.EAST, (Material)this.field_149764_J) ? 1.0 : 0.625, 1.0, Utils.canFenceConnectTo((IBlockAccess)world, (BlockPos)pos, (EnumFacing)EnumFacing.SOUTH, (Material)this.field_149764_J) ? 1.0 : 0.625);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        return PathNodeType.FENCE;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityChainFence && Utils.isHammer((ItemStack)player.func_184586_b(hand))) {
            ((TileEntityChainFence)te).hasPost = !((TileEntityChainFence)te).hasPost;
            IBlockState newstate = this.func_176221_a(state.func_177226_a((IProperty)FORCED_POST, (Comparable)Boolean.valueOf(((TileEntityChainFence)te).hasPost)), (IBlockAccess)world, pos);
            world.func_175656_a(pos, newstate);
            world.func_175641_c(pos, newstate.func_177230_c(), 255, 0);
            return true;
        }
        return false;
    }
}

