/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.MultiblockConveyorScanner;

public abstract class MultiblockStuctureBase<T extends TileEntityMultiblockPart<T>>
implements MultiblockHandler.IMultiblock {
    static final TemplateManager RES_LOC_TEMPLATE_MANAGER = new TemplateManager("Blue Sunrise is a wanker", DataFixesManager.func_188279_a());
    private final ResourceLocation loc;
    private final String name;
    private Template template;
    private IngredientStack[] materials = null;
    private ItemStack[][][] structure = null;
    private IngredientStack[][][] checkStructure = null;
    protected Vec3i offset = Vec3i.field_177959_e;
    private Vec3i size = Vec3i.field_177959_e;
    private float manualScale = 0.0f;
    private T te;

    public MultiblockStuctureBase(ResourceLocation loc) {
        this.loc = loc;
        String[] split = loc.func_110623_a().split("/");
        this.name = "II:" + Utils.toCamelCase(split[split.length - 1], false);
    }

    public void updateStructure() {
        this.template = RES_LOC_TEMPLATE_MANAGER.func_186237_a(null, this.loc);
        this.size = this.template.func_186259_a();
        this.manualScale = 10.0f / ((float)Math.max(Math.max(this.size.func_177958_n(), this.size.func_177952_p()), this.size.func_177956_o()) / 7.0f);
        this.structure = new ItemStack[this.size.func_177956_o()][this.size.func_177952_p()][this.size.func_177958_n()];
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    this.structure[y][z][x] = ItemStack.field_190927_a;
                }
            }
        }
        this.checkStructure = new IngredientStack[this.size.func_177956_o()][this.size.func_177952_p()][this.size.func_177958_n()];
        List blocks = this.template.field_186270_a;
        HashSet<IngredientStack> matsSet = new HashSet<IngredientStack>();
        for (Template.BlockInfo info : blocks) {
            IngredientStack here = this.getIngredientStackForBlockInfo(info);
            if (here.getExampleStack().func_190926_b()) continue;
            this.structure[info.field_186242_a.func_177956_o()][info.field_186242_a.func_177952_p()][info.field_186242_a.func_177958_n()] = here.getExampleStack();
            this.checkStructure[info.field_186242_a.func_177956_o()][info.field_186242_a.func_177952_p()][info.field_186242_a.func_177958_n()] = here;
            Optional<IngredientStack> match = matsSet.stream().filter(arg_0 -> ((IngredientStack)here).equals(arg_0)).findAny();
            if (match.isPresent()) {
                ++match.get().inputSize;
                continue;
            }
            matsSet.add(here);
        }
        this.materials = matsSet.toArray(new IngredientStack[0]);
    }

    public String getUniqueName() {
        return this.name;
    }

    public boolean isBlockTrigger(IBlockState state) {
        return this.checkState(state, this.checkStructure[this.offset.func_177956_o()][this.offset.func_177952_p()][this.offset.func_177958_n()], null, null);
    }

    public boolean createStructure(World world, BlockPos startPos, EnumFacing side, EntityPlayer player) {
        ItemStack hammer;
        if ((side = side.func_176734_d()) == EnumFacing.UP || side == EnumFacing.DOWN) {
            side = EnumFacing.func_176733_a((double)player.field_70177_z);
        }
        boolean mirrored = false;
        boolean b = this.structureCheck(world, startPos, side, false);
        if (!b) {
            mirrored = true;
            b = this.structureCheck(world, startPos, side, true);
        }
        if (!b) {
            return false;
        }
        ItemStack itemStack = hammer = player.func_184614_ca().func_77973_b().getToolClasses(player.func_184614_ca()).contains("IE_HAMMER") ? player.func_184614_ca() : player.func_184592_cb();
        if (MultiblockHandler.fireMultiblockFormationEventPost((EntityPlayer)player, (MultiblockHandler.IMultiblock)this, (BlockPos)startPos, (ItemStack)hammer).isCanceled()) {
            return false;
        }
        for (int h = -this.offset.func_177956_o(); h < this.size.func_177956_o() - this.offset.func_177956_o(); ++h) {
            for (int l = -this.offset.func_177952_p(); l < this.size.func_177952_p() - this.offset.func_177952_p(); ++l) {
                for (int w = -this.offset.func_177958_n(); w < this.size.func_177958_n() - this.offset.func_177958_n(); ++w) {
                    if (this.structure[h + this.offset.func_177956_o()][l + this.offset.func_177952_p()][w + this.offset.func_177958_n()].func_190926_b()) continue;
                    int ww = mirrored ? -w : w;
                    BlockPos pos2 = startPos.func_177967_a(side, l).func_177967_a(side.func_176746_e(), ww).func_177982_a(0, h, 0);
                    T tile = this.placeTile(world, pos2);
                    if (tile == null) continue;
                    ((TileEntityMultiblockPart)tile).facing = side;
                    ((TileEntityMultiblockPart)tile).mirrored = mirrored;
                    ((TileEntityMultiblockPart)tile).formed = true;
                    ((TileEntityMultiblockPart)tile).field_174879_c = (h + this.offset.func_177956_o()) * this.size.func_177952_p() * this.size.func_177958_n() + (l + this.offset.func_177952_p()) * this.size.func_177958_n() + w + this.offset.func_177958_n();
                    ((TileEntityMultiblockPart)tile).offset = new int[]{side == EnumFacing.WEST ? -l + 1 : (side == EnumFacing.EAST ? l - 1 : (side == EnumFacing.NORTH ? ww : -ww)), h, side == EnumFacing.NORTH ? -l + 1 : (side == EnumFacing.SOUTH ? l - 1 : (side == EnumFacing.EAST ? ww : -ww))};
                    tile.func_70296_d();
                    this.addBlockEvent(world, pos2);
                }
            }
        }
        return true;
    }

    protected boolean structureCheck(World world, BlockPos startPos, EnumFacing dir, boolean mirror) {
        for (int h = -this.offset.func_177956_o(); h < this.size.func_177956_o() - this.offset.func_177956_o(); ++h) {
            for (int l = -this.offset.func_177952_p(); l < this.size.func_177952_p() - this.offset.func_177952_p(); ++l) {
                for (int w = -this.offset.func_177958_n(); w < this.size.func_177958_n() - this.offset.func_177958_n(); ++w) {
                    if (this.structure[h + this.offset.func_177956_o()][l + this.offset.func_177952_p()][w + this.offset.func_177958_n()].func_190926_b()) continue;
                    int ww = mirror ? -w : w;
                    BlockPos pos = startPos.func_177967_a(dir, l).func_177967_a(dir.func_176746_e(), ww).func_177982_a(0, h, 0);
                    if (this.checkState(world.func_180495_p(pos), this.checkStructure[h + this.offset.func_177956_o()][l + this.offset.func_177952_p()][w + this.offset.func_177958_n()], world, pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected abstract void addBlockEvent(World var1, BlockPos var2);

    @Nullable
    protected abstract T placeTile(World var1, BlockPos var2);

    public ItemStack[][][] getStructureManual() {
        return this.structure;
    }

    public IngredientStack[] getTotalMaterials() {
        return this.materials;
    }

    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        if (stack.func_77973_b() instanceof ItemBlockIEBase && ((ItemBlockIEBase)stack.func_77973_b()).func_179223_d() == IEContent.blockConveyor) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            ClientUtils.mc().func_175599_af().func_181564_a(MultiblockConveyorScanner.conveyorStack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
            return true;
        }
        return false;
    }

    public float getManualScale() {
        return this.manualScale * 0.85f;
    }

    public boolean canRenderFormedStructure() {
        return true;
    }

    public void renderFormedStructure() {
        if (this.te == null) {
            this.te = this.getMBInstance();
            ((TileEntityMultiblockPart)this.te).facing = EnumFacing.NORTH;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.size.func_177958_n() / 2.0f - (float)this.offset.func_177958_n()), (float)((float)this.size.func_177956_o() / 2.0f - (float)this.offset.func_177956_o()), (float)((float)this.size.func_177952_p() / 2.0f - (float)this.offset.func_177952_p()));
        ImmersiveIntelligence.proxy.renderTile((TileEntity)this.te);
        GlStateManager.func_179121_F();
    }

    protected abstract T getMBInstance();

    private boolean checkState(IBlockState state, IngredientStack stack, @Nullable World world, @Nullable BlockPos pos) {
        if (stack.stack.func_77973_b() instanceof ItemBlockIEBase && ((ItemBlockIEBase)stack.stack.func_77973_b()).func_179223_d() == IEContent.blockConveyor) {
            if (world != null) {
                return ConveyorHandler.isConveyor((World)world, (BlockPos)pos, (String)ItemNBTHelper.getString((ItemStack)stack.stack, (String)"conveyorType"), null);
            }
            return state.func_177230_c() == IEContent.blockConveyor;
        }
        return stack.matchesItemStackIgnoringSize(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
    }

    private IngredientStack getIngredientStackForBlockInfo(Template.BlockInfo info) {
        IBlockState state = info.field_186243_b;
        if (state.func_177230_c() == IEContent.blockConveyor) {
            ItemStack conveyorStack = ConveyorHandler.getConveyorStack((String)info.field_186244_c.func_74779_i("conveyorBeltSubtype"));
            ItemNBTHelper.setInt((ItemStack)conveyorStack, (String)"conveyorFacing", (int)info.field_186244_c.func_74762_e("facing"));
            return new IngredientStack(conveyorStack).setUseNBT(true);
        }
        int meta = state.func_177230_c().func_176201_c(state);
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, meta);
        try {
            int[] oids = OreDictionary.getOreIDs((ItemStack)stack);
            if (oids.length > 0) {
                return new IngredientStack(OreDictionary.getOreName((int)oids[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new IngredientStack(stack);
    }

    public int[] getSize() {
        return new int[]{this.size.func_177956_o(), this.size.func_177952_p(), this.size.func_177958_n()};
    }

    public Tuple<ResourceLocation, EnumFacing> getConveyorKey(int h, int l, int w, EnumFacing facing) {
        IngredientStack is = this.checkStructure[h][l][w];
        ResourceLocation rl = new ResourceLocation(ItemNBTHelper.getString((ItemStack)is.stack, (String)"conveyorType"));
        EnumFacing sf = EnumFacing.func_82600_a((int)ItemNBTHelper.getInt((ItemStack)is.stack, (String)"conveyorFacing"));
        EnumFacing ff = EnumFacing.func_176731_b((int)(sf.func_176736_b() + facing.func_176736_b()));
        return new Tuple((Object)rl, (Object)ff);
    }
}

