/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammunition_system.factory;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.common.entity.EntityGasCloud;

public class BulletComponentFluid
implements IBulletComponent {
    Fluid fluid;
    String name;

    public BulletComponentFluid(Fluid fluid) {
        this.fluid = fluid;
        this.name = fluid.getName();
    }

    @Override
    public String getName() {
        return (this.fluid.isGaseous() ? "gas_" : "fluid_") + this.name;
    }

    @Override
    public IngredientStack getMaterial() {
        return new IngredientStack(new FluidStack(this.fluid, 1000));
    }

    @Override
    public float getDensity() {
        return (float)Math.max(this.fluid.getDensity(), 0) / 1000.0f;
    }

    @Override
    public void onEffect(float amount, BulletRegistry.EnumCoreTypes coreType, NBTTagCompound tag, Vec3d pos, Vec3d dir, World world) {
        if (world.field_72995_K) {
            return;
        }
        Vec3d v = new Vec3d(0.0, -1.0, 0.0);
        BlockPos p = new BlockPos(pos);
        Vec3d throwerPos = new Vec3d((Vec3i)p.func_177967_a(EnumFacing.UP, 3));
        if (this.fluid.isGaseous()) {
            EntityGasCloud gasCloud = new EntityGasCloud(world, throwerPos.field_72450_a + v.field_72450_a * 2.0, throwerPos.field_72448_b + v.field_72448_b * 2.0, throwerPos.field_72449_c + v.field_72449_c * 2.0, new FluidStack(this.fluid, (int)(amount * 1000.0f)));
            world.func_72838_d((Entity)gasCloud);
        } else {
            int i;
            if ((double)amount >= 0.5 && this.fluid.canBePlacedInWorld()) {
                for (i = 0; i < 5; ++i) {
                    if (!world.func_175623_d(p.func_177981_b(i))) continue;
                    world.func_175656_a(p.func_177981_b(i), this.fluid.getBlock().func_176223_P());
                }
            }
            i = 0;
            while ((float)i < 100.0f * amount) {
                Vec3d vecDir = v.func_72441_c(Utils.RAND.nextGaussian() * 0.25, Utils.RAND.nextGaussian() * 0.25, Utils.RAND.nextGaussian() * 0.25);
                EntityChemthrowerShot shot = new EntityChemthrowerShot(world, throwerPos.field_72450_a + v.field_72450_a * 2.0, throwerPos.field_72448_b + v.field_72448_b * 2.0, throwerPos.field_72449_c + v.field_72449_c * 2.0, 0.0, 0.0, 0.0, new FluidStack(this.fluid, (int)(amount * 1000.0f)));
                shot.field_70159_w = vecDir.field_72450_a * 2.0;
                shot.field_70181_x = vecDir.field_72448_b * (double)0.05f;
                shot.field_70179_y = vecDir.field_72449_c * 2.0;
                world.func_72838_d((Entity)shot);
                ++i;
            }
        }
    }

    @Override
    public BulletRegistry.EnumComponentRole getRole() {
        return BulletRegistry.EnumComponentRole.CHEMICAL;
    }

    @Override
    public int getColour() {
        return this.fluid.getColor();
    }

    @Override
    public boolean showInManual() {
        return false;
    }
}

