/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammunition_system.emplacement_weapons;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.client.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.gui.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletMagazine;

public class EmplacementWeaponCPDS
extends TileEntityEmplacement.EmplacementWeapon {
    private AxisAlignedBB vision;
    int reloadDelay = 0;
    int bulletsShot = 0;
    private Vec3d vv;
    float shootDelay = 0.0f;
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    NonNullList<ItemStack> inventoryPlatform = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int casingsToDrop = 0;
    private boolean requiresPlatformRefill = false;
    ArrayDeque<ItemStack> magazine = new ArrayDeque();
    private ItemStack s2 = ItemStack.field_190927_a;
    private final IItemHandler inventoryHandler = new ItemStackHandler(this.inventory){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "cpds_drum"), (boolean)false)) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack itemStack = super.insertItem(slot, stack, simulate);
            EmplacementWeaponCPDS.this.inventory.set(slot, this.stacks.get(slot));
            return itemStack;
        }
    };

    @Override
    public String getName() {
        return "cpds";
    }

    @Override
    public float getYawTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.CPDS.yawRotateSpeed;
    }

    @Override
    public float getPitchTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.CPDS.pitchRotateSpeed;
    }

    @Override
    public void shoot(TileEntityEmplacement te) {
        super.shoot(te);
        if (!te.func_145831_w().field_72995_K) {
            ItemStack itemStack = this.s2 = this.magazine.size() > 0 ? this.magazine.removeFirst() : ItemStack.field_190927_a;
            if (!this.s2.func_190926_b()) {
                te.func_145831_w().func_184148_a(null, (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), IISounds.autocannon_firing, SoundCategory.PLAYERS, 2.0f, 1.25f);
                EntityBullet a = BulletHelper.createBullet(te.func_145831_w(), this.s2, te.getWeaponCenter(), this.vv.func_186678_a(-1.0), 3.0f);
                a.setShootPos(te.getAllBlocks());
                if (this.entity != null) {
                    a.setShooters((Entity)this.entity, (Entity[])this.entity.partArray);
                }
                te.func_145831_w().func_72838_d((Entity)a);
            }
        } else if (this.magazine.size() > 0) {
            Vec3d weaponCenter = te.getWeaponCenter().func_178787_e(this.vv.func_186678_a(-2.5));
            Vec3d vg = this.vv.func_186678_a(4.0);
            ParticleUtils.spawnGunfireFX(weaponCenter.field_72450_a, weaponCenter.field_72448_b, weaponCenter.field_72449_c, vg.field_72450_a, vg.field_72448_b, vg.field_72449_c, 4.0f);
            this.magazine.removeFirst();
        }
        ++this.casingsToDrop;
        this.bulletsShot = (this.bulletsShot + 1) % 4;
        if (this.magazine.size() > 0 && this.shootDelay < 20.0f) {
            this.shootDelay += 6.0f;
        }
    }

    @Override
    public boolean isSetUp(boolean door) {
        return true;
    }

    @Override
    public boolean requiresPlatformRefill() {
        return this.requiresPlatformRefill;
    }

    @Override
    public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
        float force = IIContent.itemAmmoMachinegun.getDefaultVelocity() * 3.0f;
        this.s2 = this.magazine.size() > 0 ? this.magazine.peekFirst() : ItemStack.field_190927_a;
        float mass = this.s2.func_190926_b() ? 0.0f : IIContent.itemAmmoMachinegun.getMass(this.s2);
        this.vv = posTurret.func_178788_d(posTarget.func_178787_e(motion.func_186678_a(1.0 + EmplacementWeaponCPDS.getInterceptTime(force, posTurret.func_178788_d(posTarget), motion))));
        double gravityMotionY = 0.0;
        double motionY = 0.0;
        double baseMotionY = this.vv.func_72432_b().field_72448_b;
        for (double dist = this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0)); dist > 0.0; dist -= (double)(EntityBullet.DEV_SLOMO * force)) {
            force -= 0.0f * force * EntityBullet.DEV_SLOMO;
            double baseMotionYC = baseMotionY * (double)(force / (IIContent.itemAmmoMachinegun.getDefaultVelocity() * 3.0f));
            motionY += (baseMotionYC + (gravityMotionY -= (double)(0.15f * mass * EntityBullet.DEV_SLOMO))) * (double)EntityBullet.DEV_SLOMO;
        }
        this.vv = this.vv.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        float yy = (float)(Math.atan2(this.vv.field_72450_a, this.vv.field_72449_c) * 180.0 / 3.1415927410125732);
        float pp = (float)Math.toDegrees(Math.atan2(this.vv.field_72448_b, this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0))));
        return new float[]{yy, pp};
    }

    public static double getInterceptTime(float bulletVelocity, Vec3d targetPosRelative, Vec3d targetMotionRelative) {
        double c;
        double velocitySquared = targetMotionRelative.func_189985_c();
        if (velocitySquared < (double)0.001f) {
            return 0.0;
        }
        double a = velocitySquared - (double)(bulletVelocity * bulletVelocity);
        if (Math.abs(a) < (double)0.001f) {
            double t = -targetPosRelative.func_189985_c() / (2.0 * targetMotionRelative.func_72430_b(targetPosRelative));
            return Math.max(t, 0.0);
        }
        double b = 2.0 * targetMotionRelative.func_72430_b(targetPosRelative);
        double determinant = b * b - 4.0 * a * (c = targetPosRelative.func_189985_c());
        if (determinant > 0.0) {
            double t1 = (-b + Math.sqrt(determinant)) / (2.0 * a);
            double t2 = (-b - Math.sqrt(determinant)) / (2.0 * a);
            if (t1 > 0.0) {
                if (t2 > 0.0) {
                    return Math.min(t1, t2);
                }
                return t1;
            }
            return Math.max(t2, 0.0);
        }
        if (determinant < 0.0) {
            return 0.0;
        }
        return Math.max(-b / (2.0 * a), 0.0);
    }

    @Override
    public void init(TileEntityEmplacement te, boolean firstTime) {
        super.init(te, firstTime);
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_186662_g((double)Config.IIConfig.Weapons.EmplacementWeapons.CPDS.detectionRadius);
    }

    @Override
    public void tick(TileEntityEmplacement te, boolean active) {
        if (active && this.magazine.isEmpty()) {
            if (this.reloadDelay == 0) {
                if (this.inventoryPlatform.stream().anyMatch(stack -> OreDictionary.itemMatches((ItemStack)stack, (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "cpds_drum"), (boolean)false) && ItemIIBulletMagazine.getRemainingBulletCount(stack) > 0)) {
                    this.reloadDelay = 1;
                } else {
                    this.requiresPlatformRefill = true;
                }
            } else {
                ++this.reloadDelay;
            }
            if (this.reloadDelay >= Config.IIConfig.Weapons.EmplacementWeapons.CPDS.reloadTime) {
                for (ItemStack stack2 : this.inventoryPlatform) {
                    if (!OreDictionary.itemMatches((ItemStack)stack2, (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "cpds_drum"), (boolean)false) || ItemIIBulletMagazine.getRemainingBulletCount(stack2) <= 0) continue;
                    this.magazine.addAll((Collection<ItemStack>)ItemIIBulletMagazine.takeAll(stack2));
                    break;
                }
                this.reloadDelay = 0;
                this.syncWithClient(te);
            }
        }
        if (this.shootDelay > 0.0f) {
            this.shootDelay -= 1.0f;
        }
    }

    @Override
    public NBTTagCompound saveToNBT(boolean forClient) {
        NBTTagCompound nbt = super.saveToNBT(forClient);
        nbt.func_74768_a("reloadDelay", this.reloadDelay);
        nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        nbt.func_74782_a("inventoryPlatform", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventoryPlatform));
        if (!forClient) {
            nbt.func_74782_a("magazine", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.magazine));
        }
        nbt.func_74768_a("magazine_amount", this.magazine.size());
        nbt.func_74757_a("requiresPlatformRefill", this.requiresPlatformRefill);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.reloadDelay = tagCompound.func_74762_e("reloadDelay");
        this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventory", 10), (int)this.inventory.size());
        this.inventoryPlatform = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventoryPlatform", 10), (int)this.inventoryPlatform.size());
        this.magazine = new ArrayDeque(blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("magazine", 10), (int)tagCompound.func_74762_e("magazine_amount")));
        this.requiresPlatformRefill = tagCompound.func_74767_n("requiresPlatformRefill");
    }

    @Override
    public boolean canShoot(TileEntityEmplacement te) {
        return this.vv != null && te.isDoorOpened && this.magazine.size() > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityEmplacement te, float partialTicks) {
        GlStateManager.func_179094_E();
        float p = this.nextPitch - this.pitch;
        float y = this.nextYaw - this.yaw;
        boolean power = te.energyStorage.getEnergyStored() >= this.getEnergyUpkeepCost();
        float pp = this.pitch + (power ? Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)1.0f) * partialTicks * this.getPitchTurnSpeed() : 0.0f);
        float yy = this.yaw + (power ? Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)1.0f) * partialTicks * this.getYawTurnSpeed() : 0.0f);
        float f = ((float)(te.func_145831_w().func_82737_E() % 4L) + partialTicks) / 4.0f * (this.shootDelay / 20.0f);
        Utils.bindTexture(EmplacementRenderer.textureCPDS);
        GlStateManager.func_179114_b((float)yy, (float)0.0f, (float)1.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelCPDS.baseModel) {
            mod.render();
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelCPDS.internalsModel) {
            mod.render();
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelCPDS.hatchModel) {
            mod.render();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.96875f, (float)-0.15625f);
        float idle = MathHelper.func_76134_b((float)(((float)te.func_145831_w().func_82737_E() + partialTicks) % 2000.0f * 0.09f)) * 0.05f + 0.05f;
        GlStateManager.func_179114_b((float)(this.isAimedAt(this.nextYaw, this.nextPitch) ? idle * 225.0f - 35.0f : this.nextPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelCPDS.observeModel) {
            mod.render();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)0.0, (double)1.21875, (double)0.46875);
        GlStateManager.func_179114_b((float)pp, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelCPDS.gunModel) {
            mod.render();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-0.03125f, (float)-0.03125f);
        GlStateManager.func_179114_b((float)(f * 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelCPDS.barrelsModel) {
            mod.render();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        GlStateManager.func_179094_E();
        int req = IIContent.UPGRADE_EMPLACEMENT_WEAPON_CPDS.getProgressRequired();
        int l = EmplacementRenderer.modelCPDSConstruction.length;
        double maxClientProgress = Utils.getMaxClientProgress(serverProgress, req, l);
        double cc = (int)Math.min((double)((float)clientProgress + partialTicks * ((float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f)), maxClientProgress);
        double progress = MathHelper.func_151237_a((double)(cc / (double)req), (double)0.0, (double)1.0);
        Utils.bindTexture(EmplacementRenderer.textureCPDS);
        int i = 0;
        while ((double)i < (double)l * progress) {
            if ((long)(1 + i) > Math.round((double)l * progress)) {
                GlStateManager.func_179094_E();
                double scale = 1.0 - progress * (double)l % 1.0 / 1.0;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.min(scale, 1.0)));
                GlStateManager.func_179137_b((double)0.0, (double)(scale * 1.5), (double)0.0);
                EmplacementRenderer.modelCPDSConstruction[i].func_78785_a(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            } else {
                EmplacementRenderer.modelCPDSConstruction[i].func_78785_a(0.0625f);
            }
            ++i;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.func_179109_b((float)0.03125f, (float)0.0f, (float)-0.01325f);
        ShaderUtil.blueprint_static(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        i = l - 1;
        while ((double)i >= Math.max((double)l * progress - 1.0, 0.0)) {
            EmplacementRenderer.modelCPDSConstruction[i].func_78785_a(0.0625f);
            --i;
        }
        ShaderUtil.releaseShader();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @Override
    public AxisAlignedBB getVisionAABB() {
        return this.vision;
    }

    @Override
    public void syncWithEntity(EntityEmplacementWeapon entity) {
        super.syncWithEntity(entity);
        if (entity == this.entity) {
            entity.aabb = new AxisAlignedBB(-3.0, 0.0, -3.0, 3.0, 3.0, 3.0);
        }
    }

    @Override
    public EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes() {
        if (this.entity == null) {
            return new EntityEmplacementWeapon.EmplacementHitboxEntity[0];
        }
        ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity> list = new ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity>();
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBox", 2.0f, 0.75f, new Vec3d(0.0, 0.75, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "topBox", 1.75f, 1.25f, new Vec3d(0.25, 1.25, 0.0), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "camera", 0.75f, 0.75f, new Vec3d(-0.125, 2.25, -0.625), Vec3d.field_186680_a, 6));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel1", 0.5f, 0.5f, new Vec3d(0.0, 1.0, 0.0), new Vec3d(-1.25, 0.0, -0.25), 20));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel2", 0.5f, 0.5f, new Vec3d(0.0, 1.0, 0.0), new Vec3d(-1.75, 0.0, -0.25), 20));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel3", 0.5f, 0.5f, new Vec3d(0.0, 1.0, 0.0), new Vec3d(-2.25, 0.0, -0.25), 20));
        return list.toArray(new EntityEmplacementWeapon.EmplacementHitboxEntity[0]);
    }

    @Override
    public NonNullList<ItemStack> getBaseInventory() {
        return this.inventory;
    }

    @Override
    public void performPlatformRefill(TileEntityEmplacement te) {
        while (this.casingsToDrop > 0) {
            te.doProcessOutput(IIContent.itemAmmoMachinegun.getCasingStack(Math.min(this.casingsToDrop, 24)));
            this.casingsToDrop = Math.max(this.casingsToDrop - 24, 0);
        }
        for (int i = 0; i < this.inventoryPlatform.size(); ++i) {
            te.doProcessOutput((ItemStack)this.inventoryPlatform.get(i));
            this.inventoryPlatform.set(i, (Object)ItemStack.field_190927_a);
        }
        int moved = 0;
        for (int i = 0; i < this.inventory.size() && moved < this.inventoryPlatform.size(); ++i) {
            ItemStack s = (ItemStack)this.inventory.get(i);
            if (s.func_190926_b()) continue;
            this.inventoryPlatform.set(moved, (Object)s);
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            ++moved;
        }
        if (this.inventoryPlatform.stream().anyMatch(stack -> !stack.func_190926_b())) {
            this.requiresPlatformRefill = false;
            this.syncWithClient(te);
        }
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(boolean in) {
        return in ? this.inventoryHandler : super.getItemHandler(in);
    }

    @Override
    public void renderStorageInventory(GuiEmplacementPageStorage gui, int mx, int my, float partialTicks, boolean first) {
    }

    @Override
    public int getEnergyUpkeepCost() {
        return Config.IIConfig.Weapons.EmplacementWeapons.CPDS.energyUpkeepCost;
    }

    @Override
    public int getMaxHealth() {
        return Config.IIConfig.Weapons.EmplacementWeapons.CPDS.maxHealth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris() {
        return new Tuple((Object)EmplacementRenderer.textureCPDS, Arrays.asList(EmplacementRenderer.modelCPDSConstruction));
    }
}

