/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammunition_system.emplacement_weapons;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.client.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleUtils;
import pl.pabilo8.immersiveintelligence.client.gui.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.ammunition_system.emplacement_weapons.EmplacementWeaponCPDS;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.ammunition.ItemIIBulletMagazine;

public class EmplacementWeaponAutocannon
extends TileEntityEmplacement.EmplacementWeapon {
    private AxisAlignedBB vision;
    float flaps = 0.0f;
    float shootDelay = 0.0f;
    int reloadDelay = 0;
    int bulletsShot = 0;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> inventoryPlatform = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private int casingsToDrop = 0;
    private boolean requiresPlatformRefill = false;
    private ArrayDeque<ItemStack> magazine = new ArrayDeque();
    private ItemStack s2 = ItemStack.field_190927_a;
    private final IItemHandler inventoryHandler = new ItemStackHandler(this.inventory){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "autocannon"), (boolean)false)) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack itemStack = super.insertItem(slot, stack, simulate);
            EmplacementWeaponAutocannon.this.inventory.set(slot, this.stacks.get(slot));
            return itemStack;
        }
    };
    private static final int[] reloadTimers = new int[]{(int)(0.15 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime), (int)(0.25 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime), (int)(0.35 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime), (int)(0.45 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime), (int)(0.55 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime), (int)(0.65 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime), (int)(0.75 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime), (int)(0.85 * (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime)};
    private static final Runnable INSERTER_ANIM_NONE = () -> Utils.bindTexture(EmplacementRenderer.textureAutocannon);
    private static final Runnable INSERTER_ANIM_LEFT = () -> {
        Utils.bindTexture(EmplacementRenderer.textureAutocannon);
        GlStateManager.func_179114_b((float)-55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0625f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.magazineLeftModel) {
            mod.render();
        }
    };
    private static final Runnable INSERTER_ANIM_RIGHT = () -> {
        Utils.bindTexture(EmplacementRenderer.textureAutocannon);
        GlStateManager.func_179114_b((float)-55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0625f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.magazineRightModel) {
            mod.render();
        }
    };
    private Vec3d vv;

    @Override
    public String getName() {
        return "autocannon";
    }

    @Override
    public float getYawTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.yawRotateSpeed;
    }

    @Override
    public float getPitchTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.pitchRotateSpeed;
    }

    @Override
    public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
        float force = IIContent.itemAmmoAutocannon.getDefaultVelocity();
        this.s2 = this.magazine.size() > 0 ? this.magazine.peekFirst() : ItemStack.field_190927_a;
        float mass = this.s2.func_190926_b() ? 0.0f : IIContent.itemAmmoAutocannon.getMass(this.s2);
        this.vv = posTurret.func_178788_d(posTarget.func_178787_e(motion.func_186678_a(EmplacementWeaponCPDS.getInterceptTime(force, posTurret.func_178788_d(posTarget), motion))));
        double gravityMotionY = 0.0;
        double motionY = 0.0;
        double baseMotionY = this.vv.func_72432_b().field_72448_b;
        for (double dist = this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0)); dist > 0.0; dist -= (double)(EntityBullet.DEV_SLOMO * force)) {
            force -= 0.0f * force * EntityBullet.DEV_SLOMO;
            double baseMotionYC = baseMotionY * (double)(force / IIContent.itemAmmoAutocannon.getDefaultVelocity());
            motionY += (baseMotionYC + (gravityMotionY -= (double)(0.15f * mass * EntityBullet.DEV_SLOMO))) * (double)EntityBullet.DEV_SLOMO;
        }
        this.vv = this.vv.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        float yy = (float)(Math.atan2(this.vv.field_72450_a, this.vv.field_72449_c) * 180.0 / 3.1415927410125732);
        float pp = (float)Math.toDegrees(Math.atan2(this.vv.field_72448_b, this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0))));
        return new float[]{yy, pp};
    }

    @Override
    public void init(TileEntityEmplacement te, boolean firstTime) {
        super.init(te, firstTime);
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_186662_g((double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.detectionRadius);
    }

    @Override
    public void tick(TileEntityEmplacement te, boolean active) {
        if (active && this.magazine.isEmpty()) {
            if (this.reloadDelay == 0) {
                if (this.inventoryPlatform.stream().anyMatch(stack -> OreDictionary.itemMatches((ItemStack)stack, (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "autocannon"), (boolean)false) && ItemIIBulletMagazine.getRemainingBulletCount(stack) > 0)) {
                    this.reloadDelay = 1;
                } else {
                    this.requiresPlatformRefill = true;
                }
            } else {
                ++this.reloadDelay;
            }
            if (this.reloadDelay >= Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime) {
                int magsLoaded = 0;
                for (ItemStack stack2 : this.inventoryPlatform) {
                    if (magsLoaded >= 4) break;
                    if (!OreDictionary.itemMatches((ItemStack)stack2, (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "autocannon"), (boolean)false) || ItemIIBulletMagazine.getRemainingBulletCount(stack2) <= 0) continue;
                    this.magazine.addAll((Collection<ItemStack>)ItemIIBulletMagazine.takeAll(stack2));
                    ++magsLoaded;
                }
                this.reloadDelay = 0;
                this.syncWithClient(te);
            } else if (te.func_145831_w().field_72995_K) {
                this.playSoundsClient(te);
            }
        }
        if (this.shootDelay > 0.0f) {
            this.shootDelay -= 1.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSoundsClient(TileEntityEmplacement te) {
        if (this.reloadDelay == reloadTimers[0] || this.reloadDelay == reloadTimers[1] || this.reloadDelay == reloadTimers[2] || this.reloadDelay == reloadTimers[3]) {
            te.func_145831_w().func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, te.getBlockPosForPos(49), IISounds.autocannon_unload, SoundCategory.NEUTRAL, 1.0f, 0.75f);
        }
        if (this.reloadDelay == reloadTimers[4] || this.reloadDelay == reloadTimers[5] || this.reloadDelay == reloadTimers[6] || this.reloadDelay == reloadTimers[7]) {
            te.func_145831_w().func_184133_a((EntityPlayer)ClientUtils.mc().field_71439_g, te.getBlockPosForPos(49), IISounds.autocannon_reload, SoundCategory.NEUTRAL, 1.0f, 0.75f);
        }
    }

    @Override
    public void shoot(TileEntityEmplacement te) {
        super.shoot(te);
        if (!te.func_145831_w().field_72995_K) {
            ItemStack itemStack = this.s2 = this.magazine.size() > 0 ? this.magazine.removeFirst() : ItemStack.field_190927_a;
            if (!this.s2.func_190926_b()) {
                te.func_145831_w().func_184148_a(null, (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), IISounds.autocannon_firing, SoundCategory.PLAYERS, 2.0f, 0.5f);
                EntityBullet a = BulletHelper.createBullet(te.func_145831_w(), this.s2, te.getWeaponCenter(), this.vv.func_186678_a(-1.0));
                a.setShootPos(te.getAllBlocks());
                if (this.entity != null) {
                    a.setShooters((Entity)this.entity, (Entity[])this.entity.partArray);
                }
                te.func_145831_w().func_72838_d((Entity)a);
            }
        } else if (this.magazine.size() > 0) {
            Vec3d weaponCenter = te.getWeaponCenter().func_178787_e(this.vv.func_186678_a(-1.85));
            weaponCenter = weaponCenter.func_178787_e(this.vv.func_178785_b(this.bulletsShot % 2 == 0 ? 90.0f : -90.0f).func_186678_a(0.55));
            weaponCenter = weaponCenter.func_178787_e(this.vv.func_178789_a(this.bulletsShot < 2 ? 90.0f : -90.0f).func_186678_a(0.25));
            Vec3d vg = this.vv.func_186678_a(3.0);
            ParticleUtils.spawnGunfireFX(weaponCenter.field_72450_a, weaponCenter.field_72448_b, weaponCenter.field_72449_c, vg.field_72450_a, vg.field_72448_b, vg.field_72449_c, 4.0f);
            this.magazine.removeFirst();
        }
        this.shootDelay = Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.bulletFireTime;
        ++this.casingsToDrop;
        this.bulletsShot = (this.bulletsShot + 1) % 4;
    }

    @Override
    public void aimAt(float yaw, float pitch) {
        super.aimAt(yaw, pitch);
        this.flaps = this.pitch < -20.0f && this.pitch > -75.0f ? Math.min(this.flaps + 0.075f, 1.0f) : Math.max(this.flaps - 0.075f, 0.0f);
    }

    @Override
    public boolean isSetUp(boolean door) {
        return true;
    }

    @Override
    public boolean requiresPlatformRefill() {
        return this.requiresPlatformRefill;
    }

    @Override
    public NBTTagCompound saveToNBT(boolean forClient) {
        NBTTagCompound nbt = super.saveToNBT(forClient);
        nbt.func_74776_a("flaps", this.flaps);
        nbt.func_74776_a("shootDelay", this.shootDelay);
        nbt.func_74768_a("reloadDelay", this.reloadDelay);
        nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        nbt.func_74782_a("inventoryPlatform", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventoryPlatform));
        if (!forClient) {
            nbt.func_74782_a("magazine", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.magazine));
        }
        nbt.func_74768_a("magazine_amount", this.magazine.size());
        nbt.func_74757_a("requiresPlatformRefill", this.requiresPlatformRefill);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.flaps = tagCompound.func_74762_e("flaps");
        this.shootDelay = tagCompound.func_74760_g("shootDelay");
        this.reloadDelay = tagCompound.func_74762_e("reloadDelay");
        this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventory", 10), (int)this.inventory.size());
        this.inventoryPlatform = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventoryPlatform", 10), (int)this.inventoryPlatform.size());
        this.magazine = new ArrayDeque(blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("magazine", 10), (int)tagCompound.func_74762_e("magazine_amount")));
        this.requiresPlatformRefill = tagCompound.func_74767_n("requiresPlatformRefill");
    }

    @Override
    public boolean canShoot(TileEntityEmplacement te) {
        return this.vv != null && te.isDoorOpened && this.shootDelay == 0.0f && this.magazine.size() > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityEmplacement te, float partialTicks) {
        float reloadAnim = this.reloadDelay > 0 ? Math.min(1.0f, ((float)this.reloadDelay + (this.magazine.size() == 0 ? partialTicks : 0.0f)) / (float)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.reloadTime) : 0.0f;
        GlStateManager.func_179094_E();
        double cannonAnim = 0.0;
        double b1 = 0.0;
        double b2 = 0.0;
        double b3 = 0.0;
        double b4 = 0.0;
        float p = this.nextPitch - this.pitch;
        float y = this.nextYaw - this.yaw;
        float flaps = this.flaps;
        flaps = this.pitch < -20.0f && this.pitch > -75.0f ? Math.min(flaps + 0.075f * partialTicks, 1.0f) : Math.max(flaps - 0.075f * partialTicks, 0.0f);
        if (te.finishedDoorAction()) {
            cannonAnim = 1.0 - Math.min((double)(this.shootDelay + partialTicks) / (double)Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.bulletFireTime, 1.0);
            switch (this.bulletsShot) {
                case 0: {
                    b1 = te.isShooting ? Math.min(cannonAnim / 0.5, 1.0) : 0.0;
                    break;
                }
                case 1: {
                    b2 = Math.min(cannonAnim / 0.5, 1.0);
                    break;
                }
                case 2: {
                    b3 = Math.min(cannonAnim / 0.5, 1.0);
                    break;
                }
                case 3: {
                    b4 = Math.min(cannonAnim / 0.5, 1.0);
                }
            }
        }
        boolean power = te.energyStorage.getEnergyStored() >= this.getEnergyUpkeepCost();
        float pp = this.pitch + (power ? Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)1.0f) * partialTicks * this.getPitchTurnSpeed() : 0.0f);
        float yy = this.yaw + (power ? Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)1.0f) * partialTicks * this.getYawTurnSpeed() : 0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel1Model) {
            mod.field_78798_e = (float)(-8.0 * b1);
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel2Model) {
            mod.field_78798_e = (float)(-8.0 * b2);
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel3Model) {
            mod.field_78798_e = (float)(-8.0 * b3);
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel4Model) {
            mod.field_78798_e = (float)(-8.0 * b4);
        }
        Utils.bindTexture(EmplacementRenderer.textureAutocannon);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.baseModel) {
            mod.render();
        }
        GlStateManager.func_179114_b((float)yy, (float)0.0f, (float)1.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.turretModel) {
            mod.render();
        }
        GlStateManager.func_179094_E();
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.ammoBoxLidModel) {
            mod.field_78808_h = (double)reloadAnim < 0.1 ? reloadAnim / 0.1f * -4.125f : (reloadAnim < 0.9f ? -4.125f : (reloadAnim < 1.0f ? (1.0f - (reloadAnim - 0.9f) / 0.1f) * -4.125f : 0.0f));
            mod.render();
        }
        GlStateManager.func_179121_F();
        reloadAnim = Math.abs(reloadAnim - 0.5f) * 2.0f;
        EmplacementRenderer.modelAutocannon.turretTopFlapsModel[0].field_78796_g = -flaps * 1.55f;
        EmplacementRenderer.modelAutocannon.turretTopFlapsModel[1].field_78796_g = flaps * 1.55f;
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.turretTopFlapsModel) {
            mod.render();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.125f, (float)0.0f);
        GlStateManager.func_179114_b((float)pp, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.gunModel) {
            mod.render();
        }
        GlStateManager.func_179094_E();
        if ((double)reloadAnim > 0.19999999999999998) {
            for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.magazineRightBottomModel) {
                mod.render();
            }
        }
        if ((double)reloadAnim > 0.4) {
            for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.magazineRightTopModel) {
                mod.render();
            }
        }
        if ((double)reloadAnim > 0.6) {
            for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.magazineLeftBottomModel) {
                mod.render();
            }
        }
        if ((double)reloadAnim > 0.8) {
            for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.magazineLeftTopModel) {
                mod.render();
            }
        }
        GlStateManager.func_179121_F();
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel1Model) {
            mod.render();
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel2Model) {
            mod.render();
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel3Model) {
            mod.render();
        }
        for (ModelRendererTurbo mod : EmplacementRenderer.modelAutocannon.barrel4Model) {
            mod.render();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.625f, (float)1.0f, (float)-0.88125f);
        float ins_y = 0.0f;
        float ins_p1 = 15.0f;
        float ins_p2 = 175.0f;
        float ins_progress = 0.0f;
        Runnable r = INSERTER_ANIM_NONE;
        if ((double)reloadAnim > 0.1 && (double)reloadAnim < 0.9) {
            if (((double)reloadAnim - 0.1) % 0.2 / 0.2 < 0.5) {
                double p_anim = ((double)reloadAnim - 0.1) % 0.2 / 0.2 / 0.5;
                if (p_anim < 0.25) {
                    ins_y = (float)(90.0 * (p_anim / 0.25));
                } else if (p_anim < 0.5) {
                    ins_y = 90.0f;
                    ins_p1 = 15.0f + (float)(50.0 * ((p_anim - 0.25) / 0.25));
                } else if (p_anim < 0.75) {
                    ins_y = 90.0f;
                    ins_p1 = 15.0f + (float)(50.0 * (1.0 - (p_anim - 0.5) / 0.25));
                } else if ((double)reloadAnim < 0.5) {
                    ins_y = 90.0f - (float)(90.0 * ((p_anim - 0.75) / 0.25));
                } else {
                    ins_y = 90.0f - (float)(25.0 * ((p_anim - 0.75) / 0.25));
                    ins_p2 = 175.0f - (float)(70.0 * ((p_anim - 0.75) / 0.25));
                    ins_p1 = 15.0f + (float)(25.0 * ((p_anim - 0.75) / 0.25));
                }
                if (p_anim > 0.5) {
                    r = (double)reloadAnim > 0.5 ? INSERTER_ANIM_LEFT : INSERTER_ANIM_RIGHT;
                }
            } else if ((double)reloadAnim < 0.3) {
                double p_anim = ((double)reloadAnim - 0.1) / 0.2;
                if (p_anim < 0.25) {
                    ins_y = (float)(-25.0 * (p_anim / 0.25));
                } else if (p_anim < 0.5) {
                    ins_y = -25.0f;
                    ins_p1 = 15.0f + (float)(10.0 * ((p_anim - 0.25) / 0.25));
                    ins_p2 = 175.0f - (float)(30.0 * ((p_anim - 0.25) / 0.25));
                } else if (p_anim < 0.75) {
                    ins_y = -25.0f;
                    ins_p1 = 25.0f - (float)(10.0 * ((p_anim - 0.5) / 0.25));
                    ins_p2 = 145.0f + (float)(30.0 * ((p_anim - 0.5) / 0.25));
                } else {
                    ins_y = (float)(-25.0 * (1.0 - (p_anim - 0.75) / 0.25));
                }
            } else if ((double)reloadAnim < 0.5) {
                double p_anim = ((double)reloadAnim - 0.3) / 0.2;
                if (p_anim < 0.25) {
                    ins_y = (float)(-25.0 * (p_anim / 0.25));
                } else if (p_anim < 0.5) {
                    ins_y = -25.0f;
                    ins_p1 = 15.0f + (float)(15.0 * ((p_anim - 0.25) / 0.25));
                    ins_p2 = 175.0f - (float)(45.0 * ((p_anim - 0.25) / 0.25));
                } else if (p_anim < 0.75) {
                    ins_y = -25.0f;
                    ins_p1 = 30.0f - (float)(15.0 * ((p_anim - 0.5) / 0.25));
                    ins_p2 = 130.0f + (float)(45.0 * ((p_anim - 0.5) / 0.25));
                } else {
                    ins_y = (float)(-25.0 * (1.0 - (p_anim - 0.75) / 0.25));
                }
            } else if ((double)reloadAnim < 0.7) {
                double p_anim = ((double)reloadAnim - 0.5) / 0.2;
                ins_y = 65.0f;
                ins_p2 = 105.0f;
                ins_p1 = 40.0f;
                if (p_anim < 0.2) {
                    ins_y = (float)(65.0 - 12.5 * (p_anim / (double)0.2f));
                    ins_p1 = (float)(40.0 + 50.0 * (p_anim / (double)0.2f));
                    ins_p2 = (float)(105.0 + 15.0 * (p_anim / (double)0.2f));
                } else if (p_anim < 0.4) {
                    ins_y = 52.5f;
                    ins_p1 = 90.0f;
                    ins_p2 = 120.0f;
                } else if (p_anim < 0.6) {
                    ins_y = (float)(52.5 + 37.5 * ((p_anim - 0.4) / (double)0.2f));
                    ins_p1 = (float)(90.0 - 50.0 * ((p_anim - 0.4) / (double)0.2f));
                    ins_p2 = (float)(120.0 - 15.0 * ((p_anim - 0.4) / (double)0.2f));
                } else if (p_anim < 0.8) {
                    ins_p1 = (float)(40.0 - 25.0 * ((p_anim - 0.6) / (double)0.2f));
                    ins_p2 = (float)(105.0 + 70.0 * ((p_anim - 0.6) / (double)0.2f));
                    ins_y = 90.0f;
                } else {
                    ins_p1 = 15.0f;
                    ins_p2 = 175.0f;
                    ins_y = (float)(90.0 * (1.0 - (p_anim - 0.8) / (double)0.2f));
                }
            } else if ((double)reloadAnim < 0.9) {
                double p_anim = ((double)reloadAnim - 0.7) / 0.2;
                ins_y = 65.0f;
                ins_p2 = 105.0f;
                ins_p1 = 40.0f;
                if (p_anim < 0.2) {
                    ins_y = (float)(65.0 - 12.5 * (p_anim / (double)0.2f));
                    ins_p1 = (float)(40.0 + 20.0 * (p_anim / (double)0.2f));
                } else if (p_anim < 0.4) {
                    ins_y = 52.5f;
                    ins_p1 = 65.0f;
                } else if (p_anim < 0.6) {
                    ins_y = (float)(52.5 + 37.5 * ((p_anim - 0.4) / (double)0.2f));
                    ins_p1 = (float)(65.0 - 25.0 * ((p_anim - 0.4) / (double)0.2f));
                } else if (p_anim < 0.8) {
                    ins_p1 = (float)(40.0 - 25.0 * ((p_anim - 0.6) / (double)0.2f));
                    ins_p2 = (float)(105.0 + 70.0 * ((p_anim - 0.6) / (double)0.2f));
                    ins_y = 90.0f;
                } else {
                    ins_p1 = 15.0f;
                    ins_p2 = 175.0f;
                    ins_y = (float)(90.0 * (1.0 - (p_anim - 0.8) / (double)0.2f));
                }
            }
        }
        EmplacementRenderer.renderInserter(true, ins_y, ins_p1, ins_p2, ins_progress, r);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        GlStateManager.func_179094_E();
        int req = IIContent.UPGRADE_EMPLACEMENT_WEAPON_AUTOCANNON.getProgressRequired();
        int l = EmplacementRenderer.modelAutocannonConstruction.length;
        double maxClientProgress = Utils.getMaxClientProgress(serverProgress, req, l);
        double cc = (int)Math.min((double)((float)clientProgress + partialTicks * ((float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f)), maxClientProgress);
        double progress = MathHelper.func_151237_a((double)(cc / (double)req), (double)0.0, (double)1.0);
        Utils.bindTexture(EmplacementRenderer.textureAutocannon);
        int i = 0;
        while ((double)i < (double)l * progress) {
            if ((long)(1 + i) > Math.round((double)l * progress)) {
                GlStateManager.func_179094_E();
                double scale = 1.0 - progress * (double)l % 1.0 / 1.0;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.min(scale, 1.0)));
                GlStateManager.func_179137_b((double)0.0, (double)(scale * 1.5), (double)0.0);
                EmplacementRenderer.modelAutocannonConstruction[i].func_78785_a(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            } else {
                EmplacementRenderer.modelAutocannonConstruction[i].func_78785_a(0.0625f);
            }
            ++i;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.func_179109_b((float)0.03125f, (float)0.0f, (float)-0.01325f);
        ShaderUtil.blueprint_static(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        i = l - 1;
        while ((double)i >= Math.max((double)l * progress - 1.0, 0.0)) {
            EmplacementRenderer.modelAutocannonConstruction[i].func_78785_a(0.0625f);
            --i;
        }
        ShaderUtil.releaseShader();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @Override
    public AxisAlignedBB getVisionAABB() {
        return this.vision;
    }

    @Override
    public EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes() {
        if (this.entity == null) {
            return new EntityEmplacementWeapon.EmplacementHitboxEntity[0];
        }
        ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity> list = new ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity>();
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBox", 1.0f, 1.5f, new Vec3d(0.0, 1.0, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "ammoBox", 0.625f, 0.75f, new Vec3d(1.0, 0.625, 0.0), Vec3d.field_186680_a, 2));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "shieldRight", 0.75f, 2.0f, new Vec3d(-0.5, 1.0, -0.625), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "shieldLeft", 0.75f, 2.0f, new Vec3d(-0.5, 1.0, 0.625), Vec3d.field_186680_a, 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrelRight", 0.5f, 0.5f, new Vec3d(-0.5, 1.125, -0.625), new Vec3d(-0.5, 0.0, 0.0), 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrelRight", 0.5f, 0.5f, new Vec3d(-0.5, 1.125, -0.625), new Vec3d(-1.0, 0.0, 0.0), 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrelLeft", 0.5f, 0.5f, new Vec3d(-0.5, 1.0, 0.625), new Vec3d(-0.5, 0.0, 0.0), 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrelLeft", 0.5f, 0.5f, new Vec3d(-0.5, 1.0, 0.625), new Vec3d(-1.0, 0.0, 0.0), 12));
        return list.toArray(new EntityEmplacementWeapon.EmplacementHitboxEntity[0]);
    }

    @Override
    public NonNullList<ItemStack> getBaseInventory() {
        return this.inventory;
    }

    @Override
    public void renderStorageInventory(GuiEmplacementPageStorage gui, int mx, int my, float partialTicks, boolean first) {
    }

    @Override
    public void performPlatformRefill(TileEntityEmplacement te) {
        while (this.casingsToDrop > 0) {
            te.doProcessOutput(IIContent.itemAmmoAutocannon.getCasingStack(Math.min(this.casingsToDrop, 24)));
            this.casingsToDrop = Math.max(this.casingsToDrop - 24, 0);
        }
        for (int i = 0; i < this.inventoryPlatform.size(); ++i) {
            te.doProcessOutput((ItemStack)this.inventoryPlatform.get(i));
            this.inventoryPlatform.set(i, (Object)ItemStack.field_190927_a);
        }
        int moved = 0;
        for (int i = 0; i < this.inventory.size() && moved < this.inventoryPlatform.size(); ++i) {
            ItemStack s = (ItemStack)this.inventory.get(i);
            if (s.func_190926_b()) continue;
            this.inventoryPlatform.set(moved, (Object)s);
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            ++moved;
        }
        if (this.inventoryPlatform.stream().anyMatch(stack -> !stack.func_190926_b())) {
            this.requiresPlatformRefill = false;
            this.syncWithClient(te);
        }
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(boolean in) {
        return in ? this.inventoryHandler : super.getItemHandler(in);
    }

    @Override
    public int getEnergyUpkeepCost() {
        return Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.energyUpkeepCost;
    }

    @Override
    public int getMaxHealth() {
        return Config.IIConfig.Weapons.EmplacementWeapons.Autocannon.maxHealth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris() {
        return new Tuple((Object)EmplacementRenderer.textureAutocannon, Arrays.asList(EmplacementRenderer.modelAutocannonConstruction));
    }
}

