/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.render;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.rotary.MotorBeltData;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.ITowable;
import pl.pabilo8.immersiveintelligence.client.model.vehicle.ModelMotorbike;
import pl.pabilo8.immersiveintelligence.client.model.vehicle.ModelPanzer;
import pl.pabilo8.immersiveintelligence.client.render.IReloadableModelContainer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.client.tmt.TmtUtil;
import pl.pabilo8.immersiveintelligence.common.entity.EntityMotorbike;
import pl.pabilo8.immersiveintelligence.common.items.mechanical.ItemIIMotorBelt;

public class MotorbikeRenderer
extends Render<EntityMotorbike>
implements IReloadableModelContainer<MotorbikeRenderer> {
    public static ModelMotorbike model;
    public static ModelPanzer modelPanzer;
    public static MotorBeltData tracks;
    public static final ResourceLocation TEXTURE;

    public MotorbikeRenderer(RenderManager renderManager) {
        super(renderManager);
        this.subscribeToList("motorbike");
    }

    public void doRender(EntityMotorbike entity, double x, double y, double z, float f0, float f1) {
        ModelRendererTurbo mod8;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        double d0 = (entity.field_70142_S - entity.field_70165_t) * (double)f1;
        double d1 = (entity.field_70137_T - entity.field_70163_u) * (double)f1;
        double d2 = (entity.field_70136_U - entity.field_70161_v) * (double)f1;
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderHelper.func_74519_b();
        float tilt = entity.tilt;
        if (entity.turnLeft) {
            tilt -= 0.1f * f1;
        } else if (entity.turnRight) {
            tilt += 0.1f * f1;
        } else if (tilt != 0.0f) {
            float f = tilt = tilt < 0.0f ? tilt + 0.1f * f1 : tilt - 0.1f * f1;
            if (Math.abs(tilt) < 0.01f) {
                tilt = 0.0f;
            }
        }
        tilt = MathHelper.func_76131_a((float)tilt, (float)-1.0f, (float)1.0f);
        float speed = 4.0f;
        float engineSpeed = speed / 2.0f;
        float acceleration = entity.acceleration;
        acceleration = entity.engineWorking && entity.accelerated ? Math.min(acceleration + 0.1f * f1, 1.0f) : Math.max(acceleration - 0.15f * f1, 0.0f);
        float brake = entity.brakeProgress;
        brake = entity.engineWorking && entity.brake ? Math.min(brake + 0.15f * f1, 1.0f) : Math.max(brake - 0.25f * f1, 0.0f);
        float totalWorldTime = entity.func_130014_f_().func_82737_E();
        float engineMove = entity.engineWorking ? Math.abs((totalWorldTime % engineSpeed + f1) / engineSpeed - 0.5f) : 0.0f;
        float pipesMove = entity.engineWorking ? Math.abs((totalWorldTime % speed + f1) / speed - 0.5f) : 0.0f;
        float plannedRotation = entity.field_70177_z - (tilt != 0.0f ? f1 * tilt * (speed / 5.0f) : 0.0f);
        if (!entity.engineWorking && (entity.turnLeft || entity.turnRight)) {
            plannedRotation = (float)((double)plannedRotation + (double)tilt * 0.25 * (double)f1);
        }
        boolean isTowing = entity.func_184182_bu().stream().anyMatch(entity1 -> entity1 instanceof ITowable);
        float stepAngle = (float)((entity.partWheelFront.field_70163_u - entity.partWheelBack.field_70163_u) * 12.5);
        GlStateManager.func_179114_b((float)stepAngle, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-plannedRotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-(tilt * (speed / 15.0f)) * 25.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-0.55, (double)0.5, (double)0.0);
        this.func_110776_a(TEXTURE);
        for (ModelRendererTurbo mod2 : MotorbikeRenderer.model.baseModel) {
            mod2.func_78785_a(0.0625f);
        }
        switch (entity.upgrade) {
            case "storage": {
                int n;
                ModelRendererTurbo[] modelRendererTurboArray = MotorbikeRenderer.model.upgradeStorageModel;
                int mod2 = modelRendererTurboArray.length;
                for (n = 0; n < mod2; ++n) {
                    mod8 = modelRendererTurboArray[n];
                    mod8.render();
                }
                break;
            }
            case "tank": {
                int n;
                ModelRendererTurbo[] modelRendererTurboArray = MotorbikeRenderer.model.upgradeTankModel;
                int mod2 = modelRendererTurboArray.length;
                for (n = 0; n < mod2; ++n) {
                    mod8 = modelRendererTurboArray[n];
                    mod8.render();
                }
                break;
            }
            case "woodgas": {
                break;
            }
            case "seat": {
                int n;
                ModelRendererTurbo[] modelRendererTurboArray = MotorbikeRenderer.model.upgradeSeatModel;
                int mod2 = modelRendererTurboArray.length;
                for (n = 0; n < mod2; ++n) {
                    mod8 = modelRendererTurboArray[n];
                    mod8.render();
                }
                break;
            }
        }
        if (isTowing) {
            for (ModelRendererTurbo mod3 : MotorbikeRenderer.model.trailerThingyModel) {
                mod3.func_78785_a(0.0625f);
            }
        }
        GlStateManager.func_179094_E();
        float partDurability = (float)entity.engineDurability / (float)Config.IIConfig.Vehicles.Motorbike.engineDurability;
        GlStateManager.func_179109_b((float)(engineMove * 0.03125f * partDurability), (float)(-engineMove * 0.03125f * partDurability), (float)0.0f);
        GlStateManager.func_179124_c((float)partDurability, (float)partDurability, (float)partDurability);
        for (ModelRendererTurbo mod4 : MotorbikeRenderer.model.engineModel) {
            mod4.func_78785_a(0.0625f);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(pipesMove * 0.03125f * partDurability), (float)0.0f);
        for (ModelRendererTurbo mod5 : MotorbikeRenderer.model.exhaustPipesModel) {
            mod5.func_78785_a(0.0625f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5625f, (float)0.9375f, (float)0.875f);
        GlStateManager.func_179114_b((float)-18.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(tilt * -35.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.9375f, (float)0.0f);
        GlStateManager.func_179114_b((float)18.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod6 : MotorbikeRenderer.model.frontThingyModel) {
            mod6.func_78785_a(0.0625f);
        }
        for (ModelRendererTurbo mod7 : MotorbikeRenderer.model.frontThingyUpperModel) {
            mod7.func_78785_a(0.0625f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.125f, (float)0.0f, (float)0.0f);
        float wheelRot = (float)entity.partWheelFront.wheelTraverse + (entity.speed > 0.0f ? f1 * entity.speed : 0.0f);
        GlStateManager.func_179114_b((float)(wheelRot * 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod8 : MotorbikeRenderer.model.frontWheelModel) {
            mod8.func_78785_a(0.0625f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)1.25, (double)-0.385);
        for (ModelRendererTurbo mod8 : MotorbikeRenderer.model.steeringGearModel) {
            mod8.func_78785_a(0.0625f);
        }
        MotorbikeRenderer.model.accelerationModel[0].field_78795_f = 0.06981317f - TmtUtil.AngleToTMT(55.0f * acceleration);
        for (ModelRendererTurbo mod8 : MotorbikeRenderer.model.accelerationModel) {
            mod8.func_78785_a(0.0625f);
        }
        GlStateManager.func_179109_b((float)0.375f, (float)0.0f, (float)0.0f);
        MotorbikeRenderer.model.brakeModel[0].field_78795_f = 0.06981317f + TmtUtil.AngleToTMT(55.0f * brake);
        for (ModelRendererTurbo mod8 : MotorbikeRenderer.model.brakeModel) {
            mod8.func_78785_a(0.0625f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5625, (double)0.0, (double)-1.3125);
        wheelRot = (float)entity.partWheelBack.wheelTraverse + (entity.speed > 0.0f ? f1 * entity.speed : 0.0f);
        GlStateManager.func_179114_b((float)(wheelRot * 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod8 : MotorbikeRenderer.model.backWheelModel) {
            mod8.func_78785_a(0.0625f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityMotorbike entity) {
        return TEXTURE;
    }

    @Override
    public void reloadModels() {
        model = new ModelMotorbike();
        tracks = MotorBeltData.createBeltData(new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 3.0), new Vec3d(0.0, -2.0, 1.5)}, new float[]{8.0f, 8.0f, 8.0f}, ItemIIMotorBelt.MotorBelt.STEEL.type);
    }

    private void renderWheelThingy(float tilt, ModelRendererTurbo[] model) {
        GlStateManager.func_179114_b((float)(tilt * -35.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        for (ModelRendererTurbo mod : model) {
            mod.func_78785_a(0.0625f);
        }
    }

    static {
        TEXTURE = new ResourceLocation("immersiveintelligence:textures/entity/motorbike.png");
    }
}

