/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.fx;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.client.fx.IIParticle;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleRenderer;

public class ParticleGasCloud
extends IIParticle {
    private final Fluid fluid;
    public static TextureAtlasSprite TEXTURE;
    public static final HashMap<Fluid, float[]> CACHED_COLORS;

    public ParticleGasCloud(World world, double x, double y, double z, float size, Fluid fluid) {
        super(world, x, y, z);
        this.fluid = fluid;
        this.field_187130_j = 0.05f;
        this.field_70544_f = (float)((double)size * 0.85 + (double)size * 0.15 * blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian());
        this.field_70547_e = (int)(20.0 + 10.0 * blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian()) + 1;
        this.func_187117_a(TEXTURE);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_187130_j += 5.0E-4;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_70546_d++ > this.field_70547_e) {
            this.func_187112_i();
        }
        if (this.field_187127_g == this.field_187124_d) {
            this.field_187129_i *= 1.1;
            this.field_187131_k *= 1.1;
        }
        this.field_187129_i *= 0.9;
        this.field_187130_j *= 0.9;
        this.field_187131_k *= 0.9;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        this.getFluidColor(partialTicks);
        super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    protected void getFluidColor(float partialTicks) {
        this.field_82339_as = 1.0f;
        float brightness = MathHelper.func_76125_a((int)this.func_189214_a(partialTicks), (int)0, (int)1);
        float[] fluidColor = this.getFluidColor(this.fluid);
        this.field_70552_h = fluidColor[0] * brightness;
        this.field_70553_i = fluidColor[1] * brightness;
        this.field_70551_j = fluidColor[2] * brightness;
    }

    public int func_189214_a(float p_70070_1_) {
        return super.func_189214_a(p_70070_1_);
    }

    @Override
    @Nonnull
    public ParticleRenderer.DrawingStages getDrawStage() {
        return ParticleRenderer.DrawingStages.CUSTOM;
    }

    public float[] getFluidColor(Fluid fluid) {
        float[] texture;
        if (CACHED_COLORS.containsKey(fluid)) {
            return CACHED_COLORS.get(fluid);
        }
        try {
            ResourceLocation f = new ResourceLocation(fluid.getStill().func_110624_b(), "textures/" + fluid.getStill().func_110623_a() + ".png");
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(f);
            InputStream is = resource.func_110527_b();
            BufferedImage image = ImageIO.read(is);
            texture = Utils.rgbIntToRGB(image.getRGB(0, 0) - -16777216 << 2);
        }
        catch (IOException e) {
            ImmersiveIntelligence.logger.error("Could not load fluid texture file for ParticleGasCloud");
            texture = new float[]{1.0f, 1.0f, 1.0f};
        }
        CACHED_COLORS.put(fluid, texture);
        return texture;
    }

    static {
        CACHED_COLORS = new HashMap();
    }

    public static class ParticleFlareFlash
    extends ParticleGasCloud {
        public ParticleFlareFlash(World world, double x, double y, double z, int colour, float size) {
            super(world, x, y, z, size, null);
            float[] rgb = Utils.rgbIntToRGB(colour);
            this.field_70552_h = rgb[0];
            this.field_70553_i = rgb[1];
            this.field_70551_j = rgb[2];
        }

        @Override
        protected void getFluidColor(float partialTicks) {
            this.field_82339_as = 2.0f;
        }

        @Override
        @Nonnull
        public ParticleRenderer.DrawingStages getDrawStage() {
            return ParticleRenderer.DrawingStages.CUSTOM_ADDITIVE;
        }
    }
}

