/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import pl.pabilo8.immersiveintelligence.api.data.DataOperations;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operators.DataOperator;
import pl.pabilo8.immersiveintelligence.api.data.operators.arithmetic.DataOperationAdd;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataPacketTypeExpression
implements IDataType {
    public IDataType type1;
    public IDataType type2;
    DataOperator operation;
    char requiredVariable = (char)32;

    public DataPacketTypeExpression(IDataType type1, IDataType type2, DataOperator operation, char requiredVariable) {
        this.type1 = type1;
        this.type2 = type2;
        this.operation = operation;
        this.requiredVariable = requiredVariable;
    }

    public IDataType getType1() {
        return this.type1;
    }

    public IDataType getType2() {
        return this.type2;
    }

    public DataOperator getOperation() {
        return this.operation;
    }

    public char getRequiredVariable() {
        return this.requiredVariable;
    }

    public void setOperation(DataOperator operation) {
        this.operation = operation;
    }

    public void setRequiredVariable(char requiredVariable) {
        this.requiredVariable = requiredVariable;
    }

    public DataPacketTypeExpression() {
    }

    public IDataType getValue(DataPacket packet) {
        return this.operation.execute(packet, this);
    }

    @Override
    public String getName() {
        return "expression";
    }

    @Override
    public String valueToString() {
        return this.type1.valueToString() + " " + this.operation + " " + this.type2.valueToString();
    }

    @Override
    public void setDefaultValue() {
        this.type1 = new DataPacketTypeNull();
        this.type2 = new DataPacketTypeNull();
        this.operation = new DataOperationAdd();
        this.requiredVariable = (char)32;
    }

    @Override
    public void valueFromNBT(NBTTagCompound nbt) {
        this.setDefaultValue();
        if (((NBTTagCompound)nbt.func_74781_a("Value1")).func_74764_b("Type")) {
            try {
                this.type1 = (IDataType)DataPacket.varTypes.get(((NBTTagCompound)nbt.func_74781_a("Value1")).func_74779_i("Type")).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.type1.valueFromNBT((NBTTagCompound)nbt.func_74781_a("Value1"));
        } else {
            this.type1 = new DataPacketTypeNull();
        }
        if (((NBTTagCompound)nbt.func_74781_a("Value2")).func_74764_b("Type")) {
            try {
                this.type2 = (IDataType)DataPacket.varTypes.get(((NBTTagCompound)nbt.func_74781_a("Value2")).func_74779_i("Type")).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.type2.valueFromNBT((NBTTagCompound)nbt.func_74781_a("Value2"));
        } else {
            this.type2 = new DataPacketTypeNull();
        }
        this.requiredVariable = nbt.func_74779_i("requiredVariable").charAt(0);
        String type = nbt.func_74779_i("Operation");
        if (DataOperations.operations.containsKey(type)) {
            try {
                DataOperator data;
                this.operation = data = DataOperations.operations.get(type).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        nbt.func_74782_a("Value1", (NBTBase)this.type1.valueToNBT());
        nbt.func_74782_a("Value2", (NBTBase)this.type2.valueToNBT());
        nbt.func_74778_a("Operation", this.operation.name);
        nbt.func_74778_a("requiredVariable", String.valueOf(this.requiredVariable));
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 2772404;
    }

    @Override
    public String textureLocation() {
        return "immersiveintelligence:textures/gui/data_types.png";
    }

    @Override
    public int getFrameOffset() {
        return 4;
    }
}

