/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeAccessor;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeArray;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeEntity;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataPacket
implements Iterable<IDataType> {
    public Map<Character, IDataType> variables = new HashMap<Character, IDataType>();
    private EnumDyeColor packetColor = EnumDyeColor.WHITE;
    private int packetAddress = -1;
    public static final char[] varCharacters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    public static final Map<String, Class> varTypes = new HashMap<String, Class>();

    public boolean hasVariables() {
        return this.variables.size() > 0;
    }

    public boolean hasVariable(Character c) {
        return this.variables.containsKey(c);
    }

    public IDataType getPacketVariable(Character name) {
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        return new DataPacketTypeNull();
    }

    public boolean setVariable(Character c, IDataType type) {
        if (ArrayUtils.contains((char[])varCharacters, (char)c.charValue())) {
            this.variables.remove(c);
            this.variables.put(c, type);
            return true;
        }
        return false;
    }

    public DataPacket setPacketColor(EnumDyeColor color) {
        this.packetColor = color;
        return this;
    }

    public DataPacket setPacketAddress(int address) {
        if (address >= -1) {
            this.packetAddress = address;
        }
        return this;
    }

    public boolean matchesConnector(EnumDyeColor connColor, int connAddress) {
        return !(this.packetAddress != -1 && this.packetAddress != connAddress || this.packetColor != EnumDyeColor.WHITE && connColor != this.packetColor);
    }

    public void removeAllVariables() {
        for (char c : varCharacters) {
            this.removeVariable(Character.valueOf(c));
        }
    }

    public boolean removeVariable(Character c) {
        if (ArrayUtils.contains((char[])varCharacters, (char)c.charValue())) {
            this.variables.remove(c);
            return true;
        }
        return false;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<Character, IDataType> entry : this.variables.entrySet()) {
            nbt.func_74782_a(String.valueOf(entry.getKey()), (NBTBase)entry.getValue().valueToNBT());
        }
        if (this.packetColor != EnumDyeColor.WHITE) {
            nbt.func_74768_a("color", this.packetColor.func_176765_a());
        }
        if (this.packetAddress != -1) {
            nbt.func_74768_a("address", this.packetAddress);
        }
        return nbt;
    }

    public DataPacket fromNBT(NBTTagCompound nbt) {
        this.variables.clear();
        char[] cArray = varCharacters;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            NBTTagCompound n2;
            String type;
            Character c = Character.valueOf(cArray[i]);
            if (!nbt.func_74764_b(String.valueOf(c)) || !varTypes.containsKey(type = (n2 = nbt.func_74775_l(String.valueOf(c))).func_74779_i("Type"))) continue;
            IDataType data = null;
            try {
                data = (IDataType)varTypes.get(type).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            if (data == null) continue;
            data.valueFromNBT(n2);
            this.variables.put(c, data);
        }
        if (nbt.func_74764_b("color")) {
            this.packetColor = EnumDyeColor.func_176764_b((int)nbt.func_74762_e("color"));
        }
        if (nbt.func_74764_b("address")) {
            this.packetAddress = nbt.func_74762_e("address");
        }
        return this;
    }

    public DataPacket clone() {
        DataPacket packet = new DataPacket();
        packet.fromNBT(this.toNBT());
        return packet;
    }

    public String toString() {
        return this.toNBT().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataPacket) {
            DataPacket other = (DataPacket)obj;
            if (!this.variables.keySet().equals(other.variables.keySet())) {
                return false;
            }
            if (!this.matchesConnector(other.packetColor, other.packetAddress)) {
                return false;
            }
            for (Map.Entry<Character, IDataType> entry : this.variables.entrySet()) {
                if (other.getPacketVariable(entry.getKey()).valueToString().equals(entry.getValue().valueToString())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterator<IDataType> iterator() {
        return this.variables.values().iterator();
    }

    static {
        varTypes.put("null", DataPacketTypeNull.class);
        varTypes.put("integer", DataPacketTypeInteger.class);
        varTypes.put("string", DataPacketTypeString.class);
        varTypes.put("boolean", DataPacketTypeBoolean.class);
        varTypes.put("accessor", DataPacketTypeAccessor.class);
        varTypes.put("expression", DataPacketTypeExpression.class);
        varTypes.put("itemstack", DataPacketTypeItemStack.class);
        varTypes.put("array", DataPacketTypeArray.class);
        varTypes.put("entity", DataPacketTypeEntity.class);
    }
}

